/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.rec.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitEnrollDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitPersonnelReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.UmUserInfoReDomain;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitFileServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitPersonnelServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceAreaServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecSupplierServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityQtypeReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityQtypeServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruit"}, name="\u62db\u52df\u670d\u52a1")
public class RecruitCon
extends SpringmvcController {
    private static final String CODE = "rec.recruit.con";
    @Autowired
    private RecRecruitServiceRepository recRecruitServiceRepository;
    @Autowired
    private RecSupplierServiceRepository recSupplierServiceRepository;
    @Autowired
    private RecRecruitEnrollServiceRepository recRecruitEnrollServiceRepository;
    @Autowired
    private RecRecruitOtherServiceRepository recRecruitOtherServiceRepository;
    @Autowired
    private RecRecruitFileServiceRepository recRecruitFileServiceRepository;
    @Autowired
    private RecRecruitPersonnelServiceRepository recRecruitPersonnelServiceRepository;
    @Autowired
    private RecRecruitServiceAreaServiceRepository recRecruitServiceAreaServiceRepository;
    @Autowired
    private UmQualityQtypeServiceRepository umQualityQtypeServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    private static final int SIZE = 4;
    private static final String SYMBOL = "*";
    private static final String key = "RecruitCode";
    private static final String dao_startRow = "startRow";
    private static final String dao_endRow = "endRow";

    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"queryRecruitDataByUser.json"}, name="\u67e5\u8be2\u5f85\u5904\u7406\u62db\u52df\u6570\u636e")
    @ResponseBody
    public Map<String, Object> queryDataByUser(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        param.put(dao_startRow, 0);
        param.put(dao_endRow, 1);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", userSession.getUserPcode());
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("recruitType", "01");
        param.put("dataState", 1);
        SupQueryResult supQueryResult1 = this.recRecruitServiceRepository.queryRecruitPage(param);
        resultMap.put("RecruitmentNum", supQueryResult1.getTotal());
        param.put("dataState", 2);
        SupQueryResult supQueryResult2 = this.recRecruitServiceRepository.queryRecruitPage(param);
        resultMap.put("RecruitEndNum", supQueryResult2.getTotal());
        param.remove("recruitType");
        param.put("dataState", 0);
        param.put("colName0", "SUPPLIER_APPLY_STATE");
        param.put("colValue0", "1");
        param.put("supplierBlack", "0");
        param.put("supplierType", "00,01");
        SupQueryResult recSupplierSupQueryResult = this.recSupplierServiceRepository.querySupplierPage(param);
        resultMap.put("SupplierJoinNum", recSupplierSupQueryResult.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"updateResourceState.json"}, name="\u66f4\u65b0\u8d44\u6e90\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateResourceState(HttpServletRequest request, String recruitId, String resourceState) {
        if (StringUtils.isBlank((String)recruitId) || StringUtils.isBlank((String)resourceState)) {
            this.logger.error("rec.recruit.con.updateResourceState.param", (Object)(recruitId + "\u2014\u2014" + resourceState));
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        RecRecruitReDomain recruitReDomain = this.recRecruitServiceRepository.getRecruit(Integer.valueOf(recruitId));
        if (recruitReDomain == null) {
            this.logger.error("rec.recruit.con.updateResourceState.recruitReDomain is null", (Object)recruitId);
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "null");
        }
        recruitReDomain.setResourceState(resourceState);
        return this.recRecruitServiceRepository.updateRecruit((RecRecruitDomain)recruitReDomain);
    }

    @RequestMapping(value={"queryDemandDataByUser.json"}, name="\u67e5\u8be2\u5f85\u5904\u7406\u62db\u52df\u6570\u636e")
    @ResponseBody
    public Map<String, Object> queryDemandDataByUser(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        param.put(dao_startRow, 0);
        param.put(dao_endRow, 1);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", userSession.getUserPcode());
        param.put("recruitType", "03");
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("dataState", 1);
        SupQueryResult supQueryResult1 = this.recRecruitServiceRepository.queryRecruitPage(param);
        resultMap.put("DemanNum", supQueryResult1.getTotal());
        param.put("dataState", 2);
        SupQueryResult supQueryResult2 = this.recRecruitServiceRepository.queryRecruitPage(param);
        resultMap.put("DemanEndNum", supQueryResult2.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String paramStr) {
        UserSession userSession;
        this.logger.error("saveRecruit----------------------------------paramStr------------------------------" + paramStr);
        if (null == paramStr) {
            this.logger.error("rec.recruit.con.saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error("rec.recruit.con.recRecruitReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if ("02".equals(recRecruitReDomain.getRecruitType()) && (recRecruitReDomain.getRecRecruitPersonnelList() == null || recRecruitReDomain.getRecRecruitPersonnelList().size() < 3)) {
            this.logger.error("rec.recruit.con.recRecruitReDomain", (Object)"recRecruitPersonnelList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u73ed\u7ec4\u7684\u521b\u5efa\u4e0d\u5f97\u5c11\u4e8e3\u4e2a\u4eba\uff01");
        }
        if (null != recRecruitReDomain) {
            recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            recRecruitReDomain.setMemberBname(userSession.getUserName());
            recRecruitReDomain.setMemberName(userSession.getMerberCompname());
            recRecruitReDomain.setMemberCode(this.getUserInfo(request).getUserInfoCode());
            recRecruitReDomain.setMemberBcode(userSession.getUserCode());
        }
        recRecruitReDomain.setRecruitCode(this.getCode(recRecruitReDomain.getTenantCode(), "1"));
        recRecruitReDomain.setResourceState("0");
        this.logger.error(CODE, (Object)("RecRecruitEnrollList:" + recRecruitReDomain.getRecRecruitEnrollList().size()));
        return this.recRecruitServiceRepository.saveRecruit(recRecruitReDomain);
    }

    private synchronized String getCode(String tenantCode, String type) {
        String s;
        String yyyyMM = DateUtil.getDateString((Date)new Date(), (String)"yyyyMM");
        Integer no = 0;
        HashMap<String, Constable> param = new HashMap<String, Constable>();
        param.put(dao_startRow, Integer.valueOf(0));
        param.put(dao_endRow, Integer.valueOf(1));
        param.put("order", Boolean.valueOf(true));
        SupQueryResult queryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            no = ((RecRecruitReDomain)queryResult.getList().get(0)).getRecruitId();
        }
        if (StringUtils.isNotBlank((String)(s = String.valueOf(no + 1))) && s.length() < 5) {
            s = "00000" + s;
            s = s.substring(s.length() - 5);
        }
        return yyyyMM + type + s;
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruit(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error("rec.recruit.con.getRecruit", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruit(recruitId);
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = null;
        if (null != recRecruitReDomain && StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            map.put("colName0", "DATA_STATE");
            map.put("colValue0", "0,1");
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
            this.maskeAddress(recRecruitEnrollDomainList, tenantCode);
            String openFlag = "0";
            UserSession userSession = this.getUserSession(request);
            if (userSession.getUserPcode().equals(recRecruitReDomain.getMemberCode())) {
                openFlag = "2";
            }
            for (RecRecruitEnrollDomain recRecruitEnrollDomain : recRecruitEnrollDomainList) {
                if (!userSession.getUserPcode().equals(recRecruitEnrollDomain.getMemberCode())) continue;
                openFlag = "1";
            }
            recRecruitReDomain.setOpenFlag(openFlag);
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            map.remove("colName0");
            map.remove("colValue0");
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            System.out.println("recRecruitReDomain.getRecruitType------------------------888889----------------------------" + recRecruitReDomain.getRecruitType());
            if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitType()) && recRecruitReDomain.getRecruitType().equals("02")) {
                SupQueryResult supQueryResult = this.recRecruitPersonnelServiceRepository.queryRecRecruitPersonnelPage(map);
                List recRecruitPersonnelReDomainList = null;
                System.out.println("supQueryResult.getList------------------------88888889---------------------------------" + supQueryResult.getList());
                if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    recRecruitPersonnelReDomainList = supQueryResult.getList();
                    for (int i = 0; i < recRecruitPersonnelReDomainList.size(); ++i) {
                        HashMap<String, String> map0 = new HashMap<String, String>();
                        map0.put("tenantCode", tenantCode);
                        map0.put("memberCode", ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).getMemberCode());
                        SupQueryResult supQueryResult0 = this.recRecruitServiceAreaServiceRepository.queryRecRecruitServiceAreaPage(map0);
                        ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).setRecRecruitServiceAreaReDomainList(supQueryResult0.getList());
                    }
                }
                recRecruitReDomain.setRecRecruitPersonnelList(recRecruitPersonnelReDomainList);
            }
        }
        if (null != recRecruitReDomain.getRecruitTel() && recRecruitReDomain.getRecruitTel().equals("1") && request.getParameter("mark") == null) {
            recRecruitReDomain.setRecruitContactEmail(this.display(recRecruitReDomain.getRecruitContactEmail()));
            recRecruitReDomain.setRecruitContactPhone(this.hideInfo(recRecruitReDomain.getRecruitContactPhone()));
            recRecruitReDomain.setRecruitContact(this.replaceNameX(recRecruitReDomain.getRecruitContact()));
        }
        return recRecruitReDomain;
    }

    @RequestMapping(value={"getDemand.json"}, name="\u83b7\u53d6\u9700\u6c42\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getDemand(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error("rec.recruit.con.getDemand", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruit(recruitId);
        if (null == recRecruitReDomain) {
            this.logger.error("rec.recruit.con.getDemand", (Object)"param is null");
            return null;
        }
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        HashMap<String, String> map = null;
        Boolean showFlag = false;
        if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            HashMap<String, String> recMap = new HashMap<String, String>();
            recMap.put("tenantCode", tenantCode);
            recMap.put("recruitCode", recRecruitReDomain.getRecruitCode());
            if (!userSession.getUserPcode().equals(recRecruitReDomain.getMemberCode())) {
                recMap.put("memberCode", userSession.getUserPcode());
            } else {
                showFlag = true;
            }
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(recMap).getList();
            this.maskeAddress(recRecruitEnrollDomainList, tenantCode);
            if (recMap.get("memberCode") != null && ListUtil.isNotEmpty((Collection)recRecruitEnrollDomainList)) {
                showFlag = true;
            }
            if ("001".equals(this.getProappCode(request))) {
                showFlag = true;
            }
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            recRecruitReDomain.setRecruitEnrollCount(Integer.valueOf(recRecruitEnrollDomainList.size()));
        }
        if (!showFlag.booleanValue() && null != recRecruitReDomain.getRecruitTel() && recRecruitReDomain.getRecruitTel().equals("1") && request.getParameter("mark") == null) {
            recRecruitReDomain.setRecruitContactEmail(this.display(recRecruitReDomain.getRecruitContactEmail()));
            recRecruitReDomain.setRecruitContactPhone(this.hideInfo(recRecruitReDomain.getRecruitContactPhone()));
            recRecruitReDomain.setRecruitContact(this.replaceNameX(recRecruitReDomain.getRecruitContact()));
        }
        return recRecruitReDomain;
    }

    private void maskeAddress(List<RecRecruitEnrollDomain> recRecruitEnrollDomainList, String tenantCode) {
        if (ListUtil.isNotEmpty(recRecruitEnrollDomainList)) {
            HashMap<String, Object> userinfoQuaMap = new HashMap<String, Object>();
            userinfoQuaMap.put("tenantCode", tenantCode);
            userinfoQuaMap.put("userinfoQuaKey", "userinfoAreaName");
            userinfoQuaMap.put("fuzzy", false);
            for (RecRecruitEnrollDomain enrollDomain : recRecruitEnrollDomainList) {
                if (!StringUtils.isNotBlank((String)enrollDomain.getMemberCode()) || !StringUtils.isBlank((String)enrollDomain.getGoodsReceiptArrdess())) continue;
                userinfoQuaMap.put("userinfoCode", enrollDomain.getMemberCode());
                SupQueryResult userinfoQuaPage = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(userinfoQuaMap);
                if (userinfoQuaPage == null || !ListUtil.isNotEmpty((Collection)userinfoQuaPage.getList())) continue;
                enrollDomain.setAddress(((UmUserinfoQuaReDomain)userinfoQuaPage.getList().get(0)).getUserinfoQuaVaule());
                enrollDomain.setGoodsReceiptArrdess(((UmUserinfoQuaReDomain)userinfoQuaPage.getList().get(0)).getUserinfoQuaVaule());
            }
        }
    }

    @RequestMapping(value={"getDemandByCode.json"}, name="\u83b7\u53d6\u9700\u6c42\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getDemandByCode(HttpServletRequest request, String recruitCode) {
        if (StringUtils.isBlank((String)recruitCode)) {
            this.logger.error("rec.recruit.con.getDemand", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruitByCode(this.getTenantCode(request), recruitCode);
        if (null == recRecruitReDomain) {
            this.logger.error("rec.recruit.con.getDemand", (Object)"param is null");
            return null;
        }
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = null;
        if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            recRecruitReDomain.setRecruitEnrollCount(Integer.valueOf(recRecruitEnrollDomainList.size()));
        }
        if (null != recRecruitReDomain.getRecruitTel() && recRecruitReDomain.getRecruitTel().equals("1") && request.getParameter("mark") == null) {
            recRecruitReDomain.setRecruitContactEmail(this.display(recRecruitReDomain.getRecruitContactEmail()));
            recRecruitReDomain.setRecruitContactPhone(this.hideInfo(recRecruitReDomain.getRecruitContactPhone()));
            recRecruitReDomain.setRecruitContact(this.replaceNameX(recRecruitReDomain.getRecruitContact()));
        }
        return recRecruitReDomain;
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, String paramStr) {
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error("rec.recruit.con.updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != recRecruitReDomain.getRecruitId()) {
            RecRecruitReDomain recruit = this.recRecruitServiceRepository.getRecruit(recRecruitReDomain.getRecruitId());
            if (null == recruit) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62db\u52df\u5355\u4e0d\u5b58\u5728");
            }
            UserSession userSession = this.getUserSession(request);
            if (!userSession.getUserPcode().equals(recruit.getMemberCode())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6743\u9650\u6709\u8bef");
            }
        }
        recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        return this.recRecruitServiceRepository.updateRecruit((RecRecruitDomain)recRecruitReDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error("rec.recruit.con.deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.deleteRecruit(recruitId);
    }

    @RequestMapping(value={"saveDemand.json"}, name="\u589e\u52a0\u9700\u6c42\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveDemand(HttpServletRequest request, String paramStr) {
        this.logger.error("saveDemand----------------------------------paramStr------------------------------" + paramStr);
        if (null == paramStr) {
            this.logger.error("rec.recruit.con.saveDemand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error("rec.recruit.con.recRecruitReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            recRecruitReDomain.setMemberBname(userSession.getUserName());
            recRecruitReDomain.setMemberName(userSession.getMerberCompname());
            recRecruitReDomain.setMemberCode(this.getUserInfo(request).getUserInfoCode());
            recRecruitReDomain.setMemberBcode(userSession.getUserCode());
            recRecruitReDomain.setRecruitType("03");
        }
        if (recRecruitReDomain.getRecruitSdate() == null) {
            recRecruitReDomain.setRecruitSdate(new Date());
        }
        recRecruitReDomain.setResourceState("0");
        return this.recRecruitServiceRepository.saveRecruit(recRecruitReDomain);
    }

    @RequestMapping(value={"queryDemandPage.json"}, name="\u67e5\u8be2\u9700\u6c42\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryDemandPage(HttpServletRequest request, String qualityQtypeCode) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        String map = param.toString();
        String type = request.getParameter("type");
        String searchType = request.getParameter("searchType");
        StringBuffer childList = new StringBuffer();
        if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
            if (StringUtils.isNotBlank((String)searchType) && "1".equals(searchType)) {
                childList.append(qualityQtypeCode);
            } else {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("qualityQtypePcode", qualityQtypeCode);
                map1.put("tenantCode", this.getTenantCode(request));
                SupQueryResult UmQualityQtype = this.umQualityQtypeServiceRepository.queryQualityQtypePage(map1);
                if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                    return new SupQueryResult();
                }
                for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                    childList.append(q.getQualityQtypeCode() + ",");
                }
            }
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberCode", userSession.getUserPcode());
            }
            param.put("recruitType", "03");
            param.put("resourceState", "0");
            String resourceStateFlag = request.getParameter("resourceStateFlag");
            if (StringUtils.isNotBlank((String)resourceStateFlag) && "1".equals(resourceStateFlag)) {
                param.remove("resourceState");
            }
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            if (childList != null) {
                param.put("qualityQtypeCode", childList);
            }
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            this.logger.error("rec.recruit.conenrollList", (Object)((Object)mapParm).toString());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            if (ListUtil.isEmpty((Collection)enrollList)) {
                ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(0));
                continue;
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            String flag = "0";
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
                if (userSession == null || "".equals(userSession) || userSession.getUserCode() == null || !StringUtils.isNotBlank((String)userSession.getUserCode()) || !rr.getMemberCode().equals(userSession.getUserCode())) continue;
                flag = "1";
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitOrigin(flag);
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
            ((RecRecruitReDomain)list.get(i)).setRecRecruitEnrollList(enrollList);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPage(HttpServletRequest request, String qualityQtypeCode) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        String map = param.toString();
        String type = request.getParameter("type");
        String searchType = request.getParameter("searchType");
        StringBuffer childList = new StringBuffer();
        if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
            if (StringUtils.isNotBlank((String)searchType) && "1".equals(searchType)) {
                childList.append(qualityQtypeCode);
            } else {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("qualityQtypePcode", qualityQtypeCode);
                map1.put("tenantCode", this.getTenantCode(request));
                SupQueryResult UmQualityQtype = this.umQualityQtypeServiceRepository.queryQualityQtypePage(map1);
                if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                    return new SupQueryResult();
                }
                for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                    childList.append(q.getQualityQtypeCode() + ",");
                }
            }
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberCode", userSession.getUserPcode());
            }
            param.put("resourceState", "0");
            String resourceStateFlag = request.getParameter("resourceStateFlag");
            if (StringUtils.isNotBlank((String)resourceStateFlag) && "1".equals(resourceStateFlag)) {
                param.remove("resourceState");
            }
            param.put("recruitType", "01");
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            if (childList != null) {
                param.put("qualityQtypeCode", childList);
            }
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        int recruitEnrollCount = 0;
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            mapParm.put("colName0", "DATA_STATE");
            mapParm.put("colValue0", "0,1");
            this.logger.error("rec.recruit.conenrollList", (Object)((Object)mapParm).toString());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            if (ListUtil.isEmpty((Collection)enrollList)) {
                ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(0));
                continue;
            }
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            String flag = "0";
            for (RecRecruitEnrollDomain rr : enrollList) {
                if ("2".equals(((RecRecruitReDomain)list.get(i)).getRecruitObj()) && rr.getDataOpbillstate() == 1) {
                    ++recruitEnrollCount;
                }
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
                if (userSession == null || "".equals(userSession) || userSession.getUserCode() == null || !StringUtils.isNotBlank((String)userSession.getUserCode()) || !rr.getMemberCode().equals(userSession.getUserCode())) continue;
                flag = "1";
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(recruitEnrollCount));
            ((RecRecruitReDomain)list.get(i)).setRecruitOrigin(flag);
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
            ((RecRecruitReDomain)list.get(i)).setRecRecruitEnrollList(enrollList);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState, String memo) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error("rec.recruit.con.updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        this.logger.error("rec.recruit.con.updateRecruitState", (Object)("memo:" + memo));
        return this.recRecruitServiceRepository.updateRecruitState(Integer.valueOf(recruitId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"queryCountByState.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rec.recruit.con.queryCountByState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        return this.recRecruitServiceRepository.queryCountByState(tenantCode, dataState);
    }

    @RequestMapping(value={"queryCountByState1.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e1")
    @ResponseBody
    public HtmlJsonReBean queryCountByState1(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rec.recruit.con.queryCountByState1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        int dataState = 0;
        this.logger.error("rec.recruit.con.queryCountByState1", (Object)("param :" + tenantCode + "," + dataState + "," + recruitType + "," + userSession.getUserPcode()));
        return this.recRecruitServiceRepository.queryCountByState1(tenantCode, dataState, recruitType, userSession.getUserPcode());
    }

    @RequestMapping(value={"queryCountByState2.json"}, name="\u9700\u6c42\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState2(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rec.recruit.con.queryCountByState2", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        int dataState = 0;
        this.logger.error("rec.recruit.con.queryCountByState2", (Object)("param :" + tenantCode + "," + dataState + "," + recruitType + "," + userSession.getUserPcode()));
        return this.recRecruitServiceRepository.queryCountByState2(tenantCode, dataState, recruitType, userSession.getUserPcode());
    }

    @RequestMapping(value={"userAcitivyPage.json"}, name="\u7528\u6237\u6d3b\u8dc3\u5ea6\u6392\u884c")
    @ResponseBody
    public SupQueryResult<UmUserInfoReDomain> userActivityPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.userAcitivyPage(param);
        return supQueryResult;
    }

    @RequestMapping(value={"queryRecruitPageC.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPageC(HttpServletRequest request, String qualityQtypeCode) {
        List recEnrollList;
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        StringBuffer recruitCode = new StringBuffer();
        String map = param.toString();
        String type = request.getParameter("type");
        String searchType = request.getParameter("searchType");
        StringBuffer childList = new StringBuffer();
        if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
            if (StringUtils.isNotBlank((String)searchType) && "1".equals(searchType)) {
                childList.append(qualityQtypeCode);
            } else {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("qualityQtypePcode", qualityQtypeCode);
                map1.put("tenantCode", this.getTenantCode(request));
                SupQueryResult UmQualityQtype = this.umQualityQtypeServiceRepository.queryQualityQtypePage(map1);
                if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                    return new SupQueryResult();
                }
                for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                    childList.append(q.getQualityQtypeCode() + ",");
                }
            }
        }
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("fuzzy", true);
        param1.put("tenantCode", this.getTenantCode(request));
        param1.put("memberCode", userSession.getUserPcode());
        if (param.get("enrollState") != null) {
            if (Objects.equals("3", param.get("enrollState").toString())) {
                param1.put("dataOpbillstate", 0);
            } else {
                param1.put("dataState", param.get("enrollState"));
            }
        }
        if ((recEnrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(param1).getList()) != null && ListUtil.isNotEmpty((Collection)recEnrollList)) {
            for (RecRecruitEnrollDomain recEnroll : recEnrollList) {
                if (param.get("recruitCode") != null) {
                    this.logger.error("--------\u6839\u636e\u62db\u52df\u5355\u53f7\u67e5\u8be2----------");
                    if (!recEnroll.getRecruitCode().matches(".*" + param.get("recruitCode") + ".*")) continue;
                    this.logger.error("--------\u8f93\u5165\u5355\u53f7\u5305\u542b----------");
                    recruitCode.append(recEnroll.getRecruitCode() + ",");
                    continue;
                }
                this.logger.error("--------\u8f93\u5165\u5355\u53f7\u4e0d\u5305\u542b----------");
                recruitCode.append(recEnroll.getRecruitCode() + ",");
            }
        }
        if (StringUtils.isEmpty((String)recruitCode.toString()) || recruitCode.length() == 0) {
            return new SupQueryResult();
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)String.valueOf(childList))) {
                param.put("qualityQtypeCode", childList);
            }
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberBcode", userSession.getUserCode());
            }
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            param.put("recruitObj", "2");
            param.put("recruitCode", recruitCode);
            param.put("resourceState", "0");
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            String flag = "0";
            if (!ListUtil.isNotEmpty((Collection)enrollList)) continue;
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
                if (userSession.getUserCode() == null || !StringUtils.isNotBlank((String)userSession.getUserCode()) || !rr.getMemberCode().equals(userSession.getUserCode())) continue;
                flag = "1";
            }
            RecRecruitEnrollDomain recRecruitEnrollDomain = (RecRecruitEnrollDomain)enrollList.get(0);
            Integer dataState = recRecruitEnrollDomain.getDataState();
            Integer dataOpbillstate = recRecruitEnrollDomain.getDataOpbillstate();
            if (dataOpbillstate == 0) {
                dataState = 3;
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitOrigin(flag);
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            ((RecRecruitReDomain)list.get(i)).setEnrollState(dataState);
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"getRecruitByCode.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruitByCode(HttpServletRequest request, String recruitCode) {
        if (StringUtils.isBlank((String)recruitCode)) {
            this.logger.error("rec.recruit.con.getRecruit", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruitByCode(tenantCode, recruitCode);
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        HashMap<String, String> map = null;
        if (null != recRecruitReDomain && StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            System.out.println("recRecruitReDomain.getRecruitType------------------------888889----------------------------" + recRecruitReDomain.getRecruitType());
            if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitType()) && recRecruitReDomain.getRecruitType().equals("02")) {
                SupQueryResult supQueryResult = this.recRecruitPersonnelServiceRepository.queryRecRecruitPersonnelPage(map);
                List recRecruitPersonnelReDomainList = null;
                System.out.println("supQueryResult.getList------------------------88888889---------------------------------" + supQueryResult.getList());
                if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    recRecruitPersonnelReDomainList = supQueryResult.getList();
                    for (int i = 0; i < recRecruitPersonnelReDomainList.size(); ++i) {
                        HashMap<String, String> map0 = new HashMap<String, String>();
                        map0.put("tenantCode", tenantCode);
                        map0.put("memberCode", ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).getMemberCode());
                        SupQueryResult supQueryResult0 = this.recRecruitServiceAreaServiceRepository.queryRecRecruitServiceAreaPage(map0);
                        ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).setRecRecruitServiceAreaReDomainList(supQueryResult0.getList());
                    }
                }
                recRecruitReDomain.setRecRecruitPersonnelList(recRecruitPersonnelReDomainList);
            }
        }
        return recRecruitReDomain;
    }

    public String hideInfo(String str) {
        return str.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public String replaceNameX(String str) {
        String reg = ".{1}";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        int i = 0;
        while (m.find()) {
            if (++i == 1) continue;
            m.appendReplacement(sb, SYMBOL);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String display(String value) {
        if (null == value || "".equals(value)) {
            return value;
        }
        int len = value.length();
        int pamaone = len / 2;
        int pamatwo = pamaone - 1;
        int pamathree = len % 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (len <= 2) {
            if (pamathree == 1) {
                return SYMBOL;
            }
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.charAt(len - 1));
        } else if (pamatwo <= 0) {
            stringBuilder.append(value.substring(0, 1));
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.substring(len - 1, len));
        } else if (pamatwo >= 2 && 5 != len) {
            int pamafive = (len - 4) / 2;
            stringBuilder.append(value.substring(0, pamafive));
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(SYMBOL);
            }
            if (pamathree == 0) {
                // empty if block
            }
            if (pamathree != 0) {
                // empty if block
            }
            stringBuilder.append(value.substring(len - (pamafive + 1), len));
        } else {
            int pamafour = len - 2;
            stringBuilder.append(value.substring(0, 1));
            for (int i = 0; i < pamafour; ++i) {
                stringBuilder.append(SYMBOL);
            }
            stringBuilder.append(value.substring(len - 1, len));
        }
        return stringBuilder.toString();
    }
}

