/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.res.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateReplyDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateReplyReDomain;
import com.qjsoft.laser.controller.facade.res.repository.ResEvaluateReplyServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/res/evaluateReply"}, name="\u8bc4\u4ef7\u56de\u590d")
public class EvaluateReplyCon
extends SpringmvcController {
    private static String CODE = "res.evaluateReply.con";
    @Autowired
    private ResEvaluateReplyServiceRepository resEvaluateReplyServiceRepository;

    protected String getContext() {
        return "evaluateReply";
    }

    @RequestMapping(value={"saveEvaluateReply.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u56de\u590d")
    @ResponseBody
    public HtmlJsonReBean saveEvaluateReply(HttpServletRequest request, ResEvaluateReplyDomain resEvaluateReplyDomain) {
        if (null == resEvaluateReplyDomain) {
            this.logger.error(CODE + ".saveEvaluateReply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        return this.fetchInfo(resEvaluateReplyDomain, userSession, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveEvaReplyForGoods.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u56de\u590d - \u5546\u54c1\u8bc4\u8bba\u5217\u8868\u9875")
    @ResponseBody
    public HtmlJsonReBean saveEvaReplyForGoods(HttpServletRequest request, ResEvaluateReplyDomain resEvaluateReplyDomain) {
        if (null == resEvaluateReplyDomain) {
            this.logger.error(CODE + ".saveEvaReplyForGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        return this.fetchInfo(resEvaluateReplyDomain, userSession, this.getTenantCode(request));
    }

    private HtmlJsonReBean fetchInfo(ResEvaluateReplyDomain resEvaluateReplyDomain, UserSession userSession, String tenantCode) {
        if (null == resEvaluateReplyDomain || null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        resEvaluateReplyDomain.setUserCode(userSession.getUserCode());
        resEvaluateReplyDomain.setMemberCode(userSession.getUserPcode());
        resEvaluateReplyDomain.setMemberName(userSession.getMerberCompname());
        resEvaluateReplyDomain.setTenantCode(tenantCode);
        return this.resEvaluateReplyServiceRepository.saveEvaluateReply(resEvaluateReplyDomain);
    }

    @RequestMapping(value={"getEvaluateReply.json"}, name="\u83b7\u53d6\u8bc4\u4ef7\u56de\u590d\u4fe1\u606f")
    @ResponseBody
    public ResEvaluateReplyReDomain getEvaluateReply(String evaluateReplyId) {
        if (StringUtils.isBlank((String)evaluateReplyId)) {
            this.logger.error(CODE + ".getEvaluateReply", (Object)"param is null");
            return null;
        }
        return this.resEvaluateReplyServiceRepository.getEvaluateReply(Integer.valueOf(evaluateReplyId));
    }

    @RequestMapping(value={"updateEvaluateReply.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u56de\u590d")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateReply(HttpServletRequest request, ResEvaluateReplyDomain resEvaluateReplyDomain) {
        if (null == resEvaluateReplyDomain) {
            this.logger.error(CODE + ".updateEvaluateReply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resEvaluateReplyDomain.setTenantCode(this.getTenantCode(request));
        return this.resEvaluateReplyServiceRepository.updateEvaluateReply(resEvaluateReplyDomain);
    }

    @RequestMapping(value={"deleteEvaluateReply.json"}, name="\u5220\u9664\u8bc4\u4ef7\u56de\u590d")
    @ResponseBody
    public HtmlJsonReBean deleteEvaluateReply(String evaluateReplyId) {
        if (StringUtils.isBlank((String)evaluateReplyId)) {
            this.logger.error(CODE + ".deleteEvaluateReply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateReplyServiceRepository.deleteEvaluateReply(Integer.valueOf(evaluateReplyId));
    }

    @RequestMapping(value={"queryEvaluateReplyPage.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u56de\u590d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResEvaluateReplyReDomain> queryEvaluateReplyPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resEvaluateReplyServiceRepository.queryEvaluateReplyPage(param);
    }

    @RequestMapping(value={"updateEvaluateReplyState.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u56de\u590d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateReplyState(String evaluateReplyId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)evaluateReplyId)) {
            this.logger.error(CODE + ".updateEvaluateReplyState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateReplyServiceRepository.updateEvaluateReplyState(Integer.valueOf(evaluateReplyId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateReplyDel.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u56de\u590d\u5220\u9664\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateReplyDel(String evaluateReplyId, Boolean del) {
        if (StringUtils.isBlank((String)evaluateReplyId) || del == null) {
            this.logger.error(CODE + ".updateReplyDel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateReplyServiceRepository.updateReplyDel(Integer.valueOf(evaluateReplyId), del);
    }

    @RequestMapping(value={"saveEvaReplyForGoodsForUser.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u56de\u590d - \u5546\u54c1\u8bc4\u8bba\u5217\u8868\u9875-\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean saveEvaReplyForGoodsForUser(HttpServletRequest request, ResEvaluateReplyDomain resEvaluateReplyDomain) {
        if (null == resEvaluateReplyDomain) {
            this.logger.error(CODE + ".saveEvaReplyForGoodsForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        return this.fetchInfo(resEvaluateReplyDomain, userSession, this.getTenantCode(request));
    }
}

