/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.sm.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.sm.domain.SmBlackipDomain;
import com.qjsoft.laser.controller.facade.sm.domain.SmBlackipReDomain;
import com.qjsoft.laser.controller.facade.sm.repository.BlackipServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sm/smblackip"}, name="\u9ed1\u540d\u5355\u7ba1\u7406")
public class SmBlackipCon
extends SpringmvcController {
    private static String CODE = "sm.smblackip.con";
    @Autowired
    private BlackipServiceRepository blackipServiceRepository;

    protected String getContext() {
        return "smblackip";
    }

    @RequestMapping(value={"saveSmBlackip.json"}, name="\u589e\u52a0\u9ed1\u540d\u5355\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveSmBlackip(HttpServletRequest request, SmBlackipDomain smblackipDomain) {
        if (null == smblackipDomain) {
            this.logger.error(CODE + ".saveSmBlackip", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        smblackipDomain.setTenantCode(this.getTenantCode(request));
        return this.blackipServiceRepository.saveSmBlackip(smblackipDomain);
    }

    @RequestMapping(value={"getSmBlackip.json"}, name="\u83b7\u53d6\u9ed1\u540d\u5355\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public SmBlackipReDomain getSmBlackip(Integer blackipId) {
        if (StringUtils.isBlank((Integer)blackipId)) {
            this.logger.error(CODE + ".getSmBlackip", (Object)"param is null");
            return null;
        }
        return this.blackipServiceRepository.getBlackip(blackipId);
    }

    @RequestMapping(value={"updateSmBlackip.json"}, name="\u66f4\u65b0\u9ed1\u540d\u5355\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateSmBlackip(HttpServletRequest request, SmBlackipDomain smblackipDomain) {
        if (null == smblackipDomain) {
            this.logger.error(CODE + ".updateSmBlackip", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        smblackipDomain.setTenantCode(this.getTenantCode(request));
        return this.blackipServiceRepository.updateBlackip(smblackipDomain);
    }

    @RequestMapping(value={"deleteSmBlackip.json"}, name="\u5220\u9664\u9ed1\u540d\u5355\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteSmBlackip(Integer blackipId) {
        if (StringUtils.isBlank((Integer)blackipId)) {
            this.logger.error(CODE + ".deleteSmBlackip", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.blackipServiceRepository.deleteSmBlackipById(blackipId);
    }

    @RequestMapping(value={"querySmBlackipPage.json"}, name="\u67e5\u8be2\u9ed1\u540d\u5355\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SmBlackipReDomain> querySmBlackipPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.blackipServiceRepository.querySmBlackipPage(param);
    }

    @RequestMapping(value={"updateSmBlackipState.json"}, name="\u66f4\u65b0\u9ed1\u540d\u5355\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSmBlackipState(String blackipId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)blackipId)) {
            this.logger.error(CODE + ".updateSmBlackipState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.blackipServiceRepository.updateBlackipState(Integer.valueOf(blackipId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryBlackipLoadCache.json"}, name="Blackip\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryBlackipLoadCache() {
        return this.blackipServiceRepository.queryBlackipCache();
    }
}

