/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.mns.domain.MnsMnslistDomainBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractReDomain;
import com.qjsoft.laser.controller.facade.sp.repository.SpScontractServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserBaseServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static String CODE = "sp.scontract.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private SpScontractServiceRepository spScontractServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private UserBaseServiceRepository userBaseServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontract(spScontractDomain);
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, String> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsSpec5(skuDomain.getSkuId().toString());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error(CODE + ".updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error(CODE + ".saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error(CODE + ".updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error(CODE + ".updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }

    @RequestMapping(value={"saveScontractStrNew1.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractNew1(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u65b0\u589e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractPageNew.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param.get("memberGcode") && !"".equals(param.get("memberGcode"))) {
            if ("0".equals(param.get("memberGcode")) || "1".equals(param.get("memberGcode"))) {
                param.put("order", true);
            } else {
                param.put("order", true);
                param.put("fuzzy", true);
            }
        } else {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null == spScontractReDomain.getContractDepositdate() || null == spScontractReDomain.getContractEffectivedate()) continue;
            Date endDate = spScontractReDomain.getContractDepositdate();
            Date startDate = spScontractReDomain.getContractEffectivedate();
            double times = endDate.getTime() - startDate.getTime();
            times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
            DecimalFormat df = new DecimalFormat("#0.0");
            String years = df.format(times);
            if (years.endsWith(".0")) {
                years = years.substring(0, years.length() - 2);
            }
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
            spScontractReDomain.setAreaName(years);
        }
        return result;
    }

    @RequestMapping(value={"updateScontractStr.json"}, name="\u4fee\u6539\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateScontractStr(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u4fee\u6539\u9500\u552e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SupQueryResult spScontractReDomainSupQueryResult;
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(scontractStr.getContractEffectivedate());
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            if (map.get("sconId") != null && !"".equals(map.get("sconId"))) {
                this.spScontractServiceRepository.deleteScontract(Integer.valueOf(map.get("sconId").toString()));
            }
            map.put("scontractCode", scontractStr.getScontractCode());
            List SpScontractFile = this.spScontractServiceRepository.queryScontractFilePage(map).getList();
            if (ListUtil.isNotEmpty((Collection)SpScontractFile)) {
                for (SpScontractFileReDomain spScontractFile : SpScontractFile) {
                    this.logger.error("ScontractFileId=================>", (Object)spScontractFile.getScontractFileId());
                    this.spScontractServiceRepository.deleteScontractFile(spScontractFile.getScontractFileId());
                }
            }
            scontractStr.setDataState(Integer.valueOf(1));
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractCode", htmlJsonReBean.getDataObj().toString());
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
            }
            if (null == (spScontractReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                this.logger.error("result=================>", (Object)spScontractReDomainSupQueryResult);
            } else {
                Integer scontractId = ((SpScontractReDomain)spScontractReDomainSupQueryResult.getList().get(0)).getScontractId();
                this.spScontractServiceRepository.updateScontractState(scontractId, Integer.valueOf(1), null, null);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryBuyerScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryBuyerScontractPage(HttpServletRequest request) {
        SupQueryResult result;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (result = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                Date endDate = spScontractReDomain.getContractDepositdate();
                Date startDate = spScontractReDomain.getContractEffectivedate();
                double times = endDate.getTime() - startDate.getTime();
                times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
                DecimalFormat df = new DecimalFormat("#0.0");
                String years = df.format(times);
                if (years.endsWith(".0")) {
                    years = years.substring(0, years.length() - 2);
                }
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
                spScontractReDomain.setAreaName(years);
            }
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                long endDate = spScontractReDomain.getContractDepositdate().getTime();
                long startDate = spScontractReDomain.getContractEffectivedate().getTime();
                long nowDate = new Date().getTime();
                Integer buttonState = 0;
                Integer dataState = spScontractReDomain.getDataState();
                if ("0".equals(spScontractReDomain.getMemberGcode()) && dataState != 5) {
                    if (startDate > nowDate) {
                        dataState = 0;
                        buttonState = 1;
                    } else if (nowDate >= startDate && nowDate <= endDate) {
                        if (dataState == 2) {
                            dataState = 2;
                            buttonState = 4;
                        } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                            if (Double.valueOf(spScontractReDomain.getMemberCname()) == 0.0) {
                                dataState = 4;
                                buttonState = 1;
                            } else {
                                dataState = 1;
                                buttonState = 2;
                            }
                        }
                    } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                        if (Double.valueOf(spScontractReDomain.getMemberCname()) > 0.0) {
                            dataState = 3;
                            buttonState = 3;
                        } else {
                            dataState = 4;
                            buttonState = 1;
                        }
                    }
                }
                spScontractReDomain.setDataState(dataState);
                spScontractReDomain.setContractUserurl(buttonState.toString());
            }
            if (!spScontractReDomain.getMemberGcode().startsWith("2")) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scontractCode", spScontractReDomain.getScontractCode());
            params.put("dataState", 1);
            SupQueryResult spScontractFileReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractFilePage(params);
            if (null == spScontractFileReDomainSupQueryResult || ListUtil.isEmpty((Collection)spScontractFileReDomainSupQueryResult.getList())) {
                spScontractReDomain.setContractUserurl("5");
                continue;
            }
            spScontractReDomain.setContractUserurl("6");
        }
        return result;
    }

    @RequestMapping(value={"updateScontractNew.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontractNew(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        SpScontractReDomain scontract = this.spScontractServiceRepository.getScontract(spScontractDomain.getScontractId());
        scontract.setContractDepositdate(spScontractDomain.getContractDepositdate());
        return this.spScontractServiceRepository.updateScontract((SpScontractDomain)scontract);
    }

    @RequestMapping(value={"updateScontractFileNew.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileNew(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scontractCode", goodsClassDomain.getScontractCode());
        SupQueryResult result = this.spScontractServiceRepository.queryScontractFilePage(param);
        goodsClassDomain.setScontractFileId(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        goodsClassDomain.setScontractFileCode(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileCode());
        this.logger.error("ScontractFileId----------------------------------------" + ((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"saveBuyerScontractExcelStr.json"}, name="\u5bfc\u5165\u4e70\u5bb6\u5408\u540c\u8868\u683c")
    @ResponseBody
    public HtmlJsonReBean saveBuyerScontractExcel(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractObillcode", scontractStr.getScontractObillcode());
            param.put("contractInvstate", 2);
            SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
            HtmlJsonReBean htmlJsonReBean = null;
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
                scontractStr.setContractInvstate(Integer.valueOf(1));
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            } else {
                SpScontractReDomain spScontractReDomain = (SpScontractReDomain)result.getList().get(0);
                spScontractReDomain.setMemberCcode(scontractStr.getMemberCcode());
                spScontractReDomain.setMemberCname(scontractStr.getMemberCname());
                htmlJsonReBean = this.spScontractServiceRepository.updateScontract((SpScontractDomain)spScontractReDomain);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractGoodsPageNew1.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868\uff08\u65b0\uff09")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryScontractGoodsPageNew1(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractGoodsPage(param);
        this.logger.error("\u5408\u540c\u5546\u54c11---------------------------------" + result.getList());
        SupQueryResult rsSkuResult = new SupQueryResult();
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            for (SpScontractGoodsReDomain spScontractGoodsReDomain : result.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", spScontractGoodsReDomain.getSkuCode());
                SupQueryResult rsSkuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuOnePage(map);
                this.logger.error("\u5408\u540c\u5546\u54c12---------------------------------" + rsSkuReDomainSupQueryResult.getRows());
                if (null != rsSkuReDomainSupQueryResult && !ListUtil.isEmpty((Collection)rsSkuReDomainSupQueryResult.getRows())) continue;
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)rsSkuReDomainSupQueryResult.getRows().get(0);
                rsSkuReDomain.setPricesetInsideprice(spScontractGoodsReDomain.getPricesetNprice());
                rsSkuResult.getRows().add(rsSkuReDomain);
                rsSkuResult.getList().add(rsSkuReDomain);
            }
        }
        this.logger.error("\u5408\u540c\u5546\u54c13---------------------------------" + rsSkuResult.getRows());
        return rsSkuResult;
    }

    public String readJsonFile(String fileName) {
        String jsonStr = "";
        this.logger.error("fileName---------------------------------" + fileName);
        try {
            File jsonFile = new File(fileName);
            FileReader fileReader = new FileReader(jsonFile);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            jsonStr = sb.toString();
            return jsonStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Map<String, List<String>>> type1(String tenantCode) {
        String memberGcode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-sp-memberGcode"));
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(memberGcode, Map.class);
        this.logger.error("list------------------------------" + list);
        return list;
    }

    private List<Map<String, Object>> type3() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n{\"AREA_CODE\":110101,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":18656965766},\n{\"AREA_CODE\":110102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110106,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110107,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110108,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110109,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110111,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110112,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110113,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110114,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110115,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":110116,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110117,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110118,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":110119,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120113,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120114,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120115,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120116,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120117,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120118,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120119,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120101,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120105,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120106,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120110,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120111,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":120112,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130181,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130183,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130184,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130105,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130107,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130108,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130109,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130110,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130111,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130121,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130123,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130125,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130126,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130127,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130128,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130129,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130130,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130131,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130132,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130133,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130171,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130172,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130202,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130203,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130204,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130205,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130207,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130208,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130209,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130223,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130224,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130225,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130227,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130229,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130271,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130272,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130273,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130274,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130281,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130283,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130372,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130302,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130303,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130304,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130306,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130321,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130322,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130324,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130371,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130402,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130403,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130404,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130406,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130407,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130408,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130423,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130424,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130425,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130426,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130427,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130430,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130431,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130432,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130433,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130434,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130435,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130471,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130473,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130481,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130526,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130527,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130528,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130529,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130530,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130531,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130532,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130533,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130534,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130535,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130571,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130581,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130582,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130502,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130503,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130521,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130522,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130523,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130524,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130525,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130635,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130636,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130637,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130638,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130671,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130672,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130681,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130682,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130683,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130684,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130602,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130606,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130607,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130608,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130609,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130623,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130624,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130626,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130627,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130628,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130629,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130630,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130631,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130632,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130633,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130634,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130773,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130702,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130703,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130705,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130706,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130708,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130709,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130722,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130723,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130724,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130725,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130726,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130727,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130728,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130730,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130731,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130732,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130771,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130772,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130802,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130803,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130804,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130821,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130822,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130824,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130825,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130826,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130827,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130828,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130871,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130881,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":130982,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130983,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130984,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130902,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130903,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130921,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130922,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130923,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130924,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130925,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130926,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130927,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130928,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130929,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130930,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130971,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130972,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130973,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":130981,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131002,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131003,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131022,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131023,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131024,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131025,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131026,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131028,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131071,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131081,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131082,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131121,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131122,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131123,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131124,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131125,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131126,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131127,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131128,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131171,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131172,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":131182,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":140402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140411,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140427,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140428,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140429,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140430,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140431,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140471,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140481,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140581,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140603,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140624,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140671,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140724,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140725,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140726,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140727,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140728,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140729,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140781,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140721,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140802,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140821,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140823,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140824,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140825,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140827,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140828,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140829,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140830,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140881,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140882,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140926,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140927,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140928,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140929,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140930,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140931,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140932,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140971,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140981,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140902,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140922,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140924,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140925,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141002,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141021,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141022,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141023,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141024,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141025,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141026,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141027,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141028,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141029,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141030,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141031,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141032,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141033,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141034,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141081,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141082,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141125,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141126,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141127,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141128,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141129,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141130,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141181,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":141182,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140106,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140107,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140108,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140109,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140110,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140181,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140211,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140212,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140226,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140227,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140271,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140311,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":140371,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":150102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150125,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150172,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150204,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150205,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150206,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150207,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150271,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150304,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150404,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150428,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150429,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150430,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150526,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150571,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150581,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150624,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150625,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150626,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150627,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150603,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150703,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150721,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150724,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150725,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150726,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150727,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150781,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150782,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150783,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150784,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150785,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150802,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150821,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150823,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150824,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150825,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150924,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150925,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150926,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150927,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150928,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150929,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150981,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150902,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":150922,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152201,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152501,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152526,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152527,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152528,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152529,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152530,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152531,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152571,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152922,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152971,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":152921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":210902,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210903,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210904,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210905,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210911,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210921,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210922,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211002,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211003,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211004,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211005,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211011,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211021,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211081,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211122,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211223,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211224,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211281,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211282,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211202,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211204,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211221,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211302,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211303,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211321,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211322,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211324,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211381,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211382,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211402,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211403,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211404,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211421,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211422,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":211481,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210105,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},");
        sb.append("{\"AREA_CODE\":210106,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210111,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210112,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210113,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210114,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210115,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210123,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210124,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210181,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210202,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210203,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210204,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210211,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210212,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210213,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210214,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210224,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210281,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210283,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210311,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210321,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210323,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210381,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210302,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210303,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210304,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210402,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210403,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210404,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210411,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210421,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210422,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210423,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210502,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210503,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210504,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210505,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210521,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210522,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210602,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210603,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210604,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210624,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210681,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210682,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210781,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210782,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210702,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210703,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210711,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210726,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210727,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210802,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210803,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210804,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210811,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210881,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":210882,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":220174,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220182,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220183,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220106,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220112,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220113,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220172,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220173,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220204,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220211,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220271,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220272,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220273,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220281,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220282,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220283,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220284,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220381,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220382,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220581,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220582,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220503,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220605,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220681,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220721,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220771,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220781,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220802,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220821,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220871,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220881,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":220882,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222401,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222404,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222405,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222406,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":222424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230108,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230109,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230110,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230111,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230112,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230113,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230125,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230126,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230127,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230128,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230129,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230183,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230184,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230227,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230229,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230230,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230231,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230281,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230204,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230205,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230206,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230207,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230208,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230304,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230305,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230306,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230381,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230382,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230404,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230405,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230406,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230407,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230503,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230505,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230506,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230603,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230604,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230605,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230606,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230624,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230671,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230703,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230704,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230705,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230706,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230707,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230708,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230709,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230710,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230711,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230712,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230713,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230714,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230715,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230716,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230781,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230804,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230805,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230811,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230828,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230881,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230882,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230883,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230803,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230902,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230903,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230904,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":230921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231002,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231003,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231004,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231005,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231025,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231071,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231081,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231083,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231084,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231085,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231086,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231182,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231181,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231226,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231281,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231282,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":231283,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232701,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232703,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232704,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232721,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":232723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":310115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310116,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310118,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310120,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310151,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310101,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310104,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310105,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310106,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310107,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310109,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310112,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310113,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":310114,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":320102,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320104,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320105,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320106,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320111,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320113,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320114,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320116,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320118,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320205,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320206,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320211,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320213,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320214,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320281,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320282,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320321,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320322,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320324,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320371,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320381,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320382,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320302,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320303,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320305,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320311,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320312,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320402,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320404,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320411,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320412,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320413,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320481,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320505,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320506,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320507,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320508,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320509,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320571,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320581,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320582,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320583,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320585,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320681,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320682,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320684,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320602,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320611,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320612,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320621,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320623,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320671,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320703,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320706,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320707,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320722,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320723,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320724,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320771,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320772,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320803,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320804,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320812,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320813,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320826,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320830,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320831,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320871,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320902,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320903,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320904,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320921,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320922,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320923,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320924,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320925,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320971,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":320981,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321002,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321003,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321012,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321023,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321071,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321081,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321084,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321102,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321111,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321112,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321171,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321181,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321182,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321183,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321202,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321203,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321204,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321271,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321281,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321282,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321283,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321302,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321311,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321322,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321323,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321324,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":321371,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":330103,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330104,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330105,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330106,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330108,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330109,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330110,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330111,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330112,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330122,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330127,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330182,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330102,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330203,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330205,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330206,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330211,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330212,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330213,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330225,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330226,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330281,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330282,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330327,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330328,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330329,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330371,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330381,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330382,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330302,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330303,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330304,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330305,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330324,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330326,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330402,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330411,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330421,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330424,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330481,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330482,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330483,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330502,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330503,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330521,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330522,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330523,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330602,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330603,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330604,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330624,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330681,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330683,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330781,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330782,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330783,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330784,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330702,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330703,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330723,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330726,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330727,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330802,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330803,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330822,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330824,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330825,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330881,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330902,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330903,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330921,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":330922,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331002,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331003,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331004,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331022,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331023,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331024,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331081,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331082,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331083,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331125,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331126,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331127,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331181,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331102,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331121,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331122,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331123,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":331124,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"AREA_CODE\":340503,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340504,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340506,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340521,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340522,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340523,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340602,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340603,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340604,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340621,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340705,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340706,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340711,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340722,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340824,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340825,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340826,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340827,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340828,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340871,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340881,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340802,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340803,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340811,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340822,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341002,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341003,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},");
        sb.append("{\"AREA_CODE\":341004,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341021,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341022,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341023,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341024,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341102,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341103,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341122,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341124,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341125,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341126,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341171,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341172,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341181,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341182,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341222,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341225,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341226,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341271,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341272,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341282,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341202,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341203,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341204,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341221,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341302,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341321,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341322,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341323,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341324,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341371,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341372,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341502,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341503,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341504,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341522,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341523,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341524,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341525,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341602,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341621,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341622,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341623,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341702,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341721,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341722,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341723,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341802,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341821,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341822,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341823,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341824,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341825,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341871,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":341881,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340102,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340103,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340104,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340111,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340121,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340122,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340123,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340124,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340171,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340172,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340173,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340181,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340202,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340203,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340207,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340208,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340221,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340222,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340223,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340225,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340271,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340272,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340311,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340321,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340322,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340323,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340371,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340372,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340302,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340303,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340304,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340402,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340403,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340404,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340405,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340406,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340421,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":340422,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"AREA_CODE\":350102,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350103,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350104,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350105,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350111,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350121,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350122,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350123,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350124,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350125,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350128,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350181,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350182,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350203,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350205,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350206,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350211,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350212,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350213,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350304,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350305,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350322,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350302,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350303,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350402,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350403,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350421,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350423,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350424,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350425,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350426,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350427,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350428,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350429,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350430,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350481,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350502,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350503,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350504,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350505,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350521,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350524,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350525,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350526,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350527,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350581,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350582,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350583,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350603,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350622,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350623,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350624,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350625,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350626,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350627,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350628,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350629,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350681,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350602,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350702,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350703,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350721,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350722,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350723,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350724,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350725,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350781,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350782,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350783,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350802,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350803,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350821,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350823,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350824,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350825,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350881,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":350922,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350923,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350924,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350925,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350926,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350981,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350982,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350902,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":350921,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360802,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360803,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360821,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360822,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360823,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360824,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360825,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360826,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360827,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360828,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360829,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360830,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360881,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360902,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360921,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360922,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360923,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360924,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360925,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360926,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360981,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360982,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360983,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361003,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361021,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361022,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361023,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361024,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361025,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361026,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361027,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361028,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361030,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361002,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361102,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361103,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361121,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361123,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361124,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361125,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361126,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361127,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361128,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361129,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361130,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":361181,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360102,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360103,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360104,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360105,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360111,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360112,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360121,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360123,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360124,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360202,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360203,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360222,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360281,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360302,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360313,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360321,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360322,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360323,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360423,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360424,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360425,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360426,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360428,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360429,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360430,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360481,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360482,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360483,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360402,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360403,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360404,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360502,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360521,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360602,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360622,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360681,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360733,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360734,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360735,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360781,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360702,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360703,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360704,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360722,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360723,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360724,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360725,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360726,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360727,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360728,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360729,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360730,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360731,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":360732,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":370124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370125,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370126,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370112,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370113,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370114,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370211,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370212,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370213,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370214,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370215,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370271,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370281,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370283,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370285,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370304,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370305,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370306,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370481,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370404,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370405,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370406,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370503,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370505,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370571,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370572,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370611,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370612,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370613,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370634,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370671,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370672,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370681,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370682,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370683,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370684,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370685,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370686,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370687,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370772,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370781,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370782,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370783,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370784,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370785,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370786,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370703,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370704,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370705,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370724,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370725,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370811,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370812,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370827,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370828,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370829,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370830,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370831,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370832,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370871,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370881,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370883,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370982,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370983,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370902,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370911,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":370923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371002,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371003,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371071,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371072,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371073,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371082,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371083,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371172,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371311,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371312,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371325,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371326,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371327,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371328,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371329,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371371,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371372,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371373,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371427,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371428,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371471,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371472,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371481,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371482,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371403,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371526,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371581,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371602,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371603,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371625,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371626,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371728,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371771,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371772,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371703,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371721,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371724,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371725,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":371726,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":410902,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410922,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410923,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410926,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410927,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410928,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410971,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410972,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411002,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411003,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411024,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411025,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411071,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411081,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411082,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411121,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411122,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411171,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411202,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411203,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411221,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411224,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411271,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411281,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411282,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411302,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411303,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411321,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411322,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411323,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411324,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411325,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411326,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411327,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411328,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411329,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411330,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411371,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411372,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411381,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411421,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411422,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411423,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411424,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411425,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411426,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411471,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411472,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411481,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411402,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411403,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411502,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411503,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411521,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411522,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411523,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411524,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411525,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411526,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411527,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411528,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411571,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},");
        sb.append("{\"AREA_CODE\":411628,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411671,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411681,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411602,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411621,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411622,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411623,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411624,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411625,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411626,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411627,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411702,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411721,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411722,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411723,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411724,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411725,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411726,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411727,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411728,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411729,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":411771,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":419001,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410102,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410103,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410104,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410105,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410106,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410108,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410122,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410171,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410172,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410173,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410181,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410182,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410183,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410184,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410185,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410202,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410203,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410204,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410205,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410212,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410221,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410222,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410223,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410225,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410303,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410304,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410305,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410306,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410311,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410322,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410323,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410324,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410325,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410326,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410327,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410328,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410329,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410371,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410381,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410302,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410402,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410403,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410404,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410411,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410421,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410422,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410423,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410425,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410471,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410472,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410481,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410482,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410503,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410505,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410506,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410522,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410523,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410526,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410527,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410571,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410581,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410502,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410602,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410603,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410611,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410621,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410622,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410671,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410782,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410702,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410703,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410704,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410711,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410721,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410724,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410725,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410726,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410727,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410728,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410771,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410772,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410773,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410781,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410802,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410803,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410804,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410811,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410821,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410822,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410823,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410825,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410871,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410882,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":410883,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":420102,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420103,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420104,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420105,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420106,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420107,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420111,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420112,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420113,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420114,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420115,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420116,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420117,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420203,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420204,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420205,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420222,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420281,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420202,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420302,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420303,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420304,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420322,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420323,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420324,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420325,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420381,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420502,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420503,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420504,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420505,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420506,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420525,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420526,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420527,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420528,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420529,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420581,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420582,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420583,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420607,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420624,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420625,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420626,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420682,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420683,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420684,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420602,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420606,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420702,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420703,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420704,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420802,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420804,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420821,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420822,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420881,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420902,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420921,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420922,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420923,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420981,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420982,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":420984,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421083,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421087,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421002,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421003,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421022,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421023,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421024,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421071,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421081,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421102,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421121,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421122,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421123,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421124,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421125,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421126,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421127,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421171,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421181,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421182,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421202,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421221,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421222,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421223,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421224,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421281,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421303,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421321,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":421381,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422801,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422802,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422822,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422823,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422825,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422826,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422827,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":422828,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":429004,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":429005,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":429006,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":429021,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"AREA_CODE\":430502,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430503,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430511,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430521,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430522,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430523,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430524,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430525,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430527,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430528,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430529,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430581,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430621,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430623,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430624,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430626,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430671,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430681,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430682,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430602,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430603,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430611,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430702,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430703,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430721,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430722,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430723,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430724,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430725,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430726,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430771,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430781,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430802,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430811,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430821,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430822,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430981,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430902,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430903,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430921,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430922,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430923,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430971,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430972,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431002,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431003,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431021,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431022,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431023,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431024,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431025,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431026,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431027,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431028,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431081,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431102,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431103,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431121,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431122,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431123,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431124,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431125,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431126,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431127,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431128,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431129,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431171,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431172,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431173,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431223,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431224,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431225,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431226,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431227,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431228,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431229,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431230,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431271,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431281,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431202,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431221,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431222,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431302,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431321,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431322,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431381,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":431382,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433101,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433122,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433123,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433124,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433125,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433126,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433127,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433130,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433172,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":433173,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430102,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430103,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430104,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430105,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430111,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430112,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430121,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430181,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430182,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430202,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430203,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430204,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430211,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430221,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430223,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430224,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430225,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430271,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430281,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430302,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430304,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430321,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430371,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430372,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430373,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430381,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430382,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430406,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430407,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430408,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430412,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430421,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430422,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430423,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430424,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430426,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430471,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430472,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430473,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430481,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430482,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":430405,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":445281,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445202,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445203,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445222,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445224,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445302,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445303,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445321,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445322,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":445381,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440106,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440111,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440112,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":440113,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440114,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440115,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440117,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440118,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":440103,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440104,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440105,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440203,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440204,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440205,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440222,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440224,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440229,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440232,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440233,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440281,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440282,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440303,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":440304,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":440305,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":440306,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":440307,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":440308,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":440309,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":440310,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":440404,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440402,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440403,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440507,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440511,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440512,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440513,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440514,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440515,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440523,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"AREA_CODE\":440604,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440605,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":440606,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":440607,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440608,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":440703,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440704,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440705,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440781,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":440783,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440784,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440785,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440802,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440803,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440804,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440811,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440823,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440825,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440881,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440882,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440883,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440902,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440904,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440981,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440982,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":440983,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":441202,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441203,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441204,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441223,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441224,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441225,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441226,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441284,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441302,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441303,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441322,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441323,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441324,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441402,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441403,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441422,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441423,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441424,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441426,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441427,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441481,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441523,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441581,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441502,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441521,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441602,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441621,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441622,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441623,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441624,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441625,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":441702,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":441704,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":441721,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":441781,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":441802,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441803,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441821,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441823,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441825,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441826,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441881,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441882,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"AREA_CODE\":441900,\"HCCONTRACT_TYPEPRO\":13509607855,\"LPJCONTRACT_TYPEPRO\":13509607855},\n{\"AREA_CODE\":442000,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"AREA_CODE\":445102,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":445103,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":445122,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450102,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450103,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450105,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450107,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450108,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450109,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450110,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450123,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450124,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450125,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450126,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450127,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450202,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450203,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450204,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450205,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},");
        sb.append("{\"AREA_CODE\":450206,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450222,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450223,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450224,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450225,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450226,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450302,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450303,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450304,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450305,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450311,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450312,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450321,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450323,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450324,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450325,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450326,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450327,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450328,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450329,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450330,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450331,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450332,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":450403,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450405,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450406,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450421,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450422,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450423,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450481,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450502,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450503,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450512,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450521,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450603,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450621,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450681,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450602,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450702,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450703,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450721,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450722,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450802,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450803,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450804,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450821,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450881,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450902,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450903,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450921,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450922,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450923,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450924,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":450981,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451002,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451021,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451022,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451023,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451024,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451026,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451027,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451028,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451029,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451030,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451031,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451081,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451102,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":451103,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":451121,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":451122,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":451123,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"AREA_CODE\":451224,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451225,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451226,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451227,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451228,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451229,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451202,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451203,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451221,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451222,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451223,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451302,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451321,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451322,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451323,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451324,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451381,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451402,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451421,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451422,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451423,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451424,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451425,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":451481,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"AREA_CODE\":460105,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460106,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460107,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460108,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460202,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460203,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460204,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460205,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460322,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460323,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460321,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":460400,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469001,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469002,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469005,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469006,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469007,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469021,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469022,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469023,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469024,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469025,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469026,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469027,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469028,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469029,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":469030,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"AREA_CODE\":500112,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500113,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500114,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500115,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500116,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500117,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500118,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500119,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500120,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500151,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500152,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500153,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500154,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500155,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500156,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500101,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500103,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500104,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500105,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500106,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500107,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500108,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500109,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500110,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500111,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500229,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500230,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500231,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500233,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500235,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500236,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500237,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500238,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500240,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500241,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500242,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":500243,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510703,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510704,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510705,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510722,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510723,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510725,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510726,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510727,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510781,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510823,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510824,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510802,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510811,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510812,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510821,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510822,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510903,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510904,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":510923,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511002,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511011,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511024,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511025,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511071,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511083,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511111,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511112,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511113,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511123,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511124,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511126,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511129,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511132,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511133,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511181,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511324,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511325,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511381,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511302,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511303,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511304,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511321,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511402,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511403,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511421,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511423,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511424,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511425,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511502,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511503,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511521,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511523,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511524,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511525,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511526,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511527,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511528,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511529,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511602,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511603,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511621,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511622,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511681,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511722,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511723,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511724,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511725,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511771,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511781,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511702,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511703,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":\"\",\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":511902,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511903,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511923,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":511971,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":512002,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":512021,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":512022,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513225,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513226,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513227,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513228,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513230,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513231,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513232,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513233,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513201,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513221,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513222,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513223,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513224,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513301,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513324,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513325,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513326,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513327,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513328,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513329,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513330,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513331,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513332,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513333,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513334,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513335,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513336,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513337,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513338,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513424,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513425,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513426,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513427,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513428,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513429,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513430,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513431,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513432,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513433,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513434,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513435,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513436,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513437,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513401,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513422,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":513423,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510105,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510106,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510107,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510108,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510112,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510113,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510114,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510115,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510116,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510117,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510121,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510129,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510131,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510132,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510181,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510182,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510183,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510184,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510185,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510104,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510302,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510303,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510304,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510311,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510321,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510422,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510402,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510403,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510411,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510421,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510502,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510503,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510504,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510521,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510522,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510524,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510525,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510603,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510604,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510681,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510682,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":510683,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13679038688},\n{\"AREA_CODE\":520102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520103,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520111,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520112,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520113,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520115,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520121,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520122,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520123,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520181,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520201,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520203,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520221,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520281,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520302,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520303,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520304,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520324,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520325,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520326,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520327,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520328,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520329,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520330,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520381,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520382,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520402,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520403,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520422,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520423,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520424,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520425,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520502,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520521,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520522,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520523,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520524,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520525,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520526,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520527,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520602,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520603,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520621,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520622,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520624,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520625,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520626,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520627,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":520628,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522301,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522324,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522325,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522326,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522327,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522328,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522632,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522633,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522634,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522635,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522636,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522601,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522622,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522624,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522625,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522626,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522627,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522628,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522629,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522630,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522631,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522701,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522702,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522722,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522723,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522725,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522726,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522727,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522728,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522729,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522730,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522731,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":522732,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13541258242},\n{\"AREA_CODE\":530623,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530624,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530625,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530626,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530627,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530628,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530629,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530630,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530602,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530621,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530622,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530702,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530721,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530722,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530723,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530724,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530802,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530821,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530822,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530823,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530824,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530825,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530826,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530827,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530828,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530829,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530925,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530926,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530927,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530902,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530921,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530922,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530923,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530924,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532301,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532323,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532324,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532325,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532326,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532327,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532328,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532329,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532331,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532501,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532502,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532503,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532504,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532523,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532524,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532525,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532527,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532528,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532529,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532530,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532531,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532532,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532623,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532624,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532625,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532626,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532627,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532628,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532601,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532622,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532801,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532822,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532823,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532901,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532922,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532923,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532924,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532925,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},");
        sb.append("{\"AREA_CODE\":532926,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532927,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532928,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532929,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532930,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532931,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":532932,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533102,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533103,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533122,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533123,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533124,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533325,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533301,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533323,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533324,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533401,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533422,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":533423,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530128,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530129,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530181,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530102,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530103,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530111,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530112,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530113,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530114,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530115,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530124,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530125,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530126,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530127,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530302,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530303,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530321,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530323,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530324,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530325,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530326,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530381,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530402,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530403,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530422,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530423,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530424,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530425,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530426,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530427,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530428,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530502,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530521,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530523,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530524,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":530581,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"AREA_CODE\":540102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540126,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540127,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540172,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540173,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540174,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540232,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540233,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540234,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540235,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540236,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540237,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540226,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540227,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540228,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540229,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540230,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540231,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540325,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540326,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540327,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540328,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540329,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540330,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540526,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540527,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540528,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540529,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540530,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540531,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":540524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542427,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542428,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542429,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542430,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542431,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542526,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":542527,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":611002,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611021,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611022,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611023,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611024,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611025,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":611026,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610111,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610112,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610113,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610114,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610115,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610116,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610117,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610118,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610122,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610124,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610103,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610104,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610202,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610203,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610204,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610222,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610302,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610303,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610304,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610324,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610326,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610327,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610328,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610329,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610330,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610331,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610422,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610423,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610424,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610425,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610426,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610427,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610428,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610429,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610430,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610431,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610481,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610402,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610403,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610404,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610502,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610503,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610522,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610523,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610524,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610525,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610526,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610527,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610528,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610581,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610582,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610626,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610627,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610628,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610629,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610630,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610631,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610632,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610602,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610603,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610621,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610622,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610625,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610702,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610703,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610722,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610723,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610724,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610725,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610726,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610727,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610728,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610729,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610730,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610831,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610881,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610830,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610802,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610803,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610822,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610824,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610825,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610826,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610827,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610828,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610829,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610902,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610923,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610924,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610925,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610926,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610927,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610928,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":610929,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620103,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620104,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620105,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620111,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620121,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620122,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620123,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620171,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620201,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620302,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620321,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620402,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620403,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620421,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620422,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620423,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620502,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620503,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620521,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620522,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620523,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620524,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620525,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620602,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620621,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620622,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620702,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620721,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620722,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620723,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620724,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620725,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620824,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620825,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620826,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620871,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620802,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620821,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620822,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620823,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620902,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620923,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620924,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620981,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":620982,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621002,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621021,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621022,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621023,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621024,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621025,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621026,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621027,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621102,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621121,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621122,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621123,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621124,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621125,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621126,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621222,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621223,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621224,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621225,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621226,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621227,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621228,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621202,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":621221,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622901,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622923,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622924,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622925,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622926,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":622927,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623001,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623021,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623022,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623023,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623024,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623025,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623026,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":623027,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"AREA_CODE\":630123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":630225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632622,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632624,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632625,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632626,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632724,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632725,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632726,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632701,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632801,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632802,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632821,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632823,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632857,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632858,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":632859,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640106,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640181,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640205,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640303,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640381,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640424,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640425,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640423,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":640522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654301,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654322,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654325,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654326,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":659001,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":659002,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":659003,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":659004,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":659006,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650204,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650205,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650402,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650421,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650422,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650502,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650521,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650522,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652324,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652325,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652327,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652328,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652301,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652302,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652323,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652701,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652702,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652722,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652723,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652801,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652822,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652823,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652824,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652825,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652827,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652828,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652829,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652871,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652901,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652922,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652924,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652925,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652926,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652927,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652928,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":652929,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653023,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653024,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653001,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653022,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653101,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653122,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653123,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653124,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653125,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653126,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653127,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653128,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653129,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653130,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653131,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653201,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653222,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653226,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":653227,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654024,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654025,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654026,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654027,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654028,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654002,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654003,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654004,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654021,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654022,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654023,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654201,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654221,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654223,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654224,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":654226,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650102,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650104,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650105,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650106,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650107,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650109,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650121,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650171,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"AREA_CODE\":650172,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401}\n]");
        String json = sb.toString();
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(json, Map.class);
        return list;
    }

    private List<Map<String, Object>> type2() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n{\"COMPANY_CODE\":14353956,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14423757,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14423571,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14423575,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14423755,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14423804,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14423825,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14423649,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14423572,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423583,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423593,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423658,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423659,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423752,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423754,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423806,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423750,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14423673,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14423751,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14423662,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14423772,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14423818,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14423586,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14423774,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14423590,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14423701,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14423841,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14423850,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14423872,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14423873,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423874,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423882,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14423883,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14423889,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423919,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423925,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14423952,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424020,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424021,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14424029,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424047,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424066,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424067,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424103,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14424127,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424142,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424144,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424147,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14424155,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424156,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424163,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424164,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424165,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424191,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424233,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14424236,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424238,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424256,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424276,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424298,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424320,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424355,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424362,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424363,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424394,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424413,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424482,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424483,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424521,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424522,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424523,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14424530,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424538,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424542,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424561,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424563,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14424574,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424592,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424593,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14424598,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14424606,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424620,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424624,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14424653,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14424654,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14424670,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14424672,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424694,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424699,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424703,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424704,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424710,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14424711,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424712,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14424721,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424748,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14424749,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424762,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14424793,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14424860,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14424862,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14424876,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424877,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14424878,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424880,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14424917,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424931,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14424942,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14424993,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425010,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425012,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425016,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425024,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425026,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425081,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425082,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425084,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425095,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14425097,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425098,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425102,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425104,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425106,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425107,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425108,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425114,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14425133,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14425134,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425170,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425171,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425195,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14425196,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425198,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425222,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14425223,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425250,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425299,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425300,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425303,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425361,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425362,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425363,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425364,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425372,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14425375,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425389,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425396,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425403,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425424,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425425,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425431,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425432,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425445,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425449,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425457,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425479,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425485,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14425490,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425546,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14425566,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425567,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425568,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425588,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425589,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425590,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425591,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425607,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425637,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425639,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425644,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14425651,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425653,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14425655,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425780,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425790,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14425804,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425805,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425806,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14425807,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14425811,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425816,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425819,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14425830,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14425839,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14428729,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14428812,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14428820,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14428837,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14428909,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14428924,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14428950,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14428953,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14428986,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14428987,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14428988,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14428996,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14428998,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429026,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429027,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14429040,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429069,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429145,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14429147,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14429160,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429161,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429201,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14429243,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429244,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429251,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429252,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429254,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429315,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429326,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429332,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14429333,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429376,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14429385,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429387,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429392,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429449,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14429460,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14429470,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429485,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429488,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14429500,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429501,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14429532,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14429537,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429583,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429608,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429626,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429652,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429653,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14429669,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14429673,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429695,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429699,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429708,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14429710,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429715,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429716,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14429718,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429727,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429729,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429735,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429736,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429737,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429738,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14429745,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429750,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14429751,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429757,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429775,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429777,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429800,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14429828,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429879,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14429881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429882,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429883,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429926,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429934,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429948,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14429954,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14429962,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429992,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14429993,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14429995,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14429998,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14430082,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14430083,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14430087,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14430111,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14430120,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14430485,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14430486,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14430538,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14430575,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14430577,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14430593,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14430594,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14430615,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14431399,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14432433,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14432446,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14432456,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14432469,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14432497,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14432508,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14432532,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433005,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14433007,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14433019,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433028,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14433036,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433111,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14433112,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433115,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433154,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433155,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433156,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14433172,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433173,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433176,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14433188,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433189,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433191,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14433192,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14433194,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433203,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14433210,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433277,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14433278,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14433302,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14433337,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14433346,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14433364,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14433375,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14433377,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433378,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14433394,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14433888,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14433891,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14433912,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14433943,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434004,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434005,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14434006,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434013,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14434052,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434053,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434078,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434156,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434157,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434164,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434168,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434220,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434240,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14434241,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434243,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434255,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14434258,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434276,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434279,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434283,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434285,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434320,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434324,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434351,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14434370,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434371,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434375,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434420,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434429,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434430,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14434446,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14434449,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434459,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434475,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14434499,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434500,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434502,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14434503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434506,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434515,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434520,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434522,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434524,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434536,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434554,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434555,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434558,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434606,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434634,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434643,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434644,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14434646,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14434655,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434745,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434762,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434763,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434776,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14434779,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14434786,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434800,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434817,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434822,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434824,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434846,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434848,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434860,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434868,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434869,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14434904,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434905,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434906,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14434915,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14434916,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14434918,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14434921,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14434940,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14435015,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435027,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435082,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435086,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435114,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435144,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435152,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435168,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14435202,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14435203,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14435261,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435262,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14435286,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14435292,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435308,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435322,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435328,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435395,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14435397,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14435398,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14435399,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435406,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435408,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14435452,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435475,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435478,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435511,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435564,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435606,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435608,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14435609,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435613,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435624,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435639,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435662,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14435674,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14435675,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14435677,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435679,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435684,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14435740,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435742,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435752,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435776,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435777,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435779,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14435785,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14435789,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14435859,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14435871,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14435876,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14437454,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14437773,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14438390,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14444229,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14444440,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14444451,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14444452,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14444467,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14444483,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14444525,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14444526,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14444573,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14444578,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14444633,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14444656,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14444658,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14444659,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14444722,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14444746,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14444760,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14444761,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14444774,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14444785,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14444787,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14454416,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14454473,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14454476,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14454480,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14455357,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14455445,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14455500,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14455548,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14455549,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14455571,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14455683,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14455709,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14455788,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14455789,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14455843,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14455870,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},");
        sb.append("{\"COMPANY_CODE\":14455872,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14455986,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456107,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14456131,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456154,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456193,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456232,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456257,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456274,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456298,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456304,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456318,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14456387,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456431,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14456432,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456452,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14456466,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456468,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456499,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456520,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456545,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456674,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14456681,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456687,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14456688,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456701,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14456702,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456703,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14456729,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14456743,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14456788,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456808,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456825,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14456902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14456936,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456951,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14456952,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14456963,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14456964,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14456984,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14456995,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457086,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457087,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457089,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457116,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457169,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457207,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457221,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14457222,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457239,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457291,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14457329,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457333,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457334,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457335,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457356,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457360,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457361,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457362,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14457363,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457377,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14457409,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14457413,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457420,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14457445,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457447,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457478,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14457532,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457533,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457556,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457579,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457608,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457610,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14457611,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457640,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457644,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457650,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457651,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457653,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457655,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457694,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457717,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457727,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457746,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457747,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457748,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457772,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457799,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457842,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457864,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457867,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457915,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457939,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14457942,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14457944,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14457948,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14457951,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457963,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457965,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14457966,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14457967,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14457968,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457969,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457975,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14458002,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458035,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458036,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458038,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14458070,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458086,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458102,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14458103,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458104,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14458106,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458118,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14458132,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458133,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14458137,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458138,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458157,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458159,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458168,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14458169,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458179,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458190,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458206,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458228,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458234,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458251,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458268,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458269,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458280,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458296,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458298,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458305,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458306,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458323,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458356,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458401,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458404,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14458413,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458420,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458431,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14458442,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458451,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458452,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458456,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458468,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458476,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458477,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458478,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14458494,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458500,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458502,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458504,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458506,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458513,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14458516,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458534,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14458537,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458539,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14458541,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458550,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458593,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14458659,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458663,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458670,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458697,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458698,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14458701,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458705,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458706,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14458707,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458725,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458727,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14458731,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458815,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458829,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458830,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458832,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458849,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14458855,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14458870,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14458889,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458899,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14458908,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458915,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14458916,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460821,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14460832,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14460839,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14460842,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14460844,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14460845,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14460854,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14460866,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14460887,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14460890,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14460891,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460892,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460894,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14460900,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14460901,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460921,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14460968,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14460969,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14460971,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460979,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14460988,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461058,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461092,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461110,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461125,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461126,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14461127,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461128,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14461129,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461172,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461174,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461183,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461184,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461185,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461212,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14461214,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461230,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461231,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461232,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461233,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461234,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461237,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461281,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14461318,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461357,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461385,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14461461,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461470,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461486,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461521,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14461523,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14461531,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14461532,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461534,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461536,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461547,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461549,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461590,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14461591,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14461610,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14461634,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14461656,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14461676,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461685,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14461692,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461694,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461706,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461708,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461747,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461772,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461774,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14461783,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461784,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461791,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461792,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461808,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14461825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14461826,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461841,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14461858,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461866,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14461867,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461881,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461886,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14461892,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461893,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461952,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14461953,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14461954,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461955,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14461993,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462021,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462023,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462033,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462055,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462056,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462088,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462104,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462106,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462131,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462133,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462139,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462156,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462157,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462170,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462171,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462176,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462178,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462184,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462185,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462186,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462188,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462192,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462193,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462195,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14462197,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462353,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462354,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462362,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14462372,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14462381,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462388,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462397,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462417,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462418,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462421,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462434,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462447,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462449,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462461,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14462480,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462482,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462501,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462527,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462553,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462554,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462562,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462567,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462568,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462614,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462616,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462617,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462618,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462742,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462750,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462751,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462752,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462762,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14462787,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462820,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14462822,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462832,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462834,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462847,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462849,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462880,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462885,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462911,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462913,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462931,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14462932,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14462933,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14462935,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14462951,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14462969,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14462979,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14462985,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14462987,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463016,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463042,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463045,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14463048,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463065,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463068,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14463087,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463095,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463159,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463177,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463187,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14463189,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14463209,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463215,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463216,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463218,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463219,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14463235,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463249,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14463266,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463268,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463274,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463282,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463283,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463284,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463285,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463293,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463297,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463299,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463311,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463340,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463341,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463344,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463364,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463366,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463380,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463406,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463410,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14463411,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463422,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463423,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463424,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463466,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14463467,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463469,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463479,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463485,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463486,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463488,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463537,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463538,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14463539,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463559,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463573,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463616,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14463619,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463656,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463667,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14463674,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463690,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14463753,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463754,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14463756,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14463757,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463874,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14463933,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463934,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14463972,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464065,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14464069,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464070,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464071,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464134,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464135,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464138,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464139,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464140,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464151,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464152,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464207,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464212,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464215,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464216,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464218,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464227,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14464228,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464229,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464232,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464234,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464250,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464271,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464306,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464328,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464356,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464359,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464360,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464372,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464374,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464384,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464410,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14464412,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464458,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14464463,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464464,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464482,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464484,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464490,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464505,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464509,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14464529,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464540,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464542,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464552,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464554,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464563,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464565,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464566,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464567,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464605,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464606,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464609,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464615,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464616,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14464632,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464647,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464648,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464660,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464661,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464673,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464674,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464695,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464696,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464697,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14464700,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14464719,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464765,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},");
        sb.append("{\"COMPANY_CODE\":14464766,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14464770,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464782,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464822,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464823,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464824,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14464845,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464859,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14464866,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14464867,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465459,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465460,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465461,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465464,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465480,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14465481,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14465513,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14465517,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465518,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14465555,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465557,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465577,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465578,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465580,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465582,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14465595,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465612,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465623,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465630,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465631,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465632,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14465633,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465638,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465659,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14465720,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465721,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14465723,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465741,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465757,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14465763,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465764,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465765,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465819,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14465834,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465835,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465836,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465847,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465865,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14465866,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14465867,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465868,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465869,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465916,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465917,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14465918,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465924,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465925,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14465926,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465930,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14465944,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14465955,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14465957,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14465958,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14465990,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14466021,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466022,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14466023,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466025,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466027,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466029,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466041,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466042,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466068,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466071,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466089,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466091,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466133,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466136,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466148,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14466162,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466164,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466183,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466198,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466199,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466206,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466207,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466225,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466227,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466250,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466278,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466279,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466286,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466299,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466304,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14466320,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466322,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14466351,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466352,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466378,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466379,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466391,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466394,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466405,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466427,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466434,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466447,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14466468,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466485,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466511,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14466526,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466532,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14466533,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466548,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466556,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466629,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466643,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466710,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14466713,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466715,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14466719,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466723,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14466734,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14466742,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466797,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466799,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14466807,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466808,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466809,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466830,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466849,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466850,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14466868,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466869,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466870,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14466917,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14466918,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466919,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466950,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14466952,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14466966,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466967,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14466998,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14467017,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14467018,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467053,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467055,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467056,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467057,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14467060,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467064,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467096,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467119,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467120,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467130,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467274,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14467285,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467286,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467295,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14467304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14467306,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14467309,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14467310,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14467322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467323,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14467375,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467385,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467386,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467387,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467388,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14467398,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467410,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14467411,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467413,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467417,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14467419,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467430,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14467440,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467441,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467444,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14467467,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467468,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467471,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467488,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467489,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467536,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467538,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467551,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467552,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467572,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467575,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14467577,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14467578,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14467607,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14467608,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467613,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467643,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14467644,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14467647,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14467648,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467649,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14467666,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14467673,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14467687,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14467696,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14467697,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14468361,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468362,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14468363,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468364,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468369,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468370,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468385,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14468386,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468422,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468463,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468474,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14468475,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468496,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14468504,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468505,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468507,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468509,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468538,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468544,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468583,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468584,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468587,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14468602,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468613,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468614,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468620,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468621,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468633,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468634,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468698,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14468699,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14468700,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14468723,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468724,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468725,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468738,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468749,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468751,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14468753,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468767,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14468775,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468786,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468802,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468804,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468834,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468856,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468868,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468873,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468888,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468889,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468905,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468906,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14468908,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14468909,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14468915,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14468916,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14468925,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468940,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468942,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14468944,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468946,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14468956,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14468957,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14468984,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468986,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14468987,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14468988,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14469009,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469018,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469021,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469022,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469034,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469049,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14469077,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469082,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469083,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14469188,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469189,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469203,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469235,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14469250,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14469251,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469253,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14469254,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469275,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14469278,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469284,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14469316,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469319,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14469324,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14469345,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14469350,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14469370,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14469371,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14471640,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14471641,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14471688,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14474769,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14474776,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14474791,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14474798,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14474799,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474818,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14474825,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474826,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14474840,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474842,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14474852,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14474854,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14474865,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14474866,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14474872,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14474895,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14474896,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14474908,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474913,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474914,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14474915,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474947,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14474959,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14474972,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14474974,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14474987,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14474998,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475086,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14475087,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475112,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475136,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475137,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475139,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14475140,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475155,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475175,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475210,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475212,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475213,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475243,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475246,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475247,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475248,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14475249,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14475262,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475263,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475265,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475266,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475267,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475297,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475309,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475315,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475316,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475317,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475324,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475335,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475337,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475339,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475341,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14475342,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475354,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475360,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475368,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475372,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475392,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475393,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475395,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475399,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475400,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475401,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475409,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475420,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475422,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475423,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475436,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14475437,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475440,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475451,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475466,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475469,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475475,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475476,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475477,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475478,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475489,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475508,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14475509,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475512,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475513,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475514,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475533,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475541,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475552,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475554,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475557,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475561,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475571,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475572,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475576,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475577,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475580,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475581,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14475586,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475588,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475610,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475612,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475613,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475615,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475616,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475619,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475620,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475623,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475624,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475648,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475677,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475718,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475719,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475739,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475755,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475757,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475783,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475784,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475785,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475786,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475787,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475800,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475840,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475849,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475856,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475857,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475862,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475863,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14475890,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475893,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475913,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475914,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475925,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14475956,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14475964,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475966,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475970,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475982,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14475988,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14475996,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14475998,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476005,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476010,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476011,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476037,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476038,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476045,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476046,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14476100,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476103,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476147,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14476148,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476149,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476150,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14476151,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14476152,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476153,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476162,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476163,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14476164,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476172,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476175,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476185,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476209,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476233,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476234,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476242,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476261,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476300,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14476302,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476303,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476324,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476327,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476328,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476343,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476344,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476350,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476351,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476368,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476370,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476373,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476374,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476395,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476408,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14476409,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476430,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476466,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},");
        sb.append("{\"COMPANY_CODE\":14476469,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476490,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476495,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476543,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476545,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476565,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476566,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476567,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476568,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476569,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476570,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476574,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476576,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476588,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476603,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476606,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476612,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14476646,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476649,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476670,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476726,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14476728,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14476737,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476751,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476762,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476773,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14476802,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476803,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14476817,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476818,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14476847,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476850,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14476858,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476895,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14476915,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14476929,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14477020,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477021,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14477024,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477028,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477029,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14477033,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477052,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477070,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477071,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477085,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14477096,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477138,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477221,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14477283,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477290,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14477311,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14477312,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477335,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477349,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14477353,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14477370,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14477386,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14477399,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477405,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477421,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14477451,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477452,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477465,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14477480,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477481,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477482,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14477503,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477569,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14477607,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477608,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477640,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477649,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477660,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477662,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477700,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477701,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477702,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477718,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477779,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477784,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477785,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477787,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14477818,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477819,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477845,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477847,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477854,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14477877,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14477879,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14477944,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14477954,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14477965,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14477978,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14477979,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477982,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477983,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14477990,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478006,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14478022,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478023,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478039,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14478040,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14478043,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14478078,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478079,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14478081,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478083,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478102,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478122,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14478200,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478201,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478202,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478203,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478212,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478217,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14478224,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478247,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14478253,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14478268,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14478309,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14478324,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14478330,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478347,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478380,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478488,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14478536,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478562,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478563,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14478596,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478597,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14478604,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14478635,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14478647,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478658,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14478659,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482279,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14482280,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14482288,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482322,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482347,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482387,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482388,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14482389,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482398,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482404,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14482406,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482409,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482446,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14482454,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482465,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482472,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482475,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482479,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482508,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482509,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482532,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14482539,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482574,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482578,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482611,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482612,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14482613,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14482632,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482635,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482637,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482642,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482648,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482667,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482668,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14482670,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482699,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482710,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482711,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482713,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482721,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482745,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14482746,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14482747,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482748,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482749,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14482755,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482792,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482810,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14482836,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14482843,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482856,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482857,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482871,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482873,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14482879,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482895,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482896,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14482901,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14482902,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482903,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482957,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482958,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482970,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14482976,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14482979,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482980,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483006,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483007,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14483017,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483018,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14483028,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14483060,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483061,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483074,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483139,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483144,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483148,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483175,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483190,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14483229,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483230,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483234,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483240,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483248,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483251,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483256,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483258,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483289,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483295,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483352,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14483354,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483361,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483387,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483438,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483439,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483440,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483444,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483517,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483519,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483538,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483539,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483553,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483563,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483574,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483575,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483591,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483592,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483593,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483611,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483634,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14483656,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483675,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14483676,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483677,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483679,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483704,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483716,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483735,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14483758,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14483779,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483787,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483788,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483789,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14483824,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483832,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483854,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483860,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483863,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483864,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483865,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483869,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14483876,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483892,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483894,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483906,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483907,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14483926,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14483941,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14483972,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14483982,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14483994,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14484020,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14484023,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14484034,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14484093,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14484110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14484112,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14484121,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14484123,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14484143,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14484152,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14484163,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14484170,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14484217,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14484239,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14484242,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14484247,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14484249,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14484271,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14484284,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14484290,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14484306,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14484311,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14484312,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14484313,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14484348,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14487667,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14487709,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14487725,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14487739,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14487771,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14487772,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14487780,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14487809,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14487818,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14487829,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14487871,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14487895,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14487920,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14487921,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14487923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14487943,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14487944,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14487945,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14487951,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14487977,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14487979,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488011,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488027,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14488028,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488034,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488035,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14488045,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14488081,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488082,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488208,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488209,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14488212,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488249,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488265,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488279,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14488291,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488312,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488317,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488318,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488340,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488349,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14488370,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14488385,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14488386,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488390,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488434,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488452,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14488453,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14488454,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488457,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488458,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488471,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488478,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14488479,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14488546,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14488573,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488587,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488588,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488613,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488650,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14488653,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488666,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488668,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14488696,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488715,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488735,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14488782,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488784,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14488785,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488793,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14488833,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14488848,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14488866,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488898,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488904,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14488911,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488938,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488939,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488942,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488943,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14488950,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488951,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14488974,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14489002,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489003,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14489010,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489012,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14489015,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489018,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489025,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14489037,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14489048,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14489049,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489066,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14489068,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489102,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489120,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489122,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489123,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489142,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489143,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489148,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14489193,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489212,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14489213,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14489297,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489305,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14489307,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489308,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489316,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489349,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489399,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489605,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14489657,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489700,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14489713,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489732,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489733,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489734,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489781,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14489782,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489791,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14489815,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14489826,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489834,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14489839,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14489841,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489853,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489867,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14489868,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489907,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14489920,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14489921,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489922,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14489936,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14489940,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14489970,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14489986,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490017,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490018,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490029,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490045,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490046,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490047,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490048,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14490055,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490058,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490059,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490064,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490071,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490085,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14490090,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490091,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490092,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490093,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490094,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490126,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490155,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490166,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490168,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14490185,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490191,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490196,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490213,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490225,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490252,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490265,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490266,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490267,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490268,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490269,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490280,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490282,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490284,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14490295,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490305,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490306,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490314,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490316,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490317,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490323,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490324,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490349,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14490370,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490387,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490388,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490389,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490396,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490398,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490399,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490420,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490421,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490430,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490431,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},");
        sb.append("{\"COMPANY_CODE\":14490449,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490476,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490477,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490486,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490487,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490494,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490505,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490508,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490509,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490517,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490526,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490537,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490540,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490541,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490542,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490544,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490559,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490568,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490578,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490582,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490583,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490584,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490600,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490607,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490608,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490615,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490617,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490619,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490636,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490637,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490645,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490660,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490662,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490663,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490664,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490673,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490687,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490718,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490726,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14490727,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490741,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490755,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490756,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490760,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14490775,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490779,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14490787,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490790,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14490806,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490807,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490809,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490815,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490826,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490835,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490837,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14490871,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490873,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490874,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490876,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14490884,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490905,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490930,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490970,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14490971,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14490985,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14490986,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491009,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491032,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491039,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491062,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491082,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491083,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14491121,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14491135,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491143,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14491148,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491183,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491191,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491193,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491194,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14491211,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14491212,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14491245,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14491257,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491261,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491262,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491264,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491296,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491297,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491298,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491326,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14491350,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14491373,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491374,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491382,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14491384,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14491385,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491412,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14491421,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14491437,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491438,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14491466,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14491499,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491510,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14491526,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491527,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491542,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14491555,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14491557,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491605,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491606,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491677,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14491678,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491679,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491680,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491681,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14491751,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14491754,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14491844,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14491867,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14491868,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14491874,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491885,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14491907,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14491935,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492035,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14492036,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14492052,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492079,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492087,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492092,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14492105,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492131,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14492135,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492137,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14492147,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492168,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14492192,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492193,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492194,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492238,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14492253,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14492262,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492268,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14492301,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14492302,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14492303,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14492325,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492327,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492330,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492331,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492333,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492339,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492374,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492377,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492400,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492408,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14492454,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14492461,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492485,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492507,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492508,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492515,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492522,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492538,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14492541,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492542,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492551,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492552,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492553,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492560,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14492561,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492594,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492605,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492606,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14492611,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492635,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492636,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492637,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492656,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492682,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492683,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14492684,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14492690,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492705,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14492738,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14492775,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14492992,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14492993,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493024,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493036,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493048,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493049,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493065,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493130,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493139,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493140,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493141,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493142,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493147,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493148,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493185,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14493193,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493207,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14493251,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14493298,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493309,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493311,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493314,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493334,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493345,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493382,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493452,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493453,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493454,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493457,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493460,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493461,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493471,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493475,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493495,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14493514,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493521,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493525,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493532,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493537,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493539,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493546,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493574,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493650,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14493651,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493701,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493703,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493705,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14493770,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14493771,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493773,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493829,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14493836,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493837,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14493882,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493906,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493914,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493920,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14493928,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14493930,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14493932,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14493933,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14493934,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14493974,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14493986,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14493990,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494014,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494016,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494017,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494028,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14494029,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494043,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14494072,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14494074,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494130,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14494143,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494144,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494175,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14494207,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14494209,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14494229,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494231,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14494249,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494252,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14494255,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494282,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14494298,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14494338,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494347,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14494359,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494367,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494368,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494376,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494379,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14494421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494441,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494465,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494508,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14494520,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494522,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494524,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14494543,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494544,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494559,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14494567,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14494596,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14494624,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494650,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494693,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494774,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494776,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14494825,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14494836,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494837,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14494854,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494881,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494882,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14494891,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14494892,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14494952,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14494953,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14494974,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14494975,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14494977,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495032,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495033,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14495094,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495104,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495120,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495121,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495183,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495194,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495197,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495198,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495199,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495211,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495222,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495225,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495235,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495250,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495258,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495267,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495305,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495352,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495368,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14495385,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14495441,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495442,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495443,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495474,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495495,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495505,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495506,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14495545,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495556,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495566,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495589,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495590,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14495620,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495628,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495638,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495645,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495646,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495670,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495688,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495689,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495728,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495736,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495737,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495754,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495764,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495800,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495810,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14495817,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495843,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495844,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14495854,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495873,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14495884,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495886,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14495889,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14495895,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495906,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14495907,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14495929,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495940,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495949,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14495966,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496149,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496158,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496175,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496198,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496199,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496211,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496212,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496227,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496436,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496438,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14496439,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14496442,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496455,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496457,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496504,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496514,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496536,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496538,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496543,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496544,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496553,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496554,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496556,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496582,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496607,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496609,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496610,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496611,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496613,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496621,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496622,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496623,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496626,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496627,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496629,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14496637,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496640,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496641,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14496642,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14496649,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496661,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496664,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496670,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496674,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496678,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496679,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496695,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14496716,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14496722,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496723,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496724,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496762,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496806,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14496821,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496856,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496879,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496894,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14496899,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496900,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496922,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14496923,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14496928,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14496942,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14496950,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496952,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14496977,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14497000,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497001,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497009,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14497045,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497051,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497057,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497062,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497074,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497095,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14497108,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14497137,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14497143,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14497149,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497156,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497177,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14497179,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14497207,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497213,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497277,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497283,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14497323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14497325,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14497327,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497337,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497358,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14497359,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497383,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14497384,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497386,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497425,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14497441,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497455,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497483,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14497484,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497510,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497512,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14497514,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14497531,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497539,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14497567,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497615,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14497650,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14497672,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497673,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497674,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497707,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497709,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497715,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497716,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497735,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497736,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497738,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},");
        sb.append("{\"COMPANY_CODE\":14497794,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497818,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497865,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497917,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497918,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497919,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14497932,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14497953,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497954,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497964,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14497975,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14497982,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497987,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14497999,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498020,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498022,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14498023,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14498028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14498107,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498156,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498164,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498170,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498185,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498219,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498290,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14498342,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14498357,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14498358,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14498359,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498361,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14498418,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498419,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498444,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498509,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498524,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498555,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498575,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14498633,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498634,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498644,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498683,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498684,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498704,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14498756,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14498763,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498764,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14498778,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14498826,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498834,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14498848,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14498849,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14498864,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14498887,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14498888,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14498890,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498925,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499045,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14499085,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14499137,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14499146,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499148,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14499155,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14499238,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499290,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14499291,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14499292,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14499293,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499459,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499480,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499481,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499487,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499526,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499527,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14499528,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14499550,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14499580,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14499596,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499597,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499601,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14499602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14499647,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499650,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14499651,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499654,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14499693,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499701,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14499703,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14499762,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14499791,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499799,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499825,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499871,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14499872,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14499904,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14499912,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14499915,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14499916,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14499932,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499951,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14500421,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14500422,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14500434,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14500435,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14500532,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14500539,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14500544,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14500550,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14500584,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14500599,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14500615,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14500678,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14500687,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14500776,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14500778,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14500804,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14500823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14500832,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14500921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14500925,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14500951,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14500971,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14501057,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501059,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14501066,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14501083,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14501144,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501155,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501167,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14501177,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14501206,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14501207,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14501238,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14501267,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14501271,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501360,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501363,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14501364,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14501370,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14501371,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14501416,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501441,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501460,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501461,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14501462,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501522,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14501575,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501583,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14501586,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14501587,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14501588,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14501589,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14501913,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14501916,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14501917,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501918,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14501923,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14501924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14501945,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14501957,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14501998,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14502020,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502021,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502032,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14502034,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502044,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502045,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502105,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14502106,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502107,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502109,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502112,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502113,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502114,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502140,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502168,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502192,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14502203,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502251,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502277,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502288,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14502289,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502310,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502313,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14502359,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502384,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502420,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502438,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502439,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502455,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14502476,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502482,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502483,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502492,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14502531,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502532,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502544,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502549,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502555,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502571,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502575,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14502586,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14502597,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502610,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502632,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502633,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502682,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14502691,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502869,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502870,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502888,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502889,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502899,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502905,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502906,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502908,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14502914,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502944,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14502956,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14502957,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502971,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14502972,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14502979,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502989,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503017,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503018,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503040,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14503041,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14503054,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503055,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503066,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503114,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503131,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503132,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503133,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503134,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503142,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503143,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503161,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14503163,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503167,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14503171,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503184,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503210,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503211,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14503231,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503287,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503294,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503317,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503318,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503366,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14503395,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503413,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503414,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503430,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14503477,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503513,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503514,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503551,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503559,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503578,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503579,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503580,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14503581,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503583,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14503585,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503620,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503621,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503630,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503631,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":14503643,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503644,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14503645,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503646,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503647,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503648,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503650,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503651,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503656,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503691,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503718,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503719,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14503721,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503750,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503790,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503792,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503803,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503814,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503815,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14503844,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14503881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14503882,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503925,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14503926,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14503991,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504164,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14504184,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504207,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504210,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14504211,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504214,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504217,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504218,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14504219,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504239,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504302,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14504303,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504320,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504368,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14504408,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504464,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504472,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504485,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504521,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504530,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14504536,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504538,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504539,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504542,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14504568,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504569,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14504598,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504615,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14504625,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14504654,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14504662,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14504663,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504686,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504695,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14504734,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14504751,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14504761,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14504766,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504767,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504769,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14504865,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504885,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14504890,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14504941,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504968,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505011,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505045,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505072,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14505082,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14505083,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505121,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14505174,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14505178,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505179,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14505235,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14505236,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505237,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505238,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14505249,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14505260,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14505261,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505262,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505268,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505274,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14505282,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505283,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505296,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14505299,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14505321,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505322,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14505335,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505361,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14505372,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505386,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505404,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505418,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14505423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14505424,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505438,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505493,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505494,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505505,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14505600,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505602,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14505768,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505776,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505834,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14505870,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505880,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14505881,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14505882,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14505903,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14505920,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14506457,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14506459,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14506490,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14506491,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14506504,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14506890,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14507441,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14507538,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14507810,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14507868,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14507869,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14507878,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14507924,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14507926,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14507993,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508001,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508016,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508017,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508020,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14508021,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508040,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508049,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508050,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508052,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14508054,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508055,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508057,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508058,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508059,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508060,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508061,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508062,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508064,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508065,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508067,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508071,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508075,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508077,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508079,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508080,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508081,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508082,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508083,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508087,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508088,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508089,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508090,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508091,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508095,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508096,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508097,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508099,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508100,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508108,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508109,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508111,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508147,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508152,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14508153,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508187,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14508207,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508247,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508248,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508305,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508306,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508365,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508367,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14508373,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508382,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508395,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508399,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14508414,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508446,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508480,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508481,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508490,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14508517,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508550,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508559,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508560,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508577,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508650,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14508674,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508691,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14508695,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14508718,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508720,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508753,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14508755,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508756,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508757,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14508778,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508811,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14508814,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14508838,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508856,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14508870,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508872,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14508873,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14508923,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14509020,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509050,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509078,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14509079,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},");
        sb.append("{\"COMPANY_CODE\":14509121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14509134,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509141,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14509156,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14509157,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14509283,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14509447,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509509,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14509557,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509574,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14509619,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509660,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14509671,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14509678,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14509720,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14509745,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509746,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14509763,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509777,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14509779,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14509848,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14509859,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510037,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14510051,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510074,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14510103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510147,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510187,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510216,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510248,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510321,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14510491,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510519,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510582,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510587,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14510605,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14510624,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14510791,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14510802,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510832,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14510837,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510838,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510899,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510977,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14511015,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14511048,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14511057,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14511059,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14511060,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14511075,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14511099,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14511139,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14511159,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14511181,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14511212,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14511220,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14512219,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14512230,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14512287,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14512290,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14512369,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14512406,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14512430,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512487,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512529,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512571,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512572,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512632,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14512633,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14512634,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512635,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512661,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14512669,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14512680,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512695,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14512789,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14512797,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14512807,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512828,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14512829,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14512832,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512833,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14512835,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14512838,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14512859,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512866,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14512867,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":14512868,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14512948,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14513000,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513063,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14513069,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513110,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14513124,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513157,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14513165,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513191,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513198,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513200,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513223,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513250,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513258,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513281,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14513283,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513284,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513333,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513335,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513338,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14513339,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14513366,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513379,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513392,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513395,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513419,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14513428,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513450,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513458,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513474,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513490,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513534,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513537,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14513538,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513539,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14513550,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513551,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513552,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513556,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513557,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513579,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513595,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513610,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513611,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513616,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513639,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513845,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14513890,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513926,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14513930,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14513957,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513958,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14513959,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14513964,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14513980,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513986,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14514042,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514071,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14514073,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14514074,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14514082,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514085,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14514127,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14514151,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514158,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514161,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14514165,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514167,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14514171,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14514193,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14514290,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14514293,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514294,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514295,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514308,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14514314,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14514326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514331,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14514392,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14514435,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514485,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514490,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514491,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514536,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514537,\"HCCONTRACT_TYPEPRO\":14714933452,\"LPJCONTRACT_TYPEPRO\":14714933452},\n{\"COMPANY_CODE\":14514569,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14514586,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514616,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514641,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14514696,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14514733,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14514758,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14514807,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514882,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14514895,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14514903,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14514927,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14515027,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14515035,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":14515081,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14515082,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14515085,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515127,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515184,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14515186,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14515188,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14515195,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515221,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14515231,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14515270,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14515285,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515318,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515341,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14515358,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515359,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515365,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515380,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515388,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14515429,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14515436,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14515462,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515463,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515464,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14515527,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":14515591,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515601,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515623,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515629,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14515644,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14515694,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14515698,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14515702,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515721,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14515727,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14515816,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14515830,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14515851,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515853,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515856,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515893,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515896,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14515941,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14515943,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":14515960,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515969,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14516037,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14516069,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14516075,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14516114,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14516133,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":14516151,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":14516171,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14516185,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300001,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300002,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300003,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300007,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80300010,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300011,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300012,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300013,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300014,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300016,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300017,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300018,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300019,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300020,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300021,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300023,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300024,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300031,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300040,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300048,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80300055,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300058,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300072,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300078,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300080,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300089,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300094,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300095,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300109,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300119,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300134,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300137,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300139,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300148,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300159,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300160,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300161,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300168,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300183,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300184,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300187,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300190,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300192,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300193,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300194,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300198,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300199,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300205,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300210,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300216,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300217,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300236,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300252,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300255,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300273,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300277,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300286,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300310,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300311,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300313,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300333,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300334,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300340,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300341,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300342,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300356,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300360,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300365,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300368,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300370,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300385,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300405,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300406,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300416,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300418,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300437,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300450,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300451,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300458,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300460,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300469,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300471,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300473,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300474,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300478,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300488,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300512,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300519,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300529,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300542,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300549,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300553,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300554,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300556,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300559,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300561,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300562,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300564,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300567,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300568,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300570,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300571,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300602,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300604,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300605,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300611,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300621,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300623,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300625,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300629,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300631,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300632,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300633,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300635,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300638,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300641,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300643,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300644,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300646,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300649,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300659,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300667,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300716,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300725,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300731,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300733,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300743,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80300748,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300752,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300783,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80300790,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80300792,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80300818,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300820,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300831,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300837,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300844,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300846,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300856,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300861,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300862,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300885,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300887,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300890,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80300896,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300909,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300915,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300916,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300922,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300923,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80300926,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300929,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300930,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300931,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300932,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300934,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300939,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80300951,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300956,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80300957,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300958,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300964,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300965,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80300968,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80300969,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300974,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300980,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300992,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80301003,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301005,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301009,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80301010,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301011,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80301022,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301024,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301027,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301035,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301036,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80301045,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80301047,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80301063,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301074,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301079,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301089,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301096,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301097,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301099,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301100,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301114,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80301117,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301118,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301120,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301122,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301127,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301128,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301131,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301132,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301133,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301134,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80301145,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301159,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301163,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301182,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301190,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301199,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301201,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301220,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301243,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301251,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301261,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301283,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80301291,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301298,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301300,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301305,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301314,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80301316,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301322,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301325,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301326,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301339,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301340,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301348,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301373,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301392,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301406,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301409,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301420,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301421,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301425,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301426,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301430,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301446,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301453,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301462,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301478,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301490,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301505,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301508,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301519,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301531,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301555,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301557,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301565,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301579,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301584,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301616,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80301617,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301618,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80301621,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80301622,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},");
        sb.append("{\"COMPANY_CODE\":80301626,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80301628,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301631,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301632,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301633,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301637,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80301641,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301642,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301643,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301644,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301646,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301647,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301648,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301650,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301651,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301652,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301653,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301655,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301656,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301658,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301660,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301661,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301662,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301664,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301665,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301668,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301669,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301670,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301671,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301675,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301676,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301677,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301678,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301679,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301681,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301684,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301686,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301688,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301691,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301692,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301693,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301695,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301697,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301700,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301701,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301702,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301706,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301707,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301710,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301711,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301714,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301715,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301716,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301717,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301720,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301721,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301741,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301742,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301743,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80301748,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301749,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301761,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301765,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301773,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301774,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301775,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301781,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301791,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80301813,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301817,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301826,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80301830,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301832,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301833,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301836,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301838,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301844,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301846,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80301851,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301857,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301866,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301868,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301870,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301873,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301875,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301876,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301878,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301879,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301888,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80301897,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301902,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301907,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301911,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301919,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80301920,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301928,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301933,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301959,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301961,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301964,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301972,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301973,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301974,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301979,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80301982,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80301984,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80301993,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301996,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301998,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80301999,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302000,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302004,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302015,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80302021,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302022,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302024,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302026,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302030,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302033,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302034,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302035,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302036,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302037,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302038,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302041,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302043,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302044,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302046,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302049,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302052,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302054,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302055,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302061,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302062,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302063,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302068,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302069,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302070,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302072,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302073,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302075,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302076,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302079,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302081,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302082,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302090,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302092,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302098,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302100,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302103,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302104,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302119,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302122,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302124,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302125,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302131,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302137,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80302145,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80302146,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302160,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80302164,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80302172,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302174,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302176,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80302180,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302190,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302199,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302201,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302202,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302203,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302205,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302206,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302208,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302209,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302210,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302211,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302213,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302215,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302216,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302217,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302226,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302232,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302234,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80302235,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302236,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302238,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302239,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302240,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302242,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302243,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302244,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302246,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302247,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302249,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302250,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302251,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302252,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302266,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302271,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302272,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302291,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302303,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302307,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80302310,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302314,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302322,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80302325,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302330,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302351,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302352,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302358,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302377,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302386,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302394,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302395,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302397,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302398,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302401,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302406,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302407,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302411,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302415,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302416,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302424,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302426,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302427,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302429,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302433,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302442,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302443,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302447,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302450,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302451,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302452,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302453,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302457,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302458,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302463,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302464,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302467,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302468,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302469,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80302474,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302476,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302477,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302480,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302481,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302483,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302485,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302486,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302488,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302489,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302490,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302491,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302498,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302499,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302501,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302505,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302517,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302520,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302541,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302553,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302556,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302557,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302561,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302574,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302575,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302576,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302579,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302582,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80302584,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302591,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80302594,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302598,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80302599,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302600,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302603,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302613,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80302614,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302633,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302637,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302647,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80302648,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302649,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302652,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80302657,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302658,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302659,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302669,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302671,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302672,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302673,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302674,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302675,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302683,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302685,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302687,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302689,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302692,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302693,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80302697,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80302722,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302734,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302753,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80302763,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302766,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302771,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302773,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302774,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302779,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302780,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302781,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302792,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302793,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302797,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302800,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302801,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302802,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302803,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302810,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302813,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302818,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302822,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302837,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302841,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302842,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302843,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302847,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302849,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302852,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302856,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80302859,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302860,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302872,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302875,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302881,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302887,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302888,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302889,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302890,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302892,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302893,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302894,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302899,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302901,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302907,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302909,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302916,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302917,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302920,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302924,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302931,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302935,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302937,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302938,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302939,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302940,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302942,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302944,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302945,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302947,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302952,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302954,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302955,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302957,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302967,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302968,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302970,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302971,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302975,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302981,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302984,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302990,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302993,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302995,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302997,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80302998,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303001,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303003,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303007,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303009,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303010,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303012,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303015,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303018,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303022,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303023,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303024,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303026,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303029,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303031,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303035,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303038,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303041,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303043,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303044,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303045,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303051,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303054,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303055,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303056,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303065,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303066,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303069,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303078,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303080,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303084,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303086,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303087,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303088,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303089,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303091,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303097,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303098,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303103,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303107,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303109,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303112,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303116,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303121,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303122,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303126,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303130,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303134,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303135,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303141,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303145,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303147,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303150,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303151,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303152,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303153,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303154,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303155,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303156,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303162,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303163,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303164,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303166,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303167,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303168,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303173,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303174,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303175,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303177,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303184,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303185,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303188,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303189,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303190,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303195,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303199,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303206,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303209,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303210,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303211,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303213,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303218,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303220,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303221,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303225,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303226,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303230,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303234,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303236,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303238,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303239,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303240,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303242,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303245,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303248,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303252,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303253,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303266,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303277,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303278,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303282,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303286,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303293,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303295,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303304,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303306,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303311,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303319,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80303322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303323,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303355,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303358,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80303364,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303371,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303374,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303375,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303382,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303385,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303390,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},");
        sb.append("{\"COMPANY_CODE\":80303393,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303399,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303400,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303402,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303409,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303411,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303413,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303415,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303418,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303420,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303422,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303425,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80303431,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303432,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303436,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303437,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303455,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80303457,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303458,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303461,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303463,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303464,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303467,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303469,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303471,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303478,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303483,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303487,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303491,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303494,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303498,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303502,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303507,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303509,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303510,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303518,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303519,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303525,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303528,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80303535,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303538,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303550,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303560,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303563,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303570,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303578,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303616,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80303619,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303621,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303625,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303627,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303630,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303635,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303636,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303637,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303642,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303644,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80303646,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303670,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80303684,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80303720,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303731,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303733,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303734,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303739,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303740,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303743,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303745,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303746,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303747,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303750,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303752,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303755,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303759,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303762,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303763,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303789,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303790,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80303849,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303864,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303868,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303869,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303874,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80303879,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303881,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80303883,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303886,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303895,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303902,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80303905,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303910,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80303916,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303920,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303922,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303924,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303925,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303926,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303927,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303931,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303932,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303936,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303939,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303941,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303942,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303943,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303944,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303951,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80303956,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80303962,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303963,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303964,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303965,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303966,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303967,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303973,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303974,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303975,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303978,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303981,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303984,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303989,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303990,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303991,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303992,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303993,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303997,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80303999,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304000,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304003,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304005,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304006,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304010,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80304012,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304014,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304015,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304017,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304019,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304022,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80304023,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304028,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304029,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304031,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304037,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304044,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304045,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304051,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304053,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304056,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304058,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304063,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304079,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304100,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304102,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80304115,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304130,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304131,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304147,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80304152,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304166,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80304177,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304181,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304182,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304185,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304190,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304192,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304193,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304199,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304202,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304203,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304208,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304209,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304210,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304214,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304219,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304225,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304228,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304232,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304240,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304245,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304251,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304254,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304257,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304270,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80304278,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304290,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304291,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80304296,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304297,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304302,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304305,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304307,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304312,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304313,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304315,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304317,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304320,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304323,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304324,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304326,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304327,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304338,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304340,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304342,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304344,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304347,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304350,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304351,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304355,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304359,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304360,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304361,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304363,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304364,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304367,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304369,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304373,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304374,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304375,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304378,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304379,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304380,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304382,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304383,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304384,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304385,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304389,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304390,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304397,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304398,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304401,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304402,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304403,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304404,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304405,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304407,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304408,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304409,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304410,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304413,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304414,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304421,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304422,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304426,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80304429,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304447,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304451,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304456,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304460,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80304461,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80304464,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304466,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304472,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304483,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304487,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80304488,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304489,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304504,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304506,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80304513,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80304525,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304542,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304544,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304547,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304555,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304559,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304568,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304579,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80304587,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304595,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304615,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304616,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80304634,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304670,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80304676,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80304677,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306551,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306603,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306611,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306617,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306635,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306636,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306651,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306655,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80306657,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306659,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306667,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306668,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306669,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306672,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306673,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306675,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306676,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306677,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306678,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306679,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306681,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306683,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306684,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306685,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306686,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306692,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306703,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306704,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80306706,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306711,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306718,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80306723,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306725,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306726,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306727,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306729,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306730,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80306731,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80306734,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306736,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306737,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306738,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306741,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306753,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306756,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80306762,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306767,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306769,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306772,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306775,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306776,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306777,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306778,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80306780,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306781,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306785,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306788,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306789,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306792,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306794,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306796,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306797,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306798,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306804,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306806,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306814,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306815,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306830,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306843,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306845,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306850,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306861,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306866,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306867,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306881,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306882,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306884,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306885,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80306886,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306887,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306888,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306889,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306890,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306896,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80306902,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306904,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306909,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306915,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306918,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306919,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306920,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306923,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80306930,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80306933,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306937,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306939,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80306940,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306943,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306950,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80306951,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306952,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306954,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306955,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306960,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306963,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306967,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80306969,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80306984,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306988,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306989,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80306990,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306992,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306993,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80306994,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80306996,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80306997,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307002,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307003,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307005,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307006,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307011,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307012,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307017,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307029,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307030,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307034,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307035,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307037,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307039,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307045,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307049,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307055,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307058,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307059,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307060,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307062,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307064,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307066,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307071,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307076,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307077,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307079,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307080,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307083,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307085,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307093,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307094,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307095,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307101,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307102,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307110,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307111,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307113,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307114,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307115,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307116,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307119,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307120,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307122,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307126,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307127,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307130,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307131,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307137,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307138,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307142,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307144,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307146,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307150,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307151,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307152,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307154,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307158,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307160,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307164,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307166,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307172,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307175,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307176,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307179,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307184,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80307187,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307188,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307191,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307195,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307202,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307203,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307210,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307224,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307228,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307230,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307232,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307234,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307238,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307239,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307241,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80307242,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307243,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307246,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307256,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307259,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307263,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80307270,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307271,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307273,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307275,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307276,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307277,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307282,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307286,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307291,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307294,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80307296,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307299,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307303,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307304,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307315,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307316,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307317,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307323,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307329,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},");
        sb.append("{\"COMPANY_CODE\":80307336,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80307337,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307339,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307347,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307348,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307351,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307352,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80307353,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307355,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307360,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307361,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307366,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307375,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307377,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307378,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307379,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307385,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307391,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307396,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307400,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307408,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307410,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307413,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307414,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307417,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307418,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307419,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307420,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307421,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307422,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307427,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307431,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307432,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307433,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307434,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307437,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307443,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307445,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307447,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307448,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307449,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307453,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307459,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307460,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307461,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307462,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307463,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307464,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307465,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307470,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307473,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307475,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307476,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307478,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307479,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307481,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307482,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307484,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307495,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307496,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307497,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307498,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307499,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307503,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307505,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307506,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307507,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307508,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307509,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307518,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307521,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307526,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307527,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307533,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307534,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307535,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307536,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307540,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307548,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307549,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307550,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307551,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307554,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307559,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307560,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307565,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307566,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307570,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307571,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307572,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307582,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307588,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307589,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307593,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307602,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307607,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307610,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307611,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307616,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307623,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307625,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307626,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307627,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307628,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307629,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307630,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307631,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307632,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307642,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307646,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307651,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80307653,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307655,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307657,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307660,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307661,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307662,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307663,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307666,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307668,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307669,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307672,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307673,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307675,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307678,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307684,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307686,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307694,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307695,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307702,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307703,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307704,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307705,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307706,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307707,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307711,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307712,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307723,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307724,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307725,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307726,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307727,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307728,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307729,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307733,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307738,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307739,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307740,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307745,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307749,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307755,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307756,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307759,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307768,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307769,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307779,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307797,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307798,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307800,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307806,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307809,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307814,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307817,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307818,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307824,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307826,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307829,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307834,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307840,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307842,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307844,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307845,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307846,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307852,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307854,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307864,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307865,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307866,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307869,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307872,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307874,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307879,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307881,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307882,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307883,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307885,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307893,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307895,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307897,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307898,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307903,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307904,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307905,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307908,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307912,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307913,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307914,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307916,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307917,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307918,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307919,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307920,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307921,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307922,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307934,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80307935,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80307937,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307948,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307951,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307959,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307960,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80307967,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80307968,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307970,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307980,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307981,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307984,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80307987,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80307995,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308001,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308006,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308008,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80308010,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308012,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308020,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308026,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308029,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308038,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308040,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308047,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308048,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308049,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308050,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80308052,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308053,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308055,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308056,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308057,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308066,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308067,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308069,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308077,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308078,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308079,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308086,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308091,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308093,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308100,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308102,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308108,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308113,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308116,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308117,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308124,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308125,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308126,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308129,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308137,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308143,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308144,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308151,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308157,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308161,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308162,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308163,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308166,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308171,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308176,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308180,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308185,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308188,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308189,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308190,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308200,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308203,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308204,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308208,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308209,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308213,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308218,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308222,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308223,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308224,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308225,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308226,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80308228,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308229,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80308230,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308231,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308232,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308239,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308241,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308242,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308256,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308257,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308258,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308263,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308269,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308271,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308280,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308281,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308285,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308286,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308288,\"HCCONTRACT_TYPEPRO\":15012500720,\"LPJCONTRACT_TYPEPRO\":15012500720},\n{\"COMPANY_CODE\":80308289,\"HCCONTRACT_TYPEPRO\":15012534371,\"LPJCONTRACT_TYPEPRO\":15012534371},\n{\"COMPANY_CODE\":80308292,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308294,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308300,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308308,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308309,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308311,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308315,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308322,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308323,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308325,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308327,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308329,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308336,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308342,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308343,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308344,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308345,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308346,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308350,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308352,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308355,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308356,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308359,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308363,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308364,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308365,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308367,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308371,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308372,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308374,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308377,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308379,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308380,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308385,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308388,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308393,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308394,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308396,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308405,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308406,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308416,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308418,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308419,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308422,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308424,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308426,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308429,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308430,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308432,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308435,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308436,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308440,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308444,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308446,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308449,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308451,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308462,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308464,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308468,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308469,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308470,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308472,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308492,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308495,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308500,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308501,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308502,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308505,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308506,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308507,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308508,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308512,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308513,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308514,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308515,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308520,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308522,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308525,\"HCCONTRACT_TYPEPRO\":13911853860,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308527,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308530,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308532,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308533,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308536,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80308538,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308541,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308546,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308547,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308548,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308552,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13911750401},\n{\"COMPANY_CODE\":80308557,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80308558,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308562,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308565,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308569,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308573,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308574,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308580,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308582,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308583,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308585,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308589,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308590,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308592,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80308594,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308595,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308598,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308600,\"HCCONTRACT_TYPEPRO\":13801283404,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308601,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308603,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308605,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308606,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308608,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13501063691},\n{\"COMPANY_CODE\":80308609,\"HCCONTRACT_TYPEPRO\":18817877536,\"LPJCONTRACT_TYPEPRO\":13901985338},\n{\"COMPANY_CODE\":80308610,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308611,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308615,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13020190963},\n{\"COMPANY_CODE\":80308616,\"HCCONTRACT_TYPEPRO\":18600675683,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308621,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80308625,\"HCCONTRACT_TYPEPRO\":13437190699,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308626,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308633,\"HCCONTRACT_TYPEPRO\":15161630228,\"LPJCONTRACT_TYPEPRO\":13901753988},\n{\"COMPANY_CODE\":80308635,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308641,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308644,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701}\n]");
        String json = sb.toString();
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(json, Map.class);
        return list;
    }

    @RequestMapping(value={"forwardQueryScontractPageNew.json"}, name="\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e")
    @ResponseBody
    public HtmlJsonReBean forwardQueryScontractPageNew(HttpServletRequest request) {
        boolean flag = true;
        Map param = this.assemMapParam(request);
        Map check = this.assemMapParam(request);
        check.put("contractInvstate", 2);
        long jiaoyan = System.currentTimeMillis();
        SupQueryResult checkResult = this.spScontractServiceRepository.queryScontractPage(check);
        if (!ListUtil.isEmpty((Collection)checkResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u60a8\u5df2\u9884\u7ea6\u8be5\u5408\u540c");
        }
        if (StringUtils.isBlank((String)param.get("scontractCode").toString()) || StringUtils.isBlank((String)param.get("userinfoPhone").toString())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        param.put("contractInvstate", 0);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        this.logger.error("scontractCode:" + param.get("scontractCode").toString());
        this.logger.error("userinfoPhone:" + param.get("userinfoPhone").toString());
        HashMap<String, Comparable<Boolean>> checkSp = new HashMap<String, Comparable<Boolean>>();
        checkSp.put("order", Boolean.valueOf(true));
        checkSp.put("fuzzy", Boolean.valueOf(false));
        checkSp.put("contractInvstate", Integer.valueOf(0));
        checkSp.put("scontractCode", (Comparable<Boolean>)param.get("scontractCode"));
        SupQueryResult supQueryResult = this.spScontractServiceRepository.queryScontractPage(checkSp);
        if (ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u5408\u540c\u53f7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Boolean> checkUserinfo = new HashMap<String, Boolean>();
        checkUserinfo.put("order", true);
        checkUserinfo.put("fuzzy", false);
        checkUserinfo.put("userinfoPhone", (Boolean)param.get("userinfoPhone"));
        SupQueryResult UserinfoResult = this.userServiceRepository.queryUserinfoPage(checkUserinfo);
        if (ListUtil.isEmpty((Collection)UserinfoResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        this.logger.error("\u6821\u9a8c\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - jiaoyan));
        SpScontractDomain spScontractDomain = (SpScontractDomain)supQueryResult.getList().get(0);
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)UserinfoResult.getList().get(0);
        this.logger.error("*******umUserinfoReDomainBean*******\uff1a" + JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoReDomainBean));
        long liucheng0 = System.currentTimeMillis();
        if (param.containsKey("contractTypepro") && null != param.get("contractTypepro") && !param.get("contractTypepro").equals("")) {
            HashMap<String, Object> salesmap = new HashMap<String, Object>();
            salesmap.put("userinfoPhone", param.get("contractTypepro").toString());
            salesmap.put("order", true);
            salesmap.put("fuzzy", false);
            SupQueryResult Salesinfo = this.userServiceRepository.queryUserinfoPage(salesmap);
            if (ListUtil.isEmpty((Collection)Salesinfo.getList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
            }
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            spScontractDomain.setContractType(((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getEmployeeName());
            spScontractDomain.setGoodsSupplierCode(((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getUserinfoCode());
            spScontractDomain.setContractTypepro(param.get("contractTypepro").toString());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            date.setTime(System.currentTimeMillis());
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setContractInvoicedate(date);
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            spScontractDomain.setMemberCode(((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getUserinfoCode());
            long maidianTime = System.currentTimeMillis();
            MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype("gtyuyue");
            mnsMnslistDomainBean.setMnslistBusname("\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e");
            mnsMnslistDomainBean.setMnschannelType(Integer.valueOf(2));
            mnsMnslistDomainBean.setMemberCode(((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getUserinfoCode());
            this.logger.error("*******usercode*******\uff1a" + spScontractDomain.getGoodsSupplierCode());
            mnsMnslistDomainBean.setDataTenant(spScontractDomain.getTenantCode());
            mnsMnslistDomainBean.setTenantCode(spScontractDomain.getTenantCode());
            HashMap<String, String> map0 = new HashMap<String, String>();
            map0.put("imsgSuserCode", "sys");
            map0.put("imsgSuserName", "sys");
            ArrayList receiverList = new ArrayList();
            HashMap<String, String> listReceiver = new HashMap<String, String>();
            listReceiver.put("code", ((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getUserinfoCode());
            listReceiver.put("name", spScontractDomain.getContractType());
            listReceiver.put("spScontract", JsonUtil.buildNonEmptyBinder().toJson((Object)spScontractDomain));
            receiverList.add(listReceiver);
            map0.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            HashMap paramMap = new HashMap();
            map0.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonEmptyBinder().toJson(map0));
            PostParamMap pmap = new PostParamMap("mns.ser.sendMnslist");
            pmap.putParamToJson("mnsMnslistDomainBean", (Object)mnsMnslistDomainBean);
            this.htmlIBaseService.sendMesReBean(pmap);
            this.logger.error("******pmap********\uff1a" + JsonUtil.buildNonEmptyBinder().toJson((Object)pmap));
            this.logger.error("*******mnsMnslistDomainBean*******\uff1a" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean));
            this.logger.error("\u57cb\u70b90\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - maidianTime));
            HtmlJsonReBean htmlJsonReBeanS = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBeanS;
        }
        this.logger.error("\u6d41\u7a0b0\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - liucheng0));
        long liucheng1 = System.currentTimeMillis();
        List<Map<String, List<String>>> type1 = this.type1(this.getTenantCode(request));
        for (int i = 0; i < this.type1(this.getTenantCode(request)).size(); ++i) {
            String member_gcode = null;
            this.logger.error("UserinfoRes+++++" + JsonUtil.buildNormalBinder().toJson(type1.get(i).get("MEMBER_GCODE")));
            if (!member_gcode.equals(param.get("memberGcode").toString())) continue;
            String contract_typepro = type1.get(i).get("CONTRACT_TYPEPRO").get(0);
            this.logger.error("UserinfoRes" + member_gcode + "++++" + contract_typepro);
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", false);
            if (StringUtils.isBlank((String)contract_typepro)) break;
            map.put("userinfoPhone", contract_typepro);
            SupQueryResult UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
            this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
            if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
            }
            spScontractDomain.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
            spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getEmployeeName());
            spScontractDomain.setContractTypepro(type1.get(i).get("CONTRACT_TYPEPRO").toString());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            date.setTime(System.currentTimeMillis());
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setContractInvoicedate(date);
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("\u7b2c\u4e00\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            long maidianTime1 = System.currentTimeMillis();
            MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype("gtyuyue");
            mnsMnslistDomainBean.setMnslistBusname("\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e");
            mnsMnslistDomainBean.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
            mnsMnslistDomainBean.setDataTenant(spScontractDomain.getTenantCode());
            mnsMnslistDomainBean.setTenantCode(spScontractDomain.getTenantCode());
            HashMap<String, String> map0 = new HashMap<String, String>();
            map0.put("imsgSuserCode", "sys");
            map0.put("imsgSuserName", "sys");
            ArrayList receiverList = new ArrayList();
            HashMap<String, String> listReceiver = new HashMap<String, String>();
            listReceiver.put("code", ((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
            listReceiver.put("name", spScontractDomain.getMemberBname());
            listReceiver.put("spScontract", JsonUtil.buildNonEmptyBinder().toJson((Object)spScontractDomain));
            receiverList.add(listReceiver);
            map0.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            HashMap paramMap = new HashMap();
            map0.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonEmptyBinder().toJson(map0));
            PostParamMap pmap = new PostParamMap("mns.ser.sendMnslist");
            pmap.putParamToJson("mnsMnslistDomainBean", (Object)mnsMnslistDomainBean);
            this.htmlIBaseService.sendMesReBean(pmap);
            this.logger.error("\u57cb\u70b91\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - maidianTime1));
            HtmlJsonReBean htmlJsonReBean1 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBean1;
        }
        this.logger.error("\u6d41\u7a0b1\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - liucheng1));
        long liucheng2 = System.currentTimeMillis();
        HashMap<String, String> map2 = new HashMap<String, String>();
        if ("2".equals(umUserinfoReDomainBean.getUserinfoType().toString())) {
            map2.put("companyCode", ((UmUserinfoReDomainBean)UserinfoResult.getList().get(0)).getCompanyCode());
            List<Map<String, Object>> type2 = this.type2();
            for (int i = 0; i < type2.size(); ++i) {
                HashMap<String, Object> map;
                if (!type2.get(i).get("COMPANY_CODE").toString().equals(map2.get("companyCode").toString())) continue;
                this.logger.error("\u8fdb\u5165\u5faa\u73af\u5224\u65ad************************************" + type2.get(i).get("COMPANY_CODE"));
                spScontractDomain.setContractInvstate(Integer.valueOf(2));
                spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
                spScontractDomain.setScontractId(null);
                spScontractDomain.setScontractCode(null);
                SupQueryResult UserinfoRes = new SupQueryResult();
                if (spScontractDomain.getFchannelCode().equals("1")) {
                    map = new HashMap<String, Object>();
                    map.put("order", true);
                    map.put("fuzzy", false);
                    if (StringUtils.isBlank((String)type2.get(i).get("LPJCONTRACT_TYPEPRO").toString())) break;
                    map.put("userinfoPhone", type2.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                    UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                    this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                    if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                    }
                    spScontractDomain.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
                    spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                    spScontractDomain.setContractTypepro(type2.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                } else if (spScontractDomain.getFchannelCode().equals("2")) {
                    map = new HashMap();
                    map.put("order", true);
                    map.put("fuzzy", false);
                    if (StringUtils.isBlank((String)type2.get(i).get("HCCONTRACT_TYPEPRO").toString())) break;
                    map.put("userinfoPhone", type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                    UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                    this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                    if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                    }
                    spScontractDomain.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
                    spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getEmployeeName());
                    spScontractDomain.setContractTypepro(type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                } else {
                    this.logger.error("\u672a\u5339\u914d\u8017\u6750/\u96f6\u914d\u4ef6*******************************************");
                    spScontractDomain.setContractTypepro(type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                }
                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                date.setTime(System.currentTimeMillis());
                spScontractDomain.setGoodsPmbillno(sm.format(date));
                spScontractDomain.setContractInvoicedate(date);
                spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
                spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
                spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
                spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
                spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
                spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
                spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
                this.logger.error("\u7b2c\u4e8c\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
                long maidianTime2 = System.currentTimeMillis();
                MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
                mnsMnslistDomainBean.setMnslistBustype("gtyuyue");
                mnsMnslistDomainBean.setMnslistBusname("\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e");
                mnsMnslistDomainBean.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
                mnsMnslistDomainBean.setDataTenant(spScontractDomain.getTenantCode());
                mnsMnslistDomainBean.setTenantCode(spScontractDomain.getTenantCode());
                HashMap<String, String> map0 = new HashMap<String, String>();
                map0.put("imsgSuserCode", "sys");
                map0.put("imsgSuserName", "sys");
                ArrayList receiverList = new ArrayList();
                HashMap<String, String> listReceiver = new HashMap<String, String>();
                listReceiver.put("code", ((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
                listReceiver.put("name", spScontractDomain.getMemberBname());
                listReceiver.put("spScontract", JsonUtil.buildNonEmptyBinder().toJson((Object)spScontractDomain));
                receiverList.add(listReceiver);
                map0.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
                HashMap paramMap = new HashMap();
                map0.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
                mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonEmptyBinder().toJson(map0));
                PostParamMap pmap = new PostParamMap("mns.ser.sendMnslist");
                pmap.putParamToJson("mnsMnslistDomainBean", (Object)mnsMnslistDomainBean);
                this.htmlIBaseService.sendMesReBean(pmap);
                this.logger.error("\u57cb\u70b92\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - maidianTime2));
                HtmlJsonReBean htmlJsonReBean2 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
                return htmlJsonReBean2;
            }
        }
        this.logger.error("\u6d41\u7a0b2\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - liucheng2));
        long liucheng3 = System.currentTimeMillis();
        HashMap map3 = new HashMap();
        if (param.containsKey("areaCode")) {
            map3.put("areaCode", param.get("areaCode"));
        } else {
            map3.put("areaCode", umUserinfoReDomainBean.getAreaCode());
        }
        List<Map<String, Object>> type3 = this.type3();
        for (int i = 0; i < type3.size(); ++i) {
            HashMap<String, Object> map;
            this.logger.error("\u8fdb\u5165\u5faa\u73af\u5224\u65ad****************************************" + type3.get(i).get("AREA_CODE"));
            if (!type3.get(i).get("AREA_CODE").toString().equals(map3.get("areaCode").toString())) continue;
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            SupQueryResult UserinfoRes = new SupQueryResult();
            if (spScontractDomain.getFchannelCode().equals("1")) {
                map = new HashMap<String, Object>();
                map.put("order", true);
                map.put("fuzzy", false);
                if (StringUtils.isBlank((String)type3.get(i).get("LPJCONTRACT_TYPEPRO").toString())) break;
                map.put("userinfoPhone", type3.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getEmployeeName());
                spScontractDomain.setContractTypepro(type3.get(i).get("LPJCONTRACT_TYPEPRO").toString());
            } else if (spScontractDomain.getFchannelCode().equals("2")) {
                map = new HashMap();
                map.put("order", true);
                map.put("fuzzy", false);
                if (StringUtils.isBlank((String)type3.get(i).get("HCCONTRACT_TYPEPRO").toString())) break;
                map.put("userinfoPhone", type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getEmployeeName());
                spScontractDomain.setContractTypepro(type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
            } else {
                spScontractDomain.setContractTypepro(type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
            }
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            date.setTime(System.currentTimeMillis());
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setContractInvoicedate(date);
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("\u7b2c\u4e09\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            long maidianTime3 = System.currentTimeMillis();
            MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype("gtyuyue");
            mnsMnslistDomainBean.setMnslistBusname("\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e");
            mnsMnslistDomainBean.setMemberCode(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
            mnsMnslistDomainBean.setDataTenant(spScontractDomain.getTenantCode());
            mnsMnslistDomainBean.setTenantCode(spScontractDomain.getTenantCode());
            HashMap<String, String> map0 = new HashMap<String, String>();
            map0.put("imsgSuserCode", "sys");
            map0.put("imsgSuserName", "sys");
            ArrayList receiverList = new ArrayList();
            HashMap<String, String> listReceiver = new HashMap<String, String>();
            listReceiver.put("code", ((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCode());
            listReceiver.put("name", spScontractDomain.getMemberBname());
            listReceiver.put("spScontract", JsonUtil.buildNonEmptyBinder().toJson((Object)spScontractDomain));
            receiverList.add(listReceiver);
            map0.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            HashMap paramMap = new HashMap();
            map0.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonEmptyBinder().toJson(map0));
            PostParamMap pmap = new PostParamMap("mns.ser.sendMnslist");
            pmap.putParamToJson("mnsMnslistDomainBean", (Object)mnsMnslistDomainBean);
            this.htmlIBaseService.sendMesReBean(pmap);
            this.logger.error("\u57cb\u70b93\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - maidianTime3));
            HtmlJsonReBean htmlJsonReBean3 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBean3;
        }
        this.logger.error("\u6d41\u7a0b3\u7ed3\u675f\u65f6\u95f4\u6233+++++++++++++++++++++++++++" + (System.currentTimeMillis() - liucheng3));
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u80fd\u5339\u914d\u5230\u5408\u9002\u7684\u9500\u552e");
    }

    @RequestMapping(value={"talkOverWithSell.json"}, name="\u9500\u552e\u66f4\u6539\u6d3d\u8c08\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean talkOverWithSell(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scontractId", (String)(param.containsKey("scontractId") ? (Object)param.get("scontractId") : null));
        map.put("dataState", (String)(param.containsKey("oldDataState") ? (Object)param.get("oldDataState") : null));
        map.put("tenantCode", tenantCode);
        this.logger.error("param++++++++++++++++++++++++++++++++" + JsonUtil.buildNormalBinder().toJson(map));
        SupQueryResult spScontractReDomainResult = this.spScontractServiceRepository.queryScontractPage(map);
        if (ListUtil.isEmpty((Collection)spScontractReDomainResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\u4fe1\u606f");
        }
        SpScontractReDomain spScontractReDomainUpdate = (SpScontractReDomain)spScontractReDomainResult.getList().get(0);
        spScontractReDomainUpdate.setDataState(Integer.valueOf(Integer.parseInt(param.get("dataState").toString())));
        this.logger.error("param++++++++++++++++++++++++++++++++" + JsonUtil.buildNormalBinder().toJson((Object)param));
        return this.spScontractServiceRepository.updateScontractState(Integer.valueOf(Integer.parseInt(param.get("scontractId").toString())), Integer.valueOf(Integer.parseInt(param.get("dataState").toString())), Integer.valueOf(Integer.parseInt(param.get("oldDataState").toString())), null);
    }

    @RequestMapping(value={"contractList.json"}, name="\u5c55\u793a\u9500\u552e\u5408\u540c\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean contractList(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        return null;
    }

    @RequestMapping(value={"ImportBuyerContracts.json"}, name="\u5bfc\u5165\u7ebf\u4e0b\u4e70\u5bb6\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr) {
        if (StringUtils.isBlank((String)scontractDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "params is null");
        }
        this.logger.error(scontractDomainStr);
        List spScontractDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        String msg = "";
        int errCount = 0;
        HtmlJsonReBean htmlJsonReBean = null;
        for (SpScontractDomain spScontractDomain : spScontractDomainList) {
            spScontractDomain.setTenantCode(this.getTenantCode(request));
            spScontractDomain.getScontractCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String scontractNcode = spScontractDomain.getScontractNcode();
            String scontractObillcode = spScontractDomain.getScontractObillcode();
            map.put("scontractObillcode", spScontractDomain.getScontractObillcode());
            this.logger.error("scontractObillcode---------------------------------" + spScontractDomain.getScontractObillcode());
            map.put("tenantCode", this.getTenantCode(request));
            map.put("contractInvstate", 0);
            List SpScontractReDomain2 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain2)) {
                msg = msg + scontractObillcode + "\u8be5\u5408\u540c\u4e0d\u5b58\u5728;";
                this.logger.error(scontractObillcode + "\uff1a11111111111\u5408\u540c\u4e0d\u5b58\u5728");
                ++errCount;
                continue;
            }
            SpScontractReDomain SpScontractReDomain22 = (SpScontractReDomain)SpScontractReDomain2.get(0);
            map.put("contractInvstate", 1);
            map.put("memberBcode", spScontractDomain.getMemberBcode());
            List SpScontractReDomain1 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain1)) {
                SpScontractReDomain22.setScontractObillcode(spScontractDomain.getScontractObillcode());
                SpScontractReDomain22.setScontractNcode(spScontractDomain.getScontractNcode());
                SpScontractReDomain22.setGoodsMoney(spScontractDomain.getGoodsMoney());
                SpScontractReDomain22.setContractEffectivedate(spScontractDomain.getContractEffectivedate());
                SpScontractReDomain22.setContractDepositdate(spScontractDomain.getContractDepositdate());
                SpScontractReDomain22.setDataState(spScontractDomain.getDataState());
                SpScontractReDomain22.setMemberCname(spScontractDomain.getMemberCname());
                SpScontractReDomain22.setMemberCcode(spScontractDomain.getMemberCcode());
                SpScontractReDomain22.setMemberBcode(spScontractDomain.getMemberBcode());
                SpScontractReDomain22.setScontractBcode(spScontractDomain.getScontractBcode());
                SpScontractReDomain22.setContractInvstate(Integer.valueOf(1));
                this.logger.error("\u4e2a\u4eba\u5408\u540c\u4e0d\u5b58\u5728\uff0c\u65b0\u589e" + scontractObillcode);
                SpScontractReDomain22.setScontractId(null);
                SpScontractReDomain22.setScontractCode(null);
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract((SpScontractDomain)SpScontractReDomain22);
                continue;
            }
            spScontractDomain.setScontractId(((SpScontractReDomain)SpScontractReDomain1.get(0)).getScontractId());
            if (StringUtils.isNotBlank((String)((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode())) {
                if (((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode().equals(scontractNcode)) {
                    this.logger.error("\u5916\u90e8\u5408\u540c\u6821\u9a8c\u901a\u8fc7\uff1a" + ((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode());
                    htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
                    continue;
                }
                msg = msg + scontractObillcode + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e0d\u6b63\u786e;";
                this.logger.error(spScontractDomain.getScontractObillcode() + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u6821\u9a8c\u4e0d\u901a\u8fc7");
                ++errCount;
                continue;
            }
            this.logger.error("msg", (Object)("\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a" + spScontractDomain.getScontractObillcode()));
            this.logger.error("msg", (Object)("id" + spScontractDomain.getScontractObillcode()));
            htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
        }
        if (errCount == 0) {
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff1a" + errCount + "\u6761," + msg);
    }
}

