/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.springmvc.util.JsoupUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;
    private boolean isIncludeRichText = false;

    public XssHttpServletRequestWrapper(HttpServletRequest request, boolean isIncludeRichText) {
        super(request);
        this.orgRequest = request;
        this.isIncludeRichText = isIncludeRichText;
    }

    public String getParameter(String name) {
        if (("content".equals(name) || name.endsWith("WithHtml")) && !this.isIncludeRichText) {
            return super.getParameter(name);
        }
        String value = super.getParameter(name = JsoupUtil.clean(name));
        if (StringUtils.isNotBlank((String)value)) {
            value = JsoupUtil.clean(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = JsoupUtil.clean(arr[i]);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name = JsoupUtil.clean(name));
        if (StringUtils.isNotBlank((String)value)) {
            value = JsoupUtil.clean(value);
        }
        return value;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }

    public String getQueryString() {
        return JsoupUtil.clean(super.getQueryString());
    }

    public Map<String, String[]> getParameterMap() {
        Map paramMap = super.getParameterMap();
        HashMap<String, String[]> xssparamMap = new HashMap<String, String[]>();
        if (MapUtil.isEmpty((Map)paramMap)) {
            return xssparamMap;
        }
        for (String key : paramMap.keySet()) {
            String[] values = (String[])paramMap.get(key);
            if (null != values && values.length > 0) {
                String[] xssvalues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (null == values[i] || !(values[i] instanceof String)) continue;
                    xssvalues[i] = JsoupUtil.clean(String.valueOf(values[i]));
                }
                xssparamMap.put(key, xssvalues);
                continue;
            }
            xssparamMap.put(key, null);
        }
        return xssparamMap;
    }
}

