/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.springmvc.util.JsoupUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;
    private boolean isIncludeRichText = false;

    public XssHttpServletRequestWrapper(HttpServletRequest request, boolean isIncludeRichText) {
        super(request);
        this.orgRequest = request;
        this.isIncludeRichText = isIncludeRichText;
    }

    public String getParameter(String name) {
        if (("content".equals(name) || name.endsWith("WithHtml")) && !this.isIncludeRichText) {
            return super.getParameter(name);
        }
        String value = super.getParameter(name = JsoupUtil.clean(name));
        if (StringUtils.isNotBlank((String)value)) {
            value = JsoupUtil.clean(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = JsoupUtil.clean(arr[i]);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name = JsoupUtil.clean(name));
        if (StringUtils.isNotBlank((String)value)) {
            value = JsoupUtil.clean(value);
        }
        return value;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }

    public String getQueryString() {
        return JsoupUtil.clean(super.getQueryString());
    }

    public Map<String, String[]> getParameterMap() {
        Map paramMap = super.getParameterMap();
        HashMap<String, String[]> xssParamMap = new HashMap<String, String[]>();
        if (MapUtil.isEmpty((Map)paramMap)) {
            return xssParamMap;
        }
        for (String key : paramMap.keySet()) {
            String[] values = (String[])paramMap.get(key);
            if (null != values && values.length > 0) {
                String[] xssvalues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (null == values[i] || !(values[i] instanceof String)) continue;
                    xssvalues[i] = JsoupUtil.clean(String.valueOf(values[i]));
                }
                xssParamMap.put(key, xssvalues);
                continue;
            }
            xssParamMap.put(key, null);
        }
        return xssParamMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        String str = this.getRequestBody((InputStream)super.getInputStream());
        if ("".equals(str)) {
            return new ServletInputStream(){

                public int read() throws IOException {
                    return 0;
                }
            };
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(str, String.class, Object.class);
        HashMap resultMap = new HashMap(map.size());
        for (String key : map.keySet()) {
            Object val = map.get(key);
            if ("content".equals(key)) {
                resultMap.put(key, val);
                continue;
            }
            if (map.get(key) instanceof String) {
                resultMap.put(key, JsoupUtil.clean(val.toString()));
                continue;
            }
            resultMap.put(key, val);
        }
        str = JsonUtil.buildNormalBinder().toJson(resultMap);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return 0;
            }
        };
    }

    private String getRequestBody(InputStream stream) {
        String line = "";
        StringBuilder body = new StringBuilder();
        int counter = 0;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            while ((line = reader.readLine()) != null) {
                body.append(line);
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (body == null) {
            return "";
        }
        return body.toString();
    }
}

