/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.sub.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.sub.domain.RecRecruitEnrollDomain;
import com.qjsoft.laser.controller.facade.sub.domain.RecRecruitEnrollReDomain;
import com.qjsoft.laser.controller.facade.sub.repository.RecRecruitEnrollServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruitEnroll"}, name="\u7528\u6237\u62a5\u540d\u670d\u52a1")
public class RecruitEnrollCon
extends SpringmvcController {
    private static String CODE = "rec.recruitEnroll.con";
    @Autowired
    private RecRecruitEnrollServiceRepository recRecruitEnrollServiceRepository;

    protected String getContext() {
        return "recruitEnroll";
    }

    @RequestMapping(value={"saveRecruitEnroll.json"}, name="\u589e\u52a0\u7528\u6237\u62a5\u540d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruitEnroll(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveRecruitEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.error("aaaaaaaaaaaaaaaa1--------------------------------" + paramStr);
        RecRecruitEnrollDomain recRecruitEnrollDomain = (RecRecruitEnrollDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitEnrollDomain.class);
        this.logger.error("aaaaaaaaaaaaaaaa2--------------------------------" + recRecruitEnrollDomain.getRecruitCode());
        recRecruitEnrollDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            recRecruitEnrollDomain.setMemberBname(userSession.getUserName());
            recRecruitEnrollDomain.setMemberBcode(userSession.getUserPcode());
        }
        recRecruitEnrollDomain.setRecruitSdate(new Date());
        recRecruitEnrollDomain.setRecruitEnrollType("0");
        return this.recRecruitEnrollServiceRepository.saveRecruitEnroll(recRecruitEnrollDomain);
    }

    @RequestMapping(value={"getRecruitEnroll.json"}, name="\u83b7\u53d6\u7528\u6237\u62a5\u540d\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitEnrollReDomain getRecruitEnroll(Integer recruitEnrollId) {
        if (StringUtils.isBlank((Integer)recruitEnrollId)) {
            this.logger.error(CODE + ".getRecruitEnroll", (Object)"param is null");
            return null;
        }
        return this.recRecruitEnrollServiceRepository.getRecruitEnroll(recruitEnrollId);
    }

    @RequestMapping(value={"updateRecruitEnroll.json"}, name="\u66f4\u65b0\u7528\u6237\u62a5\u540d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruitEnroll(HttpServletRequest request, RecRecruitEnrollDomain recRecruitEnrollDomain) {
        if (null == recRecruitEnrollDomain) {
            this.logger.error(CODE + ".updateRecruitEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.recRecruitEnrollServiceRepository.updateRecruitEnroll(recRecruitEnrollDomain);
    }

    @RequestMapping(value={"deleteRecruitEnroll.json"}, name="\u5220\u9664\u7528\u6237\u62a5\u540d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruitEnroll(Integer recruitEnrollId) {
        if (StringUtils.isBlank((Integer)recruitEnrollId)) {
            this.logger.error(CODE + ".deleteRecruitEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitEnrollServiceRepository.deleteRecruitEnroll(recruitEnrollId);
    }

    @RequestMapping(value={"queryRecruitEnrollPage.json"}, name="\u67e5\u8be2\u7528\u6237\u62a5\u540d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitEnrollDomain> queryRecruitEnrollPage(HttpServletRequest request, String recruitType) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("recruitType", recruitType);
        }
        return this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(param);
    }

    @RequestMapping(value={"updateRecruitEnrollState.json"}, name="\u66f4\u65b0\u7528\u6237\u62a5\u540d\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitEnrollState(String recruitEnrollId, Integer dataState, Integer oldDataState, HttpServletRequest request) {
        if (StringUtils.isBlank((String)recruitEnrollId)) {
            this.logger.error(CODE + ".updateRecruitEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String memo = request.getParameter("memo");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        return this.recRecruitEnrollServiceRepository.updateRecruitEnrollState(Integer.valueOf(recruitEnrollId), dataState, oldDataState, map);
    }
}

