/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.tenant.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantDomain;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantReDomain;
import com.qjsoft.laser.controller.facade.tm.repository.TmTenantServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tm/tenant"}, name="\u79df\u6237\u4fe1\u606f")
public class TenantCon
extends SpringmvcController {
    private static String CODE = "tm.tenant.con";
    @Autowired
    private TmTenantServiceRepository tmTenantServiceRepository;

    protected String getContext() {
        return "tenant";
    }

    @RequestMapping(value={"saveTenant.json"}, name="\u589e\u52a0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".saveTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.saveTenant(tmTenantDomain);
    }

    @RequestMapping(value={"getTenant.json"}, name="\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public TmTenantReDomain getTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".getTenant", (Object)"param is null");
            return null;
        }
        return this.tmTenantServiceRepository.getTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"updateTenant.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".updateTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.updateTenant(tmTenantDomain);
    }

    @RequestMapping(value={"deleteTenant.json"}, name="\u5220\u9664\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".deleteTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.deleteTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"queryTenantPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmTenantServiceRepository.queryTenantPage(param);
    }

    @RequestMapping(value={"updateTenantState.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTenantState(String tenantId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".updateTenantState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.updateTenantState(Integer.valueOf(tenantId), dataState, oldDataState);
    }
}

