/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.up.domain.UpRoleReDomainBean;
import com.qjsoft.laser.controller.facade.up.repository.RoleServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/userStore"}, name="\u95e8\u5e97\u4f1a\u5458")
public class UserStoreCon
extends SpringmvcController {
    private static String CODE = "um.userStore.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RoleServiceRepository roleServiceRepository;

    protected String getContext() {
        return "userStore";
    }

    @RequestMapping(value={"saveUserStore.json"}, name="\u589e\u52a0\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean saveUserStore(HttpServletRequest request, UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            this.logger.error(CODE + ".saveUserStore", (Object)"umUserDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveUserStore", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u4fe1\u606f\u6709\u8bef");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleMap.put("roleName", "\u95e8\u5e97");
        roleMap.put("tenantCode", tenantCode);
        SupQueryResult roleList = this.roleServiceRepository.queryUpRoleList(roleMap);
        if (null != roleList && roleList.getList().size() > 0) {
            UpRoleReDomainBean upRoleReDomainBean = (UpRoleReDomainBean)roleList.getList().get(0);
            umUserDomainBean.setUserinfoParentCode(userSession.getUserPcode());
            umUserDomainBean.setRoleCode(upRoleReDomainBean.getRoleCode());
            return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
        }
        umUserDomainBean.setUserinfoParentCode(userSession.getUserPcode());
        return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
    }

    @RequestMapping(value={"saveUserStoreByPT.json"}, name="\u5e73\u53f0\u589e\u52a0\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean saveUserStoreByPT(HttpServletRequest request, UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            this.logger.error(CODE + ".saveUserStoreByPT", (Object)"umUserDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleMap.put("roleName", "\u95e8\u5e97");
        roleMap.put("tenantCode", tenantCode);
        SupQueryResult roleList = this.roleServiceRepository.queryUpRoleList(roleMap);
        if (null != roleList && roleList.getList().size() > 0) {
            UpRoleReDomainBean upRoleReDomainBean = (UpRoleReDomainBean)roleList.getList().get(0);
            umUserDomainBean.setRoleCode(upRoleReDomainBean.getRoleCode());
            return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
        }
        return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
    }

    @RequestMapping(value={"storeJudgeRegister.json"}, name="\u5224\u65ad\u6ce8\u518c\u4fe1\u606f\u662f\u5426\u91cd\u590d")
    @ResponseBody
    public HtmlJsonReBean storeJudgeRegister(HttpServletRequest request, String userinfoCompname, String userPhone) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        if (StringUtils.isNotBlank((String)userinfoCompname)) {
            ArrayList<String> checkuserinfolist = new ArrayList<String>();
            SupQueryResult UserinfoResult = this.userServiceRepository.queryUserinfoPage(param);
            List userinfoList = UserinfoResult.getList();
            for (UmUserinfoReDomainBean umUserinfoReDomainBean : userinfoList) {
                checkuserinfolist.add(umUserinfoReDomainBean.getUserinfoCompname());
            }
            if (checkuserinfolist.contains(userinfoCompname)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u95e8\u5e97\u5df2\u5b58\u5728");
            }
        }
        if (StringUtils.isNotBlank((String)userPhone)) {
            ArrayList<String> checkuserlist = new ArrayList<String>();
            SupQueryResult UserResult = this.userServiceRepository.queryUserPage(param);
            List userList = UserResult.getList();
            for (UmUserReDomainBean userDomainBean : userList) {
                checkuserlist.add(userDomainBean.getUserPhone());
            }
            if (checkuserlist.contains(userPhone)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u9646\u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c");
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getUserStore.json"}, name="\u83b7\u53d6\u95e8\u5e97\u4f1a\u5458\u4fe1\u606f")
    @ResponseBody
    public UmUserinfoReDomainBean getUserUserSupplier(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".getUserStore", (Object)"param is null");
            return null;
        }
        return this.userServiceRepository.getUserinfo(userinfoId);
    }

    @RequestMapping(value={"updateUserStore.json"}, name="\u66f4\u65b0\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean updateUserStore(HttpServletRequest request, UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            this.logger.error(CODE + ".updateUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"deleteUserStore.json"}, name="\u5220\u9664\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean deleteUserStore(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.deleteUserinfo(userinfoId);
    }

    @RequestMapping(value={"queryUserStorePage.json"}, name="\u67e5\u8be2\u95e8\u5e97\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserStorePage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"userSession is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoParentCode", userSession.getUserPcode());
        map.put("userinfoQuality", "store");
        map.put("tenantCode", this.getTenantCode(request));
        return this.userServiceRepository.queryUserinfoPage(map);
    }

    @RequestMapping(value={"enableUserStore.json"}, name="\u542f\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean enableUserStore(String userinfoId) {
        return this.enableUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"stoppedUserStore.json"}, name="\u505c\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean stoppedUserStore(String userinfoId) {
        return this.stoppedUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"queryUserStorePageByPT.json"}, name="\u5e73\u53f0\u67e5\u8be2\u95e8\u5e97\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserStorePageByPT(HttpServletRequest request) {
        return this.queryUserStoreCommon(request);
    }

    @RequestMapping(value={"enableUserStoreByPT.json"}, name="\u542f\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean enableUserStoreByPT(String userinfoId) {
        return this.enableUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"stoppedUserStoreByPT.json"}, name="\u505c\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean stoppedUserStoreByPT(String userinfoId) {
        return this.stoppedUserStoreCommon(userinfoId);
    }

    private SupQueryResult<UmUserinfoReDomainBean> queryUserStoreCommon(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    private HtmlJsonReBean saveUserStoreCommon(String tenantCode, UmUserDomainBean umUserDomainBean) {
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserType(Integer.valueOf(0));
        umUserDomainBean.setUserinfoQuality("store");
        return this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
    }

    private HtmlJsonReBean stoppedUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".stoppedUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    private HtmlJsonReBean enableUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".enableUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(0), Integer.valueOf(-1));
    }
}

