/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.up.domain.UpRoleReDomainBean;
import com.qjsoft.laser.controller.facade.up.repository.RoleServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/userStore"}, name="\u95e8\u5e97\u4f1a\u5458")
public class UserStoreCon
extends SpringmvcController {
    private static String CODE = "um.userStore.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RoleServiceRepository roleServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;

    protected String getContext() {
        return "userStore";
    }

    @RequestMapping(value={"saveUserStore.json"}, name="\u589e\u52a0\u5f53\u524d\u767b\u9646\u8005\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean saveUserStore(HttpServletRequest request, UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            this.logger.error(CODE + ".saveUserStore", (Object)"umUserDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveUserStore", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u4fe1\u606f\u6709\u8bef");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleMap.put("roleName", "\u95e8\u5e97");
        roleMap.put("tenantCode", tenantCode);
        SupQueryResult roleList = this.roleServiceRepository.queryUpRoleList(roleMap);
        if (null != roleList && roleList.getList().size() > 0) {
            UpRoleReDomainBean upRoleReDomainBean = (UpRoleReDomainBean)roleList.getList().get(0);
            umUserDomainBean.setUserinfoParentCode(userSession.getUserPcode());
            umUserDomainBean.setRoleCode(upRoleReDomainBean.getRoleCode());
            return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
        }
        umUserDomainBean.setUserinfoParentCode(userSession.getUserPcode());
        return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
    }

    @RequestMapping(value={"saveUserStoreByPT.json"}, name="\u5e73\u53f0\u589e\u52a0\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean saveUserStoreByPT(HttpServletRequest request, UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            this.logger.error(CODE + ".saveUserStoreByPT", (Object)"umUserDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleMap.put("roleName", "\u95e8\u5e97");
        roleMap.put("tenantCode", tenantCode);
        SupQueryResult roleList = this.roleServiceRepository.queryUpRoleList(roleMap);
        if (null != roleList && roleList.getList().size() > 0) {
            UpRoleReDomainBean upRoleReDomainBean = (UpRoleReDomainBean)roleList.getList().get(0);
            umUserDomainBean.setRoleCode(upRoleReDomainBean.getRoleCode());
            return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
        }
        return this.saveUserStoreCommon(tenantCode, umUserDomainBean);
    }

    @RequestMapping(value={"storeJudgeRegister.json"}, name="\u5224\u65ad\u6ce8\u518c\u4fe1\u606f\u662f\u5426\u91cd\u590d")
    @ResponseBody
    public HtmlJsonReBean storeJudgeRegister(HttpServletRequest request, String userinfoCompname, String userPhone) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        if (StringUtils.isNotBlank((String)userinfoCompname)) {
            ArrayList<String> checkuserinfolist = new ArrayList<String>();
            SupQueryResult UserinfoResult = this.userServiceRepository.queryUserinfoPage(param);
            List userinfoList = UserinfoResult.getList();
            for (UmUserinfoReDomainBean umUserinfoReDomainBean : userinfoList) {
                checkuserinfolist.add(umUserinfoReDomainBean.getUserinfoCompname());
            }
            if (checkuserinfolist.contains(userinfoCompname)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u95e8\u5e97\u5df2\u5b58\u5728");
            }
        }
        if (StringUtils.isNotBlank((String)userPhone)) {
            ArrayList<String> checkuserlist = new ArrayList<String>();
            SupQueryResult UserResult = this.userServiceRepository.queryUserPage(param);
            List userList = UserResult.getList();
            for (UmUserReDomainBean userDomainBean : userList) {
                checkuserlist.add(userDomainBean.getUserPhone());
            }
            if (checkuserlist.contains(userPhone)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u9646\u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c");
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getUserStore.json"}, name="\u83b7\u53d6\u95e8\u5e97\u4f1a\u5458\u4fe1\u606f")
    @ResponseBody
    public UmUserinfoReDomainBean getUserUserSupplier(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".getUserStore", (Object)"param is null");
            return null;
        }
        return this.userServiceRepository.getUserinfo(userinfoId);
    }

    @RequestMapping(value={"updateUserStore.json"}, name="\u66f4\u65b0\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean updateUserStore(HttpServletRequest request, UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            this.logger.error(CODE + ".updateUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"deleteUserStore.json"}, name="\u5220\u9664\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean deleteUserStore(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.deleteUserinfo(userinfoId);
    }

    @RequestMapping(value={"queryUserStorePage.json"}, name="\u67e5\u8be2\u767b\u9646\u8005\u4e0b\u9762\u7684\u95e8\u5e97\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserStorePage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"userSession is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoParentCode", userSession.getUserPcode());
            param.put("tenantCode", this.getTenantCode(request));
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    @RequestMapping(value={"enableUserStore.json"}, name="\u542f\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean enableUserStore(String userinfoId) {
        return this.enableUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"stoppedUserStore.json"}, name="\u505c\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean stoppedUserStore(String userinfoId) {
        return this.stoppedUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"queryUserStorePageByPT.json"}, name="\u5e73\u53f0\u67e5\u8be2\u95e8\u5e97\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserStorePageByPT(HttpServletRequest request) {
        return this.queryUserStoreCommon(request);
    }

    @RequestMapping(value={"enableUserStoreByPT.json"}, name="\u542f\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean enableUserStoreByPT(String userinfoId) {
        return this.enableUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"stoppedUserStoreByPT.json"}, name="\u505c\u7528\u95e8\u5e97\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean stoppedUserStoreByPT(String userinfoId) {
        return this.stoppedUserStoreCommon(userinfoId);
    }

    private SupQueryResult<UmUserinfoReDomainBean> queryUserStoreCommon(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    private HtmlJsonReBean saveUserStoreCommon(String tenantCode, UmUserDomainBean umUserDomainBean) {
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserType(Integer.valueOf(0));
        umUserDomainBean.setUserinfoQuality("store");
        return this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
    }

    @RequestMapping(value={"saveExcelchStore.json"}, name="\u6279\u91cfexcel\u5bfc\u5165\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean saveExcelchStore(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isEmpty((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveExcelchStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<UmUserReDomainBean> errList = new ArrayList<UmUserReDomainBean>();
        String tenantCode = this.getTenantCode(request);
        List umUserinfoDomainBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(userinfoJosn, UmUserReDomainBean.class);
        if (ListUtil.isNotEmpty((Collection)umUserinfoDomainBeanList)) {
            for (UmUserReDomainBean UmUserReDomainBeanStr : umUserinfoDomainBeanList) {
                try {
                    this.saveUserStoreCommon(tenantCode, (UmUserDomainBean)UmUserReDomainBeanStr);
                }
                catch (Exception e) {
                    errList.add(UmUserReDomainBeanStr);
                }
            }
        }
        return new HtmlJsonReBean(errList);
    }

    private HtmlJsonReBean stoppedUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".stoppedUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    private HtmlJsonReBean enableUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".enableUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(0), Integer.valueOf(-1));
    }

    @RequestMapping(value={"queryStoreByUserInfoCode.json"}, name="\u6839\u636e\u5f53\u524d\u767b\u9646\u8005\u67e5\u770b\u95e8\u5e97\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryStoreByUserInfoCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"userSession is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoParentCode", userSession.getUserPcode());
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    @RequestMapping(value={"queryStoreByUserInfoCodeC.json"}, name="\u6839\u636e\u5f53\u524d\u767b\u9646\u8005\u67e5\u770b\u95e8\u5e97\u5217\u8868C")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryStoreByUserInfoCodeC(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteUserStore", (Object)"userSession is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoParentCode", userSession.getUserPcode());
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    @RequestMapping(value={"getStoreByStoreId.json"}, name="\u6839\u636e\u95e8\u5e97Id\u67e5\u770b\u8be6\u60c5")
    @ResponseBody
    public UmUserinfoReDomainBean getStoreByStoreId(HttpServletRequest request, int userInfoId) {
        UmUserinfoReDomainBean userinfo = this.userServiceRepository.getUserinfo(Integer.valueOf(userInfoId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfo.getUserinfoCode());
        map.put("tenantCode", this.getTenantCode(request));
        userinfo.setUmUserinfoQuaDomainList(this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList());
        return userinfo;
    }

    @RequestMapping(value={"getStoreByStoreIdC.json"}, name="\u6839\u636e\u95e8\u5e97Id\u67e5\u770b\u8be6\u60c5C")
    @ResponseBody
    public UmUserinfoReDomainBean getStoreByStoreIdC(HttpServletRequest request, int userInfoId) {
        UmUserinfoReDomainBean userinfo = this.userServiceRepository.getUserinfo(Integer.valueOf(userInfoId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfo.getUserinfoCode());
        map.put("tenantCode", this.getTenantCode(request));
        userinfo.setUmUserinfoQuaDomainList(this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList());
        return userinfo;
    }

    @RequestMapping(value={"saveAuthorization.json"}, name="\u7533\u8bf7\u6388\u6743\u4e66")
    @ResponseBody
    public HtmlJsonReBean saveAuthorization(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveAuthorization", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserinfoDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        umUserinfoDomainBean.setUserinfoFeestatus(Integer.valueOf(1));
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"saveAuthorizationC.json"}, name="\u7533\u8bf7\u6388\u6743\u4e66C")
    @ResponseBody
    public HtmlJsonReBean saveAuthorizationC(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveAuthorization", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserinfoDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        umUserinfoDomainBean.setUserinfoFeestatus(Integer.valueOf(1));
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"authorizationPassed.json"}, name="\u6388\u6743\u4e66\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean authorizationPassed(HttpServletRequest request, Integer userinfoId) {
        if (null == userinfoId) {
            this.logger.error(CODE + ".saveStore", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.userServiceRepository.updateStoreState(userinfoId, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"authorizationDenied.json"}, name="\u6388\u6743\u4e66\u62d2\u7edd")
    @ResponseBody
    public HtmlJsonReBean authorizationDenied(HttpServletRequest request, Integer userinfoId) {
        if (null == userinfoId) {
            this.logger.error(CODE + ".authorizationDenied", (Object)"userInfoId is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.userServiceRepository.updateStoreState(userinfoId, Integer.valueOf(3), Integer.valueOf(1));
    }

    @RequestMapping(value={"queryStore.json"}, name="\u67e5\u8be2\u6240\u6709\u95e8\u5e97\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
        }
        SupQueryResult umUserinfoReDomainBeans = this.userServiceRepository.queryUserinfoPage(param);
        return umUserinfoReDomainBeans;
    }

    @RequestMapping(value={"saveStore.json"}, name="\u5e73\u53f0\u65b0\u589e\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean saveStore(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveStore", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserReDomainBean umUserinfoDomainBean = (UmUserReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserReDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        return this.saveUserStoreCommon(this.getTenantCode(request), (UmUserDomainBean)umUserinfoDomainBean);
    }

    @RequestMapping(value={"updateStore.json"}, name="\u7f16\u8f91\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateStore(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".updateStore", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserinfoDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        this.logger.error(CODE + "=======" + userinfoJosn);
        this.logger.error(CODE + "umUserinfoDomainBean=====" + umUserinfoDomainBean.toString());
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"deleteStore.json"}, name="\u5220\u9664\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean deleteStore(HttpServletRequest request, Integer userinfoId) {
        if (null == userinfoId) {
            this.logger.error(CODE + ".deleteStore", (Object)"userinfoId is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.userServiceRepository.deleteUserinfo(userinfoId);
    }

    @RequestMapping(value={"queryAuthorization.json"}, name="\u67e5\u8be2\u6388\u6743\u4e66\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryAuthorization(HttpServletRequest request, Integer userInfoId) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoFeestatusStr", "1,2,3");
        }
        SupQueryResult umUserinfoReDomainBeans = this.userServiceRepository.queryUserinfoPage(param);
        HashMap<String, String> map = new HashMap<String, String>();
        for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeans.getList()) {
            map.put("userinfoCode", umUserinfoReDomainBean.getUserinfoCode());
            map.put("tenantCode", this.getTenantCode(request));
            umUserinfoReDomainBean.setUmUserinfoQuaDomainList(this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList());
        }
        return umUserinfoReDomainBeans;
    }

    @RequestMapping(value={"getAuthorization.json"}, name="\u6839\u636e\u6388\u6743\u4e66\u67e5\u770b\u8be6\u60c5")
    @ResponseBody
    public UmUserinfoReDomainBean getAuthorization(HttpServletRequest request, int userInfoId) {
        UmUserinfoReDomainBean userinfo = this.userServiceRepository.getUserinfo(Integer.valueOf(userInfoId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfo.getUserinfoCode());
        map.put("tenantCode", this.getTenantCode(request));
        userinfo.setUmUserinfoQuaDomainList(this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList());
        return userinfo;
    }
}

