/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmAddressServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/address"}, name="\u5356\u5bb6\u5730\u5740\u4fe1\u606f")
public class SellerAddressCon
extends SpringmvcController {
    private static String CODE = "um.address.con";
    @Autowired
    private UmAddressServiceRepository umAddressServiceRepository;

    protected String getContext() {
        return "address";
    }

    @RequestMapping(value={"saveSellerAddress.json"}, name="\u589e\u52a0\u5356\u5bb6\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveSellerAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveSellerAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressServiceRepository.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"getSellerAddress.json"}, name="\u83b7\u53d6\u5356\u5bb6\u5730\u5740\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getAddress(Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".getSellerAddress", (Object)"param is null");
            return null;
        }
        return this.umAddressServiceRepository.getAddress(addressId);
    }

    @RequestMapping(value={"updateSellerAddress.json"}, name="\u66f4\u65b0\u5356\u5bb6\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".updateSellerAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateSellerAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressServiceRepository.updateAddress(umAddressDomain);
    }

    @RequestMapping(value={"deleteSellerAddress.json"}, name="\u5220\u9664\u5356\u5bb6\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAddress(Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".deleteSellerAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressServiceRepository.deleteAddress(addressId);
    }

    @RequestMapping(value={"querySellerAddressPage.json"}, name="\u67e5\u8be2\u5356\u5bb6\u5730\u5740\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmAddressReDomain> queryAddressPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umAddressServiceRepository.queryAddressPage(param);
    }

    @RequestMapping(value={"updateSellerAddressState.json"}, name="\u66f4\u65b0\u5356\u5bb6\u5730\u5740\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAddressState(String addressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)addressId)) {
            this.logger.error(CODE + ".updateSellerAddressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressServiceRepository.updateAddressState(Integer.valueOf(addressId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateSellerAddressDefault.json"}, name="\u66f4\u65b0\u5356\u5bb6\u9ed8\u8ba4\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean updateAddressDefault(HttpServletRequest request, String addressCode) {
        if (StringUtils.isBlank((String)addressCode)) {
            this.logger.error(CODE + ".updateSellerAddressDefault", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateSellerAddressDefault", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressServiceRepository.updateAddressDefault(userSession.getUserPcode(), addressCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"getDefSellerAddress.json"}, name="\u83b7\u53d6\u5356\u5bb6\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getDefAddress(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDefSellerAddress", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressServiceRepository.getDefAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"querySellerAddressBymerberCode.json"}, name="\u83b7\u53d6\u5356\u5bb6\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressBymerberCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".querySellerAddressBymerberCode", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressServiceRepository.queryAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryMemberAddressPage.json"}, name="\u67e5\u8be2\u5f53\u524d\u4f1a\u5458\u5730\u5740\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmAddressReDomain> queryMemberAddressPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryAddressPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("userCode", userSession.getUserPcode());
            param.put("tenantCode", this.getTenantCode(request));
        }
        return this.umAddressServiceRepository.queryAddressPage(param);
    }
}

