/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.UmUserinfo;
import com.qjsoft.laser.controller.facade.um.domain.AmAddress;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmAddressServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/address"}, name="\u7528\u6237\u5730\u5740\u4fe1\u606f")
public class AddressCon
extends SpringmvcController {
    private static String CODE = "um.address.con";
    @Autowired
    UmAddressServiceRepository umAddressServiceRepository;

    protected String getContext() {
        return "address";
    }

    @RequestMapping(value={"saveAddress.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressServiceRepository.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"getAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".getAddress", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressServiceRepository.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            return null;
        }
        return umAddressReDomain;
    }

    @RequestMapping(value={"updateAddress.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".updateAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmAddressReDomain address = this.umAddressServiceRepository.getAddress(umAddressDomain.getAddressId());
        if (null == address || !address.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressServiceRepository.updateAddress(umAddressDomain);
    }

    @RequestMapping(value={"deleteAddress.json"}, name="\u5220\u9664\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".deleteAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressServiceRepository.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteAddress", (Object)"getUserCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f02\u5e38\u64cd\u4f5c");
        }
        return this.umAddressServiceRepository.deleteAddress(addressId);
    }

    @RequestMapping(value={"queryAddressPage.json"}, name="\u67e5\u8be2\u7528\u6237\u5730\u5740\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmAddressReDomain> queryAddressPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umAddressServiceRepository.queryAddressPage(param);
    }

    @RequestMapping(value={"updateAddressState.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAddressState(String addressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)addressId)) {
            this.logger.error(CODE + ".updateAddressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressServiceRepository.updateAddressState(Integer.valueOf(addressId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAddressDefault.json"}, name="\u66f4\u65b0\u7528\u6237\u9ed8\u8ba4\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean updateAddressDefault(HttpServletRequest request, String addressCode) {
        if (StringUtils.isBlank((String)addressCode)) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressServiceRepository.updateAddressDefault(userSession.getUserPcode(), addressCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"getDefAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getDefAddress(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDefAddress", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressServiceRepository.getDefAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryAddressBymerberCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressBymerberCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryAddressBymerberCode", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressServiceRepository.queryAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryAddressForUser.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        return this.umAddressServiceRepository.queryAddressBymerberCode(userinfoCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveAddressForUser.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddressForUser(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddressForUser", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)umAddressDomain.getUserCode())) {
            umAddressDomain.setUserCode(userSession.getUserPcode());
            umAddressDomain.setUserName(userSession.getMerberCompname());
        }
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressServiceRepository.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"queryAmUserAddressByCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public List<AmAddress> queryAmUserAddressByCode(HttpServletRequest request, String userinfoCode) {
        return this.umAddressServiceRepository.queryAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"updateAmUserAddressByCode.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public HtmlJsonReBean updateAmUserAddressByCode(HttpServletRequest request, String userinfoCode, String amAddressesStr) {
        List amAddresses = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressServiceRepository.updateAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"getAmUserByCode.json"}, name="\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f(AM)")
    @ResponseBody
    public UmUserinfo getAmUserByCode(HttpServletRequest request, String userinfoCode) {
        return this.umAddressServiceRepository.getAmUserByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }
}

