/*
 * Decompiled with CFR 0.152.
 */
package userexceltemplate;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.GeoRadiusResponse;
import userexceltemplate.JedisSentineUtil;
import userexceltemplate.RedisCache;

public class RedisUtil {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String NAME = "name";
    public static final String PSWORD = "psword";
    public static final String INDEX = "index";
    public static final String SSL = "ssl";
    private static RedisCache redisCache;
    private static RedisUtil redisUtil;
    private static String index;
    public static final String SCHEME = "scheme";
    protected SupperLogUtil logger = new SupperLogUtil(RedisUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisUtil getRedisUtil() {
        Class<RedisUtil> clazz = RedisUtil.class;
        synchronized (RedisUtil.class) {
            if (null == redisUtil) {
                Map<String, String> map = RedisUtil.getRes();
                String scheme = map.get(SCHEME);
                if (StringUtils.isBlank((String)scheme)) {
                    scheme = "ShardedJedisUtil";
                }
                redisCache = new JedisSentineUtil(map);
                redisUtil = new RedisUtil();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtil;
        }
    }

    public static void setIndex(String index) {
        RedisUtil.index = index;
    }

    public static Map<String, String> getRes() {
        String url = "";
        url = null != ServletMain.getRegeditBean() && StringUtils.isNotBlank((String)ServletMain.getRegeditBean().getCacheUrl()) ? ServletMain.getRegeditBean().getCacheUrl() : RegeditUtil.getCacheUrl();
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] str = url.split(":");
        if (str.length > 0) {
            map.put(INDEX, str[0]);
            RedisUtil.setIndex(str[0]);
        }
        if (str.length > 1) {
            map.put(SCHEME, str[1]);
        }
        if (str.length > 2) {
            map.put(IP, str[2]);
        }
        if (str.length > 3) {
            map.put(PORT, str[3]);
        }
        if (str.length > 4) {
            map.put(NAME, str[4]);
        }
        if (str.length > 5) {
            map.put(PSWORD, str[5]);
        }
        if (str.length > 6) {
            map.put(SSL, str[6]);
        }
        return map;
    }

    public void setGeo(String key, double longitude, double latitude, String value) {
        key = this.setKeyIndex(key);
        redisCache.setGeo(key, longitude, latitude, value);
    }

    public void remGeo(String key, String value) {
        key = this.setKeyIndex(key);
        redisCache.remGeo(key, value);
    }

    public List<GeoRadiusResponse> getMemberCodeByGeo(String key, double longitude, double latitude, String mi) {
        key = this.setKeyIndex(key);
        return redisCache.getMemberCodeByGeo(key, longitude, latitude, mi);
    }

    private String setKeyIndex(String key) {
        if (null != key && key.indexOf(index + "_") != 0) {
            key = index + "_" + key;
        }
        return key;
    }
}

