/*
 * Decompiled with CFR 0.152.
 */
package userexceltemplate;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import userexceltemplate.RedisCache;

public class JedisSentineUtil
implements RedisCache {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    private static JedisSentinelPool jedisSentinelPool;
    protected SupperLogUtil logger = new SupperLogUtil(JedisSentineUtil.class);
    private Map<String, String> map;

    public JedisSentineUtil() {
    }

    public JedisSentineUtil(Map<String, String> map) {
        this.setMap(map);
        this.iniJedisSentinelPool();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    private void iniJedisSentinelPool() {
        if (null == this.map) {
            this.map = new HashMap<String, String>();
        }
        String portss = this.map.get("port");
        String ips = this.map.get("ip");
        String names = this.map.get("name");
        String psword = this.map.get("psword");
        if (StringUtils.isBlank((String)portss)) {
            portss = "26379";
        }
        if (StringUtils.isBlank((String)ips)) {
            ips = "127.0.0.1";
        }
        if (StringUtils.isBlank((String)names)) {
            names = "mymaster";
        }
        HashSet<String> sentinels = new HashSet<String>();
        String[] ipsstr = ips.split(";");
        String[] portsstr = portss.split(";");
        for (int i = 0; i < ipsstr.length; ++i) {
            sentinels.add(ipsstr[i] + ":" + Integer.valueOf(portsstr[i]));
        }
        this.logger.info("RedisUtil.iniJedisSentinelPool", (Object)(names + ":" + ((Object)sentinels).toString()));
        jedisSentinelPool = StringUtils.isNotBlank((String)psword) ? new JedisSentinelPool(names, sentinels, psword) : new JedisSentinelPool(names, sentinels);
    }

    protected JedisCommands getJedis() {
        return jedisSentinelPool.getResource();
    }

    protected void returnRes(JedisCommands resource) {
        jedisSentinelPool.returnResource((Jedis)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGeo(String key, double longitude, double latitude, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.geoadd(key, longitude, latitude, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remGeo(String key, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.zrem(key, new String[]{value});
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    @Override
    public List<GeoRadiusResponse> getMemberCodeByGeo(String key, double longitude, double latitude, String mi) {
        JedisCommands shardedJedis = null;
        try {
            double distance = Double.valueOf(StringUtils.isBlank((String)mi) ? "5000" : mi);
            shardedJedis = this.getJedis();
            GeoRadiusParam param = GeoRadiusParam.geoRadiusParam();
            param.withDist();
            param.sortAscending();
            List georadius = shardedJedis.georadius(key, longitude, latitude, distance, GeoUnit.KM, param);
            return georadius;
        }
        catch (NumberFormatException e) {
            this.returnRes(shardedJedis);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVersion(String key) {
        String value = "";
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        value = String.valueOf(Integer.valueOf(value) + 1);
        JedisCommands resource = this.getJedis();
        try {
            resource.set(key, value);
        }
        finally {
            this.returnRes(resource);
        }
    }
}

