/*
 * Decompiled with CFR 0.152.
 */
package userexceltemplate;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;

public class RedisUtil {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String NAME = "name";
    public static final String PSWORD = "psword";
    public static final String INDEX = "index";
    public static final String SSL = "ssl";
    private static RedisUtil redisUtil;
    private static String index;
    public static final String SCHEME = "scheme";
    private static JedisSentinelPool jedisSentinelPool;
    private Map<String, String> map;
    protected SupperLogUtil logger = new SupperLogUtil(RedisUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisUtil getRedisUtil() {
        Class<RedisUtil> clazz = RedisUtil.class;
        synchronized (RedisUtil.class) {
            if (null == redisUtil) {
                Map<String, String> map = RedisUtil.getRes();
                RedisUtil.iniJedisSentinelPool(map);
                redisUtil = new RedisUtil();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtil;
        }
    }

    public static void setIndex(String index) {
        RedisUtil.index = index;
    }

    private static void iniJedisSentinelPool(Map<String, String> map) {
        if (null == map) {
            map = new HashMap<String, String>();
        }
        String portss = map.get(PORT);
        String ips = map.get(IP);
        String names = map.get(NAME);
        String psword = map.get(PSWORD);
        if (StringUtils.isBlank((String)portss)) {
            portss = "26379";
        }
        if (StringUtils.isBlank((String)ips)) {
            ips = "127.0.0.1";
        }
        if (StringUtils.isBlank((String)names)) {
            names = "mymaster";
        }
        HashSet<String> sentinels = new HashSet<String>();
        String[] ipsstr = ips.split(";");
        String[] portsstr = portss.split(";");
        for (int i = 0; i < ipsstr.length; ++i) {
            sentinels.add(ipsstr[i] + ":" + Integer.valueOf(portsstr[i]));
        }
        jedisSentinelPool = StringUtils.isNotBlank((String)psword) ? new JedisSentinelPool(names, sentinels, psword) : new JedisSentinelPool(names, sentinels);
    }

    public static Map<String, String> getRes() {
        String url = "";
        url = null != ServletMain.getRegeditBean() && StringUtils.isNotBlank((String)ServletMain.getRegeditBean().getCacheUrl()) ? ServletMain.getRegeditBean().getCacheUrl() : RegeditUtil.getCacheUrl();
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] str = url.split(":");
        if (str.length > 0) {
            map.put(INDEX, str[0]);
            RedisUtil.setIndex(str[0]);
        }
        if (str.length > 1) {
            map.put(SCHEME, str[1]);
        }
        if (str.length > 2) {
            map.put(IP, str[2]);
        }
        if (str.length > 3) {
            map.put(PORT, str[3]);
        }
        if (str.length > 4) {
            map.put(NAME, str[4]);
        }
        if (str.length > 5) {
            map.put(PSWORD, str[5]);
        }
        if (str.length > 6) {
            map.put(SSL, str[6]);
        }
        return map;
    }

    protected Jedis getJedis() {
        return jedisSentinelPool.getResource();
    }

    protected void returnRes(JedisCommands resource) {
        jedisSentinelPool.returnResource((Jedis)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeo(String key, double longitude, double latitude, String value) {
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.geoadd(key, longitude, latitude, value);
        }
        finally {
            this.returnRes((JedisCommands)shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remGeo(String key, String value) {
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.zrem(key, new String[]{value});
        }
        finally {
            this.returnRes((JedisCommands)shardedJedis);
        }
    }

    public List<GeoRadiusResponse> getMemberCodeByGeo(String key, double longitude, double latitude, String mi) {
        Jedis shardedJedis = null;
        try {
            double distance = Double.valueOf(StringUtils.isBlank((String)mi) ? "5000" : mi);
            shardedJedis = this.getJedis();
            GeoRadiusParam param = GeoRadiusParam.geoRadiusParam();
            param.withDist();
            param.sortAscending();
            List georadius = shardedJedis.georadius(key, longitude, latitude, distance, GeoUnit.KM, param);
            return georadius;
        }
        catch (NumberFormatException e) {
            this.returnRes((JedisCommands)shardedJedis);
            return null;
        }
    }

    private String setKeyIndex(String key) {
        if (null != key && key.indexOf(index + "_") != 0) {
            key = index + "_" + key;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVersion(String key) {
        String value = "";
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        value = String.valueOf(Integer.valueOf(value) + 1);
        Jedis resource = this.getJedis();
        try {
            resource.set(key, value);
        }
        finally {
            this.returnRes((JedisCommands)resource);
        }
    }
}

