/*
 * Decompiled with CFR 0.152.
 */
package userexceltemplate;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisSentinelPoolUtils {
    public static final String SYS_CODE = "ecache.CACHE.ShardedJedisUtil";
    public static JedisPool jedisPool;
    protected SupperLogUtil logger = new SupperLogUtil(JedisSentinelPoolUtils.class);
    private Map<String, String> map;

    public JedisSentinelPoolUtils(Map<String, String> map) {
        this.logger.debug("ShardedJedisUtil.initialShardedPool.init", map);
        this.setMap(map);
        this.iniJedisSentinelPool(map);
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    private void iniJedisSentinelPool(Map<String, String> map) {
        if (null == map) {
            map = new HashMap<String, String>();
        }
        String ports = map.get("port");
        String ip = map.get("ip");
        String psword = map.get("psword");
        if (StringUtils.isBlank((String)ports)) {
            ports = "6379";
        }
        if (StringUtils.isBlank((String)ip)) {
            ip = "127.0.0.1";
        }
        ip = RegeditUtil.replaceCacheUrl((String)ip);
        JedisPoolConfig config = this.getConfig();
        this.logger.debug("ShardedJedisUtil.initialShardedPool", (Object)(ip + "==" + ports));
        String ssl = map.get("ssl");
        boolean sslb = false;
        if (StringUtils.isNotBlank((String)ssl) && "1".equals(ssl)) {
            sslb = true;
        }
        jedisPool = StringUtils.isBlank((String)psword) ? new JedisPool((GenericObjectPoolConfig)config, ip, Integer.valueOf(ports).intValue(), 5000, sslb) : new JedisPool((GenericObjectPoolConfig)config, ip, Integer.valueOf(ports).intValue(), 5000, psword, sslb);
    }

    private JedisPoolConfig getConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(200);
        config.setMaxTotal(500);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
        config.setTestOnCreate(true);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeo(String key, double longitude, double latitude, String value) {
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.geoadd(key, longitude, latitude, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remGeo(String key, String value) {
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.zrem(key, new String[]{value});
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVersion(String key) {
        String value = "";
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        value = String.valueOf(Integer.valueOf(value) + 1);
        Jedis resource = this.getJedis();
        try {
            resource.set(key, value);
        }
        finally {
            this.returnRes(resource);
        }
    }

    public List<GeoRadiusResponse> getMemberCodeByGeo(String key, double longitude, double latitude, String mi) {
        Jedis shardedJedis = null;
        try {
            double distance = Double.valueOf(StringUtils.isBlank((String)mi) ? "5000" : mi);
            shardedJedis = this.getJedis();
            this.logger.error("getMemberCodeByGeo.into");
            List georadius = shardedJedis.georadius(key, longitude, latitude, distance, GeoUnit.KM);
            return georadius;
        }
        catch (NumberFormatException e) {
            this.returnRes(shardedJedis);
            return null;
        }
    }

    private Jedis getJedis() {
        try {
            return jedisPool.getResource();
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.ShardedJedisUtil.getJedis", (Throwable)e);
            return null;
        }
    }

    private void returnRes(Jedis shardedJedis) {
        shardedJedis.close();
    }
}

