/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardpDomain;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardplistDomain;
import com.qjsoft.laser.controller.facade.cd.repository.CdCardpServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgCompanyReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserRegBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserBaseServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/umuserrt"}, name="\u6743\u76ca\u7528\u6237")
public class UmUserRtCon
extends SpringmvcController {
    private static String CODE = "um.umuserrt.con";
    @Autowired
    private CdCardpServiceRepository cdCardpServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UserBaseServiceRepository userBaseServiceRepository;

    protected String getContext() {
        return "umuserrt";
    }

    @RequestMapping(value={"saveUmuserRt.json"}, name="\u589e\u52a0\u6743\u76ca\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean saveUmuserRt(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveUmuserRt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        HashSet<String> errorNameSet = new HashSet<String>();
        String cardParentCode = null;
        String tenantCode = this.getTenantCode(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveUmuserRt", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, CdCardpDomain.class);
        if (null == cdCardpDomain.getCardpCnum()) {
            this.logger.error(CODE + ".saveUmuserRt", (Object)"cardpCnum is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cdCardpDomain.setMemberCode(userSession.getUserPcode());
        cdCardpDomain.setMemberName(userSession.getUserName());
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.cdCardpServiceRepository.saveCardp(cdCardpDomain);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".saveUmuserRt.paramStr.saveError", (Object)paramStr);
            return new HtmlJsonReBean("error", "\u6743\u76ca\u6279\u6b21\u521b\u5efa\u5931\u8d25");
        }
        if (htmlJsonReBean.getDataObj() != null && StringUtils.isNotBlank((String)htmlJsonReBean.getDataObj().toString())) {
            cardParentCode = htmlJsonReBean.getDataObj().toString();
            OrgCompanyReDomain companyByCode = this.orgCompanyServiceRepository.getCompanyByCode(tenantCode, cdCardpDomain.getCardpOpcode());
            if (companyByCode == null) {
                this.logger.error(CODE + ".saveUmuserRt.companyByCode.is null", (Object)paramStr);
                return new HtmlJsonReBean("error", "\u6743\u76ca\u6279\u6b21\u521b\u5efa\u5931\u8d25");
            }
            if (ListUtil.isNotEmpty((Collection)cdCardpDomain.getCdCardplistDomainList())) {
                for (CdCardplistDomain cdCardplistDomain : cdCardpDomain.getCdCardplistDomainList()) {
                    UmUserReDomainBean userByName = this.userServiceRepository.getUserByName(cdCardplistDomain.getCardpNumber(), tenantCode);
                    if (userByName != null) {
                        errorNameSet.add(cdCardplistDomain.getCardpNumber());
                    }
                    this.saveUserRt(errorNameSet, cardParentCode, tenantCode, cdCardpDomain, htmlJsonReBean, companyByCode, cdCardplistDomain, true);
                }
                if (errorNameSet.size() != 0) {
                    return new HtmlJsonReBean("error", "\u7528\u6237\u540d\u91cd\u590d\uff1a" + ((Object)errorNameSet).toString());
                }
            } else {
                int num;
                for (int i = num = cdCardpDomain.getCardpCnum().intValue(); i > 0; --i) {
                    String lockUUID = this.getLockUUID(cdCardpDomain.getCardpNum());
                    this.logger.error(CODE + ".saveUmuserRt.", (Object)lockUUID);
                    UmUserReDomainBean userByName = this.userServiceRepository.getUserByName(lockUUID, tenantCode);
                    if (userByName != null) {
                        lockUUID = this.getLockUUID(cdCardpDomain.getCardpNum());
                        this.logger.error(CODE + "saveUmuserRt.", (Object)lockUUID);
                        userByName = this.userServiceRepository.getUserByName(lockUUID, tenantCode);
                        if (userByName != null) {
                            errorNameSet.add(lockUUID);
                            continue;
                        }
                    }
                    CdCardplistDomain cdCardplistDomain = new CdCardplistDomain();
                    cdCardplistDomain.setCardpNumber(lockUUID);
                    this.saveUserRt(errorNameSet, cardParentCode, tenantCode, cdCardpDomain, htmlJsonReBean, companyByCode, cdCardplistDomain, false);
                }
                if (errorNameSet.size() != 0) {
                    return new HtmlJsonReBean("error", "\u7528\u6237\u540d\u91cd\u590d\uff1a" + ((Object)errorNameSet).toString());
                }
            }
        }
        return htmlJsonReBean;
    }

    private void saveUserRt(Set<String> errorNameSet, String cardParentCode, String tenantCode, CdCardpDomain cdCardpDomain, HtmlJsonReBean htmlJsonReBean, OrgCompanyReDomain companyByCode, CdCardplistDomain cdCardplistDomain, boolean flag) {
        HtmlJsonReBean jsonReBean = null;
        String userPwsswd = null;
        if (flag) {
            userPwsswd = cdCardplistDomain.getCardpPass();
            jsonReBean = this.saveUserCodeUmuser(cdCardplistDomain.getCardpNumber(), cdCardplistDomain.getCardpNumber(), cdCardplistDomain.getCardpPass(), 1, tenantCode, null, null, companyByCode.getCompanyCode(), companyByCode.getCompanyName());
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + "saveUmuserRt.saveUserError.param", (Object)JSON.toJSONString((Object)cdCardpDomain));
                errorNameSet.add(cdCardplistDomain.getCardpNumber());
                return;
            }
        } else {
            userPwsswd = this.getLockUUID(8);
            jsonReBean = this.saveUserCodeUmuser(cdCardplistDomain.getCardpNumber(), cdCardplistDomain.getCardpNumber(), userPwsswd, 1, tenantCode, null, null, companyByCode.getCompanyCode(), companyByCode.getCompanyName());
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + "saveUmuserRt.saveUserError.param", (Object)JSON.toJSONString((Object)cdCardpDomain));
                errorNameSet.add(cdCardplistDomain.getCardpNumber());
                return;
            }
        }
        UmUserinfoReDomainBean userinfoByCode = this.userServiceRepository.getUserinfoByCode(jsonReBean.getDataObj().toString(), tenantCode);
        userinfoByCode.setUserinfoCert1No("3");
        userinfoByCode.setUserinfoOpcode(cardParentCode);
        userinfoByCode.setUserinfoCertNo(cdCardpDomain.getCardpFlag());
        userinfoByCode.setUserinfoCert1Url(Base64Utils.encodeToString((byte[])userPwsswd.getBytes()));
        userinfoByCode.setUserinfoCert2Url(String.valueOf(cdCardpDomain.getCardpDoneDate()));
        this.userServiceRepository.updateUserinfo((UmUserinfoDomainBean)userinfoByCode);
    }

    private synchronized String getLockUUID(Integer cardpNum) {
        return UUID.randomUUID().toString().replace("-", "").substring(0, cardpNum);
    }

    public synchronized String getSnowflakeId() {
        return String.valueOf(IdUtil.getSnowflake((long)1L, (long)1L).nextId());
    }

    public HtmlJsonReBean saveUserCodeUmuser(String userName, String userPhone, String userPwsswd, Integer userinfoType, String tenantCode, String userOpenid, String roleCode, String userinfoParentCode, String userinfoParentName) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserName(userName);
        umUserDomainBean.setUserRelname(userName);
        umUserDomainBean.setUserinfoType(userinfoType);
        if (null == umUserDomainBean.getUserinfoType()) {
            umUserDomainBean.setUserinfoType(Integer.valueOf(1));
        }
        umUserDomainBean.setUserType(Integer.valueOf(1));
        if (StringUtils.isNotBlank((String)userPhone)) {
            umUserDomainBean.setUserPhone(userPhone);
        }
        umUserDomainBean.setUserPwsswd(userPwsswd);
        umUserDomainBean.setUserinfoCompname(userName);
        umUserDomainBean.setUserinfoQuality("buy");
        umUserDomainBean.setUserOpenid(userOpenid);
        umUserDomainBean.setRoleCode(roleCode);
        umUserDomainBean.setUserinfoParentCode(userinfoParentCode);
        umUserDomainBean.setUserinfoParentName(userinfoParentName);
        UmUserRegBean umUserRegBean = new UmUserRegBean();
        umUserRegBean.setUserName(userOpenid);
        umUserRegBean.setUserinfoType(Integer.valueOf(1));
        umUserRegBean.setUserOpenid(userOpenid);
        umUserRegBean.setUserUnionid(null);
        if (null != userPhone) {
            umUserRegBean.setUserPhone(userPhone);
            umUserRegBean.setUserName(userPhone);
        }
        umUserRegBean.setTenantCode(tenantCode);
        return this.userBaseServiceRepository.saveUmuser(umUserRegBean);
    }
}

