/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.sh.repository.ShShsettlUserServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmStoreChannelSendDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoChannelReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoSimpleDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoapplyDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.upm.domain.UpmPointsRuleReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmPointsRuleServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.um.controller.UserComCon;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/web/um/userGroupCon"}, name="\u56e2\u957f\u4f1a\u5458")
public class UserGroupCon
extends UserComCon {
    private static final Logger log = LoggerFactory.getLogger(UserGroupCon.class);
    private static String CODE = "um.userGroupCon.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private ShShsettlUserServiceRepository shShsettlUserServiceRepository;
    @Autowired
    private UmGroupServiceRepository umGroupServiceRepository;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private UpmPointsRuleServiceRepository upmPointsRuleServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    public static final String SYS_CODE = "web.user.GroupCon";

    protected String getContext() {
        return "userGroupCon";
    }

    @RequestMapping(value={"queryUserinfoPageForGroup.json"}, name="\u4f1a\u5458\u6807\u7b7e\u7ba1\u7406\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<UmGroupReDomain> queryGroupPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("dataState", 0);
        SupQueryResult queryResult = this.umGroupServiceRepository.queryGroupPage(param);
        return queryResult;
    }

    @RequestMapping(value={"saveUserGroupByBus.json"}, name="")
    @ResponseBody
    public HtmlJsonReBean saveUserGroupByBus(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveUserGroupByBus", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserDomainBean umUserDomainBean = (UmUserDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserDomainBean.class);
        boolean boo = true;
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoParentCode())) {
            boo = false;
        }
        return this.saveUserStoreCommon(request, umUserDomainBean, "group", boo);
    }

    @RequestMapping(value={"saveUserGroupByUser.json"}, name="\u4f1a\u5458\u6807\u7b7e\u7ba1\u7406\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateGroup(HttpServletRequest request, UmGroupReDomain umGroupReDomain) {
        String tenantCode = this.getTenantCode(request);
        if (null == umGroupReDomain) {
            this.logger.error(CODE + ".saveUserGroupByBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umGroupReDomain.setTenantCode(tenantCode);
        log.error("======================={}", (Object)umGroupReDomain);
        log.error("=======================" + umGroupReDomain);
        return this.umGroupServiceRepository.updateGroup((UmGroupDomain)umGroupReDomain);
    }

    @RequestMapping(value={"saveUserGroupByQuality.json"}, name="\u4f1a\u5458\u6807\u7b7e\u7ba1\u7406\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteGroup(Integer groupId) {
        if (groupId == null) {
            this.logger.error(CODE + ".deleteGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.umGroupServiceRepository.updateGroupState(groupId, Integer.valueOf(1), Integer.valueOf(0), new HashMap());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryUserGroupPageByBus.json"}, name="\u67e5\u8be2\u767b\u9646\u8005\u4e0b\u9762\u7684\u56e2\u957f\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserGroupPageByBus(HttpServletRequest request, String userinfoQuality) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUserGroupPageByBus", (Object)"userSession is null");
            return null;
        }
        return this.queryUserOtherPage(request, "group", userSession.getUserPcode(), null);
    }

    @RequestMapping(value={"queryByuserinfoChannelcode.json"}, name="\u4f1a\u5458\u6807\u7b7e\u6dfb\u52a0")
    @ResponseBody
    public HtmlJsonReBean saveGroup(HttpServletRequest request, UmGroupReDomain umGroupReDomain) {
        log.error("========================{}", (Object)umGroupReDomain);
        log.error("===================", (Object)umGroupReDomain);
        String tenantCode = this.getTenantCode(request);
        if (null == umGroupReDomain) {
            this.logger.error(CODE + ".saveUserGroupByBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umGroupReDomain.setTenantCode(tenantCode);
        return this.umGroupServiceRepository.saveGroup((UmGroupDomain)umGroupReDomain);
    }

    @RequestMapping(value={"queryGroupList.json"}, name="\u67e5\u8be2\u5174\u8da3")
    @ResponseBody
    public HtmlJsonReBean queryGroupListPage(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("dataState", 0);
        param.put("groupSort", "2");
        log.info("queryGroupList==============");
        List list = this.umGroupServiceRepository.queryGroupPage(param).getList();
        return new HtmlJsonReBean((Object)list);
    }

    @RequestMapping(value={"queryUserGroupList.json"}, name="\u67e5\u8be2\u7528\u6237\u5174\u8da3")
    @ResponseBody
    public HtmlJsonReBean queryUserGroupListPage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession != null) {
            String userPcode = userSession.getUserPcode();
            String tenantCode = this.getTenantCode(request);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("memberCode", userPcode);
            map.put("tenantCode", tenantCode);
            map.put("page", 1);
            map.put("rows", 1000);
            log.info("queryUserGroupList==============");
            List list = this.umGroupServiceRepository.queryGroupListPage(map).getList();
            return new HtmlJsonReBean((Object)list);
        }
        return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @RequestMapping(value={"queryUserGroupListNum.json"}, name="\u67e5\u8be2\u7528\u6237\u9009\u62e9\u5174\u8da3\u7684\u6570\u91cf")
    @ResponseBody
    public int queryUserGroupListNum(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryUserGroupListNum.userSession.null");
            return 0;
        }
        Map map = this.assemMapMemberParam(request);
        SupQueryResult umGroupListReDomainSupQueryResult = this.umGroupServiceRepository.queryGroupListPage(map);
        if (null == umGroupListReDomainSupQueryResult || ListUtil.isEmpty((Collection)umGroupListReDomainSupQueryResult.getList())) {
            return 0;
        }
        return umGroupListReDomainSupQueryResult.getList().size();
    }

    @RequestMapping(value={"saveUserGroupList.json"}, name="\u7de8\u8f2f\u7528\u6237\u5174\u8da3")
    @ResponseBody
    public HtmlJsonReBean saveUserGroupList(HttpServletRequest request, String groupCode) {
        if (StringUtils.isEmpty((String)groupCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "groupCode is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        HashMap<String, String> groupMap = new HashMap<String, String>();
        groupMap.put("memberCode", userSession.getUserPcode());
        groupMap.put("tenantCode", userSession.getTenantCode());
        boolean upmFlag = this.checkUpm(userSession.getUserPcode(), userSession.getTenantCode(), "group");
        if (upmFlag) {
            this.logger.error(CODE + ".saveUserGroupList.upmFlag", (Object)upmFlag);
            UmGroupDomain umGroupDomain = this.makeGroupDomain(userSession, groupCode);
            this.logger.error(CODE + ",saveUserGroupList.umGroupDomain", (Object)JsonUtil.buildNonNullBinder().toJson((Object)umGroupDomain));
            this.umGroupServiceRepository.sendSaveGroup(umGroupDomain);
            HashMap map = new HashMap();
            this.updateGroupName(this.getTenantCode(request), userSession.getUserPcode());
            try {
                this.addCommunitySysMsg(request, userSession);
            }
            catch (Exception e) {
                log.error(userSession.getUserPhone() + " - \u521b\u5efa\u6d88\u606f\u5f02\u5e38\uff1a ", (Throwable)e);
            }
            return new HtmlJsonReBean();
        }
        SupQueryResult supQueryResult = this.umGroupServiceRepository.queryGroupListPage(groupMap);
        if (null != supQueryResult || ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".saveUserGroupList.groupMap", (Object)((Object)groupMap).toString());
            for (UmGroupListReDomain umGroupListReDomain : supQueryResult.getList()) {
                this.umGroupServiceRepository.deleteGroupList(umGroupListReDomain.getGroupListId());
            }
        }
        List<String> groupCodeList = Arrays.asList(groupCode.split(","));
        UmGroupReDomain groupByCode = null;
        ArrayList<UmGroupListDomain> dataList = new ArrayList<UmGroupListDomain>();
        for (String newGroupCode : groupCodeList) {
            Integer integer;
            groupByCode = this.umGroupServiceRepository.getGroupByCode(userSession.getTenantCode(), newGroupCode);
            if (groupByCode == null) continue;
            UmGroupListDomain UmGroupListDomain2 = new UmGroupListDomain();
            UmGroupListDomain2.setMemberCode(userSession.getUserPcode());
            UmGroupListDomain2.setMemberName(userSession.getUserName());
            UmGroupListDomain2.setTenantCode(userSession.getTenantCode());
            UmGroupListDomain2.setUserinfoCode(userSession.getUserPcode());
            UmGroupListDomain2.setUserinfoPhone(userSession.getUserPhone());
            UmGroupListDomain2.setGroupName(groupByCode.getGroupName());
            UmGroupListDomain2.setGroupCode(groupByCode.getGroupCode());
            UmGroupListDomain2.setGroupSort(groupByCode.getGroupSort());
            if (StringUtils.isNotBlank((String)groupByCode.getGroupType()) && (integer = Integer.valueOf(groupByCode.getGroupType())) != null) {
                UmGroupListDomain2.setGroupType(integer + "");
            }
            dataList.add(UmGroupListDomain2);
        }
        this.logger.error(CODE + ".saveUserGroupList.dataList", (Object)dataList.size());
        return this.umGroupServiceRepository.saveGroupListBatch(dataList);
    }

    private void addCommunitySysMsg(HttpServletRequest request, UserSession userSession) {
        String tenantCode = this.getTenantCode(request);
        final UpmPointsRuleReDomain upmPointsRuleReDomain = this.upmPointsRuleServiceRepository.getPointsRuleByCode(tenantCode, "49dab1144e28451497f0f8dd04b1a622");
        HashMap params = new HashMap();
        ArrayList list = new ArrayList();
        HashMap<String, Object> msgMeta = new HashMap<String, Object>();
        msgMeta.put("userPhone", userSession.getUserPhone());
        msgMeta.put("templateCode", "points_02");
        try {
            msgMeta.put("map", new HashMap<String, String>(){
                {
                    this.put("Point", String.valueOf(upmPointsRuleReDomain.getPointsRuleRatio().intValue()));
                }
            });
        }
        catch (Exception e) {
            log.error("\u5174\u8da3\u7231\u597d\u89c4\u5219\u914d\u7f6e\u6709\u8bef\uff0c\u79ef\u5206\u503c\uff1a" + upmPointsRuleReDomain.getPointsRuleRatio().toString());
            throw e;
        }
        list.add(msgMeta);
        params.put("list", list);
        String community_domain = this.getDdFlag(tenantCode, "community", "COMMUNITY_DOMAIN");
        if (null == community_domain || "".equals(community_domain)) {
            log.error("community domain is null, system msg create fail.");
        }
        String url = community_domain + "/admin/lbNoticeSysTemplate/getNoticeSysTemplateVO";
        log.info("request url " + url + " , param " + JsonUtil.buildNormalBinder().toJson(params));
        Map resp = (Map)this.restTemplate.postForObject(url, params, Map.class, new Object[0]);
        log.info(userSession.getUserPhone() + " - \u521b\u5efa\u7cfb\u7edf\u6d88\u606f\u54cd\u5e94\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)resp));
        Integer respCode = (Integer)resp.get("code");
        if (respCode != 200) {
            log.warn("create point sys msg unknown result, userPhone {}, resp {}", (Object)userSession.getUserPhone(), (Object)resp);
        } else {
            log.info("create point sys msg success, userPhone {} ", (Object)userSession.getUserPhone());
        }
    }

    private String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            this.logger.error("web.user.GroupCon.getUrl", (Object)("tenantCode:" + tenantCode + "-flagSettingType:" + flagSettingType + "-flagSettingCode:" + flagSettingCode));
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            this.logger.error("web.user.GroupCon.getUrl", (Object)("tenantCode:" + tenantCode + "-flagSettingType:" + flagSettingType + "-flagSettingCode:" + flagSettingCode));
        }
        return value;
    }

    private void updateGroupName(String tenantCode, String userinfoCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoCode", userinfoCode);
        SupQueryResult supQueryResult = this.umGroupServiceRepository.queryGroupListPage(map);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return;
        }
        for (UmGroupListReDomain umGroupListReDomain : supQueryResult.getList()) {
            UmGroupReDomain groupByCode = this.umGroupServiceRepository.getGroupByCode(umGroupListReDomain.getTenantCode(), umGroupListReDomain.getGroupCode());
            umGroupListReDomain.setGroupName(groupByCode.getGroupName());
            this.umGroupServiceRepository.updateGroupList((UmGroupListDomain)umGroupListReDomain);
        }
    }

    private UmGroupDomain makeGroupDomain(UserSession userSession, String groupCodeStr) {
        UmGroupDomain umGroupDomain = new UmGroupDomain();
        umGroupDomain.setGroupName(userSession.getUserName());
        umGroupDomain.setMemberCode(userSession.getUserPcode());
        umGroupDomain.setMemberName(userSession.getUserName());
        umGroupDomain.setTenantCode(userSession.getTenantCode());
        umGroupDomain.setGroupType("2");
        List<String> groupCodeList = Arrays.asList(groupCodeStr.split(","));
        UmGroupReDomain groupByCode = null;
        ArrayList<UmGroupListDomain> dataList = new ArrayList<UmGroupListDomain>();
        for (String newGroupCode : groupCodeList) {
            UmGroupListDomain umGroupListDomain = new UmGroupListDomain();
            groupByCode = this.umGroupServiceRepository.getGroupByCode(userSession.getTenantCode(), newGroupCode);
            umGroupListDomain.setMemberCode(userSession.getUserPcode());
            umGroupListDomain.setMemberName(userSession.getUserName());
            umGroupListDomain.setTenantCode(userSession.getTenantCode());
            umGroupListDomain.setUserinfoCode(userSession.getUserPcode());
            umGroupListDomain.setUserinfoPhone(userSession.getUserPhone());
            umGroupListDomain.setGroupName(groupByCode.getGroupName());
            umGroupListDomain.setGroupCode(groupByCode.getGroupCode());
            umGroupListDomain.setGroupSort(groupByCode.getGroupSort());
            dataList.add(umGroupListDomain);
        }
        this.logger.error(CODE + ".makeGroupDomain.dataList.size", (Object)dataList.size());
        umGroupDomain.setUmGroupListDomainList(dataList);
        return umGroupDomain;
    }

    private boolean checkUpm(String userinfoCode, String tenantCode, String pointsRuleApi) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleApi", pointsRuleApi);
        SupQueryResult supQueryResult = this.upmUpointsServiceRepository.queryUpointsListPage(map);
        this.logger.error(CODE + ".checkUpm.map", (Object)((Object)map).toString());
        return null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList());
    }

    @RequestMapping(value={"queryUserGroupPageByQuy.json"}, name="\u67e5\u8be2\u5e73\u53f0\u56e2\u957f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserGroupPageByQuy(HttpServletRequest request, String userinfoQuality) {
        return this.queryUserOtherPage(request, "group", null, null);
    }

    @RequestMapping(value={"queryUserGroupPageByApple.json"}, name="\u5e73\u53f0\u67e5\u8be2\u5f85\u5ba1\u6838\u56e2\u957f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserGroupPageByApple(HttpServletRequest request, String userinfoQuality) {
        return this.queryUserOtherPage(request, "group", null, 4);
    }

    @RequestMapping(value={"checkJudgeRegister.json"}, name="\u5224\u65ad\u6ce8\u518c\u4fe1\u606f\u662f\u5426\u91cd\u590d")
    @ResponseBody
    public HtmlJsonReBean checkJudgeRegister(HttpServletRequest request, String userinfoCompname, String userPhone) {
        return this.check(request, userinfoCompname, userPhone, null, null);
    }

    @RequestMapping(value={"getUserinfoByInvite.json"}, name="\u6839\u636e\u9080\u8bf7\u7801\u548c\u4f1a\u5458\u4ee3\u7801\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f")
    @ResponseBody
    public UmUserinfoReDomainBean getUserinfoByInvite(HttpServletRequest request, String userinfoCode, String shsettlUserInvite) {
        SupQueryResult qlist;
        if (StringUtils.isBlank((String)userinfoCode) && StringUtils.isBlank((String)shsettlUserInvite)) {
            this.logger.error(CODE + ".getUserinfoByInvite", (Object)"param is null");
            return null;
        }
        if (StringUtils.isBlank((String)shsettlUserInvite)) {
            userinfoCode = this.getUserSession(request).getUserPcode();
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", userinfoCode);
        map.put("shsettlType", "2");
        if (StringUtils.isNotBlank((String)shsettlUserInvite)) {
            map.put("shsettlUserInvite", shsettlUserInvite);
        }
        if (null == (qlist = this.shShsettlUserServiceRepository.queryShsettlUserPage(map)) || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error(CODE + ".getUserinfoByInvite.qlist.null", map);
            return null;
        }
        UmUserinfoReDomainBean userinfo = this.userServiceRepository.getUserinfoByCode(userinfoCode, tenantCode);
        if (null != userinfo && StringUtils.isNotBlank((String)userinfo.getUserinfoParentCode()) && StringUtils.isNotBlank((String)userinfo.getUserinfoParentCode())) {
            UmUserinfoReDomainBean userinfoByPCode = this.userServiceRepository.getUserinfoByCode(userinfo.getUserinfoParentCode(), tenantCode);
            if (null == userinfoByPCode) {
                this.logger.error(CODE + ".getUserinfoByInvite.userinfoByPCode.null", (Object)userinfo.getUserinfoParentCode());
                return null;
            }
            map.remove("shsettlUserInvite");
            map.put("memberBcode", userinfoByPCode.getUserinfoCode());
            qlist = this.shShsettlUserServiceRepository.queryShsettlUserPage(map);
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                this.logger.error(CODE + ".getUserinfoByInvite.qlist1.null", map);
                return null;
            }
            userinfo.setUserinfoParentDomain(userinfoByPCode);
            return userinfo;
        }
        return userinfo;
    }

    @RequestMapping(value={"getUser.json"}, name="\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f")
    @ResponseBody
    public UmUserinfoReDomainBean getUser(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".getUser", (Object)"param is null");
            return null;
        }
        return this.userServiceRepository.getUserinfo(userinfoId);
    }

    @RequestMapping(value={"updateUserinfo.json"}, name="\u66f4\u65b0\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean updateUserinfo(HttpServletRequest request, String userinfojson) {
        if (StringUtils.isBlank((String)userinfojson)) {
            this.logger.error(CODE + ".updateUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfojson, UmUserinfoDomainBean.class);
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"deleteUser.json"}, name="\u5220\u9664\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean deleteUser(Integer userinfoId) {
        if (StringUtils.isBlank((Integer)userinfoId)) {
            this.logger.error(CODE + ".deleteUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.deleteUserinfo(userinfoId);
    }

    public SupQueryResult<UmUserinfoReDomainBean> queryUserOtherPage(HttpServletRequest request, String userinfoQuality, String userinfoParentCode, Integer dataState) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUserOtherPage", (Object)"userSession is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", userinfoQuality);
            param.put("userinfoParentCode", userinfoParentCode);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("dataState", dataState);
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    @RequestMapping(value={"enableUser.json"}, name="\u542f\u7528\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean enableUser(String userinfoId) {
        return this.enableUserStoreCommon(userinfoId);
    }

    @RequestMapping(value={"stoppedUser.json"}, name="\u505c\u7528\u4f1a\u5458")
    @ResponseBody
    public HtmlJsonReBean stoppedUser(String userinfoId) {
        return this.stoppedUserStoreCommon(userinfoId);
    }

    private HtmlJsonReBean stoppedUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".stoppedUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(-1), Integer.valueOf(0), null);
    }

    private HtmlJsonReBean enableUserStoreCommon(String userinfoId) {
        if (StringUtils.isBlank((String)userinfoId)) {
            this.logger.error(CODE + ".enableUserStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.userServiceRepository.updateUserinfoState(Integer.valueOf(userinfoId), Integer.valueOf(0), Integer.valueOf(-1), null);
    }

    @RequestMapping(value={"getStoreById.json"}, name="\u6839\u636eId\u67e5\u770b\u8be6\u60c5")
    @ResponseBody
    public UmUserinfoReDomainBean getStoreById(HttpServletRequest request, int userInfoId) {
        return this.userServiceRepository.getAuthorization(userInfoId, this.getTenantCode(request));
    }

    @RequestMapping(value={"getStoreByIdForUser.json"}, name="\u6839\u636eId\u67e5\u770b\u8be6\u60c5C")
    @ResponseBody
    public UmUserinfoReDomainBean getStoreByIdForUser(HttpServletRequest request, int userInfoId) {
        return this.userServiceRepository.getAuthorization(userInfoId, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveAuthorization.json"}, name="\u7533\u8bf7\u6388\u6743\u4e66")
    @ResponseBody
    public HtmlJsonReBean saveAuthorization(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveAuthorization", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserinfoDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        umUserinfoDomainBean.setUserinfoFeestatus(Integer.valueOf(1));
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"saveAuthorizationC.json"}, name="\u7533\u8bf7\u6388\u6743\u4e66C")
    @ResponseBody
    public HtmlJsonReBean saveAuthorizationC(HttpServletRequest request, String userinfoJosn) {
        if (StringUtils.isBlank((String)userinfoJosn)) {
            this.logger.error(CODE + ".saveAuthorization", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(userinfoJosn, UmUserinfoDomainBean.class);
        umUserinfoDomainBean.setTenantCode(this.getTenantCode(request));
        umUserinfoDomainBean.setUserinfoFeestatus(Integer.valueOf(1));
        return this.userServiceRepository.updateUserinfo(umUserinfoDomainBean);
    }

    @RequestMapping(value={"authorizationPassed.json"}, name="\u6388\u6743\u4e66\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean authorizationPassed(HttpServletRequest request, Integer userinfoId) {
        if (null == userinfoId) {
            this.logger.error(CODE + ".authorizationPassed", (Object)"userinfoJosn is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.userServiceRepository.updateStoreState(userinfoId, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"authorizationDenied.json"}, name="\u6388\u6743\u4e66\u62d2\u7edd")
    @ResponseBody
    public HtmlJsonReBean authorizationDenied(HttpServletRequest request, Integer userinfoId) {
        if (null == userinfoId) {
            this.logger.error(CODE + ".authorizationDenied", (Object)"userInfoId is null");
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.userServiceRepository.updateStoreState(userinfoId, Integer.valueOf(3), Integer.valueOf(1));
    }

    @RequestMapping(value={"queryAuthorization.json"}, name="\u67e5\u8be2\u6388\u6743\u4e66\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryAuthorization(HttpServletRequest request, Integer userInfoId) {
        Map param = this.assemMapParam(request);
        return this.userServiceRepository.queryAuthorization(param, this.getTenantCode(request));
    }

    @RequestMapping(value={"getAuthorization.json"}, name="\u6839\u636e\u6388\u6743\u4e66\u67e5\u770b\u8be6\u60c5")
    @ResponseBody
    public UmUserinfoReDomainBean getAuthorization(HttpServletRequest request, int userInfoId) {
        return this.userServiceRepository.getAuthorization(userInfoId, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryStoreChannelPage.json"}, name="\u67e5\u8be2\u56e2\u957f\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public List<UmStoreChannelSendDomain> queryStoreChannelPage(HttpServletRequest request, String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        param.put("channelType", "2");
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        if (null == disChannelReDomainSupQueryResult || ListUtil.isEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            return null;
        }
        List channelList = disChannelReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)channelList)) {
            return null;
        }
        List userinfoChannelList = this.umUserinfoQuaServiceRepository.getUserinfoChannelByInfoCode(tenantCode, userinfoCode);
        List<UmStoreChannelSendDomain> channelNewList = new ArrayList<UmStoreChannelSendDomain>();
        for (DisChannelReDomain disChannelReDomain : channelList) {
            UmStoreChannelSendDomain umStoreChannel = new UmStoreChannelSendDomain();
            try {
                BeanUtils.copyAllPropertys((Object)umStoreChannel, (Object)disChannelReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + "queryStoreChannelPage.BeanUtils.copyAllPropertys", (Throwable)e);
            }
            channelNewList.add(umStoreChannel);
        }
        if (ListUtil.isEmpty((Collection)userinfoChannelList)) {
            channelNewList = this.changeChannelNewList(channelNewList);
            return channelNewList;
        }
        ArrayList<UmStoreChannelSendDomain> channelOwnList = new ArrayList();
        channelOwnList = this.formdateList(channelNewList, userinfoChannelList);
        return channelOwnList;
    }

    private List<UmStoreChannelSendDomain> formdateList(List<UmStoreChannelSendDomain> channelNewList, List<UmUserinfoChannelReDomain> userinfoChannelList) {
        boolean flag = true;
        String checkBusiness = "";
        String packingFee = "";
        String transportFree = "";
        String channelCloseTime = "";
        String channelOpenTime = "";
        ArrayList<UmStoreChannelSendDomain> channelOwnList = new ArrayList<UmStoreChannelSendDomain>();
        for (UmStoreChannelSendDomain disChannel : channelNewList) {
            for (UmUserinfoChannelReDomain umUserinfoChannel : userinfoChannelList) {
                if (disChannel.getChannelCode().equals(umUserinfoChannel.getChannelCode())) {
                    if ("checkBusiness".equals(umUserinfoChannel.getUserinfoChannelKey())) {
                        checkBusiness = umUserinfoChannel.getUserinfoChannelVaule();
                    }
                    if ("packingFee".equals(umUserinfoChannel.getUserinfoChannelKey())) {
                        packingFee = umUserinfoChannel.getUserinfoChannelVaule();
                    }
                    if ("transportFree".equals(umUserinfoChannel.getUserinfoChannelKey())) {
                        transportFree = umUserinfoChannel.getUserinfoChannelVaule();
                    }
                    if ("channelCloseTime".equals(umUserinfoChannel.getUserinfoChannelKey())) {
                        channelCloseTime = umUserinfoChannel.getUserinfoChannelVaule();
                    }
                    if ("channelOpenTime".equals(umUserinfoChannel.getUserinfoChannelKey())) {
                        channelOpenTime = umUserinfoChannel.getUserinfoChannelVaule();
                    }
                    if (!StringUtils.isNotBlank((String)checkBusiness) || !StringUtils.isNotBlank((String)packingFee) || !StringUtils.isNotBlank((String)transportFree) || !StringUtils.isNotBlank((String)channelCloseTime) || !StringUtils.isNotBlank((String)channelOpenTime)) continue;
                    flag = true;
                    break;
                }
                flag = false;
            }
            if (StringUtils.isNotBlank((String)checkBusiness) && StringUtils.isNotBlank((String)packingFee) && StringUtils.isNotBlank((String)transportFree)) {
                flag = true;
            }
            if (!flag) {
                disChannel.setPackingFee("0");
                disChannel.setTransportFree("0");
                disChannel.setCheckBusiness("-1");
                disChannel.setChannelCloseTime(channelCloseTime);
                disChannel.setChannelOpenTime(channelOpenTime);
            } else {
                disChannel.setCheckBusiness(checkBusiness);
                disChannel.setPackingFee(packingFee);
                disChannel.setTransportFree(transportFree);
                disChannel.setChannelCloseTime(channelCloseTime);
                disChannel.setChannelOpenTime(channelOpenTime);
                checkBusiness = "";
                packingFee = "";
                transportFree = "";
                channelCloseTime = "";
                channelOpenTime = "";
            }
            channelOwnList.add(disChannel);
        }
        return channelOwnList;
    }

    private List<UmStoreChannelSendDomain> changeChannelNewList(List<UmStoreChannelSendDomain> channelNewList) {
        ArrayList<UmStoreChannelSendDomain> channelOwnList = new ArrayList<UmStoreChannelSendDomain>();
        for (UmStoreChannelSendDomain disChannel : channelNewList) {
            disChannel.setPackingFee("0");
            disChannel.setTransportFree("0");
            disChannel.setCheckBusiness("-1");
            channelOwnList.add(disChannel);
        }
        return channelOwnList;
    }

    @RequestMapping(value={"saveUserStoreChannel.json"}, name="\u589e\u52a0\u5f53\u524d\u767b\u9646\u8005\u56e2\u957f\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean saveUserStoreChannel(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveUserStoreChannel", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List umUserinfochannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, UmUserinfoChannelReDomain.class);
        if (ListUtil.isEmpty((Collection)umUserinfochannelList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        return this.umUserinfoQuaServiceRepository.sendSaveUserinfoChannelBatch(umUserinfochannelList);
    }

    @RequestMapping(value={"queryUserStorePageForChannel.json"}, name="\u67e5\u8be2\u767b\u9646\u8005\u4e0b\u9762\u7684\u56e2\u957f\u4f1a\u5458\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserStorePageForChannel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
        }
        return this.userServiceRepository.queryUserinfoPage(param);
    }

    @RequestMapping(value={"updateChannelTimeBatch.json"}, name="\u589e\u52a0\u5f53\u524d\u767b\u9646\u8005\u56e2\u957f\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean updateChannelTimeBatch(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.umUserinfoQuaServiceRepository.updateChannelTimeBatchEnt(param);
    }

    @RequestMapping(value={"queryStoreBySimpleObjPage.json"}, name="\u67e5\u8be2\u6240\u6709\u56e2\u957f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoSimpleDomain> queryStoreBySimpleObjPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.userServiceRepository.queryStoreBySimpleObjPageEnt(param, this.getTenantCode(request));
    }

    @RequestMapping(value={"getStoreBySimpleObjPage.json"}, name="\u67e5\u8be2\u6240\u6709\u56e2\u957f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public UmUserinfoSimpleDomain getStoreBySimpleObjPage(HttpServletRequest request, String userinfoCode) {
        UmUserinfoReDomainBean userinfoByCode;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
        }
        if (null == (userinfoByCode = this.userServiceRepository.getUserinfoByCode(userinfoCode, this.getTenantCode(request)))) {
            return null;
        }
        HashMap<String, String> param2 = new HashMap<String, String>();
        param2.put("tenantCode", this.getTenantCode(request));
        param2.put("userinfoCode", userinfoCode);
        SupQueryResult umUserinfoQuaResult = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(param2);
        SupQueryResult umUserinfoChannelReDomainSupQueryResult = this.umUserinfoQuaServiceRepository.queryUserinfoChannelPage(param2);
        UmUserinfoSimpleDomain umUserinfoSimpleDomainStr = new UmUserinfoSimpleDomain();
        if (ListUtil.isNotEmpty((Collection)umUserinfoQuaResult.getList())) {
            for (UmUserinfoQuaReDomain userinfoQuaReDomain : umUserinfoQuaResult.getList()) {
                if ("storeMapLocation".equals(userinfoQuaReDomain.getUserinfoQuaKey())) {
                    umUserinfoSimpleDomainStr.setStoreMapLocation(userinfoQuaReDomain.getUserinfoQuaVaule());
                }
                if ("storeDistribution".equals(userinfoQuaReDomain.getUserinfoQuaKey())) {
                    umUserinfoSimpleDomainStr.setStoreDistribution(userinfoQuaReDomain.getUserinfoQuaVaule());
                }
                if ("storeOpenTime".equals(userinfoQuaReDomain.getUserinfoQuaKey())) {
                    umUserinfoSimpleDomainStr.setStoreOpenTime(userinfoQuaReDomain.getUserinfoQuaVaule());
                }
                if (!"storeCloseTime".equals(userinfoQuaReDomain.getUserinfoQuaKey())) continue;
                umUserinfoSimpleDomainStr.setStoreCloseTime(userinfoQuaReDomain.getUserinfoQuaVaule());
            }
        }
        if (ListUtil.isNotEmpty((Collection)umUserinfoChannelReDomainSupQueryResult.getList())) {
            for (UmUserinfoChannelReDomain userinfoChannelReDomain : umUserinfoChannelReDomainSupQueryResult.getList()) {
                if ("channelOpenTime".equals(userinfoChannelReDomain.getUserinfoChannelKey())) {
                    umUserinfoSimpleDomainStr.setStoreOpenTime(userinfoChannelReDomain.getUserinfoChannelVaule());
                }
                if ("channelCloseTime".equals(userinfoChannelReDomain.getUserinfoChannelKey())) {
                    umUserinfoSimpleDomainStr.setStoreCloseTime(userinfoChannelReDomain.getUserinfoChannelVaule());
                }
                if ("packingFee".equals(userinfoChannelReDomain.getUserinfoChannelKey())) {
                    umUserinfoSimpleDomainStr.setPackingFee(userinfoChannelReDomain.getUserinfoChannelVaule());
                }
                if (!"transportFree".equals(userinfoChannelReDomain.getUserinfoChannelKey())) continue;
                umUserinfoSimpleDomainStr.setTransportFree(userinfoChannelReDomain.getUserinfoChannelVaule());
            }
        }
        UmUserinfoSimpleDomain umUserinfoSimpleDomain = new UmUserinfoSimpleDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umUserinfoSimpleDomain, (Object)userinfoByCode);
            BeanUtils.copyAllPropertysNotNull((Object)umUserinfoSimpleDomain, (Object)umUserinfoSimpleDomainStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return umUserinfoSimpleDomain;
    }

    @RequestMapping(value={"updateUserinfoByGroupToUser.json"}, name="\u5206\u914d\u56e2\u957f\u7ed9\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean updateUserinfoByGroupToUser(HttpServletRequest request, String userinfoapplyjson) {
        if (StringUtils.isBlank((String)userinfoapplyjson)) {
            this.logger.error(CODE + ".updateUserinfoByGroupToUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateUserinfoByGroupToUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        UmUserinfoapplyDomain umUserinfoapplyDomain = (UmUserinfoapplyDomain)JsonUtil.buildNormalBinder().getJsonToObject(userinfoapplyjson, UmUserinfoapplyDomain.class);
        if (null != umUserinfoapplyDomain && StringUtils.isBlank((String)umUserinfoapplyDomain.getUserinfoCode()) && StringUtils.isBlank((String)umUserinfoapplyDomain.getUserinfoParentCode())) {
            this.logger.error(CODE + ".updateUserinfoByGroupToUser", (Object)"umUserinfoDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        umUserinfoapplyDomain.setTenantCode(this.getTenantCode(request));
        return this.userServiceRepository.updateUserinfoapplyParentCode(umUserinfoapplyDomain);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".makeExcelData.supQueryResult", (Object)(" is null" + json));
            return null;
        }
        List umUserinfoReDomainBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), UmUserinfoReDomainBean.class);
        if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeanList)) {
            this.logger.error(CODE + ".makeExcelData.umUserinfoReDomainBeanList", (Object)(" is null" + json));
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if ("dentist".equals(excelTemplate) || "dentistre".equals(excelTemplate)) {
            for (UmUserinfoReDomainBean um : umUserinfoReDomainBeanList) {
                List umUserinfoapplyDomainList = um.getUmUserinfoapplyDomainList();
                boolean flag = false;
                if (ListUtil.isNotEmpty((Collection)umUserinfoapplyDomainList)) {
                    for (UmUserinfoapplyDomain umUserinfoapplyDomain : umUserinfoapplyDomainList) {
                        Map<String, Object> objectDetailToMap = this.covertMapWtite(umUserinfoapplyDomain);
                        if (!flag) {
                            Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)um), String.class, Object.class);
                            objectDetailToMap.putAll(objectToMap);
                            flag = true;
                        }
                        mapList.add(objectDetailToMap);
                    }
                    continue;
                }
                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)um), String.class, Object.class);
                mapList.add(objectToMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMapWtite(UmUserinfoapplyDomain umUserReDomainBean) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("userPhone", umUserReDomainBean.getUserPhone());
        return orderMaps;
    }

    public static void main(String[] args) {
        String groupCode = "11";
        List<Object> data = new ArrayList();
        ArrayList datalist = new ArrayList();
        if (!StringUtils.isBlank((String)groupCode)) {
            String[] groupCodes = groupCode.split(",");
            data = Arrays.asList(groupCodes);
        }
        log.info("data:{}", data);
    }
}

