/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.version.controller;

import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ve.domain.VerJoblistDomain;
import com.qjsoft.laser.controller.facade.ve.domain.VerJoblistReDomain;
import com.qjsoft.laser.controller.facade.ve.repository.VerJoblistServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.jenkins.util.JenkinsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ve/Joblist"}, name="\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868")
public class JoblistCon
extends SpringmvcController {
    private static String CODE = "ve.Joblist.con";
    @Autowired
    private VerJoblistServiceRepository verJoblistServiceRepository;

    protected String getContext() {
        return "Joblist";
    }

    @RequestMapping(value={"saveJoblist.json"}, name="\u589e\u52a0\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868")
    @ResponseBody
    public HtmlJsonReBean saveJoblist(HttpServletRequest request, VerJoblistDomain VerJoblistDomain2) {
        if (null == VerJoblistDomain2) {
            this.logger.error(CODE + ".saveJoblist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.verJoblistServiceRepository.saveJoblist(VerJoblistDomain2);
    }

    @RequestMapping(value={"getJoblist.json"}, name="\u83b7\u53d6\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868\u4fe1\u606f")
    @ResponseBody
    public VerJoblistReDomain getJoblist(Integer jobId) {
        if (StringUtils.isBlank((Integer)jobId)) {
            this.logger.error(CODE + ".getJoblist", (Object)"param is null");
            return null;
        }
        return this.verJoblistServiceRepository.getJoblist(jobId);
    }

    @RequestMapping(value={"getJoblistFromService.json"}, name="\u83b7\u53d6\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868\u4fe1\u606f")
    @ResponseBody
    public Map<String, Job> getJoblistFromService() {
        String jenkinsUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsURL");
        String jenkinsUsername = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsUserName");
        String jenkinsPassword = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsPassWord");
        JenkinsUtils jenkins = null;
        try {
            jenkins = new JenkinsUtils(new URI(jenkinsUrl), jenkinsUsername, jenkinsPassword);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        Map jobs = null;
        try {
            jobs = jenkins.getJobs("1.\u2605\u661f\u4e91\u53d1\u5e03");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jobs;
    }

    @RequestMapping(value={"updateJoblist.json"}, name="\u66f4\u65b0\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868")
    @ResponseBody
    public HtmlJsonReBean updateJoblist(HttpServletRequest request, VerJoblistDomain VerJoblistDomain2) {
        if (null == VerJoblistDomain2) {
            this.logger.error(CODE + ".updateJoblist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.verJoblistServiceRepository.updateJoblist(VerJoblistDomain2);
    }

    @RequestMapping(value={"deleteJoblist.json"}, name="\u5220\u9664\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868")
    @ResponseBody
    public HtmlJsonReBean deleteJoblist(Integer jobId) {
        if (StringUtils.isBlank((Integer)jobId)) {
            this.logger.error(CODE + ".deleteJoblist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.verJoblistServiceRepository.deleteJoblist(jobId);
    }

    @RequestMapping(value={"queryJoblistPage.json"}, name="\u67e5\u8be2\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<VerJoblistReDomain> queryJoblistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.verJoblistServiceRepository.queryJoblistModelPage(param);
    }

    @RequestMapping(value={"updateJoblistState.json"}, name="\u66f4\u65b0\u7248\u672c\u5347\u7ea7jenkins\u5de5\u4f5c\u8868\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateJoblistState(String jobId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)jobId)) {
            this.logger.error(CODE + ".updateJoblistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.verJoblistServiceRepository.updateJoblistState(Integer.valueOf(jobId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updataeJobRelease.json"}, name="\u91cd\u542fJob\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updataeJobRelease(Integer jobId) {
        if (StringUtils.isBlank((Integer)jobId)) {
            this.logger.error(CODE + ".getVersion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobId is null");
        }
        VerJoblistReDomain joblist = this.verJoblistServiceRepository.getJoblist(jobId);
        if (null == joblist) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "joblist is null");
        }
        String jobName = joblist.getJobName();
        if (StringUtils.isBlank((String)jobName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobName is null");
        }
        String jenkinsUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsURL");
        String jenkinsUsername = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsUserName");
        String jenkinsPassword = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsPassWord");
        String jenkinsCrumb = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsCrumb");
        this.logger.error(CODE + ".jenkinsUrl=======" + jenkinsUrl, (Object)"\u4ece\u6570\u636e\u5b57\u5178\u83b7\u53d6");
        if (null == jenkinsUrl || null == jenkinsUsername || null == jenkinsPassword || null == jenkinsCrumb) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jenkinsData is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Jenkins-Crumb", jenkinsCrumb);
        try {
            JenkinsUtils jenkinsUtils = new JenkinsUtils(new URI(jenkinsUrl), jenkinsUsername, jenkinsPassword);
            JobWithDetails job = jenkinsUtils.getJob(jobName);
            job.build(map);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updateReleaseVersion====", (Object)"\u53d1\u5e03\u7248\u672c\u5347\u7ea7\u65e5\u5fd7\u5f02\u5e38");
        }
        return new HtmlJsonReBean((Object)"\u6267\u884c\u53d1\u5e03");
    }

    @RequestMapping(value={"refreshJobService.json"}, name="\u5237\u65b0Job\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean refreshJobService(Integer jobId) {
        if (StringUtils.isBlank((Integer)jobId)) {
            this.logger.error(CODE + ".getVersion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobId is null");
        }
        VerJoblistReDomain joblist = this.verJoblistServiceRepository.getJoblist(jobId);
        if (null == joblist) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "joblist is null");
        }
        String jobName = joblist.getJobName();
        if (StringUtils.isBlank((String)jobName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobName is null");
        }
        String jenkinsUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsURL");
        String jenkinsUsername = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsUserName");
        String jenkinsPassword = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsPassWord");
        String jenkinsCrumb = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsCrumb");
        this.logger.error(CODE + ".jenkinsUrl=======" + jenkinsUrl, (Object)"\u4ece\u6570\u636e\u5b57\u5178\u83b7\u53d6");
        Integer lastBuildNumber = null;
        if (null == jenkinsUrl || null == jenkinsUsername || null == jenkinsPassword || null == jenkinsCrumb) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jenkinsData is null");
        }
        try {
            JenkinsUtils jenkinsUtils = new JenkinsUtils(new URI(jenkinsUrl), jenkinsUsername, jenkinsPassword);
            JobWithDetails job = jenkinsUtils.getJob(jobName);
            lastBuildNumber = jenkinsUtils.getPredictionsNumber(jobName, null);
            joblist.setLastBuildNumber(lastBuildNumber);
            this.verJoblistServiceRepository.updateJoblist((VerJoblistDomain)joblist);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updateReleaseVersion====", (Object)"\u53d1\u5e03\u7248\u672c\u5347\u7ea7\u65e5\u5fd7\u5f02\u5e38");
        }
        return new HtmlJsonReBean((Object)"\u5237\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"getJobServiceLog.json"}, name="\u67e5\u770bJob\u670d\u52a1\u91cd\u542f\u65e5\u5fd7")
    @ResponseBody
    public HtmlJsonReBean getJobServiceLog(Integer jobId) {
        if (StringUtils.isBlank((Integer)jobId)) {
            this.logger.error(CODE + ".getVersion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobId is null");
        }
        VerJoblistReDomain joblist = this.verJoblistServiceRepository.getJoblist(jobId);
        if (null == joblist) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "joblist is null");
        }
        if (null == joblist.getLastBuildNumber()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u670d\u52a1\u672a\u5237\u65b0");
        }
        String jobName = joblist.getJobName();
        String jobConsoleOutputText = null;
        if (StringUtils.isBlank((String)jobName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jobName is null");
        }
        String jenkinsUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsURL");
        String jenkinsUsername = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsUserName");
        String jenkinsPassword = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-version-jenkinsPassWord");
        this.logger.error(CODE + ".jenkinsUrl=======" + jenkinsUrl, (Object)"\u4ece\u6570\u636e\u5b57\u5178\u83b7\u53d6");
        if (null == jenkinsUrl || null == jenkinsUsername || null == jenkinsPassword) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jenkinsData is null");
        }
        try {
            JenkinsUtils jenkinsUtils = new JenkinsUtils(new URI(jenkinsUrl), jenkinsUsername, jenkinsPassword);
            jobConsoleOutputText = jenkinsUtils.getJobConsoleOutString(joblist.getJobName(), joblist.getLastBuildNumber());
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updateReleaseVersion====", (Object)"\u53d1\u5e03\u7248\u672c\u5347\u7ea7\u65e5\u5fd7\u5f02\u5e38");
        }
        return new HtmlJsonReBean((Object)jobConsoleOutputText);
    }
}

