/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wa.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wa.domain.IaInsuranceReDomain;
import com.qjsoft.laser.controller.facade.wa.domain.IaInsurancelistDomain;
import com.qjsoft.laser.controller.facade.wa.domain.WaWaiterDomain;
import com.qjsoft.laser.controller.facade.wa.domain.WaWaiterReDomain;
import com.qjsoft.laser.controller.facade.wa.domain.WaWaiteruserDomain;
import com.qjsoft.laser.controller.facade.wa.domain.WaWaiteruserItReDomain;
import com.qjsoft.laser.controller.facade.wa.domain.WaWaiteruserReDomain;
import com.qjsoft.laser.controller.facade.wa.domain.orderexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.facade.wa.repository.WaWaiterServiceRepository;
import com.qjsoft.laser.controller.facade.wa.repository.WaWaiteruserItServiceRepository;
import com.qjsoft.laser.controller.facade.wa.repository.WaWaiteruserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wa/waiter"}, name="\u670d\u52a1\u5355\u670d\u52a1")
public class WaiterCon
extends SpringmvnNewController {
    private static String CODE = "wa.waiter.con";
    @Autowired
    private WaWaiterServiceRepository waWaiterServiceRepository;
    @Autowired
    private WaWaiteruserServiceRepository waWaiteruserServiceRepository;
    @Autowired
    private WaWaiteruserItServiceRepository waWaiteruserItServiceRepository;

    protected String getContext() {
        return "waiter";
    }

    @RequestMapping(value={"saveWaiter.json"}, name="\u589e\u52a0\u670d\u52a1\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveWaiter(HttpServletRequest request, WaWaiterDomain waWaiterDomain) {
        if (null == waWaiterDomain) {
            this.logger.error(CODE + ".saveWaiter", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        waWaiterDomain.setTenantCode(this.getTenantCode(request));
        return this.waWaiterServiceRepository.saveWaiter(waWaiterDomain);
    }

    @RequestMapping(value={"getWaiter.json"}, name="\u83b7\u53d6\u670d\u52a1\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WaWaiterReDomain getWaiter(Integer waiterId) {
        if (StringUtils.isBlank((Integer)waiterId)) {
            this.logger.error(CODE + ".getWaiter", (Object)"param is null");
            return null;
        }
        return this.waWaiterServiceRepository.getWaiter(waiterId);
    }

    @RequestMapping(value={"getWaiterByBillcode.json"}, name="\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u670d\u52a1\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WaWaiterReDomain getWaiterByBillcode(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".getWaiterByBillcode", (Object)"contractBillcode is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult waWaiterReDomainSupQueryResult = this.waWaiterServiceRepository.queryWaiterPage(param);
        if (null == waWaiterReDomainSupQueryResult || ListUtil.isEmpty((Collection)waWaiterReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".getWaiterByBillcode.waWaiterReDomainSupQueryResult", (Object)"contractBillcode is null");
            return null;
        }
        WaWaiterReDomain waWaiterReDomain = (WaWaiterReDomain)waWaiterReDomainSupQueryResult.getList().get(0);
        if (StringUtils.isNotBlank((String)waWaiterReDomain.getGoodsSupplierCode())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("memberBcode", waWaiterReDomain.getGoodsSupplierCode());
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult waWaiteruserReDomainSupQueryResult = this.waWaiteruserServiceRepository.queryWaiteruserPage(map);
            if (null != waWaiteruserReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)waWaiteruserReDomainSupQueryResult.getList())) {
                WaWaiteruserReDomain waWaiteruserReDomain = (WaWaiteruserReDomain)waWaiteruserReDomainSupQueryResult.getList().get(0);
                waWaiterReDomain.setWaWaiteruserDomain((WaWaiteruserDomain)waWaiteruserReDomain);
            }
        }
        return waWaiterReDomain;
    }

    @RequestMapping(value={"updateWaiterForPmu.json"}, name="\u624b\u52a8\u5206\u914d\u6444\u5f71\u5e08")
    @ResponseBody
    public HtmlJsonReBean updateWaiterForPmu(HttpServletRequest request, String memberBcode, String memberBname, Integer waiterId) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)memberBname) || StringUtils.isBlank((Integer)waiterId)) {
            this.logger.error(CODE + ".updateWaiterForPmu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WaWaiterReDomain waiter = this.waWaiterServiceRepository.getWaiter(waiterId);
        if (null == waiter) {
            return new HtmlJsonReBean((Object)"\u6444\u5f71\u5e08\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (waiter.getDataState() == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5206\u914d\u7684\u670d\u52a1\u5355\u4e0d\u5141\u8bb8\u518d\u5206\u914d");
        }
        Date waiterVaildate = waiter.getWaiterVaildate();
        Date waiterGddate = waiter.getWaiterGddate();
        long datePoor = WaiterCon.getDatePoor(waiterGddate, waiterVaildate);
        int serviceDate = 0;
        if (datePoor <= 4L) {
            serviceDate = WaiterCon.getDateisAm(waiterVaildate) != false ? 1 : 2;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberBcode", memberBcode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult waWaiteruserReDomainSupQueryResult = this.waWaiteruserServiceRepository.queryWaiteruserPage(map);
        if (null == waWaiteruserReDomainSupQueryResult || ListUtil.isEmpty((Collection)waWaiteruserReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u4e0d\u5230\u6444\u5f71\u5e08");
        }
        WaWaiteruserReDomain waWaiteruserReDomain = (WaWaiteruserReDomain)waWaiteruserReDomainSupQueryResult.getList().get(0);
        map.clear();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("waiteruserCode", waWaiteruserReDomain.getWaiteruserCode());
        map.put("waiteruserItStartt", DateUtil.getDateString((Date)waiterVaildate, (String)"yyyy-MM-dd"));
        map.put("order", true);
        map.put("fuzzy", true);
        SupQueryResult waWaiteruserItReDomainSupQueryResult = this.waWaiteruserItServiceRepository.queryWaiteruserItPage(map);
        if (null != waWaiteruserItReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)waWaiteruserItReDomainSupQueryResult.getList())) {
            if (2 <= waWaiteruserItReDomainSupQueryResult.getList().size()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6444\u5f71\u5e08\u65e0\u6863\u671f");
            }
            if (WaiterCon.getDateisAm(DateUtil.getDateToString((String)((WaWaiteruserItReDomain)waWaiteruserItReDomainSupQueryResult.getList().get(0)).getWaiteruserItStartt(), (String)"yyyy-MM-dd HH:mm:ss")) != false ? 1 == serviceDate : 2 == serviceDate) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6444\u5f71\u5e08\u65e0\u6863\u671f");
            }
        }
        return this.waWaiterServiceRepository.updateWaiterForPmu(waiterId, waWaiteruserReDomain.getUserCode(), Integer.valueOf(serviceDate));
    }

    @RequestMapping(value={"updateWaiter.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateWaiter(HttpServletRequest request, WaWaiterDomain waiterDomain) {
        if (null == waiterDomain) {
            this.logger.error(CODE + ".updateWaiter", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        waiterDomain.setTenantCode(this.getTenantCode(request));
        return this.waWaiterServiceRepository.updateWaiter(waiterDomain);
    }

    @RequestMapping(value={"deleteWaiter.json"}, name="\u5220\u9664\u670d\u52a1\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteWaiter(Integer waiterId) {
        if (StringUtils.isBlank((Integer)waiterId)) {
            this.logger.error(CODE + ".deleteWaiter", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.deleteWaiter(waiterId);
    }

    @RequestMapping(value={"queryWaiterPage.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WaWaiterReDomain> queryWaiterPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String exportFlag = null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        Boolean flag = Boolean.valueOf(exportFlag);
        this.logger.error(CODE + ".queryWaiterPage", (Object)param);
        if (flag.booleanValue()) {
            UserSession userSession = this.getUserSession(request);
            String userCode = userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("headMap", ExcelExportTemplate.iaExcelParam());
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", "\u4fdd\u9669\u4fe1\u606f\u5bfc\u51fa");
            try {
                this.exportComExcel(request, param, infoMap, "wa.waiter.queryWaiterPage", null);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".excelExportGoods.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.waWaiterServiceRepository.queryWaiterPage(param);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List waWaiterReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WaWaiterReDomain.class);
        if (ListUtil.isEmpty((Collection)waWaiterReDomainList)) {
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (WaWaiterReDomain waWaiterReDomain : waWaiterReDomainList) {
            IaInsuranceReDomain iaInsuranceReDomain;
            List iaInsurancelistList;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String contractBillcode = waWaiterReDomain.getContractBillcode();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("insuranceOpcode", contractBillcode);
            param.put("tenantCode", waWaiterReDomain.getTenantCode());
            SupQueryResult iaInsuranceReDomainSupQueryResult = this.waWaiterServiceRepository.queryInsurancePage(param);
            if (null == iaInsuranceReDomainSupQueryResult || ListUtil.isEmpty((Collection)iaInsuranceReDomainSupQueryResult.getList()) || ListUtil.isEmpty((Collection)(iaInsurancelistList = (iaInsuranceReDomain = (IaInsuranceReDomain)iaInsuranceReDomainSupQueryResult.getList().get(0)).getIaInsurancelistList()))) continue;
            for (IaInsurancelistDomain iaInsurancelistDomain : iaInsurancelistList) {
                map.put("contractBillcode", contractBillcode);
                String insurancelistNo = iaInsurancelistDomain.getInsurancelistNo();
                map.put("IDcard", contractBillcode);
                String insurancelistFile2 = iaInsurancelistDomain.getInsurancelistFile2();
                map.put("phone", insurancelistFile2);
                Date waiterVaildate = waWaiterReDomain.getWaiterVaildate();
                map.put("waiterVaildate", waiterVaildate);
                String insurancelistFile1 = iaInsurancelistDomain.getInsurancelistFile1();
                map.put("userName", insurancelistFile1);
                map.put("memberCname", "\u53a6\u95e8\u94c2\u7235");
                mapList.add(map);
            }
        }
        return mapList;
    }

    @RequestMapping(value={"updateWaiterState.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWaiterState(String waiterId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateWaiterStateOne.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u5f85\u62cd\u6444")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateOne(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(1), Integer.valueOf(0), map);
    }

    @RequestMapping(value={"updateWaiterStateTwo.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u62cd\u6444\u4e2d")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateTwo(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(2), Integer.valueOf(1), map);
    }

    @RequestMapping(value={"updateWaiterStateThree.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u5f85\u4f20\u7247")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateThree(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(3), Integer.valueOf(2), map);
    }

    @RequestMapping(value={"updateWaiterStateFour.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u5f85\u5236\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateFour(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(4), Integer.valueOf(3), map);
    }

    @RequestMapping(value={"updateWaiterStateFive.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u5236\u4f5c\u4e2d")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateFive(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(5), Integer.valueOf(4), map);
    }

    @RequestMapping(value={"updateWaiterStateSix.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u670d\u52a1\u72b6\u6001\u5236\u4f5c\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateWaiterStateSix(String waiterId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)waiterId)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.waWaiterServiceRepository.updateWaiterState(Integer.valueOf(waiterId), Integer.valueOf(6), Integer.valueOf(5), map);
    }

    @RequestMapping(value={"checkOrderForPmu.json"}, name="\u68c0\u67e5\u6444\u5f71\u5e08\u4e0b\u5355\u6392\u671f")
    @ResponseBody
    public WaWaiteruserReDomain checkOrderForPmu(HttpServletRequest request, String waiterVaildate, String waiterGddate, String areaCode) {
        if (StringUtils.isBlank((String)waiterVaildate) || StringUtils.isBlank((String)waiterGddate) || StringUtils.isBlank((String)areaCode)) {
            this.logger.error(CODE + ".updateWaiterState", (Object)"param is null");
            return null;
        }
        return this.waWaiterServiceRepository.checkOrderForPmu(waiterVaildate, waiterVaildate, areaCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryWaiterPageByUser.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u670d\u52a1\u5206\u9875\u5217\u8868(\u8fc7\u6ee4\u5f53\u524d\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<WaWaiterReDomain> queryWaiterPageByPmu(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("goodsSupplierCode", userSession.getUserPcode());
        return this.waWaiterServiceRepository.queryWaiterPage(param);
    }

    @RequestMapping(value={"queryWaiterPageByBcode.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u670d\u52a1\u5206\u9875\u5217\u8868(\u8fc7\u6ee4\u4e70\u5bb6)")
    @ResponseBody
    public SupQueryResult<WaWaiterReDomain> queryWaiterPageByBcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberBcode", userSession.getUserPcode());
        return this.waWaiterServiceRepository.queryWaiterPage(param);
    }

    public static long getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long hour = diff % nd / nh;
        return hour;
    }

    public static Boolean getDateisAm(Date nowDate) {
        SimpleDateFormat df = new SimpleDateFormat("HH");
        String str = df.format(new Date());
        int a = Integer.parseInt(str);
        if (a >= 12) {
            return false;
        }
        return true;
    }
}

