/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wh.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreGoodsDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreGoodsReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreSkuNumBean;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreSkuReDomain;
import com.qjsoft.laser.controller.facade.wh.repository.WhStoreGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/storeGoods"}, name="\u4ed3\u5e93\u5546\u54c1")
public class StoreGoodsCon
extends SpringmvcController {
    private static String CODE = "wh.storeGoods.con";
    @Autowired
    private WhStoreGoodsServiceRepository whStoreGoodsServiceRepository;

    protected String getContext() {
        return "storeGoods";
    }

    @RequestMapping(value={"saveStoreGoods.json"}, name="\u589e\u52a0\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveStoreGoods(HttpServletRequest request, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            this.logger.error(CODE + ".saveStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreGoodsServiceRepository.saveStoreGoods(whStoreGoodsDomain);
    }

    @RequestMapping(value={"getStoreGoods.json"}, name="\u83b7\u53d6\u4ed3\u5e93\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public WhStoreGoodsReDomain getStoreGoods(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".getStoreGoods", (Object)"param is null");
            return null;
        }
        return this.whStoreGoodsServiceRepository.getStoreGoods(storeGoodsId);
    }

    @RequestMapping(value={"updateStoreGoods.json"}, name="\u66f4\u65b0\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateStoreGoods(HttpServletRequest request, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            this.logger.error(CODE + ".updateStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreGoodsServiceRepository.updateStoreGoods(whStoreGoodsDomain);
    }

    @RequestMapping(value={"deleteStoreGoods.json"}, name="\u5220\u9664\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteStoreGoods(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".deleteStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreGoodsServiceRepository.deleteStoreGoods(storeGoodsId);
    }

    @RequestMapping(value={"queryStoreGoodsPage.json"}, name="\u67e5\u8be2\u4ed3\u5e93\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreGoodsReDomain> queryStoreGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreGoodsPage(param);
    }

    @RequestMapping(value={"updateStoreGoodsState.json"}, name="\u66f4\u65b0\u4ed3\u5e93\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStoreGoodsState(String storeGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)storeGoodsId)) {
            this.logger.error(CODE + ".updateStoreGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreGoodsServiceRepository.updateStoreGoodsState(Integer.valueOf(storeGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryStoreSkuPage.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.remove("tenantCode");
        String memberCode = this.getTeananMemberCode(request);
        param.put("memberCode", memberCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"queryStoreSkuPages.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPages(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"updateSendStoreReNum.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSendStoreReNum(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        List whStoreSkuNumBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, WhStoreSkuNumBean.class);
        if (ListUtil.isEmpty((Collection)whStoreSkuNumBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        UserSession session = this.getUserSession(request);
        String memberCode = session.getUserPcode();
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            whStoreSkuNumBean.setMemberCode(memberCode);
        }
        return this.whStoreGoodsServiceRepository.sendUpdateStoreSkuNum(whStoreSkuNumBeanList);
    }

    @RequestMapping(value={"getStoreGoodsById.json"}, name="\u6839\u636eid\u83b7\u53d6\u4ed3\u5e93\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public WhStoreGoodsReDomain getStoreGoodsById(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".getStoreGoodsById", (Object)"param is null");
            return null;
        }
        return this.whStoreGoodsServiceRepository.getStoreGoods(storeGoodsId);
    }
}

