/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wh.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wh.domain.WhDgnumDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhDgnumListDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhDgnumListReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhDgnumReDomain;
import com.qjsoft.laser.controller.facade.wh.repository.WhDgnumServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/dgnum"}, name="\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
public class WhDgnumCon
extends SpringmvcController {
    private static String CODE = "wh.dgnum.con";
    @Autowired
    private WhDgnumServiceRepository whDgnumServiceRepository;

    protected String getContext() {
        return "dgnum";
    }

    @RequestMapping(value={"saveDgnum.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean saveDgnum(HttpServletRequest request, WhDgnumDomain DgnumDomain) {
        if (null == DgnumDomain) {
            this.logger.error(CODE + ".saveDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        DgnumDomain.setMemberMcode(userSession.getUserPcode());
        DgnumDomain.setMemberMname(userSession.getUserName());
        DgnumDomain.setTenantCode(userSession.getTenantCode());
        return this.whDgnumServiceRepository.saveDgnum(DgnumDomain);
    }

    @RequestMapping(value={"getDgnum.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u4fe1\u606f")
    @ResponseBody
    public WhDgnumReDomain getDgnum(Integer dgnumId) {
        if (StringUtils.isBlank((Integer)dgnumId)) {
            this.logger.error(CODE + ".getDgnum", (Object)"param is null");
            return null;
        }
        return this.whDgnumServiceRepository.getDgnum(dgnumId);
    }

    @RequestMapping(value={"updateDgnum.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateDgnum(HttpServletRequest request, WhDgnumReDomain DgnumDomain) {
        if (null == DgnumDomain) {
            this.logger.error(CODE + ".updateDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DgnumDomain.setTenantCode(this.getTenantCode(request));
        return this.whDgnumServiceRepository.updateDgnum((WhDgnumDomain)DgnumDomain);
    }

    @RequestMapping(value={"deleteDgnum.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnum(Integer dgnumId) {
        if (StringUtils.isBlank((Integer)dgnumId)) {
            this.logger.error(CODE + ".deleteDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whDgnumServiceRepository.deleteDgnum(dgnumId);
    }

    @RequestMapping(value={"queryDgnumPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhDgnumReDomain> queryDgnumPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whDgnumServiceRepository.queryDgnumPage(param);
    }

    @RequestMapping(value={"updateDgnumState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDgnumState(String dgnumId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dgnumId)) {
            this.logger.error(CODE + ".updateDgnumState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whDgnumServiceRepository.updateDgnumState(Integer.valueOf(dgnumId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveDgnumByJson.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean saveDgnumByJson(HttpServletRequest request, String paramStr) {
        WhDgnumDomain dgnumDomain = (WhDgnumDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, WhDgnumDomain.class);
        if (null == dgnumDomain) {
            this.logger.error(CODE + ".saveDgnumByJson", (Object)"paramStr is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        dgnumDomain.setMemberMcode(userSession.getUserPcode());
        dgnumDomain.setMemberMname(userSession.getUserName());
        dgnumDomain.setTenantCode(userSession.getTenantCode());
        return this.whDgnumServiceRepository.saveDgnum(dgnumDomain);
    }

    @RequestMapping(value={"deleteDgnumListByCode.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteDgnumListByCode(HttpServletRequest request, String dgnumListCode) {
        if (StringUtils.isBlank((String)dgnumListCode)) {
            this.logger.error(CODE + ".deleteDgnumListByCode", (Object)"dgnumListCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whDgnumServiceRepository.deleteDgnumListByCode(this.getTenantCode(request), dgnumListCode);
    }

    @RequestMapping(value={"saveWhDgnumListByJson.json"}, name="\u5e93\u5b58\u9002\u7528\u8303\u56f4\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveWhDgnumListByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List whDgnumListDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, WhDgnumListDomain.class);
        if (ListUtil.isEmpty((Collection)whDgnumListDomainList)) {
            this.logger.error(CODE + ".saveWarehouseListByJson", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String userPcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String userName = userSession.getUserName();
        for (WhDgnumListDomain whDgnumListDomain : whDgnumListDomainList) {
            whDgnumListDomain.setMemberMcode(userPcode);
            whDgnumListDomain.setMemberMname(userName);
            whDgnumListDomain.setTenantCode(tenantCode);
        }
        return this.whDgnumServiceRepository.saveDgnumListBatch(whDgnumListDomainList);
    }

    @RequestMapping(value={"deleteDgnumListByNumCode.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1list\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnumListByNumCode(HttpServletRequest request, String dgnumCode) {
        if (StringUtils.isBlank((String)dgnumCode)) {
            this.logger.error(CODE + ".deleteDgnumListByNumCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whDgnumServiceRepository.deleteDgnumListByNumCode(this.getTenantCode(request), dgnumCode);
    }

    @RequestMapping(value={"queryDgnumListPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhDgnumListReDomain> queryDgnumListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whDgnumServiceRepository.queryDgnumListPage(param);
    }

    @RequestMapping(value={"saveDgnumList.json"}, name="\u4fdd\u5b58\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean saveDgnumList(HttpServletRequest request, WhDgnumListDomain whDgnumListDomain) {
        if (null == whDgnumListDomain) {
            this.logger.error(CODE + ".saveDgnumList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        whDgnumListDomain.setMemberMcode(userSession.getUserPcode());
        whDgnumListDomain.setMemberMname(userSession.getUserName());
        whDgnumListDomain.setTenantCode(userSession.getTenantCode());
        return this.whDgnumServiceRepository.saveDgnumList(whDgnumListDomain);
    }

    @RequestMapping(value={"getDgnumList.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u4fe1\u606f")
    @ResponseBody
    public WhDgnumListReDomain getDgnumList(Integer dgnumListId) {
        if (StringUtils.isBlank((Integer)dgnumListId)) {
            this.logger.error(CODE + ".getDgnumList", (Object)"param is null");
            return null;
        }
        return this.whDgnumServiceRepository.getDgnumList(dgnumListId);
    }

    @RequestMapping(value={"updateDgnumList.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateDgnumList(HttpServletRequest request, WhDgnumListDomain whDgnumListDomain) {
        if (null == whDgnumListDomain) {
            this.logger.error(CODE + ".updateDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whDgnumListDomain.setTenantCode(this.getTenantCode(request));
        return this.whDgnumServiceRepository.updateDgnumList(whDgnumListDomain);
    }

    @RequestMapping(value={"deleteDgnumList.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnumList(Integer dgnumListId) {
        if (StringUtils.isBlank((Integer)dgnumListId)) {
            this.logger.error(CODE + ".deleteDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whDgnumServiceRepository.deleteDgnumList(dgnumListId);
    }
}

