/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wh.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wh.domain.WhWarehouseDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhWarehouseReDomain;
import com.qjsoft.laser.controller.facade.wh.repository.WhWarehouseServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/warehouse"}, name="\u4ed3\u5e93")
public class WarehouseCon
extends SpringmvcController {
    private static String CODE = "wh.warehouse.con";
    @Autowired
    private WhWarehouseServiceRepository whWarehouseServiceRepository;

    protected String getContext() {
        return "warehouse";
    }

    @RequestMapping(value={"saveWarehouse.json"}, name="\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveWarehouse(HttpServletRequest request, WhWarehouseDomain WhWarehouseDomain2) {
        if (null == WhWarehouseDomain2) {
            this.logger.error(CODE + ".saveWarehouse", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhWarehouseDomain2.setTenantCode(this.getTenantCode(request));
        return this.whWarehouseServiceRepository.saveWarehouse(WhWarehouseDomain2);
    }

    @RequestMapping(value={"saveWarehouseByMemberCode.json"}, name="\u4f9b\u5e94\u5546\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveWarehouseByMemberCode(HttpServletRequest request, WhWarehouseDomain WhWarehouseDomain2) {
        if (null == WhWarehouseDomain2) {
            this.logger.error(CODE + ".saveWarehouse", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String userPcode = userSession.getUserPcode();
        WhWarehouseDomain2.setMemberCode(userPcode);
        WhWarehouseDomain2.setTenantCode(this.getTenantCode(request));
        return this.whWarehouseServiceRepository.saveWarehouse(WhWarehouseDomain2);
    }

    @RequestMapping(value={"getWarehouse.json"}, name="\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f")
    @ResponseBody
    public WhWarehouseReDomain getWarehouse(Integer warehouseId) {
        if (StringUtils.isBlank((Integer)warehouseId)) {
            this.logger.error(CODE + ".getWarehouse", (Object)"param is null");
            return null;
        }
        return this.whWarehouseServiceRepository.getWarehouse(warehouseId);
    }

    @RequestMapping(value={"updateWarehouse.json"}, name="\u66f4\u65b0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean updateWarehouse(HttpServletRequest request, WhWarehouseDomain WhWarehouseDomain2) {
        if (null == WhWarehouseDomain2) {
            this.logger.error(CODE + ".updateWarehouse", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhWarehouseDomain2.setTenantCode(this.getTenantCode(request));
        return this.whWarehouseServiceRepository.updateWarehouse(WhWarehouseDomain2);
    }

    @RequestMapping(value={"updateWarehouseByMemberCode.json"}, name="\u7528\u6237\u66f4\u65b0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean updateWarehouseByMemberCode(HttpServletRequest request, WhWarehouseDomain WhWarehouseDomain2) {
        if (null == WhWarehouseDomain2) {
            this.logger.error(CODE + ".updateWarehouseByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String userPcode = userSession.getUserPcode();
        WhWarehouseDomain2.setMemberCode(userPcode);
        WhWarehouseDomain2.setTenantCode(this.getTenantCode(request));
        return this.whWarehouseServiceRepository.updateWarehouse(WhWarehouseDomain2);
    }

    @RequestMapping(value={"deleteWarehouse.json"}, name="\u5220\u9664\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean deleteWarehouse(Integer warehouseId) {
        if (StringUtils.isBlank((Integer)warehouseId)) {
            this.logger.error(CODE + ".deleteWarehouse", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whWarehouseServiceRepository.deleteWarehouse(warehouseId);
    }

    @RequestMapping(value={"queryWarehousePage.json"}, name="\u67e5\u8be2\u4ed3\u5e93\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhWarehouseReDomain> queryWarehousePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whWarehouseServiceRepository.queryWarehousePage(param);
    }

    @RequestMapping(value={"queryWarehousePageByMemberCode.json"}, name="\u7528\u6237\u67e5\u8be2\u4ed3\u5e93\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhWarehouseReDomain> queryWarehousePageByMemberCode(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whWarehouseServiceRepository.queryWarehousePage(param);
    }

    @RequestMapping(value={"updateWarehouseState.json"}, name="\u66f4\u65b0\u4ed3\u5e93\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWarehouseState(String warehouseId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)warehouseId)) {
            this.logger.error(CODE + ".updateWarehouseState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whWarehouseServiceRepository.updateWarehouseState(Integer.valueOf(warehouseId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateWarehouseStateByMemberCode.json"}, name="\u7528\u6237\u66f4\u65b0\u4ed3\u5e93\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWarehouseStateByMemberCode(String warehouseId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)warehouseId)) {
            this.logger.error(CODE + ".updateWarehouseStateByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whWarehouseServiceRepository.updateWarehouseState(Integer.valueOf(warehouseId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryWarehouse.json"}, name="\u67e5\u8be2\u4ed3\u5e93\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhWarehouseReDomain> queryWarehouse(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whWarehouseServiceRepository.queryWarehousePage(param);
    }

    @RequestMapping(value={"queryWarehouseByMemberCode.json"}, name="\u7528\u6237\u67e5\u8be2\u4ed3\u5e93\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhWarehouseReDomain> queryWarehouseByMemberCode(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whWarehouseServiceRepository.queryWarehousePage(param);
    }

    @RequestMapping(value={"queryWarehouseForAt.json"}, name="\u67e5\u8be2\u4ed3\u5e93\u5217\u8868-\u7ed9\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<WhWarehouseReDomain> queryWarehouseForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whWarehouseServiceRepository.queryWarehousePage(param);
    }
}

