/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wh.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountlistReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhReportDataDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreGoodsDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreGoodsReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreSkuNumBean;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreSkuReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhUserwhReDomain;
import com.qjsoft.laser.controller.facade.wh.repository.WhStoreGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/storeGoods"}, name="\u4ed3\u5e93\u5546\u54c1")
public class StoreGoodsCon
extends SpringmvcController {
    private static String CODE = "wh.storeGoods.con";
    @Autowired
    private WhStoreGoodsServiceRepository whStoreGoodsServiceRepository;

    protected String getContext() {
        return "storeGoods";
    }

    @RequestMapping(value={"saveStoreGoods.json"}, name="\u589e\u52a0\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveStoreGoods(HttpServletRequest request, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            this.logger.error(CODE + ".saveStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreGoodsServiceRepository.saveStoreGoods(whStoreGoodsDomain);
    }

    @RequestMapping(value={"getStoreGoods.json"}, name="\u83b7\u53d6\u4ed3\u5e93\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public WhStoreGoodsReDomain getStoreGoods(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".getStoreGoods", (Object)"param is null");
            return null;
        }
        return this.whStoreGoodsServiceRepository.getStoreGoods(storeGoodsId);
    }

    @RequestMapping(value={"updateStoreGoods.json"}, name="\u66f4\u65b0\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateStoreGoods(HttpServletRequest request, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            this.logger.error(CODE + ".updateStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreGoodsServiceRepository.updateStoreGoods(whStoreGoodsDomain);
    }

    @RequestMapping(value={"deleteStoreGoods.json"}, name="\u5220\u9664\u4ed3\u5e93\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteStoreGoods(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".deleteStoreGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreGoodsServiceRepository.deleteStoreGoods(storeGoodsId);
    }

    @RequestMapping(value={"queryStoreGoodsPage.json"}, name="\u67e5\u8be2\u4ed3\u5e93\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreGoodsReDomain> queryStoreGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreGoodsPage(param);
    }

    @RequestMapping(value={"updateStoreGoodsState.json"}, name="\u66f4\u65b0\u4ed3\u5e93\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStoreGoodsState(String storeGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)storeGoodsId)) {
            this.logger.error(CODE + ".updateStoreGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreGoodsServiceRepository.updateStoreGoodsState(Integer.valueOf(storeGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryStoreSkuPage.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.remove("tenantCode");
        String memberCode = this.getTeananMemberCode(request);
        param.put("memberCode", memberCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"queryStoreSkuPages.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPages(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"queryStoreSkuPagesByMem.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868-\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPagesByMem(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"updateSendStoreReNum.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSendStoreReNum(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        List whStoreSkuNumBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, WhStoreSkuNumBean.class);
        if (ListUtil.isEmpty((Collection)whStoreSkuNumBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        UserSession session = this.getUserSession(request);
        String memberCcode = session.getUserPcode();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)this.getTenantCode(request));
        if (StringUtils.isBlank((String)memberCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberCode is null");
        }
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            whStoreSkuNumBean.setMemberCode(memberCode);
            whStoreSkuNumBean.setMemberCcode(memberCcode);
        }
        return this.whStoreGoodsServiceRepository.sendUpdateStoreSkuNum(whStoreSkuNumBeanList);
    }

    @RequestMapping(value={"getStoreGoodsById.json"}, name="\u6839\u636eid\u83b7\u53d6\u4ed3\u5e93\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public WhStoreGoodsReDomain getStoreGoodsById(Integer storeGoodsId) {
        if (StringUtils.isBlank((Integer)storeGoodsId)) {
            this.logger.error(CODE + ".getStoreGoodsById", (Object)"param is null");
            return null;
        }
        return this.whStoreGoodsServiceRepository.getStoreGoods(storeGoodsId);
    }

    @RequestMapping(value={"autoSend.json"}, name="\u5e93\u5b58\u540c\u6b65")
    @ResponseBody
    public HtmlJsonReBean autoSend() {
        return this.whStoreGoodsServiceRepository.autoSend();
    }

    @RequestMapping(value={"queryStoreSkuPagesForPlat.json"}, name="\u67e5\u8be2\u5e93\u5b58\u51fa\u5165\u5e93\u8bb0\u5f55SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkuReDomain> queryStoreSkuPagesForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        this.logger.error("param is ------------>", (Object)param);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreGoodsServiceRepository.queryStoreSkuPage(param);
    }

    @RequestMapping(value={"updateSendStoreReNumForRetail.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSendStoreReNumForRetail(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        List whStoreSkuNumBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, WhStoreSkuNumBean.class);
        if (ListUtil.isEmpty((Collection)whStoreSkuNumBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        UserSession session = this.getUserSession(request);
        String memberCcode = session.getUserPcode();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)this.getTenantCode(request));
        if (StringUtils.isBlank((String)memberCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberCode is null");
        }
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            whStoreSkuNumBean.setMemberCode(memberCode);
            whStoreSkuNumBean.setMemberCcode(memberCcode);
        }
        return this.whStoreGoodsServiceRepository.sendUpdateStoreSkuNum(whStoreSkuNumBeanList);
    }

    @RequestMapping(value={"queryReportDataByWh.json"}, name="\u4ed3\u5e93\u62a5\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult queryReportDataByWh(HttpServletRequest request) {
        String merchantCode = this.getMerchantCode(request);
        int whWarningSize = this.queryNumBySup(request, null).getList().size();
        int whWarningSizePm = this.queryNumForPm(request, null).getList().size();
        WhReportDataDomain whReportDataDomain = new WhReportDataDomain();
        whReportDataDomain.setWhWarningSize(whWarningSize);
        whReportDataDomain.setWhWarningSizePm(whWarningSizePm);
        SupQueryResult supQueryResult = new SupQueryResult();
        ArrayList<WhReportDataDomain> list = new ArrayList<WhReportDataDomain>();
        list.add(whReportDataDomain);
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"queryNumBySup.json"}, name="\u5e93\u5b58\u9884\u8b66")
    @ResponseBody
    public SupQueryResult queryNumBySup(HttpServletRequest request, String goodsSupplynum) {
        String merchantCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)goodsSupplynum)) {
            goodsSupplynum = SupDisUtil.getRemot((String)("goodsSupplynum" + merchantCode));
        }
        if (StringUtils.isEmpty((String)goodsSupplynum)) {
            return new SupQueryResult();
        }
        SupDisUtil.set((String)("goodsSupplynum" + merchantCode), (String)goodsSupplynum);
        Map map = this.assemMapMemberParam(request);
        map.put("goodsSupplynum", goodsSupplynum);
        return this.whStoreGoodsServiceRepository.queryNumBySup(map);
    }

    @RequestMapping(value={"queryNumForPm.json"}, name="\u8425\u9500\u5e93\u5b58\u9884\u8b66")
    @ResponseBody
    public SupQueryResult queryNumForPm(HttpServletRequest request, String goodsSupplynum) {
        Map map = this.assemMapMemberParam(request);
        if (StringUtils.isBlank((String)goodsSupplynum)) {
            goodsSupplynum = SupDisUtil.getRemot((String)("goodsSupplynumForPm" + map.get("memberCode")));
        }
        if (StringUtils.isEmpty((String)goodsSupplynum)) {
            return new SupQueryResult();
        }
        HashMap<String, String> pmMap = new HashMap<String, String>();
        pmMap.put("pbCode", "0001");
        pmMap.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.whStoreGoodsServiceRepository.queryPromotionPage(pmMap);
        if (ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".queryNumForPm", (Object)"pmPromotionReDomainList is null");
            return new SupQueryResult();
        }
        HashMap<String, String> rangListMap = new HashMap<String, String>();
        HashMap<String, String> skuWhMap = new HashMap<String, String>();
        ArrayList whStoreSkuReDomainList = new ArrayList();
        for (PmPromotionReDomain pmPromotionReDomain : supQueryResult.getList()) {
            String promotionCode = pmPromotionReDomain.getPromotionCode();
            rangListMap.put("promotionCode", promotionCode);
            rangListMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult DiscountlistSup = this.whStoreGoodsServiceRepository.queryPromotionDiscountlistPage(rangListMap);
            if (ListUtil.isEmpty((Collection)DiscountlistSup.getList())) {
                this.logger.error(CODE + ".queryNumForPm", (Object)"pmPromotionDiscountlistReDomain is null");
                return new SupQueryResult();
            }
            PmPromotionDiscountlistReDomain pmPromotionDiscountlistReDomain = (PmPromotionDiscountlistReDomain)DiscountlistSup.getList().get(0);
            String skuNo = pmPromotionDiscountlistReDomain.getDiscountCode();
            skuWhMap.put("skuNo", skuNo);
            skuWhMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult skuSupQueryResult = this.whStoreGoodsServiceRepository.queryStoreSkuPage(skuWhMap);
            if (((WhStoreSkuReDomain)skuSupQueryResult.getList().get(0)).getGoodsSupplynum().intValue() > Integer.parseInt(goodsSupplynum)) continue;
            whStoreSkuReDomainList.add(skuSupQueryResult.getList().get(0));
        }
        SupQueryResult supQuery = new SupQueryResult();
        supQuery.setList(whStoreSkuReDomainList);
        supQueryResult.setTotal((long)whStoreSkuReDomainList.size());
        return supQuery;
    }

    @RequestMapping(value={"updateSendStoreReNumForPlat.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSendStoreReNumForPlat(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        List whStoreSkuNumBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, WhStoreSkuNumBean.class);
        if (ListUtil.isEmpty((Collection)whStoreSkuNumBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        UserSession session = this.getUserSession(request);
        String memberCcode = session.getUserPcode();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)this.getTenantCode(request));
        if (StringUtils.isBlank((String)memberCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberCode is null");
        }
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            whStoreSkuNumBean.setMemberCode(memberCode);
            whStoreSkuNumBean.setMemberCcode(memberCcode);
        }
        return this.whStoreGoodsServiceRepository.sendUpdateStoreSkuNum(whStoreSkuNumBeanList);
    }

    @RequestMapping(value={"queryWarehouse.json"}, name="\u67e5\u8be2\u5546\u54c1\u5b9e\u65f6\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryWarehouse(HttpServletRequest request, String departNum, String goodsStr) {
        Map map = this.assemMapMemberParam(request);
        map.put("departNum", departNum);
        List WhUserwhReDomainList = this.whStoreGoodsServiceRepository.queryUserwh(map).getList();
        ArrayList<WhStoreGoodsDomain> numList = new ArrayList<WhStoreGoodsDomain>();
        for (WhUserwhReDomain whUserwhReDomain : WhUserwhReDomainList) {
            String[] split = goodsStr.split(",");
            List<String> goodsNoList = Arrays.asList(split);
            List<Map<String, Object>> dmsMap = this.updateGoodsNum(goodsNoList, whUserwhReDomain);
            for (Map<String, Object> warehouseMap : dmsMap) {
                if (warehouseMap.containsKey("time")) {
                    HashMap sendDbMap = new HashMap();
                    sendDbMap.put("tenantCode", map.get("tenantCode"));
                    for (String num : goodsNoList) {
                        sendDbMap.put("goodsEcode", num);
                    }
                    return new HtmlJsonReBean((Object)this.whStoreGoodsServiceRepository.queryStoreGoodsPage(map).getList());
                }
                String available_quantity = String.valueOf(warehouseMap.get("AVAILABLE_QUANTITY"));
                for (WhStoreGoodsDomain whStoreGoods : numList) {
                    if (whStoreGoods.getGoodsEocode().equals(String.valueOf(warehouseMap.get("ITEM_NUM")))) {
                        if (available_quantity.equals("") || available_quantity == null || available_quantity.equals("null")) continue;
                        double valueNum = Double.parseDouble(available_quantity);
                        BigDecimal goodsSupplynum = whStoreGoods.getGoodsSupplynum();
                        double v = goodsSupplynum.doubleValue();
                        BigDecimal warehouseNum = BigDecimal.valueOf(valueNum + v);
                        whStoreGoods.setGoodsSupplynum(warehouseNum);
                        continue;
                    }
                    WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
                    whStoreGoodsDomain.setGoodsEocode(String.valueOf(warehouseMap.get("ITEM_NUM")));
                    if (!available_quantity.equals("") && available_quantity != null && !available_quantity.equals("null")) {
                        double valueNum = Double.parseDouble(available_quantity);
                        BigDecimal warehouseNum = BigDecimal.valueOf(valueNum);
                        whStoreGoodsDomain.setGoodsSupplynum(warehouseNum);
                    }
                    numList.add(whStoreGoodsDomain);
                }
            }
        }
        return new HtmlJsonReBean(numList);
    }

    public List<Map<String, Object>> updateGoodsNum(List goodsNoList, WhUserwhReDomain whUserwhDomainByDb) {
        int j;
        ArrayList sendMapList;
        List rsList;
        Double l = goodsNoList.size();
        double size = l / 50.0;
        int ceil = (int)Math.ceil(size);
        int i = 1;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        String num = whUserwhDomainByDb.getMemberCode();
        sendMap.put("inventory_num", num);
        this.logger.error("ceil ===" + ceil);
        if (ceil > i) {
            rsList = goodsNoList.subList((i - 1) * 50, i * 50 - 1);
            sendMapList = new ArrayList();
            for (j = 0; j < rsList.size(); ++j) {
                HashMap sendMapCh = new HashMap();
                sendMapCh.put("item_num", rsList.get(j));
                sendMapList.add(sendMapCh);
            }
            sendMap.put("item_num_list", sendMapList);
        } else if (ceil == i) {
            this.logger.error("\u6e2c\u8a66\u9032\u4f86");
            rsList = goodsNoList.subList((i - 1) * 50, goodsNoList.size() - 1);
            sendMapList = new ArrayList();
            for (j = 0; j < rsList.size(); ++j) {
                HashMap sendMapCh = new HashMap();
                sendMapCh.put("item_num", rsList.get(j));
                sendMapList.add(sendMapCh);
            }
            sendMap.put("item_num_list", sendMapList);
        } else {
            return null;
        }
        List jsonToList = null;
        this.logger.error(sendMap + "sendMap");
        Map<String, Object> ResultMap = this.webUtilRequest(sendMap);
        if (ResultMap.get("time").equals("out") || ResultMap.get("returncode").equals("0")) {
            jsonToList.add(ResultMap);
        }
        this.logger.error("ResultMap===" + ResultMap);
        Object data = ResultMap.get("data");
        jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(data), Map.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error("updateGoodsNum.resourceResult", (Object)"resourceResult is null");
        }
        return jsonToList;
    }

    public Map<String, Object> webUtilRequest(Map<String, Object> sendhttpParam) {
        String finalUrl = "http://47.111.186.163:8080/eOrder/rest/gateway/masterdata/onhandinventory";
        try {
            String json = WebUtils.doPostByJson((String)finalUrl, sendhttpParam, (int)5000, (int)5000);
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            return jsonToMap;
        }
        catch (IOException e) {
            HashMap<String, Object> timeMap = new HashMap<String, Object>();
            timeMap.put("time", "out");
            return timeMap;
        }
    }
}

