/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wh.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.wh.domain.WhOpstoreDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhOpstoreGoodsDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhOpstoreReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhOpstoreSkuDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhOpstoreSkuReDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreGoodsDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhStoreSkuDomain;
import com.qjsoft.laser.controller.facade.wh.domain.WhWarehouseReDomain;
import com.qjsoft.laser.controller.facade.wh.repository.WhOpstoreServiceRepository;
import com.qjsoft.laser.controller.facade.wh.repository.WhStoreGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.wh.repository.WhWarehouseServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class WhOpstoreComCon
extends SpringmvcController {
    private static String CODE = "wh.opstore.con";
    @Autowired
    private WhOpstoreServiceRepository whOpstoreServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private WhStoreGoodsServiceRepository whStoreGoodsServiceRepository;
    @Autowired
    private WhWarehouseServiceRepository whWarehouseServiceRepository;

    protected String getContext() {
        return "opstore";
    }

    public String make(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            return "error";
        }
        if (ListUtil.isEmpty((Collection)whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty((Collection)whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return "error";
        }
        if (ListUtil.isNotEmpty((Collection)whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty((Collection)whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            HashMap<String, WhOpstoreGoodsDomain> goodsmap = new HashMap<String, WhOpstoreGoodsDomain>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", whOpstoreDomain.getTenantCode());
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
                ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)goodsmap.get(whOpstoreSkuDomain.getGoodsCode());
                if (null == whOpstoreGoodsDomain) {
                    map.put("goodsCode", whOpstoreSkuDomain.getGoodsCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                    if (null == rsResourceGoodsReDomain) {
                        return "error:" + ((Object)map).toString();
                    }
                    whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)rsResourceGoodsReDomain);
                    }
                    catch (Exception e) {
                        return "error1:" + ((Object)map).toString();
                    }
                    goodsmap.put(whOpstoreSkuDomain.getGoodsCode(), whOpstoreGoodsDomain);
                }
                if (null == (whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                    whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
                    whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
                }
                whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
            }
            if (MapUtil.isEmpty(goodsmap)) {
                return "error3";
            }
            ArrayList whOpstoreGoodsDomainList = new ArrayList();
            for (String goodsCode : goodsmap.keySet()) {
                whOpstoreGoodsDomainList.add(goodsmap.get(goodsCode));
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal weight = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal mainnum = BigDecimal.ZERO;
        BigDecimal mainweight = BigDecimal.ZERO;
        BigDecimal mainamt = BigDecimal.ZERO;
        for (WhOpstoreGoodsDomain whOpstoreGoodsReDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            num = BigDecimal.ZERO;
            weight = BigDecimal.ZERO;
            amt = BigDecimal.ZERO;
            for (WhOpstoreSkuDomain whOpstoreSkuReDomain : whOpstoreGoodsReDomain.getWhOpstoreSkuDomainList()) {
                if (null == whOpstoreSkuReDomain.getGoodsNum()) {
                    whOpstoreSkuReDomain.setGoodsNum(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getGoodsWeight()) {
                    whOpstoreSkuReDomain.setGoodsWeight(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getPricesetNprice()) {
                    whOpstoreSkuReDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                num = num.add(whOpstoreSkuReDomain.getGoodsNum());
                weight = weight.add(whOpstoreSkuReDomain.getGoodsWeight());
                amt = amt.add(whOpstoreSkuReDomain.getPricesetNprice().multiply(whOpstoreSkuReDomain.getGoodsNum()));
            }
            whOpstoreGoodsReDomain.setGoodsNum(num);
            whOpstoreGoodsReDomain.setGoodsWeight(weight);
            mainnum = mainnum.add(num);
            mainweight = mainweight.add(weight);
            mainamt = mainamt.add(amt);
        }
        whOpstoreDomain.setGoodsNum(mainnum);
        whOpstoreDomain.setGoodsWeight(mainweight);
        whOpstoreDomain.setGoodsAmt(mainamt);
        return null;
    }

    protected HtmlJsonReBean saveOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error(CODE + ".saveOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession");
        }
        whOpstoreDomain.setMemberCode(userSession.getUserPcode());
        whOpstoreDomain.setMemberName(userSession.getMerberCompname());
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        String msg = this.make(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
        }
        return this.whOpstoreServiceRepository.saveOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean saveOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error(CODE + ".saveOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        return this.saveOpstoreMain(request, whOpstoreDomain);
    }

    protected HtmlJsonReBean updateOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error(CODE + ".updateOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreServiceRepository.updateOpstore(whOpstoreDomain);
    }

    protected WhOpstoreReDomain getOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error(CODE + ".getOpstoreMain", (Object)"param is null");
            return null;
        }
        return this.whOpstoreServiceRepository.getOpstore(opstoreId);
    }

    protected HtmlJsonReBean updateOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error(CODE + ".updateOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreServiceRepository.updateOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean deleteOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error(CODE + ".deleteOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreServiceRepository.deleteOpstore(opstoreId);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageCom(HttpServletRequest request, String storeGoodsBtype) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)((String)param.get("storeGoodsBtype")))) {
                storeGoodsBtype = param.get("storeGoodsBtype").toString();
            }
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreServiceRepository.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageMain(HttpServletRequest request, String storeGoodsBtype) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreServiceRepository.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreSkuReDomain> queryOpstoreSkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whOpstoreServiceRepository.queryOpstoreSkuPage(param);
    }

    protected HtmlJsonReBean updateOpstoreStateMain(String opstoreId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opstoreId)) {
            this.logger.error(CODE + ".updateOpstoreStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreServiceRepository.updateOpstoreState(Integer.valueOf(opstoreId), dataState, oldDataState, null);
    }

    protected HtmlJsonReBean saveOpstoreStrMainStr(HttpServletRequest request, String whStoreDomainStr) {
        if (StringUtils.isBlank((String)whStoreDomainStr)) {
            this.logger.error(CODE + ".saveOpstoreStrMainStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSkuDomain skuDomain = (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(whStoreDomainStr, RsSkuDomain.class);
        if (null == skuDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuDomain");
        }
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult whWarehouseReDo = this.whWarehouseServiceRepository.queryWarehousePage(map);
        if (null == whWarehouseReDo || ListUtil.isEmpty((Collection)whWarehouseReDo.getList())) {
            this.logger.error(CODE + ".saveOpstoreStrMainStr", (Object)"whWarehouseReDo is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ed3\u5e93\u4e3a\u7a7a");
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)skuDomain);
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)skuDomain);
            whStoreSkuDomain.setTenantCode(this.getTenantCode(request));
            whStoreGoodsDomain.setTenantCode(this.getTenantCode(request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.put("skuNo", skuDomain.getSkuNo());
        ArrayList<WhStoreSkuDomain> skuList = new ArrayList<WhStoreSkuDomain>();
        for (WhWarehouseReDomain warehouseReDomain : whWarehouseReDo.getList()) {
            whStoreSkuDomain.setWarehouseCode(warehouseReDomain.getWarehouseCode());
            whStoreSkuDomain.setWarehouseName(warehouseReDomain.getWarehouseName());
            whStoreGoodsDomain.setWarehouseCode(warehouseReDomain.getWarehouseCode());
            whStoreGoodsDomain.setWarehouseName(warehouseReDomain.getWarehouseName());
            map.put("warehouseCode", warehouseReDomain.getWarehouseCode());
            SupQueryResult whStoreGoodsReDoSup = this.whStoreGoodsServiceRepository.queryStoreGoodsPage(map);
            if (null != whStoreGoodsReDoSup && ListUtil.isNotEmpty((Collection)whStoreGoodsReDoSup.getList())) {
                this.logger.error(CODE + ".saveOpstoreStrMainStr", (Object)"whStoreGoodsReDoSup is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0b\u5355bom\u91cd\u590d\uff0c\u4e0b\u5355bom\u5df2\u5165\u5e93" + warehouseReDomain.getWarehouseName());
            }
            map.put("warehouseCode", warehouseReDomain.getWarehouseCode());
            SupQueryResult whStoreSkuReDoSup = this.whStoreGoodsServiceRepository.queryStoreSkuPage(map);
            if (null != whStoreSkuReDoSup && ListUtil.isNotEmpty((Collection)whStoreSkuReDoSup.getList())) {
                this.logger.error(CODE + ".saveOpstoreStrMainStr", (Object)"whStoreSkuReDoSup is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0b\u5355bom\u91cd\u590d\uff0c\u4e0b\u5355bom\u5df2\u5165\u5e93" + warehouseReDomain.getWarehouseName());
            }
            skuList.add(whStoreSkuDomain);
            whStoreGoodsDomain.setWhStoreSkuDomainList(skuList);
            this.whStoreGoodsServiceRepository.saveStoreGoods(whStoreGoodsDomain);
        }
        return new HtmlJsonReBean();
    }
}

