/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.crp.CrpUrechargeDomain;
import cn.com.qj.bff.domain.crp.CrpUrechargeReDomain;
import cn.com.qj.bff.domain.crp.CrpUrechargelistDomain;
import cn.com.qj.bff.domain.mh.ActiveDomain;
import cn.com.qj.bff.domain.mh.ActiveRebateDomain;
import cn.com.qj.bff.domain.reb.RebPointsConfDomain;
import cn.com.qj.bff.domain.reb.RebPointsConfReDomain;
import cn.com.qj.bff.domain.reb.RebPointsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleReDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.vd.VdFaccountOuterDomain;
import cn.com.qj.bff.domain.vd.VdFaccountOuterDtDomain;
import cn.com.qj.bff.domain.vd.VdFaccountOuterSubsetReDomain;
import cn.com.qj.bff.service.crp.CrpUrechargeService;
import cn.com.qj.bff.service.crp.CrpUrechargelistService;
import cn.com.qj.bff.service.mh.ExService;
import cn.com.qj.bff.service.nm.NmNoService;
import cn.com.qj.bff.service.reb.RebPointsGoodsService;
import cn.com.qj.bff.service.reb.RebPointsService;
import cn.com.qj.bff.service.reb.RebPointsUsersService;
import cn.com.qj.bff.service.reb.RebPointsuserService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.vd.VdFaccountOuterService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/points"}, name="\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
public class RebPointsCon
extends SpringmvcController {
    private static String CODE = "reb.points.con";
    @Autowired
    private RebPointsuserService rebPointsuserService;
    @Autowired
    private RebPointsService rebPointsService;
    @Autowired
    RebPointsGoodsService rebPointsGoodsService;
    @Autowired
    RebPointsUsersService rebPointsUsersService;
    @Autowired
    NmNoService nmNoService;
    @Autowired
    ExService exService;
    @Autowired
    private VdFaccountOuterService vdFaccountOuterService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrpUrechargeService crpUrechargeService;
    @Autowired
    private CrpUrechargelistService crpUrechargelistService;

    @Override
    protected String getContext() {
        return "points";
    }

    @RequestMapping(value={"savePoints.json"}, name="\u589e\u52a0\u8fd4\u5229\u5f00\u542f")
    @ResponseBody
    public HtmlJsonReBean savePoints(HttpServletRequest request, String rebPointsDomainStr) {
        List<RebPointsUsersDomain> rebPointsUsersDomainList;
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".savePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        if (null == rebPointsDomain.getUpointsType()) {
            rebPointsDomain.setUpointsType("2");
            rebPointsDomain.setDataState(1);
            HashMap<String, Object> pointsParam = new HashMap<String, Object>();
            pointsParam.put("tenantCode", this.getTenantCode(request));
            pointsParam.put("channelCode", rebPointsDomain.getChannelCode());
            pointsParam.put("upointsType", "2");
            SupQueryResult<RebPointsReDomain> supQueryResult = this.rebPointsService.queryPointsPage(pointsParam);
            if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                this.logger.error(CODE + ".savePoints", (Object)"\u6e20\u9053\u89c4\u5219\u5df2\u5b58\u5728");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u89c4\u5219\u5df2\u5b58\u5728");
            }
        }
        String rebPointsCode = this.nmNoService.createMaxBillNumber(null, "RebPoints", "rebPoints", this.getTenantCode(request));
        if ("1".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FL" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        } else if ("2".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FYSQ" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        } else if ("3".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FYHX" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        }
        rebPointsDomain.setPointsStart("0");
        rebPointsDomain.setPointsCode(rebPointsCode);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        DisChannel disChannel = this.getChannelModel(rebPointsDomain.getChannelCode(), request);
        if (null != disChannel) {
            rebPointsDomain.setGoodsClass(disChannel.getGoodsClass());
            rebPointsDomain.setMemberMcode(disChannel.getMemberMcode());
            rebPointsDomain.setMemberMname(disChannel.getMemberMname());
        }
        UserSession userSession = this.getUserSession(request);
        rebPointsDomain.setMemberCode(userSession.getMemberCode());
        rebPointsDomain.setMemberName(userSession.getUserName());
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.savePoints(rebPointsDomain);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(rebPointsCode);
                rebPointsGoodsDomain.setTenantCode(rebPointsDomain.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        if (ListUtil.isNotEmpty(rebPointsUsersDomainList = rebPointsDomain.getRebPointsUsersDomainList())) {
            for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                rebPointsUsersDomain.setPointsCode(rebPointsCode);
                rebPointsUsersDomain.setTenantCode(rebPointsDomain.getTenantCode());
            }
            this.rebPointsUsersService.saveRebPointsUsersBatch(rebPointsUsersDomainList);
        }
        if (rebPointsDomain.getUpointsType().equals("2")) {
            this.rebPointsService.queryPointsCache();
        }
        return htmlJsonReBean;
    }

    private ActiveDomain createActive(RebPointsDomain rebPointsDomain) {
        ActiveDomain activeDomain = new ActiveDomain();
        Date date = new Date();
        activeDomain.setGrantNo(rebPointsDomain.getPointsCode());
        activeDomain.setApplyDate(date);
        activeDomain.setApplyDepart(rebPointsDomain.getPointsUserqua());
        activeDomain.setApplyPerson(rebPointsDomain.getMemberName());
        activeDomain.setBrandName(rebPointsDomain.getFchannelClassifyName());
        activeDomain.setStartTime(rebPointsDomain.getPointsStartdate());
        activeDomain.setEndTime(rebPointsDomain.getPointsEstartdate());
        activeDomain.setTenantCode(rebPointsDomain.getTenantCode());
        activeDomain.setGrantType(rebPointsDomain.getFundType());
        activeDomain.setAttachUrl(rebPointsDomain.getFchannelName());
        activeDomain.setApplayNo(rebPointsDomain.getPointsPcvalue());
        ActiveRebateDomain activeRebate = new ActiveRebateDomain();
        activeRebate.setRebPointsGoodsDomainList(rebPointsDomain.getRebPointsGoodsDomainList());
        activeRebate.setRebType(rebPointsDomain.getPointsDatetype());
        activeRebate.setComplianceRebType(rebPointsDomain.getPointsDatatype());
        activeRebate.setUpointsName(rebPointsDomain.getUpointsName());
        activeRebate.setActiveFeeRemark(rebPointsDomain.getPointsRemark());
        activeDomain.setActiveRebate(activeRebate);
        return activeDomain;
    }

    @RequestMapping(value={"getPoints.json"}, name="\u83b7\u53d6\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u4fe1\u606f")
    @ResponseBody
    public RebPointsReDomain getPoints(HttpServletRequest request, Integer pointsId, String pointsCode) {
        RebPointsReDomain points = null;
        points = null != pointsCode ? this.rebPointsService.getPointsByCode(this.getTenantCode(request), pointsCode) : this.rebPointsService.getPoints(pointsId);
        if (points == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", points.getTenantCode());
        map.put("pointsCode", points.getPointsCode());
        ArrayList<RebPointsGoodsDomain> rebPointsGoodsDomainList = new ArrayList<RebPointsGoodsDomain>();
        SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(map);
        if (rebPointsGoodsReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsGoodsReDomainSupQueryResult.getList())) {
            rebPointsGoodsDomainList.addAll(rebPointsGoodsReDomainSupQueryResult.getList());
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsReDomainSupQueryResult.getList()) {
                rebPointsGoodsDomain.setChannelCode(points.getChannelCode());
                rebPointsGoodsDomain.setChannelName(points.getChannelName());
            }
        }
        points.setRebPointsGoodsDomainList(rebPointsGoodsDomainList);
        SupQueryResult<RebPointsUsersReDomain> rebPointsUsersDomainSupQueryResult = this.rebPointsUsersService.queryPointsUsersPage(map);
        if (rebPointsUsersDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsUsersDomainSupQueryResult.getList())) {
            ArrayList<RebPointsUsersDomain> rebPointsUsersDomainList = new ArrayList<RebPointsUsersDomain>(rebPointsUsersDomainSupQueryResult.getList());
            points.setRebPointsUsersDomainList(rebPointsUsersDomainList);
        }
        return points;
    }

    @RequestMapping(value={"updatePoints.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePoints(HttpServletRequest request, String rebPointsDomainStr) {
        List<RebPointsUsersDomain> rebPointsUsersDomainList;
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsReDomain rebPointsDomain = (RebPointsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsReDomain.class);
        RebPointsReDomain getById = this.rebPointsService.getPoints(rebPointsDomain.getPointsId());
        getById.setTenantCode(this.getTenantCode(request));
        ((RebPointsDomain)getById).setDataState(0);
        getById.setPointsUserqua(rebPointsDomain.getPointsUserqua());
        getById.setPointsDatatype(rebPointsDomain.getPointsDatatype());
        getById.setFchannelName(rebPointsDomain.getFchannelName());
        getById.setUpointsName(rebPointsDomain.getUpointsName());
        getById.setChannelCode(rebPointsDomain.getChannelCode());
        getById.setChannelName(rebPointsDomain.getChannelName());
        getById.setPointsDatetype(rebPointsDomain.getPointsDatetype());
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.updatePoints(getById);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        this.rebPointsGoodsService.deletePointsGoodsByPointsCode(this.getTenantCode(request), getById.getPointsCode());
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(getById.getPointsCode());
                rebPointsGoodsDomain.setTenantCode(getById.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("pointsCode", getById.getPointsCode());
        SupQueryResult<RebPointsUsersReDomain> rebPointsUsersDomainSupQueryResult = this.rebPointsUsersService.queryPointsUsersPage(map);
        if (null != rebPointsUsersDomainSupQueryResult && CollectionUtils.isNotEmpty((Collection)rebPointsUsersDomainSupQueryResult.getList())) {
            for (RebPointsUsersReDomain rebPointsUsersReDomain : rebPointsUsersDomainSupQueryResult.getList()) {
                this.rebPointsUsersService.deleteRebPointsUsers(rebPointsUsersReDomain.getPointsUserId());
            }
        }
        if (CollectionUtils.isNotEmpty(rebPointsUsersDomainList = rebPointsDomain.getRebPointsUsersDomainList())) {
            for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                rebPointsUsersDomain.setPointsCode(getById.getPointsCode());
                rebPointsUsersDomain.setTenantCode(getById.getTenantCode());
            }
            this.rebPointsUsersService.saveRebPointsUsersBatch(rebPointsUsersDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deletePoints.json"}, name="\u5220\u9664\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean deletePoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deletePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryPointsPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("channelCode");
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsState.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState, null);
        if (htmlJsonReBean.isSuccess()) {
            this.rebPointsService.queryPointsCache();
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updatePointsUstart.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsUstart(String pointsId, Integer pointsUstart, Integer oldPointsUstart) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsUstart", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.updatePointsUstartState(Integer.valueOf(pointsId), pointsUstart, oldPointsUstart, null);
    }

    @RequestMapping(value={"queryPointsPageStr.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPageStr(HttpServletRequest request, String channelCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("channelCode");
        param.put("memberMcode", this.getMemberCode(this.getChannelCode(request), request));
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsStr.json"}, name="\u66f4\u65b0\u8fd4\u5229\u89c4\u5219  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePointsStr(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        RebPointsReDomain getById = this.rebPointsService.getPoints(rebPointsDomain.getPointsId());
        getById.setPointsRatio(rebPointsDomain.getPointsRatio());
        getById.setTenantCode(this.getTenantCode(request));
        getById.setPointsGoodsScope(rebPointsDomain.getPointsGoodsScope());
        this.rebPointsGoodsService.deletePointsGoodsByPointsCode(this.getTenantCode(request), getById.getPointsCode());
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(getById.getPointsCode());
                rebPointsGoodsDomain.setTenantCode(getById.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        return this.rebPointsService.updatePoints(getById);
    }

    @RequestMapping(value={"queryPointsRulePage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u8bbe\u7f6e\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<RebPointsRuleReDomain> queryPointsRulePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsRulePage(param);
    }

    @RequestMapping(value={"updatePointsRule.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsRule(HttpServletRequest request, String rebPointsRuleDomainStr) {
        if (StringUtils.isBlank((String)rebPointsRuleDomainStr)) {
            this.logger.error(CODE + ".updatePointsRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsRuleDomain rebPointsRuleDomain = (RebPointsRuleDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsRuleDomainStr, RebPointsRuleDomain.class);
        rebPointsRuleDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePointsRule(rebPointsRuleDomain);
    }

    @RequestMapping(value={"queryPointsConfPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u8bbe\u7f6e\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<RebPointsConfReDomain> queryPointsConfPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsConfPage(param);
    }

    @RequestMapping(value={"updatePointsConf.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsConf(HttpServletRequest request, String rebPointsConfDomainStr) {
        if (StringUtils.isBlank((String)rebPointsConfDomainStr)) {
            this.logger.error(CODE + ".updatePointsRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsConfDomain rebPointsConfDomain = (RebPointsConfDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsConfDomainStr, RebPointsConfDomain.class);
        rebPointsConfDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePointsConf(rebPointsConfDomain);
    }

    @RequestMapping(value={"updatePointsConfSkuList.json"}, name="\u4fee\u6539\u8fd4\u5229\u5546\u54c1\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsConfSkuList(HttpServletRequest request, String rebPointsGoodsDomains) {
        if (StringUtils.isBlank((String)rebPointsGoodsDomains)) {
            this.logger.error(CODE + ".updatePointsConfSkuList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rebPointsGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(rebPointsGoodsDomains, RebPointsGoodsDomain.class);
        if (CollectionUtils.isNotEmpty((Collection)rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setTenantCode(this.getTenantCode(request));
            }
            this.rebPointsGoodsService.deletePointsGoodsByPointsCode(this.getTenantCode(request), ((RebPointsGoodsDomain)rebPointsGoodsDomainList.get(0)).getPointsCode());
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updatePointsConfState.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsConfState(HttpServletRequest request, Integer pointsConfId, Integer dataState) {
        return this.rebPointsService.updatePointsConfState(pointsConfId, dataState, null, new HashMap<String, Object>());
    }

    @RequestMapping(value={"updateFYHXPointsStateSuccess.json"}, name="\u8d39\u7528\u6838\u9500\u5ba1\u6838\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean updateFYHXPointsStateSuccess(HttpServletRequest request, String pointsIdStr) {
        if (null == pointsIdStr) {
            this.logger.error(CODE + ".updateFYHXPointsStateSuccess", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] pointsIdList = pointsIdStr.split(",");
        HtmlJsonReBean htmlJsonReBean = null;
        for (String pointsIds : pointsIdList) {
            int pointsId = Integer.parseInt(pointsIds);
            RebPointsReDomain rebPointsDomain = this.rebPointsService.getPoints(pointsId);
            if (null == rebPointsDomain) {
                this.logger.error(CODE + ".updateFYHXPointsStateSuccess.rebPointsDomain", (Object)("rebPointsDomain is null==" + pointsId));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            htmlJsonReBean = this.rebPointsService.updatePointsState(pointsId, 1, ((RebPointsDomain)rebPointsDomain).getDataState(), new HashMap<String, Object>());
            if (!htmlJsonReBean.isSuccess() && !rebPointsDomain.getFundType().equals("3")) continue;
            if (rebPointsDomain.getPointsDatetype().equals("1")) {
                htmlJsonReBean = this.rebPointsService.sendUpointsClearToFy(rebPointsDomain);
            }
            HashMap<String, Object> usersMap = new HashMap<String, Object>();
            usersMap.put("pointsCode", rebPointsDomain.getPointsCode());
            usersMap.put("tenantCode", rebPointsDomain.getTenantCode());
            SupQueryResult<RebPointsUsersReDomain> queryPointsUsersPage = this.rebPointsUsersService.queryPointsUsersPage(usersMap);
            if (null == queryPointsUsersPage || !ListUtil.isNotEmpty((Collection)queryPointsUsersPage.getList())) continue;
            for (RebPointsUsersReDomain rebPointsUsersReDomain : queryPointsUsersPage.getList()) {
                if (rebPointsDomain.getPointsDatetype().equals("2")) {
                    htmlJsonReBean = this.saveUrechargeByFy(rebPointsUsersReDomain);
                }
                if (!rebPointsDomain.getPointsDatetype().equals("3")) continue;
                htmlJsonReBean = this.vdFaccountOuterByFY(rebPointsUsersReDomain);
            }
        }
        return htmlJsonReBean;
    }

    private HtmlJsonReBean vdFaccountOuterByFY(RebPointsUsersReDomain rebPointsUsersReDomain) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (rebPointsUsersReDomain.getPointsuserUserRatio() != null && rebPointsUsersReDomain.getPointsuserUserRatio().compareTo(BigDecimal.ZERO) != 0) {
            String userinfoCode = rebPointsUsersReDomain.getPointsUserOp();
            String type = userinfoCode.substring(0, 1);
            String fundType = "01";
            String basic = type + fundType;
            VdFaccountOuterDtDomain vdFaccountOuterDtDomain = new VdFaccountOuterDtDomain();
            HashMap<String, Object> vdMap = new HashMap<String, Object>();
            vdMap.put("merchantCode", rebPointsUsersReDomain.getPointsUserOp());
            vdMap.put("tenantCode", rebPointsUsersReDomain.getTenantCode());
            vdMap.put("faccountType", basic);
            SupQueryResult<VdFaccountOuterDomain> vdFaccountInfoQueryResult = this.vdFaccountOuterService.queryFaccountOuterPageNew(vdMap);
            if (vdFaccountInfoQueryResult != null && CollectionUtils.isNotEmpty((Collection)vdFaccountInfoQueryResult.getList())) {
                this.logger.info(CODE + ".vdFaccountOuterByFY", (Object)JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInfoQueryResult.getList()));
                VdFaccountOuterDomain vdFaccountOuterDomain = (VdFaccountOuterDomain)vdFaccountInfoQueryResult.getList().get(0);
                HashMap<String, Object> vdSubMap = new HashMap<String, Object>();
                vdSubMap.put("faccountOuterNo", vdFaccountOuterDomain.getFaccountOuterNo());
                vdSubMap.put("fundType", vdFaccountOuterDomain.getFundType());
                SupQueryResult<VdFaccountOuterSubsetReDomain> vdFaccountOuterSubsetQueryResult = this.vdFaccountOuterService.queryFaccountOuterSubsetPage(vdSubMap);
                if (vdFaccountOuterSubsetQueryResult == null || CollectionUtils.isEmpty((Collection)vdFaccountOuterSubsetQueryResult.getList())) {
                    this.logger.error(CODE + ".vdFaccountOuterByFY", (Object)("DMS\u672a\u627e\u5230\u8d26\u6237\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson(vdSubMap)));
                    return new HtmlJsonReBean(CODE + ".activeAudit.getBrandByName.msg", "DMS\u672a\u627e\u5230\u8d26\u6237\u4fe1\u606f");
                }
                VdFaccountOuterSubsetReDomain vdFaccountOuterSubset = (VdFaccountOuterSubsetReDomain)vdFaccountOuterSubsetQueryResult.getList().get(0);
                BigDecimal faccountAmount = vdFaccountOuterSubset.getFaccountAmount();
                vdFaccountOuterSubset.setFaccountAmount(vdFaccountOuterSubset.getFaccountAmount().add(rebPointsUsersReDomain.getPointsuserUserRatio()));
                htmlJsonReBean = this.vdFaccountOuterService.updateFaccountOuterSubset(vdFaccountOuterSubset);
                vdFaccountOuterDtDomain.setFaccountBfamount(faccountAmount);
                vdFaccountOuterDtDomain.setFaccountAfamount(vdFaccountOuterSubset.getFaccountAmount());
                try {
                    vdFaccountOuterDtDomain.setFaccountingDate(DateUtils.parseDateToString((Date)new Date(), (String)"yyyyMMdd"));
                }
                catch (ParseException e) {
                    this.logger.error(CODE + ".vdFaccountOuterByFY", (Throwable)e);
                }
                vdFaccountOuterDtDomain.setFaccountOuterNo(vdFaccountOuterDomain.getFaccountOuterNo());
                vdFaccountOuterDtDomain.setFaccountOuterName("\u57fa\u672c\u6237");
                vdFaccountOuterDtDomain.setFaccountTitileCode("2001002001");
                vdFaccountOuterDtDomain.setBusinessOrderno(rebPointsUsersReDomain.getPointsCode());
                vdFaccountOuterDtDomain.setCurrencyCode("01");
                vdFaccountOuterDtDomain.setFundType("01");
                if (rebPointsUsersReDomain.getPointsuserUserRatio().compareTo(BigDecimal.ZERO) > 0) {
                    vdFaccountOuterDtDomain.setOrderDc("2");
                } else {
                    vdFaccountOuterDtDomain.setOrderDc("1");
                }
                vdFaccountOuterDtDomain.setOrderAmount(rebPointsUsersReDomain.getPointsuserUserRatio());
                vdFaccountOuterDtDomain.setTenantCode(vdFaccountOuterDomain.getTenantCode());
                vdFaccountOuterDtDomain.setBusinessType("1");
                vdFaccountOuterDtDomain.setTxnDscpt(vdFaccountOuterDomain.getFaccountReqno());
                htmlJsonReBean = this.vdFaccountOuterService.saveFaccountOuterDt(vdFaccountOuterDtDomain);
            }
        }
        return htmlJsonReBean;
    }

    private HtmlJsonReBean saveUrechargeByFy(RebPointsUsersReDomain rebPointsUsersReDomain) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (rebPointsUsersReDomain.getPointsuserUserRatio() != null && rebPointsUsersReDomain.getPointsuserUserRatio().compareTo(BigDecimal.ZERO) != 0) {
            HashMap<String, Object> userJson = new HashMap<String, Object>();
            userJson.put("userinfoCode", rebPointsUsersReDomain.getPointsUserOp());
            userJson.put("tenantCode", rebPointsUsersReDomain.getTenantCode());
            String userinfoCode = rebPointsUsersReDomain.getPointsUserOp();
            SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainQueryResult = this.userService.queryUserinfoPage(userJson);
            if (umUserinfoReDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)umUserinfoReDomainQueryResult.getList()) && StringUtils.isNotBlank((String)((UmUserinfoReDomainBean)umUserinfoReDomainQueryResult.getList().get(0)).getUserinfoUcode())) {
                userinfoCode = ((UmUserinfoReDomainBean)umUserinfoReDomainQueryResult.getList().get(0)).getUserinfoUcode();
            }
            HashMap<String, Object> crpMap = new HashMap<String, Object>();
            crpMap.put("userinfoCode", userinfoCode);
            crpMap.put("tenantCode", rebPointsUsersReDomain.getTenantCode());
            crpMap.put("rechargeMode", "0");
            SupQueryResult<CrpUrechargeReDomain> queryResult = this.crpUrechargeService.queryCrpUrechargePage(crpMap);
            if (queryResult != null && CollectionUtils.isNotEmpty((Collection)queryResult.getList())) {
                CrpUrechargeDomain crpUrechargeDomain = (CrpUrechargeDomain)queryResult.getList().get(0);
                BigDecimal smoney = crpUrechargeDomain.getRechargeSmoney();
                crpUrechargeDomain.setRechargeAllmoney(crpUrechargeDomain.getRechargeSmoney().add(rebPointsUsersReDomain.getPointsuserUserRatio()));
                crpUrechargeDomain.setRechargeSmoney(crpUrechargeDomain.getRechargeSmoney().add(rebPointsUsersReDomain.getPointsuserUserRatio()));
                this.crpUrechargeService.updateCrpUrecharge(crpUrechargeDomain);
                CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
                if (rebPointsUsersReDomain.getPointsuserUserRatio().compareTo(BigDecimal.ZERO) > 0) {
                    crpUrechargelistDomain.setUrechargelistDir("2");
                    crpUrechargelistDomain.setBankcardCode("Credit");
                } else {
                    crpUrechargelistDomain.setRechargeName10("1");
                    crpUrechargelistDomain.setUrechargelistDir("1");
                }
                crpUrechargelistDomain.setRechargeOpno(rebPointsUsersReDomain.getPointsCode());
                crpUrechargelistDomain.setRechargeAllmoney(smoney);
                crpUrechargelistDomain.setRechargeSmoney(crpUrechargeDomain.getRechargeSmoney());
                crpUrechargelistDomain.setRechargeType("1");
                crpUrechargelistDomain.setUserinfoCode(rebPointsUsersReDomain.getPointsUserOp());
                crpUrechargelistDomain.setUserinfoName(rebPointsUsersReDomain.getPointsUserName());
                crpUrechargelistDomain.setRechargeOpno4(crpUrechargeDomain.getRechargeName1());
                crpUrechargelistDomain.setTenantCode(crpUrechargeDomain.getTenantCode());
                htmlJsonReBean = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateFYHXPointsStateNoPass.json"}, name="\u8d39\u7528\u6838\u9500\u5ba1\u6838\u62d2\u7edd")
    @ResponseBody
    public HtmlJsonReBean updateFYHXPointsStateNoPass(HttpServletRequest request, String pointsIdStr) {
        if (null == pointsIdStr) {
            this.logger.error(CODE + ".updateFYHXPointsStateSuccess", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] pointsIdList = pointsIdStr.split(",");
        HtmlJsonReBean htmlJsonReBean = null;
        for (String pointsIds : pointsIdList) {
            int pointsId = Integer.parseInt(pointsIds);
            RebPointsReDomain rebPointsDomain = this.rebPointsService.getPoints(pointsId);
            if (null == rebPointsDomain) {
                this.logger.error(CODE + ".updateFYHXPointsStateSuccess.rebPointsDomain", (Object)("rebPointsDomain is null==" + pointsId));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            htmlJsonReBean = this.rebPointsService.updatePointsState(pointsId, 2, ((RebPointsDomain)rebPointsDomain).getDataState(), new HashMap<String, Object>());
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            this.logger.error(CODE + ".updateFYHXPointsStateSuccess", (Object)("updateFYHXPointsStateSuccess is error==" + pointsId));
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }
}

