/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractproDomain;
import cn.com.qj.bff.domain.oc.OcContractproReDomain;
import cn.com.qj.bff.service.oc.OcContractEngineService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcContractproService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractpro"}, name="\u8ba2\u5355\u6269\u5c55\u8868")
public class ContractproCon
extends SpringmvcController {
    private static String CODE = "oc.contractpro.con";
    @Autowired
    private OcContractproService ocContractproService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private OcContractEngineService ocContractEngineService;

    @Override
    protected String getContext() {
        return "contractpro";
    }

    @RequestMapping(value={"saveContractpro.json"}, name="\u589e\u52a0\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean saveContractpro(HttpServletRequest request, OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            this.logger.error(CODE + ".saveContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractproDomain.setContractproType("url");
        ocContractproDomain.setTenantCode(this.getTenantCode(request));
        this.confirmReceipt(request, ocContractproDomain.getContractBillcode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocContractproDomain.getContractBillcode());
        map.put("contractproKey", ocContractproDomain.getContractproKey());
        this.logger.error(CODE + ".saveContractpro", map);
        SupQueryResult<OcContractproReDomain> list = this.ocContractproService.querycontractproPage(map);
        this.logger.error(CODE + ".saveContractpro.list", (Object)list.getList());
        if (null == list || ListUtil.isEmpty((Collection)list.getList())) {
            return this.ocContractproService.savecontractpro(ocContractproDomain);
        }
        OcContractproReDomain rsSkuReDomain = (OcContractproReDomain)list.getList().get(0);
        this.logger.error(CODE + ".saveContractpro.list", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
        rsSkuReDomain.setContractproValue(ocContractproDomain.getContractproValue());
        rsSkuReDomain.setContractproValue1(ocContractproDomain.getContractproValue1());
        return this.ocContractproService.updatecontractpro(rsSkuReDomain);
    }

    private Boolean confirmReceipt(HttpServletRequest request, String contractBillcode) {
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", contractBillcode, tenantCode);
        OcContractReDomain contract = this.ocContractService.getContractByCode(getContractMap);
        if (contract == null) {
            return false;
        }
        HtmlJsonReBean contractResult = this.sendContractNext(request, contractBillcode);
        if (null == contractResult || !contractResult.isSuccess()) {
            return false;
        }
        List<OcContractGoodsDomain> ocContractGoodsDomainList = contract.getGoodsList();
        if (ocContractGoodsDomainList == null) {
            this.logger.error(CODE + ".confirmReceive.ocContractGoodsDomainList", (Object)"ocContractGoodsDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        return true;
    }

    private HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"getContractpro.json"}, name="\u83b7\u53d6\u8ba2\u5355\u6269\u5c55\u8868\u4fe1\u606f")
    @ResponseBody
    public OcContractproReDomain getContractpro(Integer contractproId) {
        if (StringUtils.isBlank((Integer)contractproId)) {
            this.logger.error(CODE + ".getContractpro", (Object)"param is null");
            return null;
        }
        return this.ocContractproService.getcontractpro(contractproId);
    }

    @RequestMapping(value={"updateContractpro.json"}, name="\u66f4\u65b0\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean updateContractpro(HttpServletRequest request, OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            this.logger.error(CODE + ".updateContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractproDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractproService.updatecontractpro(ocContractproDomain);
    }

    @RequestMapping(value={"deleteContractpro.json"}, name="\u5220\u9664\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean deleteContractpro(Integer contractproId) {
        if (StringUtils.isBlank((Integer)contractproId)) {
            this.logger.error(CODE + ".deleteContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractproService.deletecontractpro(contractproId);
    }

    @RequestMapping(value={"queryContractproPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u6269\u5c55\u8868\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractproReDomain> queryContractproPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractproService.querycontractproPage(param);
    }

    @RequestMapping(value={"updateContractproState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u6269\u5c55\u8868\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractproState(String contractproId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractproId)) {
            this.logger.error(CODE + ".updateContractproState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractproService.updatecontractproState(Integer.valueOf(contractproId), dataState, oldDataState, null);
    }
}

