/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.reb.RebAdApplyCancelDomain;
import cn.com.qj.bff.domain.reb.RebAdApplyDomain;
import cn.com.qj.bff.domain.reb.RebAdApplyReDomain;
import cn.com.qj.bff.domain.reb.RebUpointsReDomain;
import cn.com.qj.bff.service.reb.RebAdApplyCancelService;
import cn.com.qj.bff.service.reb.RebAdApplyService;
import cn.com.qj.bff.service.reb.RebUpointsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/adApply"}, name="\u5e7f\u544a\u6295\u653e\u7533\u8bf7\u8868\u670d\u52a1")
public class RebAdApplyCon
extends SpringmvcController {
    private static String CODE = "reb.adApply.con";
    @Autowired
    private RebAdApplyService rebAdApplyService;
    @Autowired
    private RebUpointsService rebUpointsService;
    @Autowired
    private RebAdApplyCancelService rebAdApplyCancelService;

    @Override
    protected String getContext() {
        return "adApply";
    }

    @RequestMapping(value={"saveRebAdApply.json"}, name="\u65b0\u589e\u5e7f\u544a\u6295\u653e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean saveRebAdApply(HttpServletRequest request, String rebAdApplyDomainStr) {
        String tenantCode;
        if (StringUtils.isBlank((String)rebAdApplyDomainStr)) {
            this.logger.error(CODE + ".saveRebAdApply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebAdApplyDomain rebAdApplyDomain = (RebAdApplyDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebAdApplyDomainStr, RebAdApplyDomain.class);
        String errorMsg = this.saveRebAdApply4Validate(rebAdApplyDomain, tenantCode = this.getTenantCode(request));
        if (Objects.nonNull(errorMsg)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, errorMsg);
        }
        rebAdApplyDomain.setTenantCode(tenantCode);
        rebAdApplyDomain.setChannelCode(this.getChannelCode(request));
        rebAdApplyDomain.setOperatorName(this.getUserSession(request).getUserRelname());
        return this.rebAdApplyService.saveRebAdApply(rebAdApplyDomain);
    }

    private String saveRebAdApply4Validate(RebAdApplyDomain rebAdApplyDomain, String tenantCode) {
        if (Objects.isNull(rebAdApplyDomain.getDealerCode())) {
            return "\u8bf7\u9009\u62e9\u7533\u8bf7\u7ecf\u9500\u5546";
        }
        if (Objects.isNull(rebAdApplyDomain.getAdOp1())) {
            return "\u8bf7\u9009\u62e9\u62a5\u9500\u91d1\u989d";
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("memberCode", rebAdApplyDomain.getDealerCode());
        queryMap.put("dataState", 0);
        SupQueryResult<RebUpointsReDomain> rebUpointsReDomainSupQueryResult = this.rebUpointsService.queryUpointsPage(queryMap);
        if (EmptyUtil.isEmpty(rebUpointsReDomainSupQueryResult) || ListUtil.isEmpty((Collection)rebUpointsReDomainSupQueryResult.getList())) {
            return "\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002";
        }
        RebUpointsReDomain rebUpointsReDomain = (RebUpointsReDomain)rebUpointsReDomainSupQueryResult.getList().get(0);
        if (Objects.isNull(rebUpointsReDomain.getUpointsNum()) || rebUpointsReDomain.getUpointsNum().compareTo(new BigDecimal(rebAdApplyDomain.getAdOp1())) < 0) {
            return "\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u4e0d\u80fd\u4fdd\u5b58";
        }
        return null;
    }

    @RequestMapping(value={"getRebAdApply.json"}, name="\u83b7\u53d6\u5e7f\u544a\u6295\u653e\u7533\u8bf7\u4fe1\u606f")
    @ResponseBody
    public RebAdApplyReDomain getRebAdApply(HttpServletRequest request, Integer adApplyId) {
        if (StringUtils.isBlank((Integer)adApplyId)) {
            this.logger.error(CODE + ".getRebAdApply", (Object)"param is null");
            return null;
        }
        RebAdApplyReDomain rebAdApply = this.rebAdApplyService.getRebAdApply(adApplyId);
        if (StringUtils.isNotBlank((String)rebAdApply.getAdOp3())) {
            String rebAdApplyParentCode = rebAdApply.getAdOp3();
            RebAdApplyReDomain rebAdApplyReDomain = this.rebAdApplyService.getRebAdApplyByCode(this.getTenantCode(request), rebAdApplyParentCode);
            rebAdApply.setToVerifyAmount(rebAdApplyReDomain.getToVerifyAmount());
        }
        return rebAdApply;
    }

    @RequestMapping(value={"updateRebAdApply.json"}, name="\u66f4\u65b0\u5e7f\u544a\u6295\u653e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean updateRebAdApply(HttpServletRequest request, String rebAdApplyDomainStr) {
        if (StringUtils.isBlank((String)rebAdApplyDomainStr)) {
            this.logger.error(CODE + ".updateRebAdApply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebAdApplyDomain rebAdApplyDomain = (RebAdApplyDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebAdApplyDomainStr, RebAdApplyDomain.class);
        rebAdApplyDomain.setTenantCode(this.getTenantCode(request));
        rebAdApplyDomain.setOperatorName(this.getUserSession(request).getUserRelname());
        return this.rebAdApplyService.updateRebAdApply(rebAdApplyDomain);
    }

    @RequestMapping(value={"deleteRebAdApply.json"}, name="\u5220\u9664\u5e7f\u544a\u6295\u653e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean deleteRebAdApply(Integer adApplyId) {
        if (StringUtils.isBlank((Integer)adApplyId)) {
            this.logger.error(CODE + ".deleteRebAdApply", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebAdApplyService.deleteRebAdApply(adApplyId);
    }

    @RequestMapping(value={"queryRebAdApplyPage.json"}, name="\u67e5\u8be2\u5e7f\u544a\u6295\u653e\u7533\u8bf7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebAdApplyReDomain> queryRebAdApplyPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<RebAdApplyReDomain> queryResult = this.rebAdApplyService.queryRebAdApplyPage(param);
        List list = queryResult.getList();
        for (RebAdApplyReDomain rebAdApplyReDomain : list) {
            if (StringUtils.isNotBlank((String)rebAdApplyReDomain.getAdOp3())) {
                String rebAdApplyParentCode = rebAdApplyReDomain.getAdOp3();
                RebAdApplyReDomain rebAdApplyReDomainParent = this.rebAdApplyService.getRebAdApplyByCode(this.getTenantCode(request), rebAdApplyParentCode);
                rebAdApplyReDomain.setToVerifyAmount(rebAdApplyReDomainParent.getToVerifyAmount());
            }
            HashMap<String, Object> cancelParam = new HashMap<String, Object>();
            cancelParam.put("order", true);
            cancelParam.put("adOp1", rebAdApplyReDomain.getAdApplyCode());
            SupQueryResult<RebAdApplyCancelDomain> rebAdApplyCancelDomainSupQueryResult = this.rebAdApplyCancelService.queryRebAdApplyCancelPage(cancelParam);
            if (!CollectionUtils.isNotEmpty((Collection)rebAdApplyCancelDomainSupQueryResult.getList())) continue;
            rebAdApplyReDomain.setAdCancelId(((RebAdApplyCancelDomain)rebAdApplyCancelDomainSupQueryResult.getList().get(0)).getAdCancelId());
        }
        return queryResult;
    }

    @RequestMapping(value={"updateRebAdApplyState.json"}, name="\u66f4\u65b0\u5e7f\u544a\u6295\u653e\u7533\u8bf7\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRebAdApplyStateByCode(HttpServletRequest request, String adApplyCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)adApplyCode)) {
            this.logger.error(CODE + ".updateRebAdApplyStateByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> param = this.assemMapParam(request);
        return this.rebAdApplyService.updateRebAdApplyStateByCode(this.getTenantCode(request), adApplyCode, dataState, oldDataState, param);
    }
}

