/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.controller.order.ContractComCon;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cp.CpRechargeReDomain;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.ExcelExportTemplate;
import cn.com.qj.bff.domain.oc.OcConsumeBigData;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcRefundGoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.domain.oc.PackageExpressDomain;
import cn.com.qj.bff.service.cp.CpRechargeService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.service.sg.SgSendgoodsLogService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/purchase"}, name="\u8fd0\u8425\u7aef\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1")
public class PurchaseCon
extends ContractComCon {
    private static final String CODE = "oc.purchase.con";
    @Autowired
    private CpRechargeService cpRechargeService;
    @Autowired
    private OcRefundService ocRefundService;
    @Autowired
    private SgSendgoodsLogService sgSendgoodsLogService;

    @Override
    protected String getContext() {
        return "purchase";
    }

    @RequestMapping(value={"getContractAndRefundByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5,\u5305\u62ec\u9000\u5355\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContractAndRefundByCode(HttpServletRequest request) {
        Map<String, Object> param = this.getMemberBcodeQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocContractReDomain.getMemberBcode())) {
            return null;
        }
        String contractBillcode = ocContractReDomain.getContractBillcode();
        HashMap<String, Object> queryRefundMap = new HashMap<String, Object>();
        queryRefundMap.put("tenantCode", this.getTenantCode(request));
        queryRefundMap.put("contractBillcode", contractBillcode);
        SupQueryResult<OcRefundReDomain> supQueryResult = this.ocRefundService.queryRefundReDomainPage(queryRefundMap);
        if (supQueryResult == null || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error("oc.purchase.con.getContractAndRefundByCode.supQueryResult", (Object)((Object)queryRefundMap).toString());
            return ocContractReDomain;
        }
        List ocRefundlist = supQueryResult.getList();
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            return ocContractReDomain;
        }
        for (OcRefundReDomain ocRefundReDomain : ocRefundlist) {
            List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundReDomain.getOcRefundGoodsList();
            if (ListUtil.isEmpty(ocRefundGoodsDomainList)) {
                this.logger.error("oc.purchase.con.getContractAndRefundByCode.ocRefundGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain));
                continue;
            }
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
                String reGoodsNo = ocRefundGoodsDomain.getGoodsNo();
                if (StringUtils.isEmpty((String)reGoodsNo)) {
                    this.logger.error("oc.purchase.con.getContractAndRefundByCode.reGoodsNo");
                    continue;
                }
                for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                    String ocGoodsNo = ocContractGoodsDomain.getGoodsNo();
                    if (!reGoodsNo.equals(ocGoodsNo)) continue;
                    this.logger.error("oc.purchase.con.getContractAndRefundByCode.goodsNo1", (Object)(ocGoodsNo + "======" + ocRefundReDomain.getDataState()));
                    ocContractGoodsDomain.setGoodsState((int)ocRefundReDomain.getDataState());
                }
            }
        }
        ocContractReDomain.setGoodsList(goodsList);
        return ocContractReDomain;
    }

    @RequestMapping(value={"saveExContractGoods.json"}, name="\u8ba2\u5355\u6362\u8d27\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExContractGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error("oc.purchase.con.saveExContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveExContractGoodsCom(request, orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveContractEmp.json"}, name="\u91c7\u8d2d\u8ba2\u5355\u5f52\u5c5e\u64cd\u4f5c\u5458\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractEmp(HttpServletRequest request, String orderDomainStr) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.purchase.con.saveContractEmp", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String memberBcode = userSession.getUserPcode();
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode(), memberBcode, "9");
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryOcContractToCensus.json"}, name="\u83b7\u53d6\u8ba2\u5355\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public OcConsumeBigData queryOcContractToCensus(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        return this.ocContractService.queryOcContractToCensus(param);
    }

    @RequestMapping(value={"saveOcContractGoodsEmp.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveOcContractGoodsEmp(HttpServletRequest request, String ocContractGoodsDomainStr) {
        if (StringUtils.isBlank((String)ocContractGoodsDomainStr)) {
            this.logger.error("oc.purchase.con.saveOcContractGoodsEmp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List ocContractGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(ocContractGoodsDomainStr, OcContractGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
                ocContractGoodsDomain.setTenantCode(tenantCode);
                ocContractGoodsDomain.setContractGoodsGtype("1");
                this.ocContractService.saveContractGoods(ocContractGoodsDomain);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveContractSp.json"}, name="\u5408\u540c\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractSp(HttpServletRequest request, String orderDomainStr, String contractProperty) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode(), null, contractProperty);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("oc.purchase.con.updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractDomain occontractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, OcContractDomain.class);
        String contractRemark = occontractDomain.getContractRemark();
        if (StringUtils.isNotBlank((String)contractRemark) && contractRemark.length() > 250) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u4e0d\u8d85\u8fc7250\u5b57");
        }
        OcContractReDomain contract = this.ocContractService.getContract(occontractDomain.getContractId());
        contract.setContractRemark(contractRemark);
        return this.updateContractCom(request, contract);
    }

    @RequestMapping(value={"updateContractoc.json"}, name="\u4fee\u6539\u8ba2\u5355\u53ca\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateContractoc(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("oc.purchase.con.updateContractoc", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractReDomain occontractDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, OcContractReDomain.class);
        return this.updateContractCom(request, occontractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContract(HttpServletRequest request, String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error("oc.purchase.con.deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractReDomain ocContractReDomain = this.ocContractService.getContract(Integer.valueOf(contractId));
        if (null == ocContractReDomain) {
            this.logger.error("oc.purchase.con.deleteContract.ocContractReDomain", (Object)"ocContractReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocContractReDomain");
        }
        String userinfoCode = this.getUserSession(request).getUserPcode();
        if (!userinfoCode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error("oc.purchase.con.deleteContract.userinfoCode", (Object)"userinfoCode is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error");
        }
        return this.deleteContractCom(contractId);
    }

    @RequestMapping(value={"queryContractGoodsPage.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractGoodsPageBytenant.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868(\u79df\u6237)")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageBytenant(HttpServletRequest request) {
        String exportFlag;
        Boolean flag;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((flag = Boolean.valueOf(exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag"))).booleanValue()) {
            String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
            String fileName = "\u8ba2\u5355\u5546\u54c1\u5217\u8868";
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractGoodsPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error("oc.purchase.con.queryContractGoodsPageBytenant.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractSettlDomain.json"}, name="\u8ba2\u5355\u670d\u52a1\u7ed3\u7b97\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractSettlDomain> queryContractSettlDomain(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<OcContractSettlDomain> ocContractSettlDomainSupQueryResult = this.ocContractService.queryContractSettlPage(param);
        return ocContractSettlDomainSupQueryResult;
    }

    @RequestMapping(value={"updateContractSettl.json"}, name="\u5408\u540c\u7ed3\u7b97\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateContractSettl(HttpServletRequest request, OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            this.logger.error("oc.purchase.con.updateContractSettl", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.updateContractSettl(ocContractSettlDomain);
    }

    @RequestMapping(value={"updateContractSettlNew.json"}, name="\u5408\u540c\u7ed3\u7b97\u4fee\u6539\u51ed\u8bc1\u53f7")
    @ResponseBody
    public HtmlJsonReBean updateContractSettlNew(HttpServletRequest request, String contractSettlStr) {
        if (null == contractSettlStr) {
            this.logger.error("oc.purchase.con.updateContractSettlNew", (Object)("param is null" + contractSettlStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> param = this.assemMapParam(request);
        OcContractSettlDomain contractSettlByCode = this.ocContractService.getContractSettlByCode(param);
        if (contractSettlByCode == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "nullocContractSettlDomain" + contractSettlStr);
        }
        contractSettlByCode.setContractSettlOpno(contractSettlStr);
        return this.ocContractService.updateContractSettl(contractSettlByCode);
    }

    @RequestMapping(value={"queryRechargePagePayment.json"}, name="\u67e5\u8be2\u6709\u51e0\u6761\u6d41\u6c34\u53ef\u4ee5\u7ebf\u4e0b\u4ed8\u6b3e")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryRechargePagePayment(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        ArrayList<CpRechargeReDomain> cpRechargeReDomainList = new ArrayList<CpRechargeReDomain>();
        SupQueryResult cpRechargeReDomainSupQueryResultStr = new SupQueryResult();
        SupQueryResult<CpRechargeReDomain> cpRechargeReDomainSupQueryResult = this.cpRechargeService.queryRechargePage(param);
        if (ListUtil.isNotEmpty((Collection)cpRechargeReDomainSupQueryResult.getList())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (CpRechargeReDomain cpRechargeReDomain : cpRechargeReDomainSupQueryResult.getList()) {
                params.put("tenantCode", cpRechargeReDomain.getTenantCode());
                params.put("contractSettlOpno", cpRechargeReDomain.getRechargeOpcode());
                SupQueryResult<OcContractSettlDomain> ocContractSettlDomainSupQueryResult = this.ocContractService.queryContractSettlPage(params);
                if (!ListUtil.isEmpty((Collection)ocContractSettlDomainSupQueryResult.getList())) continue;
                cpRechargeReDomainList.add(cpRechargeReDomain);
            }
        }
        cpRechargeReDomainSupQueryResultStr.setList(cpRechargeReDomainList);
        cpRechargeReDomainSupQueryResultStr.setRows(cpRechargeReDomainList);
        return cpRechargeReDomainSupQueryResultStr;
    }

    private SupQueryResult<OcContractReDomain> queryContractPageS(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u8fd0\u8425\u7aef\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.debug(CODE, (Object)("--------------------" + param.toString()));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error("oc.purchase.con.updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error("oc.purchase.con.offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractService.dataState_2, OcContractService.dataState_1);
    }

    @RequestMapping(value={"cancelContractC.json"}, name="\u53d6\u6d88\u8ba2\u5355  C\u7aef")
    @ResponseBody
    public HtmlJsonReBean cancelContractC(HttpServletRequest request, Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error("oc.purchase.con.cancelContractC.", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractReDomain contract = this.ocContractService.getContract(contractId);
        if (null == contract) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contract is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u5f02\u5e38");
        }
        if (!userSession.getUserPcode().equals(contract.getMemberBcode())) {
            this.logger.error("oc.purchase.con.cancelContractC.", (Object)"\u8d8a\u6743\u64cd\u4f5c");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u975e\u672c\u4eba\u8ba2\u5355\u65e0\u6cd5\u53d6\u6d88");
        }
        return this.updateContractStateExtendCom(contractId, OcContractService.dataState_no, OcContractService.dataState_1);
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u8fd0\u8425\u7aef\u83b7\u53d6\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map<String, Object> param = this.getMemberBcodeQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocContractReDomain.getMemberBcode())) {
            return null;
        }
        return ocContractReDomain;
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error("oc.purchase.con.saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        return this.syncContractPayStateCom(request, contractBillcode, contractSubCode);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchPayStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error("oc.purchase.con.checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkContractPayCom(request, contractBillcode);
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error("oc.purchase.con.updatePackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"receiving.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean receiving(HttpServletRequest request, String contractBillcode, Integer packageId) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error("oc.purchase.con.receiving", (Object)"param is null");
        }
        return this.confirmReceive(request, contractBillcode, packageId);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error("oc.purchase.con.confirmReceive", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractService.dataState_3, true);
    }

    @RequestMapping(value={"confirmReceivable.json"}, name="\u786e\u8ba4\u6536\u6b3e")
    @ResponseBody
    public HtmlJsonReBean confirmReceivable(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error("oc.purchase.con.confirmReceive.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractService.dataState_1, false);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFareBatch.json"}, name="\u6279\u91cf\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFareBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareBatchCom(request, paramStr, null);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error("oc.purchase.con.calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, null);
    }
}

