/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsGoodsRtagDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRtagReDomain;
import cn.com.qj.bff.domain.rs.RsRtagDomain;
import cn.com.qj.bff.domain.rs.RsRtagReDomain;
import cn.com.qj.bff.service.rs.RsGoodsRtagService;
import cn.com.qj.bff.service.rs.RsRtagService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/rtag"}, name="\u5546\u54c1\u6807\u7b7e")
public class RtagCon
extends SpringmvcController {
    private static String CODE = "rs.rtag.con";
    @Autowired
    private RsRtagService rsRtagService;
    @Autowired
    private RsGoodsRtagService rsGoodsRtagService;

    @Override
    protected String getContext() {
        return "rtag";
    }

    @RequestMapping(value={"saveRtag.json"}, name="\u589e\u52a0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean saveRtag(HttpServletRequest request, RsRtagDomain rsRtagDomain) {
        if (null == rsRtagDomain) {
            this.logger.error(CODE + ".saveRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String rtagName = rsRtagDomain.getRtagName();
        if (StringUtils.isBlank((String)rtagName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.checkRtagName(request, rtagName, rsRtagDomain.getRtagCode());
        if (null != htmlJsonReBean && htmlJsonReBean.getSysRecode().equals("error")) {
            return htmlJsonReBean;
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(userSession.getMerberCompname());
        DisChannel channelByMemRe = this.getChannelByMemRe(userSession.getUserPcode(), request);
        rsRtagDomain.setChannelCode(channelByMemRe.getChannelCode());
        rsRtagDomain.setChannelName(channelByMemRe.getChannelName());
        return this.rsRtagService.saveRtag(rsRtagDomain);
    }

    @RequestMapping(value={"getRtag.json"}, name="\u83b7\u53d6\u5546\u54c1\u6807\u7b7e\u4fe1\u606f")
    @ResponseBody
    public RsRtagReDomain getRtag(Integer rtagId) {
        if (StringUtils.isBlank((Integer)rtagId)) {
            this.logger.error(CODE + ".getRtag", (Object)"param is null");
            return null;
        }
        return this.rsRtagService.getRtag(rtagId);
    }

    @RequestMapping(value={"updateRtag.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean updateRtag(HttpServletRequest request, RsRtagDomain rsRtagDomain) {
        if (null == rsRtagDomain || null == rsRtagDomain.getRtagCode()) {
            this.logger.error(CODE + ".updateRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String rtagName = rsRtagDomain.getRtagName();
        if (StringUtils.isBlank((String)rtagName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.checkRtagName(request, rtagName, rsRtagDomain.getRtagCode());
        if (null != htmlJsonReBean && htmlJsonReBean.getSysRecode().equals("error")) {
            return htmlJsonReBean;
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(userSession.getMerberCompname());
        HtmlJsonReBean htmlJsonReBean1 = this.rsRtagService.updateRtag(rsRtagDomain);
        RsGoodsRtagDomain rsGoodsRtagDomain = new RsGoodsRtagDomain();
        rsGoodsRtagDomain.setRtagCode(rsRtagDomain.getRtagCode());
        rsGoodsRtagDomain.setRtagName(rsRtagDomain.getRtagName());
        rsGoodsRtagDomain.setRtagFont(rsRtagDomain.getRtagFont());
        rsGoodsRtagDomain.setRtagBack(rsRtagDomain.getRtagBack());
        rsGoodsRtagDomain.setTenantCode(this.getTenantCode(request));
        this.rsGoodsRtagService.updateByRtagCode(rsGoodsRtagDomain);
        return htmlJsonReBean1;
    }

    @RequestMapping(value={"deleteRtag.json"}, name="\u5220\u9664\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean deleteRtag(Integer rtagId) {
        if (StringUtils.isBlank((Integer)rtagId)) {
            this.logger.error(CODE + ".deleteRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsRtagReDomain rsRtagReDomain = this.rsRtagService.getRtag(rtagId);
        SupQueryResult<RsGoodsRtagReDomain> supQueryResult = this.rsGoodsRtagService.queryGoodsRtagPage(this.getQueryMapParam("rtagCode,tenantCode", rsRtagReDomain.getRtagCode(), rsRtagReDomain.getTenantCode()));
        if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".deleteRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u6709\u5173\u8054\u5546\u54c1\uff0c\u8bf7\u5148\u53d6\u6d88\u5546\u54c1\u6807\u7b7e\uff01");
        }
        return this.rsRtagService.deleteRtag(rtagId);
    }

    @RequestMapping(value={"queryRtagPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.setMapRequest(param, request);
        return this.rsRtagService.queryRtagPage(param);
    }

    @RequestMapping(value={"updateRtagState.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRtagState(String rtagId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)rtagId)) {
            this.logger.error(CODE + ".updateRtagState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsRtagService.updateRtagState(Integer.valueOf(rtagId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"checkRtagName.json"}, name="\u6807\u7b7e\u540d\u68c0\u67e5")
    @ResponseBody
    public HtmlJsonReBean checkRtagName(HttpServletRequest request, String rtagName, String rtagCode) {
        if (StringUtils.isBlank((String)rtagName)) {
            this.logger.error(CODE + ".checkRtagName", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult<RsRtagReDomain> supQueryResult = this.rsRtagService.queryRtagPage(this.getQueryMapParam("rtagName,tenantCode,channelCode", rtagName, this.getTenantCode(request), this.getChannelCode(request)));
        if (null == supQueryResult || null == supQueryResult.getRows() || supQueryResult.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)rtagCode)) {
            for (RsRtagReDomain rsRtagReDomain : supQueryResult.getRows()) {
                if (rtagCode.equals(rsRtagReDomain.getRtagCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            flag = true;
        }
        if (!flag && null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
            this.logger.error(CODE + ".checkRtagName", (Object)" exist rtagName");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"goodsRtagRel.json"}, name="\u6807\u7b7e\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean goodsRtagRel(HttpServletRequest request) {
        return this.rsGoodsRtagService.updateStateList(this.getTenantCode(request), 1, 0);
    }

    @RequestMapping(value={"saveGoodsRtag.json"}, name="\u4fdd\u5b58\u6807\u7b7e\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveGoodsRtag(HttpServletRequest request, String paramStr) {
        return this.saveGoodsRtagMain(request, paramStr);
    }

    @RequestMapping(value={"saveGoodsRtagForPla.json"}, name="\u4fdd\u5b58\u6807\u7b7e\u5546\u54c1-\u5e73\u53f0\u5546\u54c1\u5217\u8868\u9875")
    @ResponseBody
    public HtmlJsonReBean saveGoodsRtagForPla(HttpServletRequest request, String paramStr) {
        return this.saveGoodsRtagMain(request, paramStr);
    }

    private HtmlJsonReBean saveGoodsRtagMain(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGoodsRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsRtagDomains = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsGoodsRtagDomain.class);
        if (ListUtil.isEmpty((Collection)rsGoodsRtagDomains)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        for (RsGoodsRtagDomain rsGoodsRtagDomain : rsGoodsRtagDomains) {
            rsGoodsRtagDomain.setTenantCode(this.getTenantCode(request));
            rsGoodsRtagDomain.setMemberCode(userSession.getUserPcode());
            rsGoodsRtagDomain.setMemberName(userSession.getMerberCompname());
        }
        return this.rsGoodsRtagService.saveGoodsRtagBatch(rsGoodsRtagDomains);
    }

    @RequestMapping(value={"deleteGoodsRtag.json"}, name="\u5220\u9664\u6807\u7b7e\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsRtag(HttpServletRequest request, String paramStr) {
        return this.deleteGoodsRtagMain(paramStr);
    }

    @RequestMapping(value={"deleteGoodsRtagForPla.json"}, name="\u5220\u9664\u6807\u7b7e\u5546\u54c1-\u5e73\u53f0\u5546\u54c1\u5217\u8868\u9875")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsRtagForPla(HttpServletRequest request, String paramStr) {
        return this.deleteGoodsRtagMain(paramStr);
    }

    private HtmlJsonReBean deleteGoodsRtagMain(String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".deleteGoodsRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsRtagDomains = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsGoodsRtagDomain.class);
        if (ListUtil.isEmpty((Collection)rsGoodsRtagDomains)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff01");
        }
        return this.rsGoodsRtagService.deleteGoodsRtagList(rsGoodsRtagDomains);
    }

    @RequestMapping(value={"queryRtagPageBySearch.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868-\u641c\u7d22\u9875")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPageBySearch(HttpServletRequest request) {
        return this.queryRtagMain(request);
    }

    @RequestMapping(value={"queryRtagForPla.json"}, name="\u5546\u54c1\u6807\u7b7e\u5217\u8868-\u5e73\u53f0\u5546\u54c1\u5217\u8868\u9875")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagForPla(HttpServletRequest request) {
        return this.queryRtagMain(request);
    }

    private SupQueryResult<RsRtagReDomain> queryRtagMain(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsRtagService.queryRtagPage(param);
    }

    @RequestMapping(value={"queryRtagByGoodsClass.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5217\u8868-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagByGoodsClass(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsRtagService.queryRtagPage(param);
    }
}

