/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.pay;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcContractSubReDomain;
import cn.com.qj.bff.domain.oc.OcContractSublistDomain;
import cn.com.qj.bff.domain.oc.OcContractproDomain;
import cn.com.qj.bff.domain.oc.OcContractproReDomain;
import cn.com.qj.bff.domain.oc.OcPackageDomain;
import cn.com.qj.bff.domain.pay.PayChannel;
import cn.com.qj.bff.domain.pay.PayInfo;
import cn.com.qj.bff.domain.pay.PteConstants;
import cn.com.qj.bff.domain.pte.BankHtmlForm;
import cn.com.qj.bff.domain.pte.PtePtfchannelReDomain;
import cn.com.qj.bff.domain.pte.PtePtradeDomain;
import cn.com.qj.bff.domain.pte.PtePtradeInfoDomain;
import cn.com.qj.bff.domain.pte.PtePtradeParticipantDomain;
import cn.com.qj.bff.domain.pte.PtePtradeReDomain;
import cn.com.qj.bff.domain.pte.PtradeBean;
import cn.com.qj.bff.domain.vd.VdFaccountInfo;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcContractSubService;
import cn.com.qj.bff.service.oc.OcContractproService;
import cn.com.qj.bff.service.pte.PtePtfchannelService;
import cn.com.qj.bff.service.pte.PtePtradeNewService;
import cn.com.qj.bff.service.vd.VdFaccountService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PayNewService
extends SupperFacade {
    public static final String SYS_CODE = "web.pay.PayService";
    public static final String FCHANNELDR_PAY = "PAY";
    @Autowired
    private PtePtfchannelService ptePtfchannelService;
    @Autowired
    private PtePtradeNewService ptePtradeNewService;
    @Autowired
    private VdFaccountService vdFaccountService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private OcContractSubService ocContractSubService;
    @Autowired
    private OcContractproService ocContractproService;
    public static final String OC_BBILLCODESTR = "OC_BBILLCODESTR";
    private static final ExecutorService pool = Executors.newFixedThreadPool(50);
    static String PTE_PTFCHANNEL_CHANNEL = "PtePtfchannel_channel_dr_key";

    public String updateBatch(String tenantCode, String contractBillcodeStr) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcodeStr)) {
            return null;
        }
        HashMap<String, String> contractTradeMap = new HashMap<String, String>();
        contractTradeMap.put("contractBillcodeStr", contractBillcodeStr);
        contractTradeMap.put("oldDataState", "1");
        contractTradeMap.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.ocContractService.updateContractPtradeSeqno(contractTradeMap);
        if (null == htmlJsonReBean || null == htmlJsonReBean.getDataObj()) {
            return null;
        }
        return htmlJsonReBean.getDataObj().toString();
    }

    public PayInfo saveBatchPay(final Map<String, Object> envmap, String memberBcode, String contractBbillcode, String fchannelPmodeCode, String tenantCode, String contractBillcodeStr, PtePtfchannelReDomain ptePtfchannelReDomain) {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBbillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        map.put("childFlag", "1");
        SupQueryResult<OcContractReDomain> qlist = this.ocContractService.queryContractPage(map);
        if (null == qlist || null == qlist.getList() || qlist.getList().isEmpty()) {
            this.logger.error("web.pay.PayService.saveBatchPay.null", (Object)(memberBcode + "=" + ((Object)map).toString()));
            return null;
        }
        List ocContractReDomainList = qlist.getList();
        envmap.put("payDate", ((OcContractReDomain)ocContractReDomainList.get(0)).getContractPaydate());
        if (ListUtil.isNotEmpty((Collection)ocContractReDomainList) && 1 == ocContractReDomainList.size()) {
            return this.savePayCom(envmap, memberBcode, ((OcContractReDomain)ocContractReDomainList.get(0)).getContractBillcode(), fchannelPmodeCode, tenantCode, ptePtfchannelReDomain, (OcContractReDomain)ocContractReDomainList.get(0));
        }
        String ptradeSeqno = "";
        BigDecimal dataAmount = BigDecimal.ZERO;
        BigDecimal contractAmount = BigDecimal.ZERO;
        BigDecimal pefAmount = BigDecimal.ZERO;
        BigDecimal logMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        ArrayList<PtePtradeInfoDomain> ptePtradeInfoDomainList = new ArrayList<PtePtradeInfoDomain>();
        ArrayList<Map<String, Object>> ristInfo = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> goodsDetails = new ArrayList<Map<String, Object>>();
        final ArrayList<OcContractReDomain> contractReDomainList = new ArrayList<OcContractReDomain>();
        int nozero = 0;
        boolean zeroFlag = false;
        for (Object ocContractReDomain : ocContractReDomainList) {
            if (null == ((OcContractDomain)ocContractReDomain).getDataBmoney()) {
                ((OcContractDomain)ocContractReDomain).setDataBmoney(BigDecimal.ZERO);
            }
            if (((OcContractDomain)ocContractReDomain).getDataBmoney().compareTo(BigDecimal.ZERO) <= 0) {
                zeroFlag = true;
                continue;
            }
            ++nozero;
        }
        if (nozero == 0) {
            this.logger.error("web.pay.PayService.saveBatchPay.0\u5143\u8ba2\u5355", (Object)"\u4e0d\u652f\u4ed8");
            return null;
        }
        PayInfo payInfo = new PayInfo();
        payInfo.setPtePtfchannelReDomain(ptePtfchannelReDomain);
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            if (null == ocContractReDomain.getContractMoney()) {
                ocContractReDomain.setContractMoney(BigDecimal.ZERO);
            }
            if (null == ocContractReDomain.getDataBmoney()) {
                ocContractReDomain.setDataBmoney(BigDecimal.ZERO);
            }
            if (null == ocContractReDomain.getPricesetRefrice()) {
                ocContractReDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            dataAmount = dataAmount.add(ocContractReDomain.getDataBmoney());
            contractAmount = contractAmount.add(ocContractReDomain.getContractMoney());
            pefAmount = pefAmount.add(ocContractReDomain.getPricesetRefrice());
            if (null != ocContractReDomain.getGoodsLogmoney()) {
                logMoney = logMoney.add(ocContractReDomain.getGoodsLogmoney());
            }
            if (null != ocContractReDomain.getContractPaymoney()) {
                pacgeMoney = pacgeMoney.add(ocContractReDomain.getContractPaymoney());
            }
            ptePtradeInfoDomainList.add(this.makePtePtradeInfoDomain(ocContractReDomain, fchannelPmodeCode));
            List<Object> goodsList = new ArrayList();
            if (ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
                for (OcPackageDomain ocPackageDomain : ocContractReDomain.getPackageList()) {
                    goodsList.addAll(ocPackageDomain.getContractGoodsList());
                }
            } else {
                goodsList = ocContractReDomain.getGoodsList();
            }
            this.contractAddressDecry(ocContractReDomain);
            contractReDomainList.add(ocContractReDomain);
            this.makePayGoods(envmap, ristInfo, goodsDetails, goodsList);
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setPtePtradeInfoDomainList(ptePtradeInfoDomainList);
        ptePtradeDomain.setOrderOamount(dataAmount);
        ptePtradeDomain.setOrderAmount(dataAmount);
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setBusinessType("P01");
        ptePtradeDomain.setPtradeBatchno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setAcquireSeqno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setPartnerCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCode());
        ptePtradeDomain.setBusinessOrderno(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setBusinessOrder(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBillcode());
        ptePtradeDomain.setPaymentMemo(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBbillcode());
        ptePtradeDomain.setOpuserCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberBcode());
        ptePtradeDomain.setOpuserName(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(((OcContractReDomain)ocContractReDomainList.get(0)).getTenantCode());
        ptePtradeDomain.setMerchantCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        envmap.put("ristInfo", JsonUtil.buildNormalBinder().toJson(ristInfo));
        envmap.put("goodsDetails", JsonUtil.buildNormalBinder().toJson(goodsDetails));
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.sendContracBatchPay");
        ptePtradeDomain.setGoodsClass(((OcContractReDomain)ocContractReDomainList.get(0)).getGoodsClass());
        ptePtradeDomain.setChannelName(((OcContractReDomain)ocContractReDomainList.get(0)).getChannelName());
        ptePtradeDomain.setChannelCode(((OcContractReDomain)ocContractReDomainList.get(0)).getChannelCode());
        ptePtradeDomain.setMemberCode(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberBcode());
        ptePtradeDomain.setMemberName(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberName());
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payInfo.getPtePtfchannelReDomain());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ptePtradeParticipantDomain.setOrderAmount(dataAmount);
        ptePtradeParticipantDomain.setOrderPrice(dataAmount);
        ptePtradeParticipantDomain.setFchannelClassifyCode(payInfo.getPtePtfchannelReDomain().getFchannelType());
        ptePtradeParticipantDomain.setPtePtradeType("0");
        if (StringUtils.isNotBlank((String)payInfo.getPtePtfchannelReDomain().getFundIntype())) {
            ptePtradeParticipantDomain.setFundType(payInfo.getPtePtfchannelReDomain().getFundIntype());
        }
        partList.add(ptePtradeParticipantDomain);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPartList(partList);
        ptradeBean.setTenantCode(((OcContractReDomain)ocContractReDomainList.get(0)).getTenantCode());
        ptradeBean.setFchannelPmodeCode(fchannelPmodeCode);
        ptradeBean.setFchannelMode(payInfo.getPtePtfchannelReDomain().getFchannelModel());
        ptePtradeDomain.setPtradeBean(ptradeBean);
        BankHtmlForm bankHtmlForm = this.ptePtradeNewService.sendSaveAutoCommit(ptePtradeDomain);
        if (null == bankHtmlForm) {
            return null;
        }
        ptradeSeqno = bankHtmlForm.getPtradeSeqno();
        payInfo.setBankHtmlForm(bankHtmlForm);
        payInfo.setPtradeSeqno(bankHtmlForm.getPtradeSeqno());
        String finalPtradeSeqno = ptradeSeqno;
        contractReDomainList.stream().forEach(o -> o.setPtradeSeqno(finalPtradeSeqno));
        pool.execute(new Runnable(){

            @Override
            public void run() {
                PayNewService.this.ptePtradeNewService.sendContractToPayByMqTopic(contractReDomainList, envmap);
            }
        });
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            HashMap<String, String> contractTradeMap = new HashMap<String, String>();
            contractTradeMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
            contractTradeMap.put("ptradeSeqno", ptradeSeqno);
            contractTradeMap.put("tenantCode", ocContractReDomain.getTenantCode());
            contractTradeMap.put("fchannelCode", payInfo.getPtePtfchannelReDomain().getFchannelCode());
            contractTradeMap.put("fchannelName", payInfo.getPtePtfchannelReDomain().getFchannelName());
            payInfo.setContractBlance(ocContractReDomain.getContractBlance());
            this.ocContractService.updateContractPtradeSeqno(contractTradeMap);
        }
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(((OcContractReDomain)ocContractReDomainList.get(0)).getContractBillcode());
        payInfo.setContractBbillcode(contractBbillcode);
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        payInfo.setOrderMoney(dataAmount);
        payInfo.setContMoney(contractAmount);
        payInfo.setPreMoney(pefAmount);
        payInfo.setLogMoney(logMoney);
        payInfo.setPacgeMoney(pacgeMoney);
        payInfo.setContractPaydate(((OcContractReDomain)ocContractReDomainList.get(0)).getContractPaydate());
        return payInfo;
    }

    private void makePayGoods(Map<String, Object> envmap, List<Map<String, Object>> ristInfo, List<Map<String, Object>> goodsDetails, List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isNotEmpty(goodsList)) {
            envmap.put("goodsName", goodsList.get(0).getGoodsName() + "\u7b49\u5546\u54c1");
            goodsList.stream().forEach(g -> {
                HashMap<String, Object> rMap = new HashMap<String, Object>();
                HashMap<String, Object> gMap = new HashMap<String, Object>();
                rMap.put("service_identify", "10000001");
                rMap.put("subject", g.getGoodsName());
                rMap.put("product_type", "1");
                rMap.put("goods_count", g.getGoodsCamount());
                ristInfo.add(rMap);
                gMap.put("id", g.getSkuNo());
                gMap.put("name", g.getGoodsName());
                gMap.put("quantity", g.getGoodsCamount());
                gMap.put("unitPrice", g.getPricesetNprice().multiply(new BigDecimal(100)));
                goodsDetails.add(gMap);
            });
        }
    }

    public void contractAddressDecry(OcContractReDomain ocContractReDomain) {
        List<OcContractproReDomain> ocContractproReDomains = this.ocContractproService.querycontractproByOrderCode(ocContractReDomain.getTenantCode(), ocContractReDomain.getContractBillcode());
        if (ListUtil.isEmpty(ocContractproReDomains)) {
            return;
        }
        List<OcContractproDomain> ocContractproDomains = ocContractproReDomains.stream().map(e -> {
            OcContractproDomain contractproDomain = new OcContractproDomain();
            try {
                BeanUtils.copyAllPropertys((Object)contractproDomain, (Object)e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return contractproDomain;
        }).collect(Collectors.toList());
        ocContractReDomain.setOcContractproDomainList(ocContractproDomains);
        this.ocContractService.decryContractAddress(ocContractReDomain);
    }

    private PtePtradeInfoDomain makePtePtradeInfoDomain(OcContractReDomain ocContractReDomain, String fchannelPmodeCode) {
        if (null == ocContractReDomain || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
        ptePtradeInfoDomain.setOrderOamount(ocContractReDomain.getContractMoney());
        ptePtradeInfoDomain.setOrderAmount(ocContractReDomain.getContractMoney());
        ptePtradeInfoDomain.setPartnerCode(ocContractReDomain.getMemberCode());
        ptePtradeInfoDomain.setBusinessOrderno(ocContractReDomain.getContractBbillcode());
        ptePtradeInfoDomain.setBusinessOrder(ocContractReDomain.getContractBillcode());
        ptePtradeInfoDomain.setPaymentMemo(ocContractReDomain.getContractBillcode());
        ptePtradeInfoDomain.setOpuserCode(ocContractReDomain.getMemberBcode());
        ptePtradeInfoDomain.setOpuserName(ocContractReDomain.getMemberBname());
        ptePtradeInfoDomain.setTenantCode(ocContractReDomain.getTenantCode());
        ptePtradeInfoDomain.setMerchantCode(ocContractReDomain.getMemberCode());
        ptePtradeInfoDomain.setFchannelPmodeCode(fchannelPmodeCode);
        return ptePtradeInfoDomain;
    }

    public PayInfo saveSubPay(Map<String, Object> envmap, String memberBcode, String contractBillcode, String contractSubCode, String fchannelPmodeCode, String tenantCode) {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OcContractSubReDomain ocContractSubReDomain = this.ocContractSubService.getContractSubByCode(tenantCode, contractSubCode);
        String ptradeSeqno = this.makeSubPte(envmap, memberBcode, contractBillcode, fchannelPmodeCode, ocContractSubReDomain);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractOneByCode(map);
        PayInfo payInfo = new PayInfo();
        payInfo.setContractBlance(ocContractReDomain.getContractBlance());
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(contractSubCode);
        payInfo.setContractBbillcode(ocContractSubReDomain.getContractBillcode());
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        if (null == ocContractSubReDomain.getContractSubGmoney()) {
            ocContractSubReDomain.setContractSubGmoney(BigDecimal.ZERO);
        }
        payInfo.setOrderMoney(ocContractSubReDomain.getContractSubGmoney());
        payInfo.setContMoney(ocContractSubReDomain.getContractSubGmoney());
        payInfo.setPreMoney(BigDecimal.ZERO);
        return payInfo;
    }

    private String makeSubPte(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, OcContractSubReDomain ocContractSubReDomain) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        String ptradeSeqno = this.getSubPay(ocContractSubReDomain, memberBcode, fchannelPmodeCode);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            ptradeSeqno = this.saveSubToPay(envmap, fchannelPmodeCode, ocContractSubReDomain);
        }
        return ptradeSeqno;
    }

    private String getSubPay(OcContractSubReDomain ocContractSubReDomain, String memberBcode, String fchannelPmodeCode) {
        if (null == ocContractSubReDomain) {
            return null;
        }
        if (null == ocContractSubReDomain || !ocContractSubReDomain.getMemberBcode().equals(memberBcode)) {
            this.logger.error("web.pay.PayService.getSubPay.null", (Object)memberBcode);
            return null;
        }
        if (ocContractSubReDomain.getDataState() != 0) {
            this.logger.error("web.pay.PayService.getSubPay.contract.dataState", (Object)("\u8ba2\u5355\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8\u3002\u72b6\u6001=" + ocContractSubReDomain.getDataState()));
            return null;
        }
        String tenantCode = ocContractSubReDomain.getTenantCode();
        String ptradeSeqno = ocContractSubReDomain.getPtradeSeqno();
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractSubCode", ocContractSubReDomain.getContractSubCode());
            map.put("tenantCode", tenantCode);
            map.put("ptradeSeqno", ptradeSeqno);
            PtePtradeReDomain ptePtradeReDomain = this.ptePtradeNewService.getPtradeByCode(map);
            if (null == ptePtradeReDomain) {
                ptradeSeqno = "";
            } else if (PteConstants.DATA_STATE_0 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_1 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_2 == ptePtradeReDomain.getDataState()) {
                if (!fchannelPmodeCode.equals(ptePtradeReDomain.getFchannelPmodeCode())) {
                    ptradeSeqno = "";
                }
            } else if (ocContractSubReDomain.getContractSubGmoney().subtract(ptePtradeReDomain.getOrderAmount()).intValue() != 0) {
                ptradeSeqno = "";
            }
        }
        return ptradeSeqno;
    }

    public PayInfo savePay(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, String tenantCode, PtePtfchannelReDomain ptePtfchannelReDomain) throws ApiException {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("web.pay.PayService.savePay.param", (Object)(contractBillcode + ":" + fchannelPmodeCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractReDomain || null == ocContractReDomain.getDataState() || ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayService.savePay.data", (Object)(contractBillcode + ":" + fchannelPmodeCode + ":" + ocContractReDomain.getDataState()));
            return null;
        }
        return this.savePayCom(envmap, memberBcode, contractBillcode, fchannelPmodeCode, tenantCode, ptePtfchannelReDomain, ocContractReDomain);
    }

    public PayInfo savePayCom(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, String tenantCode, PtePtfchannelReDomain ptePtfchannelReDomain, OcContractReDomain ocContractReDomain) throws ApiException {
        if (null == envmap || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("web.pay.PayService.savePay.param", (Object)(contractBillcode + ":" + fchannelPmodeCode));
            return null;
        }
        if (null == ocContractReDomain || null == ocContractReDomain.getDataState() || ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayService.savePay.data", (Object)(contractBillcode + ":" + fchannelPmodeCode + ":" + ocContractReDomain.getDataState()));
            return null;
        }
        if (BigDecimal.ZERO.compareTo(ocContractReDomain.getDataBmoney()) >= 0) {
            this.logger.error("web.pay.PayService.savePay.0\u5143\u8ba2\u5355", (Object)(contractBillcode + ":" + ocContractReDomain.getDataBmoney()));
            return null;
        }
        if ("2".equals(ocContractReDomain.getContractProperty()) && !ocContractReDomain.getContractBillcode().equals(ocContractReDomain.getContractBbillcode())) {
            this.logger.error("web.pay.PayService.savePay.contractProperty", (Object)"\u8de8\u5e97\u8425\u9500\u591a\u5546\u6237\u4e0d\u5141\u8bb8\u5355\u72ec\u652f\u4ed8");
            throw new ApiException("\u6b64\u8ba2\u5355\u4e0d\u80fd\u5355\u72ec\u652f\u4ed8");
        }
        if (!memberBcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error("web.pay.PayService.savePay.data", (Object)("\u975e\u5f53\u524d\u4e0b\u5355\u7528\u6237" + contractBillcode + ":" + fchannelPmodeCode + ":" + ocContractReDomain.getDataState()));
            return null;
        }
        envmap.put("payDate", ocContractReDomain.getContractPaydate());
        PayInfo payInfo = new PayInfo();
        payInfo.setPtePtfchannelReDomain(ptePtfchannelReDomain);
        String ptradeSeqno = this.makePte(envmap, memberBcode, contractBillcode, fchannelPmodeCode, ocContractReDomain, payInfo);
        this.logger.debug("web.pay.PayService.paymentCommit =====\u5355\u7b14\u652f\u4ed8=====1.2", (Object)ptradeSeqno);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            this.logger.error("web.pay.PayService.savePay.ptradeSeqno", (Object)(contractBillcode + ":" + fchannelPmodeCode));
            return null;
        }
        payInfo.setContractBlance(ocContractReDomain.getContractBlance());
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(contractBillcode);
        payInfo.setContractBbillcode(ocContractReDomain.getContractBbillcode());
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        if (null == ocContractReDomain.getDataBmoney()) {
            ocContractReDomain.setDataBmoney(BigDecimal.ZERO);
        }
        if (null == ocContractReDomain.getPricesetRefrice()) {
            ocContractReDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        payInfo.setOrderMoney(ocContractReDomain.getDataBmoney());
        payInfo.setContMoney(ocContractReDomain.getContractMoney());
        payInfo.setLogMoney(ocContractReDomain.getGoodsLogmoney());
        payInfo.setPacgeMoney(ocContractReDomain.getContractPaymoney());
        payInfo.setPreMoney(ocContractReDomain.getPricesetRefrice());
        payInfo.setContractPaydate(ocContractReDomain.getContractPaydate());
        return payInfo;
    }

    private String getPay(OcContractReDomain ocContractReDomain, String memberBcode, String fchannelPmodeCode, PayInfo payInfo) {
        BankHtmlForm bankHtmlForm;
        if (null == ocContractReDomain || null == payInfo) {
            this.logger.error("web.pay.PayService.savePay.getPay", (Object)"params is null");
            return null;
        }
        if (null == ocContractReDomain || !ocContractReDomain.getMemberBcode().equals(memberBcode)) {
            this.logger.error("web.pay.PayService.savePay.null", (Object)memberBcode);
            return null;
        }
        if (ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayService.savePay.contract.dataState", (Object)("\u8ba2\u5355\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8\u3002\u72b6\u6001=" + ocContractReDomain.getDataState()));
            return null;
        }
        String tenantCode = ocContractReDomain.getTenantCode();
        String ptradeSeqno = ocContractReDomain.getPtradeSeqno();
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payInfo.getPtePtfchannelReDomain());
        }
        catch (Exception e) {
            this.logger.error("web.pay.PayService.savePay.getPay", (Object)("BeanUtils.copyAllPropertys:" + e.getMessage()));
        }
        this.logger.error("web.pay.PayService.savePay.getPay", (Object)("BeanUtils.copyAllPropertys1:" + payInfo.getPtePtfchannelReDomain()));
        ptePtradeParticipantDomain.setOrderAmount(ocContractReDomain.getDataBmoney());
        ptePtradeParticipantDomain.setOrderPrice(ocContractReDomain.getDataBmoney());
        ptePtradeParticipantDomain.setDicActorCode("BANK");
        ptePtradeParticipantDomain.setPtePtradeType("0");
        partList.add(ptePtradeParticipantDomain);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartList(partList);
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode("0");
        ptradeBean.setFchannelPmodeCode(fchannelPmodeCode);
        ptradeBean.setOrderAmount(ocContractReDomain.getDataBmoney());
        this.logger.error("web.pay.PayService.savePay.getPay", (Object)("BeanUtils.copyAllPropertys2:" + JsonUtil.buildNormalBinder().toJson((Object)ptradeBean)));
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            this.logger.error("web.pay.PayService.paymentCommit =====\u5355\u7b14\u652f\u4ed8=====1.1.1.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ptradeBean));
            bankHtmlForm = this.ptePtradeNewService.sendParticipantByPtrade(ptradeBean);
            if (null == bankHtmlForm) {
                this.logger.error("web.pay.PayService.savePay.bankHtmlForm", (Object)"bankHtmlForm is null");
                return null;
            }
        } else {
            this.logger.error("web.pay.PayService.savePay.ptradeSeqno", (Object)"ptradeSeqno is null");
            return null;
        }
        payInfo.setBankHtmlForm(bankHtmlForm);
        this.logger.error("web.pay.PayService.paymentCommit =====\u5355\u7b14\u652f\u4ed8=====1.1.1.2", (Object)ptradeSeqno);
        return ptradeSeqno;
    }

    private String makePte(Map<String, Object> envmap, String memberBcode, String contractBillcode, String fchannelPmodeCode, OcContractReDomain ocContractReDomain, PayInfo payInfo) {
        this.logger.debug("web.pay.PayService.paymentCommit =====\u652f\u4ed8=====1.1.1", (Object)"\u8fdb\u5165makePte");
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            this.logger.error("web.pay.PayService.makePte", (Object)"pte \u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        String ptradeSeqno = this.getPay(ocContractReDomain, memberBcode, fchannelPmodeCode, payInfo);
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            this.logger.debug("web.pay.PayService.paymentCommit =====\u652f\u4ed8=====1.1.2", (Object)"\u8fdb\u5165saveToPay");
            ptradeSeqno = this.saveToPay(envmap, contractBillcode, fchannelPmodeCode, ocContractReDomain, payInfo);
        }
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            this.logger.error("web.pay.PayService.makePte", (Object)"ptradeSeqno\u4e3a\u7a7a");
            return null;
        }
        ocContractReDomain.setPtradeSeqno(ptradeSeqno);
        return ptradeSeqno;
    }

    private String saveSubToPay(Map<String, Object> envmap, String fchannelPmodeCode, OcContractSubReDomain ocContractSubReDomain) {
        if (null == envmap || null == ocContractSubReDomain || StringUtils.isBlank((String)fchannelPmodeCode)) {
            return null;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(ocContractSubReDomain.getContractSubGmoney());
        ptePtradeDomain.setOrderAmount(ocContractSubReDomain.getContractSubGmoney());
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setBusinessType("P01");
        ptePtradeDomain.setAcquireSeqno(ocContractSubReDomain.getContractSubCode());
        ptePtradeDomain.setPartnerCode(ocContractSubReDomain.getMemberCode());
        ptePtradeDomain.setBusinessOrderno(ocContractSubReDomain.getContractSubCode());
        ptePtradeDomain.setBusinessOrder(ocContractSubReDomain.getContractBillcode());
        ptePtradeDomain.setPaymentMemo(ocContractSubReDomain.getContractBillcode());
        ptePtradeDomain.setOpuserCode(ocContractSubReDomain.getMemberBcode());
        ptePtradeDomain.setOpuserName(ocContractSubReDomain.getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(ocContractSubReDomain.getTenantCode());
        ptePtradeDomain.setMerchantCode(ocContractSubReDomain.getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.sendContracSubPay");
        String ptradeSeqno = this.ptePtradeNewService.sendSavePtrade(ptePtradeDomain);
        this.ocContractSubService.updateContracSubPate(ocContractSubReDomain.getTenantCode(), ocContractSubReDomain.getContractSubCode(), ptradeSeqno);
        return ptradeSeqno;
    }

    private String saveToPay(Map<String, Object> envmap, String contractBillcode, String fchannelPmodeCode, OcContractReDomain ocContractReDomain, PayInfo payInfo) {
        if (null == envmap || null == payInfo || null == ocContractReDomain || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode)) {
            this.logger.error("web.pay.PayService.saveToPay", (Object)"params is null");
            return null;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(ocContractReDomain.getDataBmoney());
        ptePtradeDomain.setOrderAmount(ocContractReDomain.getDataBmoney());
        ptePtradeDomain.setPtradeType("03");
        ptePtradeDomain.setBusinessType("P01");
        ptePtradeDomain.setAcquireSeqno(contractBillcode);
        ptePtradeDomain.setPartnerCode(ocContractReDomain.getMemberCode());
        ptePtradeDomain.setBusinessOrderno(contractBillcode);
        ptePtradeDomain.setBusinessOrder(ocContractReDomain.getContractBbillcode());
        ptePtradeDomain.setPaymentMemo(contractBillcode);
        ptePtradeDomain.setOpuserCode(ocContractReDomain.getMemberBcode());
        ptePtradeDomain.setOpuserName(ocContractReDomain.getMemberBname());
        ptePtradeDomain.setPtradpdeCode("PAYMENT");
        ptePtradeDomain.setTenantCode(ocContractReDomain.getTenantCode());
        ptePtradeDomain.setMerchantCode(ocContractReDomain.getMemberCode());
        ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payInfo.getPtePtfchannelReDomain());
        }
        catch (Exception e) {
            this.logger.error("web.pay.PayService.saveToPay", (Object)("BeanUtils.copyAllPropertys Exception\uff1a" + e.getMessage()));
        }
        ptePtradeParticipantDomain.setOrderAmount(ocContractReDomain.getDataBmoney());
        ptePtradeParticipantDomain.setOrderPrice(ocContractReDomain.getDataBmoney());
        ptePtradeParticipantDomain.setDicActorCode("BANK");
        ptePtradeParticipantDomain.setPtePtradeType("0");
        partList.add(ptePtradeParticipantDomain);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPartList(partList);
        ptradeBean.setFchannelPmodeCode(fchannelPmodeCode);
        ptradeBean.setTenantCode(ocContractReDomain.getTenantCode());
        ptePtradeDomain.setPtradeBean(ptradeBean);
        ptradeBean.setFchannelMode("0");
        ArrayList<Map<String, Object>> ristInfo = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> goodsDetails = new ArrayList<Map<String, Object>>();
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList();
        if (ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            if (ListUtil.isEmpty(ocContractReDomain.getPackageList())) {
                this.logger.error("web.pay.PayService.saveToPay.PackageList", (Object)"ocContractReDomain.getPackageList() is null");
                return null;
            }
            for (OcPackageDomain ocPackageDomain : ocContractReDomain.getPackageList()) {
                goodsList.addAll(ocPackageDomain.getContractGoodsList());
            }
        } else {
            goodsList = ocContractReDomain.getGoodsList();
        }
        this.logger.error("web.pay.PayService.saveToPay.PackageList1", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.makePayGoods(envmap, ristInfo, goodsDetails, goodsList);
        this.logger.error("web.pay.PayService.saveToPay.PackageList2", (Object)JsonUtil.buildNormalBinder().toJson(goodsDetails));
        envmap.put("ristInfo", JsonUtil.buildNormalBinder().toJson(ristInfo));
        envmap.put("goodsDetails", JsonUtil.buildNormalBinder().toJson(goodsDetails));
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(envmap));
        this.logger.info("web.pay.PayService.paymentCommit =====\u652f\u4ed8=====1.1.2.1", (Object)("saveContracPay:" + ptePtradeDomain.getBusinessOrderno()));
        ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.saveContracPay");
        BankHtmlForm bankHtmlForm = this.ptePtradeNewService.sendSaveAutoCommit(ptePtradeDomain);
        if (null == bankHtmlForm) {
            this.logger.error("web.pay.PayService.saveToPay", (Object)"bankHtmlForm is null");
            return null;
        }
        payInfo.setBankHtmlForm(bankHtmlForm);
        String ptradeSeqno = bankHtmlForm.getPtradeSeqno();
        HashMap<String, String> contractTradeMap = new HashMap<String, String>();
        contractTradeMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
        if (!ocContractReDomain.getContractBillcode().equals(ocContractReDomain.getContractBbillcode())) {
            contractTradeMap.put("contractBbillcode", ocContractReDomain.getContractBillcode());
            ocContractReDomain.setContractBbillcode(ocContractReDomain.getContractBillcode());
        }
        contractTradeMap.put("fchannelCode", payInfo.getPtePtfchannelReDomain().getFchannelCode());
        contractTradeMap.put("fchannelName", payInfo.getPtePtfchannelReDomain().getFchannelName());
        contractTradeMap.put("ptradeSeqno", ptradeSeqno);
        contractTradeMap.put("tenantCode", ocContractReDomain.getTenantCode());
        this.logger.info("web.pay.PayService.paymentCommit =====\u652f\u4ed8=====1.1.2.2", (Object)JsonUtil.buildNormalBinder().toJson(contractTradeMap));
        this.ocContractService.updateContractPtradeSeqno(contractTradeMap);
        return ptradeSeqno;
    }

    public Map<String, PtePtfchannelReDomain> queryChannel(String fchannelPmodeCode, String tenantCode, String fchannelDr, UserSession userSession, String tginfoCode, String channelCode, String proappCode) {
        List<PtePtfchannelReDomain> list = this.getPtfchannelByChannel(userSession, fchannelPmodeCode, tenantCode, fchannelDr, tginfoCode, channelCode, proappCode);
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        HashMap<String, PtePtfchannelReDomain> channelmap = new HashMap<String, PtePtfchannelReDomain>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : list) {
            channelmap.put(ptePtfchannelReDomain.getFchannelCode(), ptePtfchannelReDomain);
        }
        return channelmap;
    }

    public List<PtePtfchannelReDomain> getPtfchannelByChannel(UserSession userSession, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode) {
        DisChannel disChannel;
        if (null == userSession || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String memberCode = userSession.getUserinfoParentCode();
        this.logger.error("web.pay.PayService.getPtfchannelByChannel.param:" + memberCode + "-" + fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr + "-" + tginfoCode + "-" + channelCode + "-" + proappCode);
        List qlist = null;
        String mpmemberCode = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            mpmemberCode = "-" + disChannel.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)memberCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)tginfoCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)channelCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)proappCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            String qtype;
            String dis;
            String type;
            String quality;
            String sort = userSession.getUserinfoSort();
            if (StringUtils.isNotBlank((String)sort) && ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(quality = userSession.getUserinfoQuality())) && ListUtil.isEmpty(qlist)) {
                String[] quaS = quality.split(",");
                List qqlist = new ArrayList();
                for (String qua : quaS) {
                    qqlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    if (ListUtil.isEmpty(qqlist) && StringUtils.isNotBlank((String)mpmemberCode)) {
                        qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    }
                    if (!ListUtil.isNotEmpty(qqlist)) continue;
                    if (null == qlist) {
                        qlist = new ArrayList();
                    }
                    qlist.addAll(qqlist);
                }
            }
            if (StringUtils.isNotBlank((String)(type = userSession.getUserinfoType())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-type-" + type + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-type-" + type + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(dis = userSession.getUserinfoDischannelcode())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(qtype = userSession.getQualityQtypeCode())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
        }
        if (ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)PTE_PTFCHANNEL_CHANNEL, (String)(channelCode + "-" + fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            this.logger.error("web.pay.PayService.getPtfchannelByChannel.qlist.null");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fchannelPmodeCode", fchannelPmodeCode);
            map.put("tenantCode", tenantCode);
            map.put("channelCode", channelCode);
            map.put("fchannelDr", fchannelDr);
            map.put("dataState", "1");
            qlist = this.ptePtfchannelService.queryPtfchannelReList(map);
            if (null == qlist || qlist.isEmpty()) {
                this.logger.error("web.pay.PayService.getPayChannel.null", (Object)((Object)map).toString());
                return null;
            }
        }
        return qlist;
    }

    public List<PtePtfchannelReDomain> getPtfchannel(UserSession userSession, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode) {
        DisChannel disChannel;
        if (null == userSession || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        List qlist = null;
        String mpmemberCode = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            mpmemberCode = "-" + disChannel.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)memberCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)tginfoCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)channelCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)proappCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            String qtype;
            String dis;
            String type;
            String quality;
            String sort = userSession.getUserinfoSort();
            if (StringUtils.isNotBlank((String)sort) && ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-sort-" + sort + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(quality = userSession.getUserinfoQuality())) && ListUtil.isEmpty((Collection)qlist)) {
                String[] quaS = quality.split(",");
                List qqlist = new ArrayList();
                for (String qua : quaS) {
                    qqlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    if (ListUtil.isEmpty(qqlist) && StringUtils.isNotBlank((String)mpmemberCode)) {
                        qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-quality-" + qua + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
                    }
                    if (!ListUtil.isNotEmpty(qqlist)) continue;
                    if (null == qlist) {
                        qlist = new ArrayList();
                    }
                    qlist.addAll(qqlist);
                }
            }
            if (StringUtils.isNotBlank((String)(type = userSession.getUserinfoType())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-type-" + type + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-type-" + type + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(dis = userSession.getUserinfoDischannelcode())) && ListUtil.isEmpty((Collection)qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-dis-" + dis + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
            if (StringUtils.isNotBlank((String)(qtype = userSession.getQualityQtypeCode())) && ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
                qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-qtype-" + qtype + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
            }
        }
        if (ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannelReDomain.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannelReDomain.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fchannelPmodeCode", fchannelPmodeCode);
            map.put("tenantCode", tenantCode);
            map.put("fchannelDr", fchannelDr);
            qlist = this.ptePtfchannelService.queryPtfchannelReList(map);
            if (null == qlist || qlist.isEmpty()) {
                this.logger.error("web.pay.PayService.getPayChannel.null", (Object)((Object)map).toString());
                return null;
            }
        }
        return qlist;
    }

    public List<PayChannel> getPayChannel(UserSession userSession, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode, String userOcode) {
        List<PtePtfchannelReDomain> qlist;
        if (null == userSession || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String type = memberCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        if (ListUtil.isEmpty(qlist = this.getPtfchannel(userSession, fchannelPmodeCode, tenantCode, fchannelDr, tginfoCode, channelCode, proappCode))) {
            this.logger.error("web.pay.PayService.getPayChannel.qlist", (Object)(memberCode + "-" + fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr + "-" + tginfoCode + "-" + channelCode + "-" + proappCode));
            return null;
        }
        Map<String, VdFaccountInfo> account = this.getVd(memberCode, tenantCode, faccountType);
        ArrayList<PayChannel> channelList = new ArrayList<PayChannel>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : qlist) {
            String channelType;
            List<VdFaccountInfo> vdList;
            HashMap<String, Object> map;
            PayChannel payChannel;
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode())) {
                payChannel = new PayChannel();
                try {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                    if ("1".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                        map = new HashMap<String, Object>();
                        map.put("tenantCode", tenantCode);
                        map.put("memberCode", memberCode);
                        map.put("fchannelType", ptePtfchannelReDomain.getFchannelType());
                        vdList = this.queryAmt(map, ptePtfchannelReDomain.getPtfchannelAmtapi(), userOcode);
                        if (ListUtil.isNotEmpty(vdList)) {
                            BeanUtils.copyAllPropertys((Object)payChannel, (Object)vdList.get(0));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("web.pay.PayService.getPayChannel.e", (Throwable)e);
                }
                channelList.add(payChannel);
                continue;
            }
            String fundType = ptePtfchannelReDomain.getFundType();
            if (StringUtils.isBlank((String)fundType)) {
                fundType = "01";
            }
            if (StringUtils.isBlank((String)(channelType = ptePtfchannelReDomain.getFchannelType()))) {
                channelType = "";
            }
            if (!faccountType.equals(channelType) && !fundType.equals("01") && type.equals(channelType.substring(0, 1))) {
                Map<String, VdFaccountInfo> naccount = this.getVd(memberCode, tenantCode, ptePtfchannelReDomain.getFchannelType());
                if (null == naccount || naccount.isEmpty()) {
                    this.logger.error("web.pay.PayService.getPayChannel.naccount", (Object)(memberCode + ":" + tenantCode + ":" + ptePtfchannelReDomain.getFchannelType()));
                    continue;
                }
                account.putAll(naccount);
            } else if (!type.equals(channelType.substring(0, 1))) {
                this.logger.error("web.pay.PayService.getPayChannel.type", (Object)(memberCode + ":" + tenantCode + ":" + ptePtfchannelReDomain.getFchannelType()));
                continue;
            }
            payChannel = new PayChannel();
            try {
                BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                VdFaccountInfo v = account.get(ptePtfchannelReDomain.getFchannelType());
                if (null != v) {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)v);
                }
                if ("1".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                    map = new HashMap();
                    map.put("tenantCode", tenantCode);
                    map.put("memberCode", memberCode);
                    map.put("fchannelType", ptePtfchannelReDomain.getFchannelType());
                    vdList = this.queryAmt(map, ptePtfchannelReDomain.getPtfchannelAmtapi(), memberCode);
                    if (ListUtil.isNotEmpty(vdList)) {
                        BeanUtils.copyAllPropertys((Object)payChannel, (Object)vdList.get(0));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("web.pay.PayService.getPayChannel.e1", (Throwable)e);
            }
            channelList.add(payChannel);
        }
        return channelList;
    }

    public List<VdFaccountInfo> queryAmt(Map<String, Object> map, String apiCode, String userOcode) {
        PostParamMap pmap = new PostParamMap(apiCode);
        pmap.putParam("userAccount", (Object)userOcode);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.getForList(pmap, VdFaccountInfo.class);
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List<VdFaccountInfo> vdList = this.vdFaccountService.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    public HtmlJsonReBean saveContractSettlBatch(List<OcContractSettlDomain> ocContractSettlDomainList) {
        return this.ocContractService.saveContractSettlBatch(ocContractSettlDomainList);
    }

    public Map<String, OcContractSettlDomain> queryContractSettl(String contractBillcode, String tenantCode) {
        List<OcContractSettlDomain> list = this.ocContractService.queryContractSettlByContractCode(tenantCode, contractBillcode);
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        HashMap<String, OcContractSettlDomain> map = new HashMap<String, OcContractSettlDomain>();
        for (OcContractSettlDomain ocContractSettlDomain : list) {
            map.put(ocContractSettlDomain.getContractSettlBlance(), ocContractSettlDomain);
        }
        return map;
    }

    public HtmlJsonReBean saveContractSublistBatch(List<OcContractSublistDomain> ocContractSublistDomainList) {
        return this.ocContractSubService.saveContractSublistBatch(ocContractSublistDomainList);
    }

    public OcContractSubReDomain getContractSub(String tenantCode, String contractSubCode) {
        return this.ocContractSubService.getContractSubByCode(tenantCode, contractSubCode);
    }
}

