/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmFootprintDomain;
import cn.com.qj.bff.domain.um.UmFootprintReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UmFootprintService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/footprint"}, name="\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
public class FootprintCon
extends SpringmvcController {
    private static String CODE = "um.footprint.con";
    @Autowired
    private UmFootprintService umFootprintService;
    @Autowired
    private RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "footprint";
    }

    @RequestMapping(value={"saveFootprint.json"}, name="\u589e\u52a0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveFootprint(HttpServletRequest request, UmFootprintDomain umFootprintDomain) {
        if (null == umFootprintDomain) {
            this.logger.error("EXCEPTION:" + CODE + ".saveFootprint.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("EXCEPTION:" + CODE + ".saveFootprint.UserSession", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("footprintType", umFootprintDomain.getFootprintType());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("fuzzy", false);
        param.put("userinfoCode", userSession.getUserPcode());
        if (umFootprintDomain.getFootprintType().equals("0")) {
            param.put("footprintOpcode", umFootprintDomain.getFootprintOpcode());
        } else {
            param.put("footprintOpcont", umFootprintDomain.getFootprintOpcont());
        }
        HashMap<String, Object> skuParam = new HashMap<String, Object>();
        skuParam.put("skuCode", umFootprintDomain.getFootprintOpcode());
        skuParam.put("tenantCode", this.getTenantCode(request));
        RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(skuParam);
        String channelCode = skuByCode.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error("EXCEPTION:" + CODE + ".saveFootprint.channel.null", (Object)"UserSession is null");
            return new HtmlJsonReBean("error", "\u5546\u54c1\u6e20\u9053\u4e3a\u7a7a");
        }
        String tginfoChannel = BaseInterUtil.getChannelCodeByType((HttpServletRequest)request, (String)BaseInterUtil.QUA_BUY);
        if (StringUtils.isBlank((String)tginfoChannel)) {
            this.logger.error("EXCEPTION:" + CODE + ".saveFootprint.tginfoChannel.null", (Object)"UserSession is null");
            return new HtmlJsonReBean("error", "\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
        }
        if (!channelCode.equals(tginfoChannel)) {
            this.logger.error("EXCEPTION:" + CODE + ".saveFootprint.channel.notSame", (Object)"saveFootprint \u5546\u54c1\u6e20\u9053\u548c\u7ad9\u70b9\u6e20\u9053\u4e0d\u4e00\u81f4");
            return new HtmlJsonReBean();
        }
        String proappCode = this.getProappCode(request);
        SupQueryResult<UmFootprintReDomain> footprintList = this.umFootprintService.queryFootprintPage(param);
        String s = JsonUtil.buildNormalBinder().toJson(footprintList);
        if (ListUtil.isEmpty((Collection)footprintList.getList())) {
            umFootprintDomain.setProappCode(proappCode);
            umFootprintDomain.setOauthEnvCode(this.getOauthEnvCode(request));
            umFootprintDomain.setChannelCode(skuByCode.getChannelCode());
            umFootprintDomain.setChannelName(skuByCode.getChannelName());
            umFootprintDomain.setUserCode(userSession.getUserCode());
            umFootprintDomain.setUserinfoCode(userSession.getUserPcode());
            umFootprintDomain.setUserName(userSession.getMerberCompname());
            umFootprintDomain.setTenantCode(this.getTenantCode(request));
            return this.umFootprintService.saveFootprint(umFootprintDomain);
        }
        if (null == ((UmFootprintReDomain)footprintList.getList().get(0)).getFootprintId()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmFootprintReDomain footprintReDomain = new UmFootprintReDomain();
        footprintReDomain.setFootprintId(((UmFootprintReDomain)footprintList.getList().get(0)).getFootprintId());
        footprintReDomain.setTenantCode(((UmFootprintReDomain)footprintList.getList().get(0)).getTenantCode());
        return this.umFootprintService.updateFootprint(footprintReDomain);
    }

    @RequestMapping(value={"getFootprint.json"}, name="\u83b7\u53d6\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmFootprintReDomain getFootprint(HttpServletRequest request, Integer footprintId) {
        if (StringUtils.isBlank((Integer)footprintId)) {
            this.logger.error(CODE + ".getFootprint", (Object)"param is null");
            return null;
        }
        UmFootprintReDomain umFootprintReDomain = this.umFootprintService.getFootprint(footprintId);
        if (null == umFootprintReDomain) {
            return null;
        }
        if (!umFootprintReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".getFootprint.user", (Object)"user is null");
            return null;
        }
        return umFootprintReDomain;
    }

    @RequestMapping(value={"updateFootprint.json"}, name="\u66f4\u65b0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateFootprint(HttpServletRequest request, UmFootprintDomain umFootprintDomain) {
        if (null == umFootprintDomain) {
            this.logger.error(CODE + ".updateFootprint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateFootprint", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umFootprintDomain.setUserCode(userSession.getUserCode());
        umFootprintDomain.setUserinfoCode(userSession.getUserPcode());
        umFootprintDomain.setUserName(userSession.getMerberCompname());
        umFootprintDomain.setTenantCode(this.getTenantCode(request));
        return this.umFootprintService.updateFootprint(umFootprintDomain);
    }

    @RequestMapping(value={"deleteFootprint.json"}, name="\u5220\u9664\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteFootprint(HttpServletRequest request, Integer footprintId) {
        if (StringUtils.isBlank((Integer)footprintId)) {
            this.logger.error(CODE + ".deleteFootprint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == this.getFootprint(request, footprintId)) {
            this.logger.error(CODE + ".deleteFootprint.user", (Object)"user is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umFootprintService.deleteFootprint(footprintId);
    }

    @RequestMapping(value={"deleteFootprintByCode.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteFootprintByCode(HttpServletRequest request, String footprintCode) {
        if (StringUtils.isBlank((String)footprintCode)) {
            this.logger.error(CODE + ".deleteFootprintByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".deleteFootprintByCode.userSession", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmFootprintReDomain footprintByCode = this.umFootprintService.getFootprintByCode(userSession.getTenantCode(), footprintCode);
        if (null == footprintByCode || !footprintByCode.getUserinfoCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteFootprintByCode.footprintByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umFootprintService.deleteFootprintByCode(this.getTenantCode(request), footprintCode);
    }

    @RequestMapping(value={"deleteFootprintByCodeStr.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u8db3\u8ff9\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteFootprintByCodeStr(HttpServletRequest request, String footprintCodeStr) {
        HtmlJsonReBean htmlJsonReBean = null;
        UserSession userSession = this.getUserSession(request);
        this.logger.error(CODE + ".userSession.param:TenantCode\uff1a" + this.getTenantCode(request) + ",UserPcode\uff1a" + userSession.getUserPcode());
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".userSession.userPcode", (Object)"userSession/userPcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)footprintCodeStr)) {
            htmlJsonReBean = this.umFootprintService.deleteFootprintByUserinfoCode(this.getTenantCode(request), userSession.getUserPcode());
        } else {
            List<String> codeList = this.getCodeList(footprintCodeStr);
            for (String footprintCode : codeList) {
                UmFootprintReDomain footprintByCode = this.umFootprintService.getFootprintByCode(userSession.getTenantCode(), footprintCode);
                if (null == footprintByCode || !footprintByCode.getUserinfoCode().equals(userSession.getUserPcode())) {
                    this.logger.error(CODE + ".deleteFootprintByCodeStr.footprintByCode", (Object)"param is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
                }
                htmlJsonReBean = this.umFootprintService.deleteFootprintByCode(this.getTenantCode(request), footprintCode);
            }
        }
        return htmlJsonReBean;
    }

    private List<String> getCodeList(String str) {
        ArrayList<String> codeList = null;
        if (null != str && str.length() > 0) {
            String[] codeStr = str.split(",");
            codeList = new ArrayList<String>();
            for (String code : codeStr) {
                codeList.add(code);
            }
        }
        return codeList;
    }

    @RequestMapping(value={"queryFootprintPage.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmFootprintReDomain> queryFootprintPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umFootprintService.queryFootprintPage(param);
    }

    @RequestMapping(value={"queryFootprintPagePlat.json"}, name="\u67e5\u8be2\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmFootprintReDomain> queryFootprintPagePlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("userinfoCode", this.getMerchantCode(request));
            param.put("orderStr", "GMT_MODIFIED desc");
            String channelCode = BaseInterUtil.getChannelCodeByType((HttpServletRequest)request, (String)BaseInterUtil.QUA_BUY);
            if (StringUtils.isNotBlank((String)channelCode)) {
                param.put("channelCode", channelCode);
            }
        }
        return this.umFootprintService.queryFootprintPage(param);
    }

    public String getCompanyChannel(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String channelCode = "";
        String userinfoCode = "";
        if ("buy".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserinfoParentCode();
        }
        if ("company".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserPcode();
        }
        if (StringUtils.isNotBlank((String)userinfoCode) && StringUtils.isNotBlank((String)userSession.getUserPcode())) {
            String tenantCode = this.getTenantCode(request);
            DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(userinfoCode + "-0-" + tenantCode), DisChannel.class);
            if (null == disChannel) {
                this.logger.error(CODE + ".find.childFlagstr", (Object)(" is null" + userinfoCode));
                return null;
            }
            if (!"wechatmini".equals(this.getOauthEnvCode(request))) {
                channelCode = this.getTginfoChannel(request);
            }
            if (StringUtils.isBlank((String)channelCode)) {
                channelCode = disChannel.getChannelCode();
            }
        }
        return channelCode;
    }

    @RequestMapping(value={"updateFootprintState.json"}, name="\u66f4\u65b0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateFootprintState(String footprintId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)footprintId)) {
            this.logger.error(CODE + ".updateFootprintState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umFootprintService.updateFootprintState(Integer.valueOf(footprintId), dataState, oldDataState);
    }
}

