/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.service;

import cn.com.qj.bff.common.bean.FmFileDomainBean;
import cn.com.qj.bff.common.bean.FmFileReDomainBean;
import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.service.ExcelIService;
import cn.com.qj.bff.common.service.HtmlIBaseService;
import cn.com.qj.bff.common.util.ExportExcelUtlis;
import cn.com.qj.bff.core.service.HtmlServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelService
extends HtmlServiceImpl
implements ExcelIService {
    private static final String sys_code = "com.common.ExcelService.";
    @Autowired
    private HtmlIBaseService htmlIBaseService;
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    @Override
    public void exportExcel(Map<String, Object> paramMap, String apiRouter) {
        if (MapUtil.isEmpty(paramMap) || StringUtils.isBlank((String)apiRouter)) {
            this.logger.error("com.common.ExcelService.intoParam.null", (Object)("paramMap:" + paramMap + ",apiRouter:" + apiRouter));
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        Object condition = paramMap.get("condition");
        String userCode = null == paramMap.get("userCode") ? "" : (String)paramMap.get("userCode");
        String fileName = null == paramMap.get("fileName") ? "\u6570\u636e\u5bfc\u51fa" : (String)paramMap.get("fileName");
        int rows = null == paramMap.get("row") ? 100 : Integer.valueOf(paramMap.get("row").toString());
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = paramMap.get("headMap");
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNonDefaultBinder().toJson(headMap), Object.class);
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        int index = 0;
        HashMap<String, Object> conditionMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(condition), String.class, Object.class);
        if (MapUtil.isEmpty((Map)conditionMap)) {
            conditionMap = new HashMap<String, Object>();
        }
        conditionMap.put("tenantCode", tenantCode);
        conditionMap.put("rows", rows);
        while (true) {
            conditionMap.put("order", true);
            conditionMap.put("page", page * rows);
            List<Object[]> dataList = this.queryExportExcelData(headMapList, conditionMap, apiRouter);
            if (ListUtil.isEmpty(dataList)) break;
            try {
                ExportExcelUtlis.exportExcel(sheet, row, headers, dataList, "yyyy-MM-dd HH:mm:ss", index);
            }
            catch (Exception e) {
                this.logger.error("com.common.ExcelService.exportExcel", (Object)"exportExcelException", (Throwable)e);
                return;
            }
            index += dataList.size();
            ++page;
        }
        this.saveExcel(workbook.getBytes(), fileName, userCode, "xls", tenantCode);
        this.logger.debug("com.common.ExcelService..saveExcel.end");
    }

    @Override
    public void exportComExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter) {
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter)) {
            this.logger.error("com.common.ExcelService.intoParam.null", (Object)("paramMap:" + paramMap + ",apiRouter:" + apiRouter));
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNonDefaultBinder().toJson(headMap), Object.class);
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        int index = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        while (true) {
            paramMap.put("page", page);
            ExcelService.makePage(paramMap);
            PostParamMap<String, Object> pmap = new PostParamMap<String, Object>(apiRouter);
            pmap.putParamToJson("map", paramMap);
            SupQueryResult<Object> supQueryResult = this.htmlIBaseService.sendReSupObject(pmap, Object.class);
            List datalist = supQueryResult.getList();
            if (ListUtil.isEmpty((Collection)datalist)) break;
            List<Map<String, Object>> fromDataList = this.covertExportData(datalist);
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            ArrayList<String> data = null;
            for (Map<String, Object> map : fromDataList) {
                data = new ArrayList<String>();
                for (Map map1 : headMapList) {
                    String beanName = map1.get("dataName").toString();
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    data.add(value);
                }
                String[] array = data.toArray(new String[data.size()]);
                dataList.add(array);
            }
            try {
                ExportExcelUtlis.exportExcel(sheet, row, headers, dataList, "yyyy-MM-dd HH:mm:ss", index);
            }
            catch (Exception e) {
                this.logger.error("com.common.ExcelService.exportExcel", (Object)"exportExcelException", (Throwable)e);
                return;
            }
            index += dataList.size();
            ++page;
        }
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("com.common.ExcelService.tempPath.null", (Object)("tempPath:" + tempPath));
            return;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            this.logger.error("com.common.ExcelService..outputStream.e", (Throwable)e);
            return;
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray(tempPath);
        }
        catch (Exception e) {
            this.logger.error("com.common.ExcelService..InputStreamByteArray.e", (Throwable)e);
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
        this.logger.debug("com.common.ExcelService..saveExcel.end");
    }

    private List<Object[]> queryExportExcelData(List<Map<String, Object>> headMapList, Map<String, Object> conditionMap, String apiRouter) {
        this.logger.debug("com.common.ExcelService.queryparam", (Object)("conditionMap:" + conditionMap));
        List<Map<String, Object>> fromDataList = this.getExportData(apiRouter, conditionMap);
        this.logger.debug("com.common.ExcelService.queryData.size", (Object)fromDataList.size());
        if (ListUtil.isEmpty(fromDataList)) {
            this.logger.error("com.common.ExcelService.exportExcel.getExportData", (Object)"fromDataList is null");
            return null;
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<String> data = null;
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map<String, Object> map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
        }
        return dataList;
    }

    private void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("com.common.ExcelService.saveExcel.null", (Object)("bytes:" + bytes.length + ",fileName:" + fileName + ",tenantCode:" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(bytes);
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", fmFileReDomainBean);
    }

    private List<Map<String, Object>> getExportData(String apiRouter, Map<String, Object> map) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>(apiRouter);
        pmap.putParamToJson("map", map);
        SupQueryResult<Object> supQueryResult = this.htmlIBaseService.sendReSupObject(pmap, Object.class);
        List datalist = supQueryResult.getList();
        return this.covertExportData(datalist);
    }

    public List<Map<String, Object>> covertExportData(List<?> datalist) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Object o : datalist) {
            String substring = o.toString().substring(1, o.toString().length() - 1);
            String[] split = substring.split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : split) {
                String[] split1 = s.split("=");
                if (split1.length == 1) {
                    map.put(split1[0].trim(), "null");
                    continue;
                }
                map.put(split1[0].trim(), split1[1].trim());
            }
            mapList.add(map);
        }
        return mapList;
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("com.common.ExcelService.saveFile", (Object)("FmFileDomainBeanBean:" + FmFileDomainBeanBean + ",fileBean:" + fileBean));
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("com.common.ExcelService.saveFile.e", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    public static void makePage(Map<String, Object> map) {
        String rows;
        String page;
        if (null == map || map.isEmpty()) {
            return;
        }
        String string = page = null == map.get(ui_page) ? "1" : map.get(ui_page).toString();
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        String string2 = rows = null == map.get(ui_rows) ? "0" : map.get(ui_rows).toString();
        if (StringUtils.isBlank((String)rows) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }

    public static void main(String[] args) {
    }
}

