/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.ul.UlLevelClearDomain;
import cn.com.qj.bff.domain.ul.UlLevelUllistReDomain;
import cn.com.qj.bff.domain.um.UmCollectDomain;
import cn.com.qj.bff.domain.um.UmCollectReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoDataReDomin;
import cn.com.qj.bff.service.es.SearchengineService;
import cn.com.qj.bff.service.ul.UlLevelClearService;
import cn.com.qj.bff.service.ul.UlLevelUllistService;
import cn.com.qj.bff.service.um.UmCollectService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/collect"}, name="\u7528\u6237\u6536\u85cf\u4fe1\u606f")
public class CollectCon
extends SpringmvcController {
    private static String CODE = "um.collect.con";
    @Autowired
    private UmCollectService umCollectService;
    @Autowired
    private UlLevelUllistService ulLevelUllistService;
    @Autowired
    private UlLevelClearService ulLevelClearService;
    @Autowired
    private SearchengineService searchengineService;

    @Override
    protected String getContext() {
        return "collect";
    }

    @RequestMapping(value={"saveCollect.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult<UmCollectReDomain> qlist = this.umCollectService.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getCompanyChannel(request));
        HtmlJsonReBean htmlJsonReBean = this.umCollectService.saveCollect(umCollectDomain);
        if (htmlJsonReBean.isSuccess()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("memberCode", userSession.getUserPcode());
            map.put("tenantCode", this.getTenantCode(request));
            map.put("levelRuleApi", "FirstCollection");
            map.put("levelUserqua", userSession.getUserinfoQuality());
            SupQueryResult<UlLevelUllistReDomain> ulLevelUllistReDomainSupQueryResult = this.ulLevelUllistService.queryUlLevelUllistPage(map);
            if (ListUtil.isEmpty((Collection)ulLevelUllistReDomainSupQueryResult.getList())) {
                UlLevelClearDomain ulLevelClearDomain = new UlLevelClearDomain();
                ulLevelClearDomain.setMemberCode(userSession.getUserPcode());
                ulLevelClearDomain.setMemberName(userSession.getMerberCompname());
                ulLevelClearDomain.setLevelRuleApi("FirstCollection");
                ulLevelClearDomain.setTenantCode(this.getTenantCode(request));
                ulLevelClearDomain.setLevelClearDirection("0");
                ulLevelClearDomain.setLevelListExcode(userSession.getUserinfoParentCode());
                ulLevelClearDomain.setLevelListExname(userSession.getUserinfoParentName());
                ulLevelClearDomain.setMemberMcode(this.getTeananMemberCode(request));
                ulLevelClearDomain.setLevelClearOpcode(this.createUUIDString());
                ulLevelClearDomain.setLevelClearOpmark(userSession.getUserPcode());
                ulLevelClearDomain.setLevelClearNum(null);
                ulLevelClearDomain.setLevelType("0");
                ulLevelClearDomain.setLevelUserqua(userSession.getUserinfoQuality());
                this.ulLevelClearService.sendLevelClearCompleted(ulLevelClearDomain);
            }
        }
        return htmlJsonReBean;
    }

    public String getCompanyChannel(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String channelCode = "";
        String userinfoCode = "";
        if ("buy".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserinfoParentCode();
        }
        if ("company".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserPcode();
        }
        if (StringUtils.isNotBlank((String)userinfoCode) && StringUtils.isNotBlank((String)userSession.getUserPcode())) {
            String tenantCode = this.getTenantCode(request);
            DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(userinfoCode + "-0-" + tenantCode), DisChannel.class);
            if (null == disChannel) {
                this.logger.error(CODE + ".find.childFlagstr", (Object)(" is null" + userinfoCode));
                return null;
            }
            if (!"wechatmini".equals(this.getOauthEnvCode(request))) {
                channelCode = this.getTginfoChannel(request);
            }
            if (StringUtils.isBlank((String)channelCode)) {
                channelCode = disChannel.getChannelCode();
            }
        }
        return channelCode;
    }

    @RequestMapping(value={"saveCollectBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollectBatch(HttpServletRequest request, String umCollectDomainList) {
        if (null == umCollectDomainList) {
            this.logger.error(CODE + ".saveCollectBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String nowChannel = this.getCompanyChannel(request);
        List umCollectDomains = JsonUtil.buildNormalBinder().getJsonToList(umCollectDomainList, UmCollectDomain.class);
        for (UmCollectDomain umCollectDomain : umCollectDomains) {
            SupQueryResult<UmCollectReDomain> qlist = this.umCollectService.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) continue;
            umCollectDomain.setUserCode(userSession.getUserCode());
            umCollectDomain.setUserinfoCode(userSession.getUserPcode());
            umCollectDomain.setUserName(userSession.getMerberCompname());
            umCollectDomain.setTenantCode(tenantCode);
            umCollectDomain.setProappCode(proappCode);
            umCollectDomain.setOauthEnvCode(oauthEnvCode);
            umCollectDomain.setChannelCode(nowChannel);
            this.umCollectService.saveCollect(umCollectDomain);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getCollect.json"}, name="\u83b7\u53d6\u7528\u6237\u6536\u85cf\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmCollectReDomain getCollect(HttpServletRequest request, Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".getCollect", (Object)"param is null");
            return null;
        }
        UmCollectReDomain umCollectReDomain = this.umCollectService.getCollect(collectId);
        if (null == umCollectReDomain) {
            return null;
        }
        if (!umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".getCollect.user", (Object)"user is error");
            return null;
        }
        return umCollectReDomain;
    }

    @RequestMapping(value={"updateCollect.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".updateCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmCollectReDomain umCollectReDomain = this.umCollectService.getCollect(umCollectDomain.getCollectId());
        if (null == umCollectReDomain) {
            return null;
        }
        if (!umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".updateCollect.user", (Object)"user is error");
            return null;
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        return this.umCollectService.updateCollect(umCollectDomain);
    }

    @RequestMapping(value={"deleteCollect.json"}, name="\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollect(HttpServletRequest request, Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".deleteCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == this.getCollect(request, collectId)) {
            this.logger.error(CODE + ".deleteCollect.user", (Object)"user is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umCollectService.deleteCollect(collectId);
    }

    @RequestMapping(value={"deleteCollectByCode.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCode(HttpServletRequest request, String collectCode) {
        if (StringUtils.isBlank((String)collectCode)) {
            this.logger.error(CODE + ".deleteCollectByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmCollectReDomain umCollectReDomain = this.umCollectService.getCollectByCode(this.getTenantCode(request), collectCode);
        if (null == umCollectReDomain || !umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".deleteCollectByCode.user", (Object)"user is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umCollectService.deleteCollectByCode(this.getTenantCode(request), collectCode);
    }

    @RequestMapping(value={"deleteCollectByCodeStr.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCodeStr(HttpServletRequest request, String collectCodeStr) {
        if (StringUtils.isBlank((String)collectCodeStr)) {
            this.logger.error(CODE + ".deleteCollectByCodeStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<String> codeList = this.getCodeList(collectCodeStr);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        for (String collectCode : codeList) {
            UmCollectReDomain collectByCode = this.umCollectService.getCollectByCode(tenantCode, collectCode);
            if (null == collectByCode || !collectByCode.getUserinfoCode().equals(userSession.getUserPcode())) {
                this.logger.error(CODE + ".deleteCollectByCodeStr.collectByCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)collectByCode));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            htmlJsonReBean = this.umCollectService.deleteCollectByCode(tenantCode, collectCode);
        }
        return htmlJsonReBean;
    }

    private List<String> getCodeList(String str) {
        ArrayList<String> codeList = null;
        if (null != str && str.length() > 0) {
            String[] codeStr = str.split(",");
            codeList = new ArrayList<String>();
            for (String code : codeStr) {
                codeList.add(code);
            }
        }
        return codeList;
    }

    @RequestMapping(value={"queryCollectPage.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPage(HttpServletRequest request, String goodsType, String order) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        String channelCode = this.getCompanyChannel(request);
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("channelCode", channelCode);
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)goodsType)) {
                param.put("goodsType", goodsType);
            }
            if (StringUtils.isNotBlank((String)order)) {
                param.put("orderStr", "GMT_MODIFIED " + order);
            }
        }
        SupQueryResult<UmCollectReDomain> umCollectReDomainSupQueryResult = this.umCollectService.queryCollectPage(param);
        String skuCodeStr = "";
        for (UmCollectReDomain umCollectReDomain : umCollectReDomainSupQueryResult.getList()) {
            if (StringUtils.isBlank((String)skuCodeStr)) {
                skuCodeStr = umCollectReDomain.getCollectOpcode();
                continue;
            }
            skuCodeStr = skuCodeStr + "," + umCollectReDomain.getCollectOpcode();
        }
        List<RsSkuReDomain> skuReDomains = null;
        try {
            skuReDomains = this.searchengineService.findReSkuListBySkuCode(skuCodeStr, userSession.getTenantCode());
        }
        catch (Exception e) {
            this.logger.error("queryShoppingPage makeEsByGoods is null", (Throwable)e);
        }
        HashMap<String, RsSkuReDomain> goodsMap = new HashMap<String, RsSkuReDomain>();
        if (ListUtil.isNotEmpty(skuReDomains)) {
            for (RsSkuReDomain rsSkuReDomain : skuReDomains) {
                goodsMap.put(rsSkuReDomain.getSkuCode() + "-" + rsSkuReDomain.getTenantCode(), rsSkuReDomain);
            }
            for (UmCollectReDomain umCollectReDomain : umCollectReDomainSupQueryResult.getList()) {
                RsSkuReDomain skuReDomain = (RsSkuReDomain)goodsMap.get(umCollectReDomain.getCollectOpcode() + "-" + umCollectReDomain.getTenantCode());
                if (null != skuReDomain) {
                    if (1 == skuReDomain.getDataOpbillstate()) {
                        umCollectReDomain.setDataState(0);
                    }
                    if (0 == skuReDomain.getDataOpbillstate()) {
                        umCollectReDomain.setDataState(2);
                    }
                    if (skuReDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) > 0) continue;
                    umCollectReDomain.setDataState(1);
                    continue;
                }
                umCollectReDomain.setDataState(3);
            }
        }
        return umCollectReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryCollectPagechannelCode.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868\u52a0\u5165\u6e20\u9053\u8fc7\u6ee4")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPagechannelCode(HttpServletRequest request, String goodsType, String order) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("channelCode", this.getNowChannel(request));
            if (StringUtils.isNotBlank((String)goodsType)) {
                param.put("goodsType", goodsType);
            }
            if (StringUtils.isNotBlank((String)order)) {
                param.put("orderStr", "GMT_MODIFIED " + order);
            }
        }
        return this.umCollectService.queryCollectPage(param);
    }

    @RequestMapping(value={"checkCollectExit.json"}, name="\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public HtmlJsonReBean checkCollectExit(HttpServletRequest request, String collectType, String collectOpcode) {
        SupQueryResult<UmCollectReDomain> qlist;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", collectType);
            param.put("collectOpcode", collectOpcode.trim());
        }
        if (null == (qlist = this.umCollectService.queryCollectPage(param)) || null == qlist.getList() || qlist.getList().isEmpty()) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"\u672a\u6536\u85cf");
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean((Object)((UmCollectReDomain)qlist.getList().get(0)).getCollectCode());
    }

    @RequestMapping(value={"checkBatchCollectExit.json"}, name="\u6279\u91cf\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public List checkBatchCollectExit(HttpServletRequest request, String collectListStr) {
        if (StringUtils.isBlank((String)collectListStr)) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        List collectList = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(collectListStr, Object.class);
        if (ListUtil.isEmpty((Collection)collectList)) {
            this.logger.error(CODE + ".checkBatchCollectExit.ListUtil.null");
            return null;
        }
        if (null == userSession) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"UserSession is null");
            return null;
        }
        ArrayList reList = new ArrayList();
        for (Map map : collectList) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", map.get("collectType"));
            param.put("collectOpcode", String.valueOf(map.get("collectOpcode")).trim());
            SupQueryResult<UmCollectReDomain> qlist = this.umCollectService.queryCollectPage(param);
            if (null == qlist || null == qlist.getList() || qlist.getList().isEmpty()) {
                this.logger.error(CODE + ".checkBatchCollectExit", param);
                continue;
            }
            reList.add(qlist.getList().get(0));
        }
        return reList;
    }

    @RequestMapping(value={"queryCollectPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPagePlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umCollectService.queryCollectPage(param);
    }

    @RequestMapping(value={"updateCollectState.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCollectState(String collectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)collectId)) {
            this.logger.error(CODE + ".updateCollectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umCollectService.updateCollectState(Integer.valueOf(collectId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveCollectFromBx.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u5317\u65b0")
    @ResponseBody
    public HtmlJsonReBean saveCollectFromBx(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult<UmCollectReDomain> qlist = this.umCollectService.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getNowChannel(request));
        return this.umCollectService.saveCollect(umCollectDomain);
    }

    @RequestMapping(value={"queryCollectTypeBigDataPage.json"}, name="\u6839\u636etype\u67e5\u8be2\u6536\u85cf\u6570\u636e")
    @ResponseBody
    public SupQueryResult<UmUserinfoDataReDomin> queryCollectTypeBigDataPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("collectType", "0");
        }
        return this.umCollectService.queryCollectTypeBigDataPage(param);
    }

    @RequestMapping(value={"queryCollectPageByOpcode.json"}, name="\u6839\u636eOpCode\u67e5\u8be2\u5546\u54c1\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPageByOpcode(HttpServletRequest request, String collectOpcode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("collectOpcode", collectOpcode);
        param.put("collectType", "0");
        return this.umCollectService.queryCollectPage(param);
    }

    public static void main(String[] args) {
        ArrayList collectList = new ArrayList();
        HashMap<String, String> MAP = new HashMap<String, String>();
        MAP.put("collectType", "11111");
        MAP.put("collectOpcode", "2222");
        collectList.add(MAP);
        collectList.add(MAP);
        String s = JsonUtil.buildNonDefaultBinder().toJson(collectList);
        System.out.println(s);
    }
}

