/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.om;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.om.OmAppointmentDomain;
import cn.com.qj.bff.domain.om.OmAppointmentReDomain;
import cn.com.qj.bff.service.om.AppointmentService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/om/appointment"}, name="\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f")
public class AppointmentCon
extends SpringmvcController {
    private static String CODE = "om.appointment.con";
    @Autowired
    private AppointmentService appointmentService;

    @Override
    protected String getContext() {
        return "appointment";
    }

    @RequestMapping(value={"saveAppointment.json"}, name="\u589e\u52a0\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAppointment(HttpServletRequest request, OmAppointmentDomain appointmentDomain) {
        if (null == appointmentDomain) {
            this.logger.error(CODE + ".saveAppointment", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        appointmentDomain.setTenantCode(this.getTenantCode(request));
        return this.appointmentService.saveAppointment(appointmentDomain);
    }

    @RequestMapping(value={"getAppointment.json"}, name="\u83b7\u53d6\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public OmAppointmentReDomain getAppointment(String appointmentId) {
        if (StringUtils.isBlank((String)appointmentId)) {
            this.logger.error(CODE + ".getAppointment", (Object)"param is null");
            return null;
        }
        return this.appointmentService.getAppointment(Integer.valueOf(appointmentId));
    }

    @RequestMapping(value={"updateAppointment.json"}, name="\u66f4\u65b0\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAppointment(HttpServletRequest request, OmAppointmentDomain appointmentDomain) {
        if (null == appointmentDomain) {
            this.logger.error(CODE + ".updateAppointment", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        appointmentDomain.setTenantCode(this.getTenantCode(request));
        return this.appointmentService.updateAppointment(appointmentDomain);
    }

    @RequestMapping(value={"deleteAppointment.json"}, name="\u5220\u9664\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAppointment(String appointmentId) {
        if (StringUtils.isBlank((String)appointmentId)) {
            this.logger.error(CODE + ".deleteAppointment", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appointmentService.deleteAppointment(Integer.valueOf(appointmentId));
    }

    @RequestMapping(value={"queryAppointmentPage.json"}, name="\u67e5\u8be2\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OmAppointmentReDomain> queryAppointmentPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appointmentService.queryAppointmentPage(param);
    }

    @RequestMapping(value={"updateAppointmentState.json"}, name="\u66f4\u65b0\u9884\u7ea6\u63a5\u5f85\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAppointmentState(String appointmentId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)appointmentId)) {
            this.logger.error(CODE + ".updateAppointmentState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appointmentService.updateAppointmentState(Integer.valueOf(appointmentId), dataState, oldDataState);
    }
}

