/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.GoodsUploadDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsSku;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SendSku;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.ShopGoodsUploadDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.GoodsUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.ShopGoodsUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.GoodsUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.Inventory;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.InventoryResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.InventoryResponseData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopGoodsQueryResponseDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.OutGoodsSendPollThread;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.OutGoodsSendPutThread;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.OutGoodsSendService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.GoodsService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class GoodsServiceImpl
extends DateBaseService
implements GoodsService {
    private static final String SYS_CODE = "jst.GoodsServiceImpl";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static OutGoodsSendService outGoodsSendService;
    private static final Object outGoodslock;

    @Override
    public String upLoadGoods(List<RsSkuReDomain> skuList) throws ApiException {
        if (ListUtil.isEmpty(skuList)) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods skuList is empty");
            return "\u53c2\u6570\u4e3a\u7a7a\uff01";
        }
        String tenantCode = skuList.get(0).getTenantCode();
        String memberCode = skuList.get(0).getMemberCcode();
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstUrl", tenantCode);
        GoodsUploadRequest goodsUploadRequest = GoodsServiceImpl.makeGoodsUploadRequest(skuList);
        this.upLoadGoods(JsonUtil.buildNonNullBinder().toJson((Object)goodsUploadRequest), appkey, secret, url + "/open/jushuitan/itemsku/upload", memberCode, tenantCode);
        UmUserinfo user = this.getUser(skuList.get(0).getTenantCode(), skuList.get(0).getMemberCcode());
        if (null == user) {
            logger.error("jst.GoodsServiceImpl.upLoadShopGoods user is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods user is null";
        }
        String shopId = user.getCompanyCode();
        if (StringUtils.isBlank((String)shopId)) {
            logger.error("jst.GoodsServiceImpl.upLoadShopGoods shopId is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods shopId is null";
        }
        ShopGoodsUploadRequest shopGoodsUploadRequest = this.makeShopGoodsUploadRequest(skuList, Integer.parseInt(shopId));
        return this.upLoadGoods(JsonUtil.buildNonNullBinder().toJson((Object)shopGoodsUploadRequest), appkey, secret, url + "/open/jushuitan/skumap/upload", memberCode, tenantCode);
    }

    private String upLoadGoods(String json, String appkey, String secret, String url, String memberCode, String tenantCode) {
        String access_token = GoodsServiceImpl.gettoken(memberCode, tenantCode);
        if (StringUtils.isBlank((String)access_token)) {
            return "success";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", json);
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = GoodsServiceImpl.buildQuery(params);
        String responseStr = GoodsServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods responseStr is null");
            return "jst.GoodsServiceImpl.upLoadGoods responseStr is null";
        }
        GoodsUploadResponse goodsUploadResponse = (GoodsUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, GoodsUploadResponse.class);
        if (null == goodsUploadResponse) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is null", (Object)responseStr);
            return "jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is null" + responseStr;
        }
        if (0 != goodsUploadResponse.getCode()) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is error", (Object)goodsUploadResponse.getMsg());
            return goodsUploadResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String saveGoods(RsResourceGoodsReDomain rsResourceGoodsDomain) throws ApiException {
        if (null == rsResourceGoodsDomain || ListUtil.isEmpty(rsResourceGoodsDomain.getSkuList())) {
            logger.error("jst.GoodsServiceImpl.saveGoods rsResourceGoodsDomain is empty");
            return "\u53c2\u6570\u4e3a\u7a7a\uff01";
        }
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        String memberCode = rsResourceGoodsDomain.getMemberCcode();
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstUrl", tenantCode);
        List<RsSku> skuList = rsResourceGoodsDomain.getSkuList();
        GoodsUploadRequest goodsUploadRequest = GoodsServiceImpl.makeGoodsUploadRequestBySkuList(rsResourceGoodsDomain.getSkuList());
        this.upLoadGoods(JsonUtil.buildNonNullBinder().toJson((Object)goodsUploadRequest), appkey, secret, url + "/open/jushuitan/itemsku/upload", memberCode, tenantCode);
        UmUserinfo user = this.getUser(skuList.get(0).getTenantCode(), skuList.get(0).getMemberCcode());
        if (null == user) {
            logger.error("jst.GoodsServiceImpl.upLoadShopGoods user is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods user is null";
        }
        String shopId = user.getCompanyCode();
        if (StringUtils.isBlank((String)shopId)) {
            logger.error("jst.GoodsServiceImpl.upLoadShopGoods shopId is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods shopId is null";
        }
        ShopGoodsUploadRequest shopGoodsUploadRequest = this.makeShopGoodsUploadRequestBySkuList(skuList, Integer.parseInt(shopId));
        return this.upLoadGoods(JsonUtil.buildNonNullBinder().toJson((Object)shopGoodsUploadRequest), appkey, secret, url + "/open/jushuitan/skumap/upload", memberCode, tenantCode);
    }

    private static void goodsUpload() {
        GoodsUploadResponse goodsUploadResponse;
        RsSkuReDomain rsSkuReDomain = new RsSkuReDomain();
        rsSkuReDomain.setSkuNo("sp002");
        rsSkuReDomain.setGoodsNo("sp002");
        rsSkuReDomain.setBrandName("");
        rsSkuReDomain.setClasstreeName("");
        rsSkuReDomain.setPricesetNprice(new BigDecimal(1));
        rsSkuReDomain.setPricesetAsprice(new BigDecimal(1));
        rsSkuReDomain.setPricesetMakeprice(new BigDecimal(1));
        rsSkuReDomain.setDataPic("");
        rsSkuReDomain.setTenantCode("2023072819990101");
        rsSkuReDomain.setGoodsName("\u6d4b\u8bd5-\u52ff\u62cd2");
        rsSkuReDomain.setSkuName("90cm");
        ArrayList<RsSkuReDomain> skuList = new ArrayList<RsSkuReDomain>();
        skuList.add(rsSkuReDomain);
        String url = "https://dev-api.jushuitan.com/open/jushuitan/itemsku/upload";
        String appkey = "1efbf09e32a047879711da12be4aff08";
        String secret = "ecf3e001e5414f7a8b750dc166198668";
        String access_token = "2fb0f16f7d9740c1af2c34f09570f7ca";
        GoodsUploadRequest goodsUploadRequest = GoodsServiceImpl.makeGoodsUploadRequest(skuList);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)goodsUploadRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = GoodsServiceImpl.buildQuery(params);
        String responseStr = GoodsServiceImpl.execute(parmStr, url);
        System.out.println(responseStr);
        if (StringUtils.isBlank((String)responseStr)) {
            // empty if block
        }
        if (null == (goodsUploadResponse = (GoodsUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, GoodsUploadResponse.class))) {
            // empty if block
        }
        if (0 != goodsUploadResponse.getCode()) {
            // empty if block
        }
    }

    @Override
    public String upLoadShopGoods(List<RsSkuReDomain> skuList) throws ApiException {
        return this.upLoadGoods(skuList);
    }

    @Override
    public List<ShopGoodsQueryResponseDatas> queryShopGoods(Integer shopId, String skuNo, String tenantCode) throws ApiException {
        if (null == shopId || StringUtils.isBlank((String)skuNo)) {
            logger.error("jst.GoodsServiceImpl.queryShopGoods param is null", (Object)(shopId + "--" + skuNo));
            return null;
        }
        return null;
    }

    @Override
    public String queryInventory(String ids, String startTime, String endTime, Integer page, Integer size) throws ApiException {
        return null;
    }

    @Override
    public String queryInventoryNum(String tenantCode, String memberCode, String minuteAmount) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCode)) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum param is null", (Object)(tenantCode + "--" + memberCode));
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String access_token = GoodsServiceImpl.gettoken(memberCode, tenantCode);
        if (StringUtils.isBlank((String)access_token)) {
            return "success";
        }
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstUrl", tenantCode) + "/open/inventory/query";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        if (StringUtils.isBlank((String)minuteAmount)) {
            minuteAmount = "1440";
        }
        Integer amount = Integer.valueOf(minuteAmount);
        calendar.add(12, -amount.intValue());
        Date startDate = calendar.getTime();
        map.put("page_index", 1);
        map.put("page_size", 100);
        map.put("modified_begin", sdf.format(startDate));
        map.put("modified_end", sdf.format(endDate));
        params.put("biz", JsonUtil.buildNormalBinder().toJson(map));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = GoodsServiceImpl.buildQuery(params);
        String responseStr = GoodsServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods responseStr is null");
            return "jst.GoodsServiceImpl.upLoadGoods responseStr is null";
        }
        InventoryResponse inventoryResponse = (InventoryResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, InventoryResponse.class);
        if (null == inventoryResponse) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum inventoryResponse is null", (Object)responseStr);
            return "jst.GoodsServiceImpl.queryInventoryNum goodsUploadResponse is null" + responseStr;
        }
        if (0 != inventoryResponse.getCode()) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum inventoryResponse is error", (Object)inventoryResponse.getMsg());
            return "jst.GoodsServiceImpl.queryInventoryNum inventoryResponse is error" + inventoryResponse.getMsg();
        }
        InventoryResponseData data = inventoryResponse.getData();
        List<Inventory> inventorys = data.getInventorys();
        for (Inventory inventory : inventorys) {
            SendSku sendSku = new SendSku();
            sendSku.setTenantCode(tenantCode);
            sendSku.setMemberCode(memberCode);
            sendSku.setInventory(inventory);
            GoodsServiceImpl.getOutGoodsSendService().addPutPool(new OutGoodsSendPutThread(GoodsServiceImpl.getOutGoodsSendService(), sendSku));
        }
        return null;
    }

    @Override
    public String queryInventoryNumBySkuNo(String tenantCode, String memberCode, String skuNo) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCode)) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum param is null", (Object)(tenantCode + "--" + memberCode));
            return null;
        }
        String access_token = GoodsServiceImpl.gettoken(memberCode, tenantCode);
        if (StringUtils.isBlank((String)access_token)) {
            return null;
        }
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstUrl", tenantCode) + "/open/inventory/query";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page_index", 1);
        map.put("page_size", 100);
        map.put("sku_ids", skuNo);
        params.put("biz", JsonUtil.buildNormalBinder().toJson(map));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = GoodsServiceImpl.buildQuery(params);
        String responseStr = GoodsServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error("jst.GoodsServiceImpl.upLoadGoods responseStr is null");
            return null;
        }
        InventoryResponse inventoryResponse = (InventoryResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, InventoryResponse.class);
        if (null == inventoryResponse) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum inventoryResponse is null", (Object)responseStr);
            return null;
        }
        if (0 != inventoryResponse.getCode()) {
            logger.error("jst.GoodsServiceImpl.queryInventoryNum inventoryResponse is error", (Object)inventoryResponse.getMsg());
            return null;
        }
        InventoryResponseData data = inventoryResponse.getData();
        List<Inventory> inventorys = data.getInventorys();
        return JsonUtil.buildNormalBinder().toJson(inventorys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutGoodsSendService getOutGoodsSendService() {
        Object object = outGoodslock;
        synchronized (object) {
            if (null == outGoodsSendService) {
                outGoodsSendService = new OutGoodsSendService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 30; ++i) {
                    outGoodsSendService.addPollPool(new OutGoodsSendPollThread(outGoodsSendService));
                }
            }
            return outGoodsSendService;
        }
    }

    public static void main(String[] args) {
        GoodsServiceImpl.goodsUpload();
    }

    private static void inventoryQuery() {
        String minuteAmount = "60";
        String url = "https://dev-api.jushuitan.com/open/inventory/query";
        String appkey = "1efbf09e32a047879711da12be4aff08";
        String secret = "ecf3e001e5414f7a8b750dc166198668";
        String access_token = "578a736d23844c39af3b84f7d18f1063";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        Integer amount = Integer.valueOf(minuteAmount);
        calendar.add(12, -amount.intValue());
        Date startDate = calendar.getTime();
        map.put("page_index", 1);
        map.put("page_size", 100);
        map.put("sku_ids", "cs012345");
        params.put("biz", JsonUtil.buildNormalBinder().toJson(map));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = GoodsServiceImpl.buildQuery(params);
        String responseStr = GoodsServiceImpl.execute(parmStr, url);
        System.out.println(responseStr);
        InventoryResponse inventoryResponse = (InventoryResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, InventoryResponse.class);
        if (null == inventoryResponse) {
            // empty if block
        }
        if (0 != inventoryResponse.getCode()) {
            // empty if block
        }
    }

    private ShopGoodsUploadRequest makeShopGoodsUploadRequest(List<RsSkuReDomain> skuList, Integer shopId) {
        ShopGoodsUploadRequest shopGoodsUploadRequest = new ShopGoodsUploadRequest();
        ArrayList<ShopGoodsUploadDomain> shopGoodsUploadDomains = new ArrayList<ShopGoodsUploadDomain>();
        ShopGoodsUploadDomain shopGoodsUploadDomain = null;
        for (RsSkuReDomain rsSkuReDomain : skuList) {
            shopGoodsUploadDomain = new ShopGoodsUploadDomain();
            shopGoodsUploadDomains.add(shopGoodsUploadDomain);
            shopGoodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            shopGoodsUploadDomain.setI_id(rsSkuReDomain.getGoodsNo());
            shopGoodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            shopGoodsUploadDomain.setShop_i_id(rsSkuReDomain.getGoodsCode());
            shopGoodsUploadDomain.setShop_sku_id(rsSkuReDomain.getSkuCode());
            shopGoodsUploadDomain.setShop_id(shopId);
        }
        shopGoodsUploadRequest.setItems(shopGoodsUploadDomains);
        return shopGoodsUploadRequest;
    }

    private ShopGoodsUploadRequest makeShopGoodsUploadRequestBySkuList(List<RsSku> skuList, Integer shopId) {
        ShopGoodsUploadRequest shopGoodsUploadRequest = new ShopGoodsUploadRequest();
        ArrayList<ShopGoodsUploadDomain> shopGoodsUploadDomains = new ArrayList<ShopGoodsUploadDomain>();
        ShopGoodsUploadDomain shopGoodsUploadDomain = null;
        for (RsSku rsSkuReDomain : skuList) {
            shopGoodsUploadDomain = new ShopGoodsUploadDomain();
            shopGoodsUploadDomains.add(shopGoodsUploadDomain);
            shopGoodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            shopGoodsUploadDomain.setI_id(rsSkuReDomain.getGoodsNo());
            shopGoodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            shopGoodsUploadDomain.setShop_i_id(rsSkuReDomain.getGoodsCode());
            shopGoodsUploadDomain.setShop_sku_id(rsSkuReDomain.getSkuCode());
            shopGoodsUploadDomain.setShop_id(shopId);
        }
        shopGoodsUploadRequest.setItems(shopGoodsUploadDomains);
        return shopGoodsUploadRequest;
    }

    private static GoodsUploadRequest makeGoodsUploadRequest(List<RsSkuReDomain> skuList) {
        GoodsUploadRequest goodsUploadRequest = new GoodsUploadRequest();
        ArrayList<GoodsUploadDomain> goodsUploadDomains = new ArrayList<GoodsUploadDomain>();
        GoodsUploadDomain goodsUploadDomain = null;
        for (RsSkuReDomain rsSkuReDomain : skuList) {
            goodsUploadDomain = new GoodsUploadDomain();
            goodsUploadDomains.add(goodsUploadDomain);
            goodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            goodsUploadDomain.setI_id(rsSkuReDomain.getGoodsNo());
            goodsUploadDomain.setBrand(rsSkuReDomain.getBrandName());
            goodsUploadDomain.setVc_name(rsSkuReDomain.getClasstreeName());
            goodsUploadDomain.setS_price(rsSkuReDomain.getPricesetNprice());
            if (null == rsSkuReDomain.getDataPic()) {
                rsSkuReDomain.setDataPic("");
            }
            goodsUploadDomain.setPic(rsSkuReDomain.getDataPic());
            goodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            goodsUploadDomain.setProperties_value(rsSkuReDomain.getSkuName());
            goodsUploadDomain.setStock_disabled(false);
            goodsUploadDomain.setC_price(rsSkuReDomain.getPricesetAsprice());
            goodsUploadDomain.setMarket_price(rsSkuReDomain.getPricesetMakeprice());
        }
        goodsUploadRequest.setItems(goodsUploadDomains);
        return goodsUploadRequest;
    }

    private static GoodsUploadRequest makeGoodsUploadRequestBySkuList(List<RsSku> skuList) {
        GoodsUploadRequest goodsUploadRequest = new GoodsUploadRequest();
        ArrayList<GoodsUploadDomain> goodsUploadDomains = new ArrayList<GoodsUploadDomain>();
        GoodsUploadDomain goodsUploadDomain = null;
        for (RsSku rsSkuReDomain : skuList) {
            goodsUploadDomain = new GoodsUploadDomain();
            goodsUploadDomains.add(goodsUploadDomain);
            goodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            goodsUploadDomain.setI_id(rsSkuReDomain.getGoodsNo());
            goodsUploadDomain.setBrand(rsSkuReDomain.getBrandName());
            goodsUploadDomain.setVc_name(rsSkuReDomain.getClasstreeName());
            goodsUploadDomain.setS_price(rsSkuReDomain.getPricesetNprice());
            if (null == rsSkuReDomain.getDataPic()) {
                rsSkuReDomain.setDataPic("");
            }
            goodsUploadDomain.setPic(rsSkuReDomain.getDataPic());
            goodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            goodsUploadDomain.setProperties_value(rsSkuReDomain.getSkuName());
            goodsUploadDomain.setStock_disabled(false);
            goodsUploadDomain.setC_price(rsSkuReDomain.getPricesetAsprice());
            goodsUploadDomain.setMarket_price(rsSkuReDomain.getPricesetMakeprice());
        }
        goodsUploadRequest.setItems(goodsUploadDomains);
        return goodsUploadRequest;
    }

    private static String makeGoodsPic(String picPre, RsSkuReDomain rsSkuReDomain) {
        String pic = "";
        boolean isNotPre = false;
        if (StringUtils.isNotBlank((String)picPre)) {
            String[] split;
            for (String pre : split = picPre.split(",")) {
                if (!rsSkuReDomain.getDataPic().contains(pre)) continue;
                isNotPre = true;
                break;
            }
            pic = split[0];
        }
        if (isNotPre) {
            return rsSkuReDomain.getDataPic();
        }
        return pic + rsSkuReDomain.getDataPic();
    }

    static {
        outGoodslock = new Object();
    }
}

