/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrdersOutQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderOutQueryGoods;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryResPonse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.SendOrderService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.RequestUrl;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendOrderServiceImpl
extends DateBaseService
implements SendOrderService {
    private static final String SYS_CODE = "SendOrderServiceImpl";

    public static void main(String[] args) {
        SendOrderServiceImpl.ordersOutQuery();
    }

    private static void ordersOutQuery() {
        String access_token = "edde3effe6ef441bb7e9118f3cc90f45";
        ArrayList<String> so_ids = new ArrayList<String>();
        so_ids.add("1005418147821375558");
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ordersOutQueryRequest.setSo_ids(so_ids);
        ordersOutQueryRequest.setStatus("Sent");
        String biz = JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest);
        List<OrdersOutQueryDatas> ordersOutQueryDatas = SendOrderServiceImpl.getOrdersOutQueryDatas(access_token, biz);
        System.out.println(JsonUtil.buildNormalBinder().toJson(ordersOutQueryDatas));
    }

    @Override
    public String querySendOrder(OcContractReDomain ocContractReDomain, Map<String, BigDecimal> goodsNum) throws Exception {
        logger.info("jushuitan.querySendOrder.goodsNum", (Object)JsonUtil.buildNormalBinder().toJson(goodsNum));
        return this.saveOrderCom(ocContractReDomain, goodsNum);
    }

    @Override
    public String saveOrder(OcContractReDomain ocContractReDomain) throws Exception {
        return this.saveOrderCom(ocContractReDomain, null);
    }

    public String saveOrderCom(OcContractReDomain ocContractReDomain, Map<String, BigDecimal> goodsNum) throws Exception {
        String access_token = SendOrderServiceImpl.gettoken(ocContractReDomain.getMemberCcode(), ocContractReDomain.getTenantCode());
        ArrayList<String> so_ids = new ArrayList<String>();
        so_ids.add(ocContractReDomain.getContractBillcode());
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ordersOutQueryRequest.setSo_ids(so_ids);
        ordersOutQueryRequest.setStatus("Sent");
        String biz = JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest);
        List<OrdersOutQueryDatas> ordersOutQueryDatas = SendOrderServiceImpl.getOrdersOutQueryDatas(access_token, biz);
        if (ListUtil.isEmpty(ordersOutQueryDatas)) {
            logger.error("SendOrderServiceImpl.simpleOrderRe ordersOutQueryDatas is null");
            return "error";
        }
        for (OrdersOutQueryDatas ordersOutQueryData : ordersOutQueryDatas) {
            SgSendgoodsReDomain sgSendGoodsDomain = this.getSgSendGoodsDomain("JST_" + ordersOutQueryData.getO_id(), ocContractReDomain.getTenantCode());
            if (null != sgSendGoodsDomain) {
                logger.error("SendOrderServiceImpl.saveOrder.\u5df2\u53d1\u8d27", (Object)ordersOutQueryData.getO_id());
                continue;
            }
            String msg = this.sgSendgoods(ocContractReDomain, ordersOutQueryData, goodsNum);
            if (!MapUtil.isNotEmpty(goodsNum) || !StringUtils.isNotBlank((String)msg)) continue;
            return msg;
        }
        return "success";
    }

    private static List<OrdersOutQueryDatas> getOrdersOutQueryDatas(String access_token, String biz) {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = RequestUrl.jstUrl + "/open/orders/single/query";
        String appkey = RequestUrl.jstappkey;
        String secret = RequestUrl.jstsecret;
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", biz);
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = SendOrderServiceImpl.buildQuery(params);
        String responseStr = SendOrderServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error("SendOrderServiceImpl.simpleOrderRe Cancelled responseStr is null");
            return null;
        }
        OrdersOutQueryResPonse ordersOutQueryResPonse = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
        if (null == ordersOutQueryResPonse) {
            logger.error("SendOrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonse is null", (Object)responseStr);
            return null;
        }
        OrdersOutQueryData data = ordersOutQueryResPonse.getData();
        if (null == data) {
            logger.error("SendOrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonsedata is null", (Object)responseStr);
            return null;
        }
        if (ListUtil.isEmpty(data.getOrders())) {
            logger.error("SendOrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonsedatas is null", (Object)responseStr);
            return null;
        }
        return data.getOrders();
    }

    private String sgSendgoods(OcContractReDomain contractReDomain, OrdersOutQueryDatas ordersOutQueryData, Map<String, BigDecimal> goodsNum) throws Exception {
        SgSendgoodsReDomain sgSendgoodsDomain = new SgSendgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)contractReDomain);
        }
        catch (Exception e) {
            logger.error("jushuitan.sgSendgoods.e", (Throwable)e);
            return null;
        }
        if (ListUtil.isEmpty(contractReDomain.getGoodsList())) {
            logger.error("jushuitan.sgSendgoods.ocContractReDomain.getGoodsList()", (Object)"goodsList is null");
            return null;
        }
        Map<String, OcContractGoodsDomain> goodsMap = this.makeMap(contractReDomain.getGoodsList());
        if (MapUtil.isEmpty(goodsMap)) {
            logger.error("jushuitan.sgSendgoods.goodsMap", (Object)"goodsMap is null");
            return null;
        }
        ArrayList<SgSendgoodsGoodsDomain> sendgoodslist = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sum = BigDecimal.ZERO;
        String msg = null;
        for (OrderOutQueryGoods queryGoods : ordersOutQueryData.getItems()) {
            BigDecimal bigDecimal;
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
            OcContractGoodsDomain ocContractGoodsDomain = goodsMap.get(queryGoods.getOuter_oi_id());
            if (null == ocContractGoodsDomain) {
                logger.error("jushuitan.makeSgSendgoodsDomain.ocContractGoodsDomain", (Object)queryGoods.getI_id());
                return null;
            }
            if (ocContractGoodsDomain.getContractGoodsSendnum() == null) {
                ocContractGoodsDomain.setContractGoodsSendnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getContractGoodsRefnum() == null) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            BigDecimal qty = new BigDecimal(queryGoods.getQty());
            BigDecimal goodsSurplusNum = ocContractGoodsDomain.getGoodsCamount().subtract(ocContractGoodsDomain.getContractGoodsSendnum()).subtract(ocContractGoodsDomain.getContractGoodsRefnum());
            if (goodsSurplusNum.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("jushuitan.makeSgSendgoodsDomain.goodsNum", (Object)goodsSurplusNum);
                return null;
            }
            if (MapUtil.isNotEmpty(goodsNum) && null != (bigDecimal = goodsNum.get(ocContractGoodsDomain.getGoodsCode()))) {
                logger.info("jushuitan.makeSgSendgoodsDomain.bigDecimal", (Object)JsonUtil.buildNormalBinder().toJson((Object)bigDecimal));
                logger.info("jushuitan.makeSgSendgoodsDomain.goodsSurplusNum", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsSurplusNum));
                logger.info("jushuitan.makeSgSendgoodsDomain.qty", (Object)JsonUtil.buildNormalBinder().toJson((Object)qty));
                BigDecimal subtract = goodsSurplusNum.subtract(qty);
                if (subtract.compareTo(bigDecimal) < 0) {
                    msg = "\u5546\u54c1\u5df2\u53d1\u8d27\uff01";
                }
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)contractReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                logger.error("jushuitan.sgSendgoods.sgSendgoodsGoodsDomain.e", (Throwable)e);
                return null;
            }
            sgSendgoodsGoodsDomain.setGoodsNum(qty);
            sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(sgSendgoodsGoodsDomain.getGoodsNum());
            sum = sum.add(ocContractGoodsDomain.getContractGoodsPrice().multiply(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount()));
            sendgoodslist.add(sgSendgoodsGoodsDomain);
        }
        Map map = DisUtil.getMapAll((String)"WlExpress-key-name");
        String code = (String)map.get(ordersOutQueryData.getLogistics_company());
        if (StringUtils.isNotBlank((String)code)) {
            sgSendgoodsDomain.setPackageMode(code);
        } else {
            sgSendgoodsDomain.setPackageMode(ordersOutQueryData.getLc_id());
        }
        sgSendgoodsDomain.setPackageBillno(ordersOutQueryData.getL_id());
        sgSendgoodsDomain.setPackageName(ordersOutQueryData.getLogistics_company());
        sgSendgoodsDomain.setGoodsMoney(sum);
        sgSendgoodsDomain.setSendgoodsCode("JST_" + ordersOutQueryData.getO_id());
        sgSendgoodsDomain.setContractObillcode(ordersOutQueryData.getO_id().toString());
        sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sendgoodslist);
        sgSendgoodsDomain.setTenantCode(contractReDomain.getTenantCode());
        sgSendgoodsDomain.setContractType("03");
        sgSendgoodsDomain.setGoodsClass("welfare");
        this.sendsaveSgSendgoods(sgSendgoodsDomain);
        return msg;
    }

    private Map<String, OcContractGoodsDomain> makeMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            logger.error("jushuitan.makeMap", (Object)"goodsList is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }
}

