/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.util;

import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.cp.CpRechargeFromU9Domain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.ResourceGoodsU9;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhQoh;
import com.yqbsoft.laser.service.ext.bus.data.util.RequestUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="sqlServerUtils")
public class SqlServerUtils {
    static final String SYS_CODE = "SqlServerUtils";
    static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);
    private static String driverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static String dbURL = "jdbc:sqlserver://192.168.1.108:1433; DatabaseName=AkanU923;encrypt=true; trustServerCertificate=true;";
    private static String userName = "sa";
    private static String password = "Akan100years";

    public static <T> List<T> getForList(Class<T> clazz, String sql, Object ... args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<T> list = new ArrayList<T>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSetMetaData metaData = preparedStatement.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                preparedStatement.setObject(i + 1, args[i]);
            }
        }
        String fieldNames = SqlServerUtils.getFieldNames(clazz);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            T instance = clazz.newInstance();
            for (int i = 0; i < columnCount; ++i) {
                Field field;
                String columnLabel = metaData.getColumnLabel(i + 1);
                Object value = resultSet.getObject(columnLabel);
                if (null == value || !fieldNames.contains(columnLabel = columnLabel.substring(0, 1).toLowerCase() + columnLabel.substring(1)) || SqlServerUtils.checkFileType(clazz, instance, columnLabel, value) || null == (field = clazz.getDeclaredField(columnLabel))) continue;
                field.setAccessible(true);
                field.set(instance, (String)value);
            }
            list.add(instance);
        }
        try {
            SqlServerUtils.closeConn(connection, preparedStatement, resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getFieldNames(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            sb.append(fields[i].getName());
            if (i >= fields.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static <T> List<T> getCustomerForList(Class<T> clazz, String sql, List<String> args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<T> list = new ArrayList<T>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSetMetaData metaData = preparedStatement.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (!CollectionUtils.isEmpty(args)) {
            for (int i = 0; i < args.size(); ++i) {
                if (args.get(i) == null) continue;
                preparedStatement.setObject(i + 1, args.get(i));
            }
        }
        String fieldNames = SqlServerUtils.getFieldNames(clazz);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            T instance = clazz.newInstance();
            for (int i = 0; i < columnCount; ++i) {
                Field field;
                String columnLabel = metaData.getColumnLabel(i + 1);
                Object value = resultSet.getObject(columnLabel);
                if (null == value || !fieldNames.contains(columnLabel = columnLabel.substring(0, 1).toLowerCase() + columnLabel.substring(1)) || SqlServerUtils.checkFileType(clazz, instance, columnLabel, value) || null == (field = clazz.getDeclaredField(columnLabel))) continue;
                field.setAccessible(true);
                field.set(instance, (String)value);
            }
            list.add(instance);
        }
        try {
            SqlServerUtils.closeConn(connection, preparedStatement, resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getCustPriceListCode(String sql, String orgCode, String userinfoOcode) {
        try {
            Connection connection = SqlServerUtils.getConn();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setObject(1, orgCode);
            preparedStatement.setObject(2, userinfoOcode);
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                return rs.getString("priceListCode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static List<CpRechargeFromU9Domain> getCjFundAdjustmentForList(String sql, String date) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<CpRechargeFromU9Domain> list = new ArrayList<CpRechargeFromU9Domain>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, date);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            CpRechargeFromU9Domain bean = new CpRechargeFromU9Domain();
            bean.setGmtCreate(DateUtils.getDateToString((String)rs.getString("AccrueDate"), (String)"yyyy-MM-dd HH:mm:ss"));
            bean.setRechargeCode("U9" + rs.getString("HeadID"));
            bean.setRechargeOpcode(rs.getString("docno"));
            BigDecimal arfcMoney_totalMoney = new BigDecimal(rs.getString("ARFCMoney_TotalMoney"));
            BigDecimal abs = arfcMoney_totalMoney.abs();
            bean.setAmountMoney(abs);
            bean.setRechargeMoney(abs);
            bean.setDdTypeCurrency(rs.getString("Currency_Code"));
            bean.setRechargeOpcode2(rs.getString("TypeName"));
            bean.setUserinfoCode(rs.getString("AccrueCust_Code"));
            bean.setUserinfoName(rs.getString("AccrueCust_Name"));
            bean.setOrganizationalCode(rs.getString("Org_Code"));
            bean.setOrganizationalName(rs.getString("Org_Name"));
            bean.setRechargeOpcode4(rs.getString("Memo"));
            bean.setRechargeUname(rs.getString("CreatedBy"));
            bean.setFchannelClassifyCode("U9tiaozheng");
            bean.setFchannelPmodeCode("web");
            list.add(bean);
        }
        return list;
    }

    public static List<CpRechargeFromU9Domain> getReFundInfoForList(String sql, String date) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<CpRechargeFromU9Domain> list = new ArrayList<CpRechargeFromU9Domain>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, date);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            CpRechargeFromU9Domain bean = new CpRechargeFromU9Domain();
            bean.setGmtCreate(DateUtils.getDateToString((String)rs.getString("CreatedOn"), (String)"yyyy-MM-dd HH:mm:ss"));
            bean.setRechargeCode("U9" + rs.getString("LineID"));
            bean.setRechargeOpcode(rs.getString("DocNo"));
            bean.setAmountMoney(new BigDecimal(rs.getString("TotalMoney_FCMoney")));
            bean.setBankcommissionMoney(new BigDecimal(rs.getString("SettlementFee_FCMoney")));
            bean.setRechargeMoney(new BigDecimal(rs.getString("Money_FCMoney")));
            bean.setReceiveNo(rs.getString("DocNo"));
            bean.setUserinfoCode(rs.getString("Cust_Code"));
            bean.setUserinfoName(rs.getString("Cust_Name"));
            bean.setOrganizationalCode(rs.getString("Org_Code"));
            bean.setOrganizationalName(rs.getString("Org_Name"));
            bean.setRechargeOpcode4(rs.getString("Memo"));
            bean.setRechargeUname(rs.getString("PayProperty"));
            bean.setRechargeUrl("u9\u9000\u6b3e");
            bean.setFundType("01");
            bean.setFchannelClassifyCode("U9tuikuan");
            bean.setFchannelPmodeCode("web");
            bean.setTenantCode(rs.getString("PayProperty"));
            list.add(bean);
        }
        return list;
    }

    public static List<WhQoh> getForStoreList(String sql) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<WhQoh> list = new ArrayList<WhQoh>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            WhQoh bean = new WhQoh();
            bean.setItemInfo_ItemCode(rs.getString("itemInfo_ItemCode"));
            bean.setStoreQty(rs.getString("storeQty"));
            bean.setWhCode(rs.getString("whCode"));
            bean.setWhName(rs.getString("whName"));
            bean.setOrgCode(rs.getString("OrgCode"));
            list.add(bean);
        }
        return list;
    }

    public static List<OcContractDomain> getOcContractForListU9(String sql, String erpDataStateStr, LocalDateTime starDate, LocalDateTime endDate, String contractBillcodeStr, int startRow, int endRow) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<OcContractDomain> list = new ArrayList<OcContractDomain>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (null != starDate) {
            preparedStatement.setObject(1, starDate);
            preparedStatement.setObject(2, endDate);
            preparedStatement.setInt(3, startRow);
            preparedStatement.setInt(4, endRow);
            preparedStatement.setString(5, erpDataStateStr);
        } else if (StringUtils.isNotBlank((String)contractBillcodeStr)) {
            preparedStatement.setObject(1, contractBillcodeStr);
            preparedStatement.setInt(2, startRow);
            preparedStatement.setInt(3, endRow);
        } else {
            preparedStatement.setInt(1, startRow);
            preparedStatement.setInt(2, endRow);
            preparedStatement.setString(3, erpDataStateStr);
        }
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            OcContractDomain bean = new OcContractDomain();
            list.add(bean);
        }
        return list;
    }

    public static List<ResourceGoodsU9> getForList11(String sql, LocalDateTime args, int startRow, int endRow) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<ResourceGoodsU9> list = new ArrayList<ResourceGoodsU9>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        preparedStatement.setInt(2, startRow);
        preparedStatement.setInt(3, endRow);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            ResourceGoodsU9 bean = new ResourceGoodsU9();
            bean.setItemCode(rs.getString("itemCode"));
            bean.setItemName(rs.getString("itemName"));
            bean.setPrv18Code(rs.getString("prv18Code"));
            bean.setPrv18Name(rs.getString("prv18Name"));
            bean.setPriceCategoryCode(rs.getString("priceCategoryCode"));
            bean.setPriceCategoryName(rs.getString("priceCategoryName"));
            bean.setPrv10Code(rs.getString("prv10Code"));
            bean.setPrv10Name(rs.getString("prv10Name"));
            bean.setPriceUOMCode(rs.getString("priceUOMCode"));
            bean.setPriceUOMName(rs.getString("priceUOMName"));
            bean.setWeight(rs.getString("weight"));
            bean.setWeightUOMCode(rs.getString("weightUOMCode"));
            bean.setWeightUOMName(rs.getString("weightUOMName"));
            bean.setBulkUOMCode(rs.getString("bulkUOMCode"));
            bean.setBulkUOMName(rs.getString("bulkUOMName"));
            bean.setItemBulk(rs.getString("itemBulk"));
            bean.setPrv14Name(rs.getString("prv14Name"));
            bean.setPrv26Name(rs.getString("prv26Name"));
            bean.setPrv24Name(rs.getString("prv24Name"));
            bean.setPrv27Name(rs.getString("prv27Name"));
            bean.setPrv25Name(rs.getString("prv25Name"));
            bean.setPrv28Name(rs.getString("prv28Name"));
            bean.setPrv8Code(rs.getString("prv8Code"));
            bean.setPrv8Name(rs.getString("prv8Name"));
            bean.setSpecs(rs.getString("specs"));
            bean.setPrv12Name(rs.getString("prv12Name"));
            bean.setPrv9Name(rs.getString("prv9Name"));
            bean.setPrv16Name(rs.getString("prv16Name"));
            bean.setEffective_IsEffective(rs.getString("effective_IsEffective"));
            bean.setPrv1Name(rs.getString("prv1Name"));
            bean.setCreatedOn(rs.getString("createdOn"));
            bean.setModifiedOn(rs.getString("modifiedOn"));
            bean.setFirstCategoryCode(rs.getString("firstCategoryCode"));
            bean.setFirstCategoryName(rs.getString("firstCategoryName"));
            bean.setSecondCategoryCode(rs.getString("secondCategoryCode"));
            bean.setSecondCategoryName(rs.getString("secondCategoryName"));
            bean.setThreeCategoryCode(rs.getString("threeCategoryCode"));
            bean.setThreeCategoryName(rs.getString("threeCategoryName"));
            bean.setPrv11Code(rs.getString("prv11Code"));
            bean.setPrv11Name(rs.getString("prv11Name"));
            list.add(bean);
        }
        return list;
    }

    public static List<ResourceGoodsU9> getForList12(String sql, String itemCode) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<ResourceGoodsU9> list = new ArrayList<ResourceGoodsU9>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, itemCode);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            ResourceGoodsU9 bean = new ResourceGoodsU9();
            bean.setItemCode(rs.getString("itemCode"));
            bean.setItemName(rs.getString("itemName"));
            bean.setPrv18Code(rs.getString("prv18Code"));
            bean.setPrv18Name(rs.getString("prv18Name"));
            bean.setPriceCategoryCode(rs.getString("priceCategoryCode"));
            bean.setPriceCategoryName(rs.getString("priceCategoryName"));
            bean.setPrv10Code(rs.getString("prv10Code"));
            bean.setPrv10Name(rs.getString("prv10Name"));
            bean.setPriceUOMCode(rs.getString("priceUOMCode"));
            bean.setPriceUOMName(rs.getString("priceUOMName"));
            bean.setWeight(rs.getString("weight"));
            bean.setWeightUOMCode(rs.getString("weightUOMCode"));
            bean.setWeightUOMName(rs.getString("weightUOMName"));
            bean.setBulkUOMCode(rs.getString("bulkUOMCode"));
            bean.setBulkUOMName(rs.getString("bulkUOMName"));
            bean.setItemBulk(rs.getString("itemBulk"));
            bean.setPrv14Name(rs.getString("prv14Name"));
            bean.setPrv26Name(rs.getString("prv26Name"));
            bean.setPrv24Name(rs.getString("prv24Name"));
            bean.setPrv27Name(rs.getString("prv27Name"));
            bean.setPrv25Name(rs.getString("prv25Name"));
            bean.setPrv28Name(rs.getString("prv28Name"));
            bean.setPrv8Code(rs.getString("prv8Code"));
            bean.setPrv8Name(rs.getString("prv8Name"));
            bean.setSpecs(rs.getString("specs"));
            bean.setPrv12Name(rs.getString("prv12Name"));
            bean.setPrv9Name(rs.getString("prv9Name"));
            bean.setPrv16Name(rs.getString("prv16Name"));
            bean.setEffective_IsEffective(rs.getString("effective_IsEffective"));
            bean.setPrv1Name(rs.getString("prv1Name"));
            bean.setCreatedOn(rs.getString("createdOn"));
            bean.setModifiedOn(rs.getString("modifiedOn"));
            bean.setFirstCategoryCode(rs.getString("firstCategoryCode"));
            bean.setFirstCategoryName(rs.getString("firstCategoryName"));
            bean.setSecondCategoryCode(rs.getString("secondCategoryCode"));
            bean.setSecondCategoryName(rs.getString("secondCategoryName"));
            bean.setThreeCategoryCode(rs.getString("threeCategoryCode"));
            bean.setThreeCategoryName(rs.getString("threeCategoryName"));
            bean.setPrv11Code(rs.getString("prv11Code"));
            bean.setPrv11Name(rs.getString("prv11Name"));
            list.add(bean);
        }
        return list;
    }

    private static <T> boolean checkFileType(Class<T> clazz, T instance, String columnLabel, Object value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (value instanceof Timestamp) {
                String value1 = simpleDateFormat.format((Date)value);
                Field field = clazz.getDeclaredField(columnLabel);
                field.setAccessible(true);
                field.set(instance, value1);
                return true;
            }
            if (value instanceof Long || value instanceof Integer) {
                Field field = clazz.getDeclaredField(columnLabel);
                field.setAccessible(true);
                field.set(instance, String.valueOf(value));
                return true;
            }
            if (value instanceof Boolean) {
                Field field = clazz.getDeclaredField(columnLabel);
                field.setAccessible(true);
                field.set(instance, value);
                return true;
            }
            if (value instanceof BigDecimal) {
                Field field = clazz.getDeclaredField(columnLabel);
                field.setAccessible(true);
                field.set(instance, value.toString());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Map<String, Object>> mapToList(String sql, Object ... args) throws SQLException, IOException, ClassNotFoundException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                preparedStatement.setObject(i + 1, args[i]);
            }
        }
        ResultSetMetaData metaData = preparedStatement.getMetaData();
        int columnCount = metaData.getColumnCount();
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                String columnName = metaData.getColumnName(i + 1);
                Object value = resultSet.getObject(columnName);
                map.put(columnName, value);
            }
            list.add(map);
        }
        try {
            SqlServerUtils.closeConn(connection, preparedStatement, resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Connection getConn() {
        System.setProperty("jdk.tls.client.protocols", "TLSv1");
        Connection dbConn = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, null);
            SSLContext.setDefault(sslContext);
            Class.forName(driverName);
            String AkanU9Url = SqlServerUtils.getDdFlag(ComConstants.tenantCode, "AkanU9Url", "AkanU9Url");
            String userName = SqlServerUtils.getDdFlag(ComConstants.tenantCode, "AkanU9UserName", "AkanU9UserName");
            String password = SqlServerUtils.getDdFlag(ComConstants.tenantCode, "AkanU9pwd", "AkanU9pwd");
            String dbURL = "jdbc:sqlserver://" + AkanU9Url + ";encrypt=true; trustServerCertificate=true;";
            dbConn = DriverManager.getConnection(dbURL, userName, password);
            logger.error("SqlServerUtils.dbConn", (Object)"SQL server\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error("SqlServerUtils.dbConn", (Object)"SQL server\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return dbConn;
    }

    protected static String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static void closeConn(Connection conn, PreparedStatement pstm, ResultSet rs) throws Exception {
        if (rs != null) {
            rs.close();
        }
        if (pstm != null) {
            pstm.close();
        }
        if (conn != null) {
            conn.close();
        }
    }

    public static List<ResourceGoodsU9> getForListBySkuNo(String sql, String skuNo) throws SQLException {
        ArrayList<ResourceGoodsU9> list = new ArrayList<ResourceGoodsU9>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, skuNo);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            ResourceGoodsU9 bean = new ResourceGoodsU9();
            bean.setItemCode(rs.getString("itemCode"));
            bean.setItemName(rs.getString("itemName"));
            bean.setPrv18Code(rs.getString("prv18Code"));
            bean.setPrv18Name(rs.getString("prv18Name"));
            bean.setPriceCategoryCode(rs.getString("priceCategoryCode"));
            bean.setPriceCategoryName(rs.getString("priceCategoryName"));
            bean.setPrv10Code(rs.getString("prv10Code"));
            bean.setPrv10Name(rs.getString("prv10Name"));
            bean.setPriceUOMCode(rs.getString("priceUOMCode"));
            bean.setPriceUOMName(rs.getString("priceUOMName"));
            bean.setWeight(rs.getString("weight"));
            bean.setWeightUOMCode(rs.getString("weightUOMCode"));
            bean.setWeightUOMName(rs.getString("weightUOMName"));
            bean.setBulkUOMCode(rs.getString("bulkUOMCode"));
            bean.setBulkUOMName(rs.getString("bulkUOMName"));
            bean.setItemBulk(rs.getString("itemBulk"));
            bean.setPrv14Name(rs.getString("prv14Name"));
            bean.setPrv26Name(rs.getString("prv26Name"));
            bean.setPrv24Name(rs.getString("prv24Name"));
            bean.setPrv27Name(rs.getString("prv27Name"));
            bean.setPrv25Name(rs.getString("prv25Name"));
            bean.setPrv28Name(rs.getString("prv28Name"));
            bean.setPrv8Code(rs.getString("prv8Code"));
            bean.setPrv8Name(rs.getString("prv8Name"));
            bean.setSpecs(rs.getString("specs"));
            bean.setPrv12Name(rs.getString("prv12Name"));
            bean.setPrv9Name(rs.getString("prv9Name"));
            bean.setPrv16Name(rs.getString("prv16Name"));
            bean.setEffective_IsEffective(rs.getString("effective_IsEffective"));
            bean.setPrv1Name(rs.getString("prv1Name"));
            bean.setCreatedOn(rs.getString("createdOn"));
            bean.setModifiedOn(rs.getString("modifiedOn"));
            bean.setFirstCategoryCode(rs.getString("firstCategoryCode"));
            bean.setFirstCategoryName(rs.getString("firstCategoryName"));
            bean.setSecondCategoryCode(rs.getString("secondCategoryCode"));
            bean.setSecondCategoryName(rs.getString("secondCategoryName"));
            bean.setThreeCategoryCode(rs.getString("threeCategoryCode"));
            bean.setThreeCategoryName(rs.getString("threeCategoryName"));
            bean.setPrv11Code(rs.getString("prv11Code"));
            bean.setPrv11Name(rs.getString("prv11Name"));
            list.add(bean);
        }
        return list;
    }

    public static List<String> getForU9SaveStoreSkuList(String sql, Object args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            list.add(rs.getString("itemInfo_ItemCode"));
        }
        return list;
    }

    public static List<WhQoh> getForU9SaveStoreList(String sql, Object args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<WhQoh> list = new ArrayList<WhQoh>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            WhQoh bean = new WhQoh();
            bean.setItemInfo_ItemCode(rs.getString("itemInfo_ItemCode"));
            bean.setStoreQty(rs.getString("storeQty"));
            bean.setWhCode(rs.getString("whCode"));
            bean.setWhName(rs.getString("whName"));
            bean.setOrgCode(rs.getString("OrgCode"));
            list.add(bean);
        }
        return list;
    }

    public static List<WhQoh> getForU9SaveStoreListNew(String sql) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<WhQoh> list = new ArrayList<WhQoh>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            WhQoh bean = new WhQoh();
            bean.setItemInfo_ItemCode(rs.getString("itemInfo_ItemCode"));
            bean.setStoreQty(rs.getString("storeQty"));
            bean.setWhCode(rs.getString("whCode"));
            bean.setWhName(rs.getString("whName"));
            bean.setOrgCode(rs.getString("OrgCode"));
            list.add(bean);
        }
        return list;
    }

    public static List<String> getForU9UpdateSkuList(String sql, LocalDateTime args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            list.add(rs.getString("itemInfo_ItemCode"));
        }
        return list;
    }

    public static List<WhQoh> getForU9UpdateStoreList(String sql, LocalDateTime args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<WhQoh> list = new ArrayList<WhQoh>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            WhQoh bean = new WhQoh();
            bean.setItemInfo_ItemCode(rs.getString("itemInfo_ItemCode"));
            bean.setStoreQty(rs.getString("storeQty"));
            bean.setWhCode(rs.getString("whCode"));
            list.add(bean);
        }
        return list;
    }

    public static List<WhQoh> getForU9SkuStoreList(String sql, String skuNo) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<WhQoh> list = new ArrayList<WhQoh>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, skuNo);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            WhQoh bean = new WhQoh();
            bean.setItemInfo_ItemCode(rs.getString("itemInfo_ItemCode"));
            bean.setStoreQty(rs.getString("storeQty"));
            bean.setWhCode(rs.getString("whCode"));
            bean.setStoreQty(rs.getString("StoreQty"));
            bean.setOrgCode(rs.getString("OrgCode"));
            list.add(bean);
        }
        return list;
    }

    public static List<ResourceGoodsU9> getForU9SkuList(String sql, LocalDateTime args) throws SQLException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<ResourceGoodsU9> list = new ArrayList<ResourceGoodsU9>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setObject(1, args);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            ResourceGoodsU9 bean = new ResourceGoodsU9();
            bean.setItemCode(rs.getString("itemCode"));
            bean.setItemName(rs.getString("itemName"));
            bean.setPrv18Code(rs.getString("prv18Code"));
            bean.setPrv18Name(rs.getString("prv18Name"));
            bean.setPriceCategoryCode(rs.getString("priceCategoryCode"));
            bean.setPriceCategoryName(rs.getString("priceCategoryName"));
            bean.setPrv10Code(rs.getString("prv10Code"));
            bean.setPrv10Name(rs.getString("prv10Name"));
            bean.setPriceUOMCode(rs.getString("priceUOMCode"));
            bean.setPriceUOMName(rs.getString("priceUOMName"));
            bean.setWeight(rs.getString("weight"));
            bean.setWeightUOMCode(rs.getString("weightUOMCode"));
            bean.setWeightUOMName(rs.getString("weightUOMName"));
            bean.setBulkUOMCode(rs.getString("bulkUOMCode"));
            bean.setBulkUOMName(rs.getString("bulkUOMName"));
            bean.setItemBulk(rs.getString("itemBulk"));
            bean.setPrv14Name(rs.getString("prv14Name"));
            bean.setPrv26Name(rs.getString("prv26Name"));
            bean.setPrv24Name(rs.getString("prv24Name"));
            bean.setPrv27Name(rs.getString("prv27Name"));
            bean.setPrv25Name(rs.getString("prv25Name"));
            bean.setPrv28Name(rs.getString("prv28Name"));
            bean.setPrv8Code(rs.getString("prv8Code"));
            bean.setPrv8Name(rs.getString("prv8Name"));
            bean.setSpecs(rs.getString("specs"));
            bean.setPrv12Name(rs.getString("prv12Name"));
            bean.setPrv9Name(rs.getString("prv9Name"));
            bean.setPrv16Name(rs.getString("prv16Name"));
            bean.setEffective_IsEffective(rs.getString("effective_IsEffective"));
            bean.setPrv1Name(rs.getString("prv1Name"));
            bean.setCreatedOn(rs.getString("createdOn"));
            bean.setModifiedOn(rs.getString("modifiedOn"));
            bean.setFirstCategoryCode(rs.getString("firstCategoryCode"));
            bean.setFirstCategoryName(rs.getString("firstCategoryName"));
            bean.setSecondCategoryCode(rs.getString("secondCategoryCode"));
            bean.setSecondCategoryName(rs.getString("secondCategoryName"));
            bean.setThreeCategoryCode(rs.getString("threeCategoryCode"));
            bean.setThreeCategoryName(rs.getString("threeCategoryName"));
            bean.setPrv11Code(rs.getString("prv11Code"));
            bean.setPrv11Name(rs.getString("prv11Name"));
            list.add(bean);
        }
        return list;
    }

    public static List<RsClasstreeDomain> getForU9SkuClassList(String sql) throws SQLException {
        ArrayList<RsClasstreeDomain> list = new ArrayList<RsClasstreeDomain>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            RsClasstreeDomain bean = new RsClasstreeDomain();
            if ("0".equals(rs.getString("Level"))) {
                bean.setClasstreeParentcode("-1");
            } else {
                bean.setClasstreeParentcode(rs.getString("LastCategoryCode"));
            }
            bean.setClasstreeCode(rs.getString("CategoryCode"));
            bean.setClasstreeName(rs.getString("CategoryName"));
            bean.setTenantCode(ComConstants.tenantCode);
            bean.setChannelCode(ComConstants.channelCode);
            bean.setMemberCode(ComConstants.membercode);
            bean.setClasstreeType("0");
            if ("2".equals(rs.getString("Level"))) {
                bean.setClasstreeLast("0");
            } else {
                bean.setClasstreeLast("1");
            }
            list.add(bean);
        }
        return list;
    }

    public static List<RsClasstreeDomain> getForU9SkuPriceClassList(String sql) throws SQLException {
        ArrayList<RsClasstreeDomain> list = new ArrayList<RsClasstreeDomain>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            RsClasstreeDomain bean = new RsClasstreeDomain();
            bean.setClasstreeParentcode("-1");
            bean.setClasstreeCode(rs.getString("CategoryCode"));
            bean.setClasstreeName(rs.getString("CategoryName"));
            bean.setTenantCode(ComConstants.tenantCode);
            bean.setChannelCode(ComConstants.channelCode);
            bean.setMemberCode(ComConstants.membercode);
            bean.setClasstreeType("9");
            list.add(bean);
        }
        return list;
    }

    public static List<ResourceGoodsU9> getForListBySkuNoBatch(String sql, List<String> skuNoList) throws SQLException {
        ArrayList<ResourceGoodsU9> list = new ArrayList<ResourceGoodsU9>();
        Connection connection = SqlServerUtils.getConn();
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 0; i < skuNoList.size(); ++i) {
            preparedStatement.setObject(i + 1, skuNoList.get(i));
        }
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            ResourceGoodsU9 bean = new ResourceGoodsU9();
            bean.setItemCode(rs.getString("itemCode"));
            bean.setItemName(rs.getString("itemName"));
            bean.setPrv18Code(rs.getString("prv18Code"));
            bean.setPrv18Name(rs.getString("prv18Name"));
            bean.setPriceCategoryCode(rs.getString("priceCategoryCode"));
            bean.setPriceCategoryName(rs.getString("priceCategoryName"));
            bean.setPrv10Code(rs.getString("prv10Code"));
            bean.setPrv10Name(rs.getString("prv10Name"));
            bean.setPriceUOMCode(rs.getString("priceUOMCode"));
            bean.setPriceUOMName(rs.getString("priceUOMName"));
            bean.setWeight(rs.getString("weight"));
            bean.setWeightUOMCode(rs.getString("weightUOMCode"));
            bean.setWeightUOMName(rs.getString("weightUOMName"));
            bean.setBulkUOMCode(rs.getString("bulkUOMCode"));
            bean.setBulkUOMName(rs.getString("bulkUOMName"));
            bean.setItemBulk(rs.getString("itemBulk"));
            bean.setPrv14Name(rs.getString("prv14Name"));
            bean.setPrv26Name(rs.getString("prv26Name"));
            bean.setPrv24Name(rs.getString("prv24Name"));
            bean.setPrv27Name(rs.getString("prv27Name"));
            bean.setPrv25Name(rs.getString("prv25Name"));
            bean.setPrv28Name(rs.getString("prv28Name"));
            bean.setPrv8Code(rs.getString("prv8Code"));
            bean.setPrv8Name(rs.getString("prv8Name"));
            bean.setSpecs(rs.getString("specs"));
            bean.setPrv12Name(rs.getString("prv12Name"));
            bean.setPrv9Name(rs.getString("prv9Name"));
            bean.setPrv16Name(rs.getString("prv16Name"));
            bean.setEffective_IsEffective(rs.getString("effective_IsEffective"));
            bean.setPrv1Name(rs.getString("prv1Name"));
            bean.setCreatedOn(rs.getString("createdOn"));
            bean.setModifiedOn(rs.getString("modifiedOn"));
            bean.setFirstCategoryCode(rs.getString("firstCategoryCode"));
            bean.setFirstCategoryName(rs.getString("firstCategoryName"));
            bean.setSecondCategoryCode(rs.getString("secondCategoryCode"));
            bean.setSecondCategoryName(rs.getString("secondCategoryName"));
            bean.setThreeCategoryCode(rs.getString("threeCategoryCode"));
            bean.setThreeCategoryName(rs.getString("threeCategoryName"));
            bean.setPrv11Code(rs.getString("prv11Code"));
            bean.setPrv11Name(rs.getString("prv11Name"));
            list.add(bean);
        }
        return list;
    }
}

