/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.ymsms;

import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpRequest;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpResponsePraser;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpResultCode;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpsParams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HttpClient {
    private int httpConnectionTimeOut = 30;
    private int httpReadTimeOut = 30;
    private TrustManager myX509TrustManager = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    };

    public HttpClient() {
    }

    public HttpClient(int httpConnectionTimeOut, int httpReadTimeOut) {
        this.httpConnectionTimeOut = httpConnectionTimeOut;
        this.httpReadTimeOut = httpReadTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T service(HttpRequest<?> request, HttpResponsePraser<T> praser) {
        HttpResultCode code = HttpResultCode.SUCCESS;
        if (request.getHttpParams().getUrl() == null || request.getHttpParams().getUrl().length() == 0) {
            code = HttpResultCode.ERROR_URL_NULL;
            return praser.prase(code, 0, null, null, request.getHttpParams().getCharSet(), null);
        }
        HttpURLConnection conn = null;
        int httpCode = 0;
        Map<String, String> headers = null;
        List<String> cookies = null;
        OutputStream outputStream = null;
        try {
            String realUrl = this.genUrl(request);
            conn = this.createConnection(request, realUrl);
            this.fillConnection(conn, request);
            this.request(conn, request);
            httpCode = conn.getResponseCode();
            headers = this.getHeaders(conn, request.getHttpParams().getCharSet());
            cookies = this.getCookies(conn, request.getHttpParams().getCharSet());
            outputStream = this.getResultOutputStream(conn);
        }
        catch (SocketTimeoutException e) {
            code = HttpResultCode.ERROR_TIMEOUT;
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            code = HttpResultCode.ERROR_HTTPS_SSL;
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            code = HttpResultCode.ERROR_HTTPS_SSL;
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            code = HttpResultCode.ERROR_METHOD;
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            code = HttpResultCode.ERROR_CHARSET;
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            code = HttpResultCode.ERROR_URL;
            httpCode = 500;
            e.printStackTrace();
        }
        catch (IOException e) {
            code = HttpResultCode.ERROR_CONNECT;
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            code = HttpResultCode.ERROR_HTTPS_SSL;
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            code = HttpResultCode.ERROR_HTTPS_SSL;
            e.printStackTrace();
        }
        catch (CertificateException e) {
            code = HttpResultCode.ERROR_HTTPS_SSL;
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        T t = null;
        try {
            t = praser.prase(code, httpCode, headers, cookies, request.getHttpParams().getCharSet(), (ByteArrayOutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((ByteArrayOutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return t;
    }

    private <T> String genUrl(HttpRequest<T> request) {
        if (request.getHttpParams().getMethod().equalsIgnoreCase("GET")) {
            String getprams = request.getContentPraser().praseRqeuestContentToString(request.getHttpParams());
            if (getprams != null) {
                String url = null;
                url = request.getHttpParams().getUrl().indexOf("?") > 0 ? request.getHttpParams().getUrl() + "&" + getprams : request.getHttpParams().getUrl() + "?" + getprams;
                return url;
            }
            return request.getHttpParams().getUrl();
        }
        return request.getHttpParams().getUrl();
    }

    private Map<String, String> getHeaders(HttpURLConnection conn, String charSet) throws UnsupportedEncodingException {
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        Map<String, List<String>> header = conn.getHeaderFields();
        if (header != null && header.size() > 0) {
            for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                if ("Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
                String valuer = "";
                if (entry.getValue() != null && entry.getValue().size() > 0) {
                    for (String value : entry.getValue()) {
                        valuer = valuer + new String(value.getBytes("ISO-8859-1"), charSet) + ",";
                    }
                    valuer = valuer.substring(0, valuer.length() - 1);
                }
                resultHeaders.put(entry.getKey(), valuer);
            }
        }
        return resultHeaders;
    }

    private List<String> getCookies(HttpURLConnection conn, String charSet) throws UnsupportedEncodingException {
        ArrayList<String> resultC = new ArrayList<String>();
        List<String> cookies = null;
        Map<String, List<String>> header = conn.getHeaderFields();
        if (header != null && header.size() > 0) {
            cookies = header.get("Set-Cookie");
        }
        if (cookies != null) {
            for (String cookie : cookies) {
                resultC.add(new String(cookie.getBytes("ISO-8859-1"), charSet));
            }
        }
        return cookies;
    }

    private ByteArrayOutputStream getResultOutputStream(HttpURLConnection conn) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try (InputStream is = conn.getInputStream();){
            if (is != null) {
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        return outStream;
    }

    private <T> void request(HttpURLConnection conn, HttpRequest<T> request) throws IOException {
        if (request.getHttpParams().getMethod().equalsIgnoreCase("POST")) {
            conn.setDoOutput(true);
            if (request.getHttpParams().getParams() != null) {
                byte[] content = request.getContentPraser().praseRqeuestContentToBytes(request.getHttpParams());
                this.fillHeader(conn, "Content-Length", String.valueOf(request.getContentPraser().praseRqeuestContentLength(request.getHttpParams())));
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.write(content);
                out.flush();
                out.close();
            }
        } else {
            conn.connect();
        }
    }

    private void fillConnection(HttpURLConnection conn, HttpRequest<?> request) throws ProtocolException {
        this.fillTimeout(conn);
        this.filleMethod(conn, request);
        this.fillHeaders(conn, request);
        this.fillCookies(conn, request);
    }

    private void fillTimeout(HttpURLConnection conn) {
        if (this.httpConnectionTimeOut != 0) {
            conn.setConnectTimeout(this.httpConnectionTimeOut * 1000);
        }
        if (this.httpReadTimeOut != 0) {
            conn.setReadTimeout(this.httpReadTimeOut * 1000);
        }
    }

    private void filleMethod(HttpURLConnection conn, HttpRequest<?> request) throws ProtocolException {
        conn.setRequestMethod(request.getHttpParams().getMethod().toUpperCase());
    }

    private void fillHeaders(HttpURLConnection conn, HttpRequest<?> request) {
        if (request.getHttpParams().getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHttpParams().getHeaders().entrySet()) {
                this.fillHeader(conn, entry.getKey(), entry.getValue());
            }
        }
    }

    private void fillHeader(HttpURLConnection conn, String key, String value) {
        conn.setRequestProperty(key, value);
    }

    private void fillCookies(HttpURLConnection conn, HttpRequest<?> request) {
        if (request.getHttpParams().getCookies() != null) {
            conn.setRequestProperty("Cookie", request.getHttpParams().getCookies());
        }
    }

    private HttpURLConnection createConnection(HttpRequest<?> request, String realUrl) throws NoSuchAlgorithmException, KeyManagementException, MalformedURLException, IOException, UnrecoverableKeyException, KeyStoreException, CertificateException {
        URL console = new URL(realUrl);
        HttpURLConnection conn = request.isHttps() ? this.genHttpsConn(console, request) : (HttpURLConnection)console.openConnection();
        return conn;
    }

    private HttpURLConnection genHttpsConn(URL console, HttpRequest<?> request) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SSLContext ctx = this.getSSLContext(request.getHttpsParams());
        HttpsURLConnection sconn = (HttpsURLConnection)console.openConnection();
        sconn.setSSLSocketFactory(ctx.getSocketFactory());
        sconn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return sconn;
    }

    private KeyStore getKeyStore(HttpsParams params) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(params.getAlgorithm());
        FileInputStream is = new FileInputStream(params.getKeyStorePath());
        ks.load(is, params.getPassword().toCharArray());
        is.close();
        return ks;
    }

    private SSLContext getSSLContext(HttpsParams params) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        if (params != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = this.getKeyStore(params);
            keyManagerFactory.init(keyStore, params.getPassword().toCharArray());
            KeyStore trustStore = this.getKeyStore(params);
            trustManagerFactory.init(trustStore);
            ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        } else {
            ctx.init(null, new TrustManager[]{this.myX509TrustManager}, new SecureRandom());
        }
        return ctx;
    }
}

