/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.ItembrandRequest;
import com.yqbsoft.laser.service.exdate.facade.response.ItembrandResponse;
import com.yqbsoft.laser.service.exdate.model.RsBrandDomain;
import com.yqbsoft.laser.service.exdate.service.BrandService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="brandService")
public class BrandServiceImpl
extends BaseServiceImpl
implements BrandService {
    private static final String SYS_CODE = "service.adapter.dms.BrandServiceImpl";

    @Override
    public String queryGoodsBrandInfo(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.null");
            return ResultEnums.error.getCode();
        }
        Httpfacade httpfacade = new Httpfacade("http://md.aiyingtong.com.cn/data/brand");
        ItembrandRequest itembrandRequest = new ItembrandRequest();
        itembrandRequest.setName("qqq");
        ItembrandResponse execute = httpfacade.execute(itembrandRequest);
        if (execute == null) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.execute");
            return ResultEnums.error.getCode();
        }
        List<RsBrandDomain> rsBrandDomainList = execute.getRsBrandDomainList();
        if (ListUtil.isEmpty(rsBrandDomainList)) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.rsBrandDomainList");
            return ResultEnums.error.getCode();
        }
        ArrayList brandList = new ArrayList();
        for (RsBrandDomain rsBrandDomain : rsBrandDomainList) {
            rsBrandDomain.setTenantCode(tenantCode);
            this.getBrand(rsBrandDomain, tenantCode);
        }
        return ResultEnums.success.getCode();
    }

    public void getBrand(RsBrandDomain rsBrandDomain, String tenantCode) throws ApiException {
        if (rsBrandDomain == null) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.checkBrandInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("brandEocode", rsBrandDomain.getBrandEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeSendmap, com.yqbsoft.laser.service.exdate.domain.RsBrandDomain.class);
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            com.yqbsoft.laser.service.exdate.domain.RsBrandDomain rsBrandDomain1 = (com.yqbsoft.laser.service.exdate.domain.RsBrandDomain)jsonToObject.getList().get(0);
            rsBrandDomain1.setBrandName(rsBrandDomain.getBrandName());
            HashMap<String, String> brandMap = new HashMap<String, String>();
            brandMap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain1));
            this.internalInvoke(ApiCodeEnums.updateBrand.getApiCode(), brandMap);
        } else {
            HashMap<String, String> brandMap = new HashMap<String, String>();
            brandMap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
            this.internalInvoke(ApiCodeEnums.saveBrand.getApiCode(), brandMap);
        }
    }

    public static void main(String[] args) {
        Httpfacade httpfacade = new Httpfacade("http://md.aiyingtong.com.cn/data/brand");
        ItembrandRequest itembrandRequest = new ItembrandRequest();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("page", 10);
        ItembrandResponse execute = httpfacade.execute(itembrandRequest);
        System.out.println(execute);
        if (execute == null) {
            // empty if block
        }
        List<RsBrandDomain> rsBrandDomainList = execute.getRsBrandDomainList();
        System.out.println("========" + rsBrandDomainList);
    }
}

