/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.CtCustrelDomain;
import com.yqbsoft.laser.service.exdate.domain.CtCustrelEmpDomain;
import com.yqbsoft.laser.service.exdate.domain.DisChannel;
import com.yqbsoft.laser.service.exdate.domain.DisChannelDomain;
import com.yqbsoft.laser.service.exdate.domain.DisDgoods;
import com.yqbsoft.laser.service.exdate.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgDepart;
import com.yqbsoft.laser.service.exdate.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgDepartempDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.exdate.domain.UmAddressDomain;
import com.yqbsoft.laser.service.exdate.domain.UmQualityQtypeDomain;
import com.yqbsoft.laser.service.exdate.domain.UmUser;
import com.yqbsoft.laser.service.exdate.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.AydStoreInfoRequest;
import com.yqbsoft.laser.service.exdate.facade.response.AydStoreInfoResponse;
import com.yqbsoft.laser.service.exdate.model.UmQualityQtype;
import com.yqbsoft.laser.service.exdate.service.UserinfoService;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="userinfoService")
public class UserinfoServiceImpl
extends BaseServiceImpl
implements UserinfoService {
    private static final String SYS_CODE = "service.adapter.dms.UserinfoServiceImpl";
    private static String PGSup = "80001";
    private int OneDayMillis = 86400000;

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    private String getDate(String type, String userinfoCode, String tenantCode) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "2002-01-01 12:00:00";
    }

    @Override
    public String synSupplierInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synSupplierInfo.null");
            return ResultEnums.error.getCode();
        }
        List umUserinfoDomainBeanList = null;
        if (ListUtil.isEmpty(umUserinfoDomainBeanList)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synSupplierInfo.umUserinfoDomainBeanList");
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : umUserinfoDomainBeanList) {
            boolean b = this.checkSupplierInfo(umUserinfoDomainBean, tenantCode);
            if (b) {
                this.updateSupplierInfo(umUserinfoDomainBean, tenantCode);
            }
            umUserinfoDomainBean.setTenantCode(tenantCode);
            paramMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            this.internalInvoke(ApiCodeEnums.saveUserinfo.getApiCode(), paramMap);
        }
        return ResultEnums.success.getCode();
    }

    public boolean checkSupplierInfo(UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkSupplierInfo.null");
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", umUserinfoDomainBean.getUserCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkSupplierInfo.queryResult", (Object)((Object)paramMap).toString());
            return false;
        }
        return true;
    }

    public void updateSupplierInfo(UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateSupplierInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", umUserinfoDomainBean.getUserCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateSupplierInfo.queryResult", (Object)((Object)paramMap).toString());
            return;
        }
        HashMap<String, String> sendMapParam = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean1 : queryResult.getList()) {
            umUserinfoDomainBean1.setUserinfoCompname(umUserinfoDomainBean.getUserinfoCompname());
            umUserinfoDomainBean1.setUserCode(umUserinfoDomainBean.getUserCode());
            umUserinfoDomainBean1.setUserName(umUserinfoDomainBean.getUserName());
            umUserinfoDomainBean1.setCompanyType(umUserinfoDomainBean.getCompanyType());
            sendMapParam.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean1));
            this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), sendMapParam);
        }
    }

    @Override
    public String synStoreInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synStoreInfo.null");
            return ResultEnums.error.getCode();
        }
        List umAddressDomainList = null;
        List umUserinfoDomainBeanList = null;
        if (ListUtil.isEmpty(umAddressDomainList)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synStoreInfo.umAddressDomainList");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean retailInfo = this.getRetailInfo(tenantCode, userinfoCode);
        if (retailInfo == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synStoreInfo.retailInfo.null", (Object)("tenantCode is" + tenantCode));
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> phoneMap = new HashMap<String, String>();
        for (UmUserDomainBean umUserinfoDomainBean : umUserinfoDomainBeanList) {
            UmUserinfoDomainBean oldUmUserinfoDomainBean = this.checkStoreInfo(umUserinfoDomainBean);
            if (null != oldUmUserinfoDomainBean) {
                this.updateStoreInfo(umUserinfoDomainBean, oldUmUserinfoDomainBean);
                continue;
            }
            if (StringUtils.isBlank((String)((String)phoneMap.get(umUserinfoDomainBean.getUserTel())))) {
                UmUser umUser = this.queryUmUserByUserPhone(tenantCode, umUserinfoDomainBean.getUserTel());
                if (null == umUser) {
                    umUserinfoDomainBean.setUserPhone(umUserinfoDomainBean.getUserTel());
                }
                phoneMap.put(umUserinfoDomainBean.getUserTel(), umUserinfoDomainBean.getUserTel());
            }
            umUserinfoDomainBean.setUserinfoType(2);
            umUserinfoDomainBean.setDataState(0);
            umUserinfoDomainBean.setUserinfoDataState(4);
            umUserinfoDomainBean.setTenantCode(tenantCode);
            umUserinfoDomainBean.setUserinfoParentCode(retailInfo.getUserinfoCode());
            umUserinfoDomainBean.setUserinfoParentName(retailInfo.getUserinfoCompname());
            ArrayList<UmUserinfoQuaDomain> umUserinfoQuaDomainList = new ArrayList<UmUserinfoQuaDomain>();
            UmUserinfoQuaDomain umUserinfoQuaDomain = new UmUserinfoQuaDomain();
            umUserinfoQuaDomainList.add(umUserinfoQuaDomain);
            umUserinfoQuaDomain.setUserinfoQuaKey("levelListCode_dealer");
            umUserinfoQuaDomain.setUserinfoQuaVaule("100055_1");
            umUserinfoDomainBean.setUmUserinfoQuaDomainList(umUserinfoQuaDomainList);
            HashMap<String, String> storeMap = new HashMap<String, String>();
            storeMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            String userinfoCodeNow = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), storeMap);
            HashMap<String, String> saveAddressMap = new HashMap<String, String>();
            for (UmAddressDomain umAddressDomain : umAddressDomainList) {
                if (!umAddressDomain.getUserCode().equals(umUserinfoDomainBean.getUserinfoOcode())) continue;
                umAddressDomain.setTenantCode(tenantCode);
                umAddressDomain.setUserCode(userinfoCodeNow);
                umAddressDomain.setAddressDefault("1");
                saveAddressMap.put("umAddressDomain", JsonUtil.buildNonNullBinder().toJson((Object)umAddressDomain));
                this.internalInvoke(ApiCodeEnums.saveAddress.getApiCode(), saveAddressMap);
            }
        }
        return ResultEnums.success.getCode();
    }

    public void updateDisByStore(List<UmUserDomainBean> umUserDomainBeanList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            map.put("userinfoOcode", umUserDomainBean.getUserinfoOcode());
            map.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
            invokeMap.put("map", map);
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
            if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.updateDisChannel", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)quresult.getList().get(0);
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            HashMap<String, String> channelMap = new HashMap<String, String>();
            channelMap.put("memberCode", userinfoCode);
            channelMap.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeChannelMap = new HashMap<String, HashMap<String, String>>();
            invokeChannelMap.put("map", channelMap);
            QueryResult channelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
            if (channelQueryResult == null || ListUtil.isEmpty((Collection)channelQueryResult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.updateDisChannel", (Object)("invokeChannelMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            DisChannel disChannel = (DisChannel)channelQueryResult.getList().get(0);
            disChannel.setMemberCcode(umUserDomainBean.getUserinfoCode());
            disChannel.setMemberCname(umUserDomainBean.getUserinfoCompname());
            disChannel.setMemberMcode(umUserDomainBean.getUserinfoParentCode());
            disChannel.setMemberCode(umUserDomainBean.getDepartCode());
            DisChannelDomain disChannelDomain = new DisChannelDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disChannelDomain, (Object)disChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("disChannelDomain", JsonUtil.buildNonNullBinder().toJson((Object)disChannelDomain));
            this.internalInvoke(ApiCodeEnums.updateChannel.getApiCode(), updateMap);
            this.updateDgoods(umUserinfoDomainBean.getTenantCode(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoParentCode());
        }
    }

    public UmUserinfoDomainBean checkStoreInfo(UmUserDomainBean umUserinfoDomainBean) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkStoreInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("qualityQtype", "dealer");
        paramMap.put("userinfoOcode", umUserinfoDomainBean.getUserinfoOcode());
        paramMap.put("tenantCode", umUserinfoDomainBean.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkStoreInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)jsonToObject.getList().get(0);
    }

    public void updateStoreInfo(UmUserDomainBean umUserinfoDomainBean, UmUserinfoDomainBean umUserinfoDomainBean1) throws ApiException {
        if (umUserinfoDomainBean == null || null == umUserinfoDomainBean1) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateStoreInfo.null");
            return;
        }
        HashMap<String, String> storeMap = new HashMap<String, String>();
        umUserinfoDomainBean1.setUserinfoCompname(umUserinfoDomainBean.getUserinfoCompname());
        umUserinfoDomainBean1.setUserinfoType(2);
        umUserinfoDomainBean1.setProvinceName(umUserinfoDomainBean.getProvinceName());
        umUserinfoDomainBean1.setAreaName(umUserinfoDomainBean.getAreaName());
        umUserinfoDomainBean1.setCityName(umUserinfoDomainBean.getCityName());
        umUserinfoDomainBean1.setCompanyAddress(umUserinfoDomainBean.getCompanyAddress());
        umUserinfoDomainBean1.setUserinfoConPhone(umUserinfoDomainBean.getUserinfoConPhone());
        String userinfoConPhone = umUserinfoDomainBean1.getUserinfoConPhone();
        if (StringUtils.isBlank((String)userinfoConPhone) || !userinfoConPhone.equals(umUserinfoDomainBean.getUserinfoConPhone())) {
            String userinfoCode = umUserinfoDomainBean1.getUserinfoCode();
            UmUser umUser = this.queryUmUser(umUserinfoDomainBean.getTenantCode(), userinfoCode);
            if (umUser != null) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateStoreInfo.umUser", (Object)("id is" + umUser.getUserId()));
                umUser.setUserTel(umUserinfoDomainBean.getUserinfoConPhone());
                UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashMap<String, UmUserDomainBean> updateMap = new HashMap<String, UmUserDomainBean>();
                updateMap.put("UmUserDomainBean", umUserDomainBean);
                this.internalInvoke(ApiCodeEnums.updateUser.getApiCode(), storeMap);
            }
        }
        storeMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean1));
        this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), storeMap);
    }

    public UmUser queryUmUser(String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userPcode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryUserPage.getApiCode(), invokeMap, UmUser.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (UmUser)queryResutl.getList().get(0);
    }

    public UmUser queryUmUserByUserPhone(String tenantCode, String userPhone) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPhone)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userPhone", userPhone);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryUserPage.getApiCode(), invokeMap, UmUser.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (UmUser)queryResutl.getList().get(0);
    }

    @Override
    public String synSalesRepresentativeInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synSalesRepresentativeInfo.null");
            return ResultEnums.error.getCode();
        }
        Httpfacade httpfacade = new Httpfacade(null);
        return ResultEnums.success.getCode();
    }

    public OrgDepart getDepShortcode(String tenantCode, String departShortcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)departShortcode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("departShortcode", departShortcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepart.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("getDepCode paramMap is" + ((Object)paramMap).toString());
            return null;
        }
        return (OrgDepart)queryResutl.getList().get(0);
    }

    public void sysDeparttemp(OrgEmployeeDomain orgEmployeeDomain) {
        if (orgEmployeeDomain == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.sysDeparttemp.null");
            return;
        }
        OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
        orgDepartempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
        orgDepartempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
        orgDepartempDomain.setTenantCode(orgEmployeeDomain.getTenantCode());
        Map<String, String> resultMap = this.getDepartCodeByMemo(orgEmployeeDomain.getCompanyCode(), orgDepartempDomain.getTenantCode());
        orgDepartempDomain.setDepartCode(resultMap.get("departCode"));
        orgDepartempDomain.setCompanyCode(resultMap.get("companyCode"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgDepartempDomain", JsonUtil.buildNonNullBinder().toJson((Object)orgDepartempDomain));
        this.internalInvoke(ApiCodeEnums.saveDepartemp.getApiCode(), map);
    }

    public Map<String, String> getDepartCodeByMemo(String orgNum, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)orgNum) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getDepartCodeByMemo.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", orgNum);
        map.put("tenantCode", tenantCode);
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), map, OrgDepartempDomain.class);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            resultMap.put("departCode", "-1");
            resultMap.put("companyCode", "-1");
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getDepartCodeByMemo.ListUtil", (Object)((Object)map).toString());
            return resultMap;
        }
        for (OrgDepartempDomain orgDepart : jsonToObject.getList()) {
            if (StringUtils.isBlank((String)orgDepart.getDepartCode())) {
                resultMap.put("departCode", "-1");
            } else {
                resultMap.put("departCode", orgDepart.getDepartCode());
            }
            String companyCode = orgDepart.getCompanyCode();
            if (StringUtils.isBlank((String)companyCode)) {
                resultMap.put("companyCode", "-1");
            } else {
                resultMap.put("companyCode", companyCode);
            }
            String departName = orgDepart.getDepartName();
            if (StringUtils.isBlank((String)departName)) {
                resultMap.put("departName", "-1");
                continue;
            }
            resultMap.put("departName", departName);
        }
        return resultMap;
    }

    public void updateSalesRepresentativeInfo(OrgEmployeeDomain orgEmployeeDomain, String tenantCode) throws ApiException {
        if (orgEmployeeDomain == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateSalesRepresentativeInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeCode", orgEmployeeDomain.getEmployeeCode());
        paramMap.put("companyCode", orgEmployeeDomain.getCompanyCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateSalesRepresentativeInfo.jsonToObject", (Object)((Object)paramMap).toString());
        }
        HashMap<String, String> employeeMap = new HashMap<String, String>();
        for (OrgEmployeeDomain orgEmployeeDomain1 : jsonToObject.getList()) {
            orgEmployeeDomain1.setCompanyCode(orgEmployeeDomain.getCompanyCode());
            orgEmployeeDomain1.setEmployeeName(orgEmployeeDomain.getEmployeeName());
            orgEmployeeDomain1.setEmployeePhone(orgEmployeeDomain.getEmployeePhone());
            employeeMap.put("orgEmployeeDomain", JsonUtil.buildNonNullBinder().toJson((Object)orgEmployeeDomain1));
            this.internalInvoke(ApiCodeEnums.updateEmployee.getApiCode(), employeeMap);
        }
    }

    public OrgEmployeeDomain checkSalesRepresentativeInfo(OrgEmployeeDomain orgEmployeeDomain, String tenantCode) throws ApiException {
        if (orgEmployeeDomain == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkSalesRepresentativeInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeOcode", orgEmployeeDomain.getEmployeeOcode());
        paramMap.put("companyCode", orgEmployeeDomain.getCompanyCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkSalesRepresentativeInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (OrgEmployeeDomain)jsonToObject.getList().get(0);
    }

    public OrgEmployeeDomain getOrgEmployeeByOcode(String tenantCode, String employeeOcode) throws ApiException {
        if (StringUtils.isBlank((String)employeeOcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getOrgEmployeeDomain.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeOcode", employeeOcode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getOrgEmployeeDomain.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (OrgEmployeeDomain)jsonToObject.getList().get(0);
    }

    @Override
    public String synStoreType(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.error.getCode();
    }

    private void updateQualityQtype(UmQualityQtypeDomain umQualityQtypeDomain, UmQualityQtypeDomain oldUmQualityQtypeDomain) {
        oldUmQualityQtypeDomain.setQtypeQtypeName(umQualityQtypeDomain.getQtypeQtypeName());
        oldUmQualityQtypeDomain.setQualityQtypeType(umQualityQtypeDomain.getQualityQtypeType());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("UmQualityQtypeDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldUmQualityQtypeDomain));
        this.logger.error("service.adapter.dms.UserinfoServiceImplupdateQualityQtype", (Object)JsonUtil.buildNonNullBinder().toJson((Object)oldUmQualityQtypeDomain));
        this.internalInvoke(ApiCodeEnums.updateQualityQtype.getApiCode(), invokeMap);
    }

    @Override
    public String synDepartInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public String updateOrSaveUser(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            return null;
        }
        umUserinfoDomainBean.setTenantCode(tenantCode);
        boolean b = this.checkUserinfo(umUserinfoDomainBean, tenantCode);
        this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.execute", (Object)("checkBoolean is" + b));
        if (b) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.update", (Object)("umUserinfoDomainBean is" + JsonUtil.buildNonNullBinder().toJson((Object)umUserinfoDomainBean)));
            String userinfoCode = this.updateUserinfo(umUserinfoDomainBean, tenantCode);
            return userinfoCode;
        }
        HashMap<String, String> umMap = new HashMap<String, String>();
        umMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.execute", (Object)("umUserinfoDomainBean is" + JsonUtil.buildNonNullBinder().toJson((Object)umUserinfoDomainBean)));
        String userinfoCode = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), umMap);
        return userinfoCode;
    }

    public Map<String, List<UmUserDomainBean>> spiltUserQuality(List<UmUserDomainBean> umUserDomainBeanList) {
        ArrayList<UmUserDomainBean> retailList = new ArrayList<UmUserDomainBean>();
        ArrayList<UmUserDomainBean> companyList = new ArrayList<UmUserDomainBean>();
        ArrayList<UmUserDomainBean> departList = new ArrayList<UmUserDomainBean>();
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            if (umUserDomainBean.getUserinfoQuality().equals("retailer")) {
                retailList.add(umUserDomainBean);
            }
            if (umUserDomainBean.getUserinfoQuality().equals("company")) {
                companyList.add(umUserDomainBean);
            }
            if (!umUserDomainBean.getUserinfoQuality().equals("depart")) continue;
            departList.add(umUserDomainBean);
        }
        HashMap<String, List<UmUserDomainBean>> resultMap = new HashMap<String, List<UmUserDomainBean>>();
        resultMap.put("retailer", retailList);
        resultMap.put("company", companyList);
        resultMap.put("depart", departList);
        return resultMap;
    }

    public void updateDis(List<UmUserDomainBean> umUserDomainBeanList) {
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userinfoOcode", umUserDomainBean.getUserinfoOcode());
            map.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
            invokeMap.put("map", map);
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
            if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.updateDisChannel", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)quresult.getList().get(0);
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            HashMap<String, String> channelMap = new HashMap<String, String>();
            channelMap.put("memberCode", userinfoCode);
            channelMap.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, String> invokeChannelMap = new HashMap<String, String>();
            invokeChannelMap.put("map", JsonUtil.buildNonNullBinder().toJson(channelMap));
            QueryResult channelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
            if (channelQueryResult == null || ListUtil.isEmpty((Collection)channelQueryResult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.updateDisChannel", (Object)("invokeChannelMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            DisChannel disChannel = (DisChannel)channelQueryResult.getList().get(0);
            disChannel.setMemberMcode(umUserinfoDomainBean.getUserinfoParentCode());
            disChannel.setMemberMname(umUserDomainBean.getUserinfoParentName());
            if (umUserinfoDomainBean.getUserinfoQuality().equals("company")) {
                disChannel.setGoodsClass("B2B");
            }
            if (umUserinfoDomainBean.getUserinfoQuality().equals("dealer")) {
                disChannel.setGoodsClass("B2B-ORG");
            }
            DisChannelDomain disChannelDomain = new DisChannelDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disChannelDomain, (Object)disChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("disChannelDomain", JsonUtil.buildNonNullBinder().toJson((Object)disChannelDomain));
            this.internalInvoke(ApiCodeEnums.updateChannel.getApiCode(), updateMap);
            this.updateDgoods(umUserinfoDomainBean.getTenantCode(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoParentCode());
        }
    }

    public void updateDgoods(String tenantCode, String memberCode, String memberMcode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("memberCode", memberCode);
        HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
        invokeMap.put("map", queryMap);
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDgoodsPage.getApiCode(), invokeMap, DisDgoods.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synDepartInfo.updateDgoods", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
            return;
        }
        DisDgoods disDgoods = (DisDgoods)queryResutl.getList().get(0);
        disDgoods.setDgoodsUprice("1");
        disDgoods.setDgoodsUnum("1");
        disDgoods.setDgoodsEdit("1");
        disDgoods.setMemberMcode(memberMcode);
        DisDgoodsDomain disDgoodsDomain = new DisDgoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsDomain, (Object)disDgoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("DisDgoodsDomain", JsonUtil.buildNonNullBinder().toJson((Object)disDgoodsDomain));
        this.internalInvoke(ApiCodeEnums.updateDgoods.getApiCode(), updateMap);
    }

    public UmUserinfoDomainBean getRetailInfo(String tenantCode, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getReCode(String tenantCode, String userinfoOpcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOpcode", userinfoOpcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return "-1";
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String getCodeByOcode(String tenantCode, String userinfoOcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return "-1";
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String doRetailData(String tenantCode, String dmsId, String userinfoCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userinfoOpcode", dmsId);
        queryMap.put("userinfoQuality", "retailer");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            UmUserDomainBean umUserDomainBean = this.buildRetailUser(dmsId, tenantCode, userinfoCode);
            HashMap<String, String> umMap = new HashMap<String, String>();
            umMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            String retailCode = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), umMap);
            OrgCompanyDomain orgCompanyDomain = this.buildReCompany(dmsId, tenantCode);
            orgCompanyDomain.setUserinfoCode(retailCode);
            HashMap<String, String> companyMap = new HashMap<String, String>();
            companyMap.put("orgCompanyDomain", JsonUtil.buildNormalBinder().toJson((Object)orgCompanyDomain));
            this.internalInvoke(ApiCodeEnums.saveCompany.getApiCode(), companyMap);
            return retailCode;
        }
        return this.getReCode(tenantCode, dmsId);
    }

    public UmUserDomainBean buildRetailUser(String dmsId, String tenantCode, String userinfoCode) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserinfoType(2);
        umUserDomainBean.setCompanyType(1);
        umUserDomainBean.setUserinfoQuality("retailer");
        umUserDomainBean.setDepartCode(dmsId);
        umUserDomainBean.setDepartName(dmsId);
        umUserDomainBean.setUserinfoCompname(dmsId);
        umUserDomainBean.setUserName(dmsId);
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserinfoOpcode(dmsId);
        umUserDomainBean.setUserinfoParentCode(userinfoCode);
        return umUserDomainBean;
    }

    public OrgCompanyDomain buildReCompany(String dmsId, String tenantCode) {
        OrgCompanyDomain orgCompanyDomain = new OrgCompanyDomain();
        orgCompanyDomain.setCompanyCode(dmsId);
        orgCompanyDomain.setCompanyShortcode(dmsId);
        orgCompanyDomain.setCompanyName(dmsId);
        orgCompanyDomain.setCompanyShortname(dmsId);
        orgCompanyDomain.setTenantCode(tenantCode);
        return orgCompanyDomain;
    }

    public String doCompanyData(OrgCompanyDomain orgCompanyDomain) {
        OrgCompanyDomain oldorgCompanyDomain = this.checkCompany(orgCompanyDomain.getCompanyOcode(), orgCompanyDomain.getTenantCode());
        this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCompanyData.oldorgCompanyDomain", (Object)(orgCompanyDomain.getCompanyOcode() + "=" + oldorgCompanyDomain));
        if (null != oldorgCompanyDomain) {
            this.updateCompany(orgCompanyDomain, oldorgCompanyDomain);
            return oldorgCompanyDomain.getCompanyCode();
        }
        HashMap<String, String> companyMap = new HashMap<String, String>();
        companyMap.put("orgCompanyDomain", JsonUtil.buildNormalBinder().toJson((Object)orgCompanyDomain));
        return this.internalInvoke(ApiCodeEnums.saveCompany.getApiCode(), companyMap);
    }

    public OrgCompanyDomain checkCompany(String companyOcode, String tenantCode) {
        if (StringUtils.isBlank((String)companyOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyOcode", companyOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public OrgCompanyDomain getCompanyByCode(String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)companyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyCode", companyCode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public OrgCompanyDomain getCompanyByOcode(String companyOcode, String tenantCode) {
        if (StringUtils.isBlank((String)companyOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyOcode", companyOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public void updateCompany(OrgCompanyDomain orgCompanyDomain, OrgCompanyDomain oldorgCompanyDomain) {
        if (null == oldorgCompanyDomain || null == orgCompanyDomain) {
            return;
        }
        oldorgCompanyDomain.setCompanyPcode(orgCompanyDomain.getCompanyPcode());
        oldorgCompanyDomain.setCompanyName(orgCompanyDomain.getCompanyName());
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("orgCompanyDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldorgCompanyDomain));
        this.internalInvoke(ApiCodeEnums.updateCompany.getApiCode(), updateMap);
    }

    public String doDepartData(OrgDepartDomain orgDepartDomain) {
        if (null == orgDepartDomain) {
            return null;
        }
        OrgDepartDomain oldOrgDepartDomain = this.checkDepart(orgDepartDomain.getDepartOcode(), orgDepartDomain.getTenantCode());
        if (null != oldOrgDepartDomain) {
            this.updateDepart(orgDepartDomain, oldOrgDepartDomain);
            return oldOrgDepartDomain.getDepartCode();
        }
        HashMap<String, String> departMap = new HashMap<String, String>();
        departMap.put("orgDepartDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain));
        return this.internalInvoke(ApiCodeEnums.saveDepartBatch.getApiCode(), departMap);
    }

    public OrgDepartDomain checkDepart(String departOcode, String tenantCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("departOcode", departOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepartDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgDepartDomain)queryResutl.getList().get(0);
    }

    public void updateDepart(OrgDepartDomain orgDepartDomain, OrgDepartDomain oldOrgDepartDomain) {
        if (null == oldOrgDepartDomain || null == orgDepartDomain) {
            return;
        }
        oldOrgDepartDomain.setDepartPcode(orgDepartDomain.getDepartPcode());
        oldOrgDepartDomain.setCompanyCode(orgDepartDomain.getCompanyCode());
        oldOrgDepartDomain.setDepartName(orgDepartDomain.getDepartName());
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("orgDepartDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldOrgDepartDomain));
        this.internalInvoke(ApiCodeEnums.updateDepart.getApiCode(), updateMap);
    }

    public boolean checkUserinfo(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkUserinfo.null");
            return false;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", umUserinfoDomainBean.getDepartCode());
        HashMap<String, String> invokeUserMap = new HashMap<String, String>();
        invokeUserMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeUserMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkUserinfo.quresult", (Object)((Object)sendMap).toString());
            return false;
        }
        return true;
    }

    public String updateUserinfo(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateUserinfo.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", umUserinfoDomainBean.getDepartCode());
        HashMap<String, String> invokeUserMap = new HashMap<String, String>();
        invokeUserMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeUserMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateUserinfo.quresult", (Object)((Object)sendMap).toString());
            return null;
        }
        HashMap<String, String> updateUserMap = new HashMap<String, String>();
        Iterator iterator = quresult.getList().iterator();
        if (iterator.hasNext()) {
            UmUserinfoDomainBean umUserDomainBean = (UmUserinfoDomainBean)iterator.next();
            umUserDomainBean.setProvinceName(umUserinfoDomainBean.getProvinceName());
            if (String.valueOf(umUserinfoDomainBean.getCompanyCode()) != null) {
                umUserDomainBean.setCompanyCode(umUserinfoDomainBean.getCompanyCode());
            }
            umUserDomainBean.setDepartCode(umUserinfoDomainBean.getDepartCode());
            umUserDomainBean.setDepartName(umUserinfoDomainBean.getDepartName());
            umUserDomainBean.setCompanyType(umUserinfoDomainBean.getCompanyType());
            umUserDomainBean.setQualityQtypeName(umUserinfoDomainBean.getQualityQtypeName());
            umUserDomainBean.setMemo(umUserinfoDomainBean.getMemo());
            updateUserMap.put("umUserinfoDomainBean", JsonUtil.buildNonNullBinder().toJson((Object)umUserDomainBean));
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateUserinfo.updateUserMap", (Object)((Object)updateUserMap).toString());
            this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), updateUserMap);
            return umUserDomainBean.getUserinfoParentCode();
        }
        return null;
    }

    public List<OrgDepart> getDepart(String tenantCode, String appmanageIcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("appmanageIcode", appmanageIcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepart.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synStoreToDepart.getDepart", (Object)((Object)map).toString());
            return null;
        }
        return queryResutl.getList();
    }

    @Override
    public String synStoreToDepart(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public void doCtEmpInfo(List<CtCustrelEmpDomain> ctCustrelEmpDomainList, String tenantCode, CtCustrelDomain ctCustrelDomain, OrgDepartDomain orgDepartDomain) {
        if (ListUtil.isEmpty(ctCustrelEmpDomainList)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCtEmpInfo.ctCustrelEmpDomainList.null");
            return;
        }
        HashMap<String, String> saveMap = new HashMap<String, String>();
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            ctCustrelEmpDomain.setTenantCode(tenantCode);
            ctCustrelEmpDomain.setCustrelCode(ctCustrelDomain.getCustrelCode());
            ctCustrelEmpDomain.setUserinfoCode(ctCustrelDomain.getUserinfoCode());
            ctCustrelEmpDomain.setUserinfoCompname(ctCustrelDomain.getUserinfoCompname());
            ctCustrelEmpDomain.setCompanyCode(ctCustrelDomain.getCompanyCode());
            ctCustrelEmpDomain.setCompanyShortname(ctCustrelDomain.getCompanyShortname());
            ctCustrelEmpDomain.setDepartCode(orgDepartDomain.getDepartCode());
            ctCustrelEmpDomain.setDepartName(orgDepartDomain.getDepartName());
            ctCustrelEmpDomain.setCompanyCode(orgDepartDomain.getCompanyCode());
            ctCustrelEmpDomain.setCompanyShortname(ctCustrelEmpDomain.getCustrelShortname());
            boolean flag = this.checkCtEmp(ctCustrelEmpDomain);
            if (flag) continue;
            saveMap.put("ctCustrelEmpDomain", JsonUtil.buildNonNullBinder().toJson((Object)ctCustrelEmpDomain));
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCtEmpInfo.saveMap", (Object)JsonUtil.buildNonNullBinder().toJson(saveMap));
            this.internalInvoke(ApiCodeEnums.saveCustrelEmp.getApiCode(), saveMap);
        }
    }

    public boolean checkCtEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        if (null == ctCustrelEmpDomain) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkCtEmp.ctCustrelEmpDomain.null");
            return false;
        }
        HashMap<String, String> querymap = new HashMap<String, String>();
        querymap.put("tenantCode", ctCustrelEmpDomain.getTenantCode());
        querymap.put("employeeCode", ctCustrelEmpDomain.getEmployeeCode());
        querymap.put("departCode", ctCustrelEmpDomain.getDepartCode());
        querymap.put("custrelUicode", ctCustrelEmpDomain.getCustrelUicode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(querymap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCustrelEmpPage.getApiCode(), invokeMap, CtCustrelEmpDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkCtEmp.queryResutl", (Object)((Object)querymap).toString());
            return false;
        }
        return true;
    }

    public List<CtCustrelEmpDomain> doCtForStop(CtCustrelDomain ctCustrelDomain, String tenantCode, OrgDepartDomain orgDepartDomain) {
        if (null == ctCustrelDomain || StringUtils.isEmpty((String)tenantCode) || null == orgDepartDomain) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCtForStop.null");
            return null;
        }
        List<CtCustrelEmpDomain> ctCustrelEmpDomainList = ctCustrelDomain.getCtCustrelEmpDomainList();
        ArrayList<CtCustrelEmpDomain> empList = new ArrayList<CtCustrelEmpDomain>();
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            OrgEmployeeDomain orgEmployeeByOcode = this.getOrgEmployeeByOcode(tenantCode, ctCustrelEmpDomain.getEmployeeCode());
            this.logger.error("service.adapter.dms.UserinfoServiceImplorgEmployee1", (Object)(tenantCode + "==" + ctCustrelEmpDomain.getEmployeeCode()));
            if (null == orgEmployeeByOcode) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCtForStop.null", (Object)(tenantCode + "===:==" + ctCustrelEmpDomain.getEmployeeCode()));
                continue;
            }
            if (ctCustrelEmpDomain.getCustrelUicode().equals("T")) {
                HashMap<String, String> querymap = new HashMap<String, String>();
                querymap.put("tenantCode", tenantCode);
                querymap.put("employeeCode", orgEmployeeByOcode.getEmployeeCode());
                querymap.put("departCode", orgDepartDomain.getDepartCode());
                querymap.put("custrelUicode", ctCustrelDomain.getCustrelUicode());
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(querymap));
                QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCustrelEmpPage.getApiCode(), invokeMap, CtCustrelEmpDomain.class);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    this.logger.error("service.adapter.dms.UserinfoServiceImpl.doCtForStop.queryResutl", (Object)((Object)invokeMap).toString());
                    continue;
                }
                for (CtCustrelEmpDomain oldCtCustrelEmpDomain : queryResutl.getList()) {
                    HashMap<String, Integer> delMap = new HashMap<String, Integer>();
                    delMap.put("custrelEmpId", oldCtCustrelEmpDomain.getCustrelEmpId());
                    this.internalInvoke(ApiCodeEnums.deleteCustrelEmp.getApiCode(), delMap);
                }
                continue;
            }
            ctCustrelEmpDomain.setCustrelUicode(ctCustrelDomain.getCustrelUicode());
            ctCustrelEmpDomain.setEmployeeCode(orgEmployeeByOcode.getEmployeeCode());
            ctCustrelEmpDomain.setDepartCode(orgDepartDomain.getDepartCode());
            empList.add(ctCustrelEmpDomain);
        }
        return empList;
    }

    public UmQualityQtypeDomain getUmQualityQtypeDomain(String tenantCode, String qtypeQtypeRemark) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("qtypeQtypeRemark", qtypeQtypeRemark);
        map.put("qualityCode", "dealer");
        HashMap<String, String> invokeMAp = new HashMap<String, String>();
        invokeMAp.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeMAp, UmQualityQtypeDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImplgetUmQualityQtypeDomain.map", (Object)((Object)map).toString());
            return null;
        }
        return (UmQualityQtypeDomain)queryResutl.getList().get(0);
    }

    public void updateChannalByStore(String tenantCode, String userinfoCodeByDep, String userinfoCodeByStore) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCodeByDep) || StringUtils.isBlank((String)userinfoCodeByStore)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateChannalByStore.null", (Object)("tenantCode:" + tenantCode + "userinfoCodeByDep:" + userinfoCodeByDep + "userinfoCodeByStore:" + userinfoCodeByStore));
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("memberCcode", userinfoCodeByStore);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateChannalByStore.queryResutl", (Object)((Object)paramMap).toString());
            return;
        }
        DisChannel disChannel = (DisChannel)queryResutl.getList().get(0);
        HashMap<String, String> paramDepMap = new HashMap<String, String>();
        paramDepMap.put("tenantCode", tenantCode);
        paramDepMap.put("memberCode", userinfoCodeByDep);
        HashMap<String, String> invokeDepMap = new HashMap<String, String>();
        invokeDepMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramDepMap));
        QueryResult queryDepResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeDepMap, DisChannel.class);
        if (queryDepResutl == null || ListUtil.isEmpty((Collection)queryDepResutl.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateChannalByStore.queryDepResutl", (Object)((Object)invokeDepMap).toString());
            return;
        }
        DisChannel disChannelByDep = (DisChannel)queryDepResutl.getList().get(0);
        String channelCodeByDep = disChannelByDep.getChannelCode();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("channelCode", disChannel.getChannelCode());
        updateMap.put("tenantCode", tenantCode);
        updateMap.put("channelPcode", channelCodeByDep);
        updateMap.put("memberCode", userinfoCodeByDep);
        HashMap<String, String> invokeUpdateMap = new HashMap<String, String>();
        invokeUpdateMap.put("map", JsonUtil.buildNonNullBinder().toJson(updateMap));
        this.logger.error("service.adapter.dms.UserinfoServiceImpl.updateChannalByStore.updateMap", (Object)((Object)updateMap).toString());
        this.internalInvoke(ApiCodeEnums.updateChannelByCode.getApiCode(), invokeUpdateMap);
    }

    public void saveUserinfoSort(CtCustrelDomain ctCustrelDomain, UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) {
        if (ctCustrelDomain == null || null == umUserinfoDomainBean) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.saveUserinfoSort.null");
            return;
        }
        HashMap<String, String> storeMap = new HashMap<String, String>();
        String userinfoGroup = umUserinfoDomainBean.getUserinfoGroup();
        if (StringUtils.isNotBlank((String)userinfoGroup)) {
            int length = userinfoGroup.split(",").length;
            if (length <= 5 && StringUtils.isNotBlank((String)ctCustrelDomain.getUserinfoGroup())) {
                userinfoGroup = userinfoGroup + "," + ctCustrelDomain.getUserinfoGroup();
            }
        } else if (StringUtils.isNotBlank((String)ctCustrelDomain.getUserinfoGroup())) {
            userinfoGroup = ctCustrelDomain.getUserinfoGroup();
        }
        umUserinfoDomainBean.setUserinfoGroup(userinfoGroup);
        umUserinfoDomainBean.setDepartCode(ctCustrelDomain.getDepartCode());
        umUserinfoDomainBean.setDepartName(ctCustrelDomain.getDepartName());
        umUserinfoDomainBean.setCompanyCode(ctCustrelDomain.getCompanyCode());
        umUserinfoDomainBean.setQualityQtypeName(ctCustrelDomain.getQualityQtypeName());
        umUserinfoDomainBean.setQualityQtypeCode(ctCustrelDomain.getQualityQtypeCode());
        storeMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), storeMap);
    }

    private String getCacheValue(String tenantCode, String memberMcode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)memberMcode)) {
            flagSettingType = flagSettingType + "-" + memberMcode;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error("service.adapter.dms.UserinfoServiceImpl.getUrl", (Object)(tenantCode + "=" + flagSettingType + "=" + flagSettingCode + "=" + value));
        return value;
    }

    public List<Map<String, String>> getOrgNum(String tenantCode, String memberMcode) {
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        String cacheValue = this.getCacheValue(tenantCode, memberMcode, "orgNum", "getOrgNum");
        if (StringUtils.isBlank((String)cacheValue)) {
            return null;
        }
        if (!cacheValue.contains(",")) {
            paramList.add((Map<String, String>)((Object)cacheValue));
            return paramList;
        }
        String[] split = cacheValue.split(",");
        HashMap<String, String> orgMap = null;
        for (int i = 0; i <= split.length - 1; ++i) {
            orgMap = new HashMap<String, String>();
            orgMap.put("org_num", split[i]);
            paramList.add(orgMap);
        }
        return paramList;
    }

    public List<CtCustrelDomain> checkCt(CtCustrelDomain ctCustrelDomain, String tenantCode) throws ApiException {
        if (ctCustrelDomain == null) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.checkCt.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("custrelUicode", ctCustrelDomain.getCustrelUicode());
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", ctCustrelDomain.getDepartCode());
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult ctQueryResult = this.getQueryResutl(ApiCodeEnums.queryCustrelPage.getApiCode(), invokeQueryMap, CtCustrelDomain.class);
        if (ctQueryResult == null || ListUtil.isEmpty((Collection)ctQueryResult.getList())) {
            return null;
        }
        return ctQueryResult.getList();
    }

    public void updateCt(CtCustrelDomain ctCustrelDomain, List<CtCustrelDomain> relList, String tenantCode) throws ApiException {
        if (ctCustrelDomain == null || ListUtil.isEmpty(relList)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.ctCustrelDomain.null");
            return;
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (CtCustrelDomain ctCustrelDomain1 : relList) {
            ctCustrelDomain1.setEmployeeCode(ctCustrelDomain.getEmployeeCode());
            ctCustrelDomain1.setEmployeeName(ctCustrelDomain.getEmployeeName());
            ctCustrelDomain1.setCustrelRemark(ctCustrelDomain.getCustrelRemark());
            ctCustrelDomain1.setCustrelPhone(ctCustrelDomain.getCustrelPhone());
            ctCustrelDomain1.setUserinfoSort(ctCustrelDomain.getUserinfoSort());
            ctCustrelDomain1.setUserinfoGroup(ctCustrelDomain.getUserinfoGroup());
            ctCustrelDomain1.setUserinfoDischannelcode(ctCustrelDomain.getUserinfoDischannelcode());
            ctCustrelDomain1.setUserinfoDischannelname(ctCustrelDomain.getUserinfoDischannelname());
            updateMap.put("ctCustrelDomain", JsonUtil.buildNonNullBinder().toJson((Object)ctCustrelDomain1));
            this.internalInvoke(ApiCodeEnums.updateCustrel.getApiCode(), updateMap);
        }
    }

    public UmUserinfoDomainBean getStoreName(String customerNum, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)customerNum)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getStoreName.null", (Object)(customerNum + "==:==" + tenantCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoOcode", customerNum);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult qUserinfoBean = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == qUserinfoBean || ListUtil.isEmpty((Collection)qUserinfoBean.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getStoreName.qUserinfoBean", (Object)((Object)map).toString());
            return null;
        }
        return (UmUserinfoDomainBean)qUserinfoBean.getList().get(0);
    }

    public List<DisChannel> getChannelCode(String priceNum) {
        if (StringUtils.isBlank((String)priceNum)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getChannelCode.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoSort", priceNum);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            return null;
        }
        List disChannelList = null;
        HashMap<String, String> disChannelMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : quresult.getList()) {
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            disChannelMap.put("memberCode", userinfoCode);
            disChannelMap.put("tenantCode", umUserinfoDomainBean.getTenantCode());
            QueryResult disChannelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), disChannelMap, DisChannel.class);
            if (null == disChannelQueryResult || ListUtil.isEmpty((Collection)disChannelQueryResult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.getChannelCode.disChannelQueryResult", (Object)((Object)disChannelMap).toString());
                return null;
            }
            disChannelList = disChannelQueryResult.getList();
        }
        return disChannelList;
    }

    public Map<String, Object> getResourcesByCode(List<Map<String, Object>> list, String goodsNo) {
        Iterator<Map<String, Object>> iterator = list.iterator();
        if (iterator.hasNext()) {
            Map<String, Object> resourceGoodsDomainMap = iterator.next();
            if (resourceGoodsDomainMap.get("goodsNo").equals(goodsNo)) {
                return resourceGoodsDomainMap;
            }
            return null;
        }
        return null;
    }

    public void synUserSupAndSub(String tenantCode) {
        HashMap<String, String> sendUserMap = new HashMap<String, String>();
        sendUserMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNormalBinder().toJson(sendUserMap));
        QueryResult quinforesult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeQueryMap, UmUserinfoDomainBean.class);
        if (null == quinforesult || ListUtil.isEmpty((Collection)quinforesult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synUserSupAndSub.disChannelQueryResult", (Object)((Object)sendUserMap).toString());
            return;
        }
        HashMap<String, String> singleQueryMap = new HashMap<String, String>();
        HashMap<String, String> invokeSingleMap = new HashMap<String, String>();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : quinforesult.getList()) {
            if (umUserinfoDomainBean.getUserinfoQuality().equals("dealer")) continue;
            String companyCode = umUserinfoDomainBean.getCompanyCode();
            singleQueryMap.put("tenantCode", tenantCode);
            singleQueryMap.put("departCode", companyCode);
            invokeSingleMap.put("map", JsonUtil.buildNormalBinder().toJson(singleQueryMap));
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeSingleMap, UmUserinfoDomainBean.class);
            if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synUserSupAndSub.quresult", (Object)((Object)singleQueryMap).toString());
                continue;
            }
            for (UmUserinfoDomainBean umUserinfoDomainBeanSingle : quresult.getList()) {
                String userinfoCode = umUserinfoDomainBeanSingle.getUserinfoCode();
                umUserinfoDomainBean.setUserinfoParentCode(userinfoCode);
                this.logger.error("service.adapter.dms.UserinfoServiceImpl.synUserSupAndSub.umId", (Object)(umUserinfoDomainBean.getUserinfoId() + "====>" + umUserinfoDomainBean.getUserinfoParentCode()));
                updateMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
                this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), updateMap);
            }
        }
    }

    public UmUserinfoDomainBean getUserinfoCodeByOcode(String userinfoOcode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getUserinfoCodeByDCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getUserinfoCodeByDCode(String departCode, String tenantCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getUserinfoCodeByDCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String getDgoodsCode(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> queryDgoodsMap = new HashMap<String, String>();
        queryDgoodsMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult dgoodsQuery = this.getQueryResutl(ApiCodeEnums.queryDgoodsPage.getApiCode(), queryDgoodsMap, DisDgoodsDomain.class);
        return ((DisDgoodsDomain)dgoodsQuery.getList().get(0)).getDgoodsCode();
    }

    public String getUserinfoCode(String departCode, String tenantCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("departCode", departCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.getUserinfoCodeByDCode.jsonToObject", (Object)((Object)map).toString());
            return null;
        }
        return ((UmUserinfoDomainBean)jsonToObject.getList().get(0)).getUserinfoCode();
    }

    public static void main(String[] args) {
    }

    @Override
    public String queryStoreInfoDirect(String tenantCode, String userinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.synStoreInfo.null");
            return ResultEnums.error.getCode();
        }
        Integer page = 1;
        Integer size = 1;
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = "AddFlag";
        this.logger.error("service.adapter.dms.UserinfoServiceImpl====url=====aydSynFlag===", (Object)("====" + url + "=====" + aydSynFlag + "==="));
        HashMap<String, String> qualityMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        qualityMap.put("tenantCode", tenantCode);
        qualityMap.put("qualityCode", "zhiying");
        invokeSendmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(qualityMap));
        QueryResult umQualityQtype = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeSendmap, UmQualityQtype.class);
        this.logger.error("=========UserinfoService.umQualityQtype=========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umQualityQtype));
        UmQualityQtype umQualityQtype1 = (UmQualityQtype)umQualityQtype.getList().get(0);
        String qualityQtypeCode = umQualityQtype1.getQualityQtypeCode();
        String qtypeQtypeName = umQualityQtype1.getQtypeQtypeName();
        Httpfacade httpfacade = new Httpfacade(url);
        AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoDirect.getUrlMethed());
        boolean flag = true;
        while (flag) {
            storeRequest.setPage(String.valueOf(page));
            storeRequest.setSize(String.valueOf(size));
            AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
            List<UmUserinfoDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.queryStoreInfo.umUserinfoDomainBeanList======" + page + "===========", (Object)JsonUtil.buildNonDefaultBinder().toJson(umUserinfoDomainBeanList));
            if (ListUtil.isEmpty(umUserinfoDomainBeanList) || umUserinfoDomainBeanList.size() == 0) {
                flag = false;
                return ResultEnums.success.getCode();
            }
            for (UmUserinfoDomainBean umUserinfo : umUserinfoDomainBeanList) {
                umUserinfo.setTenantCode(tenantCode);
                umUserinfo.setQualityQtypeCode(qualityQtypeCode);
                umUserinfo.setQualityQtypeName(qtypeQtypeName);
                this.getUserinfoCheck(umUserinfo, tenantCode, aydSynFlag);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (!page.equals(2)) continue;
            flag = false;
        }
        return ResultEnums.success.getCode();
    }

    @Override
    public String querySytoreInfoCustomer(String tenantCode, String userinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return ResultEnums.error.getCode();
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = "AddFlag";
        this.logger.error("service.adapter.dms.UserinfoServiceImpl====url=====aydSynFlag===", (Object)("====" + url + "=====" + aydSynFlag + "==="));
        HashMap<String, String> qualityMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        qualityMap.put("tenantCode", tenantCode);
        qualityMap.put("qualityCode", "jiameng");
        invokeSendmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(qualityMap));
        QueryResult umQualityQtype = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeSendmap, UmQualityQtype.class);
        this.logger.error("=========UserinfoService.umQualityQtype=========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umQualityQtype));
        UmQualityQtype umQualityQtype1 = (UmQualityQtype)umQualityQtype.getList().get(0);
        String qualityQtypeCode = umQualityQtype1.getQualityQtypeCode();
        String qtypeQtypeName = umQualityQtype1.getQtypeQtypeName();
        Httpfacade httpfacade = new Httpfacade(url);
        AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoCustomer.getUrlMethed());
        Integer page = 1;
        Integer size = 1;
        boolean flag = true;
        while (flag) {
            storeRequest.setPage(String.valueOf(page));
            storeRequest.setSize(String.valueOf(size));
            AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
            List<UmUserinfoDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
            this.logger.error("service.adapter.dms.UserinfoServiceImpl.queryStoreInfo.umUserinfoDomainBeanList======" + page + "===========", (Object)JsonUtil.buildNonDefaultBinder().toJson(umUserinfoDomainBeanList));
            if (ListUtil.isEmpty(umUserinfoDomainBeanList) || umUserinfoDomainBeanList.size() == 0) {
                flag = false;
                return ResultEnums.success.getCode();
            }
            for (UmUserinfoDomainBean umUserinfo : umUserinfoDomainBeanList) {
                umUserinfo.setQualityQtypeCode(qualityQtypeCode);
                umUserinfo.setQualityQtypeName(qtypeQtypeName);
                umUserinfo.setTenantCode(tenantCode);
                this.getUserinfoCheck(umUserinfo, tenantCode, aydSynFlag);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (!page.equals(2)) continue;
            flag = false;
        }
        return ResultEnums.success.getCode();
    }

    private void getUserinfoCheck(UmUserinfoDomainBean umUserinfo, String tenantCode, String addFlag) {
        if (StringUtils.isBlank((String)addFlag)) {
            HashMap<String, String> userinfoMap = new HashMap<String, String>();
            userinfoMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
            this.internalInvoke(ApiCodeEnums.saveUserinfo.getApiCode(), userinfoMap);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> invokeSendmap = new HashMap<String, String>();
            map.put("userinfoOcode", umUserinfo.getUserinfoOcode());
            map.put("tenantCode", tenantCode);
            invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult umUserinfoList = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeSendmap, UmUserinfoDomainBean.class);
            this.logger.error("service.adapter.dms.UserinfoServiceImpl===umUserinfoList=========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfoList));
            if (ListUtil.isEmpty((Collection)umUserinfoList.getList())) {
                HashMap<String, String> userinfoMap = new HashMap<String, String>();
                userinfoMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
                this.internalInvoke(ApiCodeEnums.saveUserinfo.getApiCode(), userinfoMap);
            } else {
                UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)umUserinfoList.getList().get(0);
                umUserinfo.setUserinfoId(umUserinfoDomainBean.getUserinfoId());
                umUserinfo.setUserinfoCode(umUserinfoDomainBean.getUserinfoCode());
                HashMap<String, String> userinfoMap = new HashMap<String, String>();
                userinfoMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
                this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), userinfoMap);
            }
        }
    }
}

