/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.AydStoreInfoRequest;
import com.yqbsoft.laser.service.exdate.facade.request.RsClassTreeRequest;
import com.yqbsoft.laser.service.exdate.facade.response.RsClassTreeResponse;
import com.yqbsoft.laser.service.exdate.service.RsClassTreeService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="aydRsClassTreeService")
public class RsClassTreeServiceImpl
extends BaseServiceImpl
implements RsClassTreeService {
    private static final String SYS_CODE = "ayd.RsClassTreeServiceImpl";

    @Override
    public String queryclassTree(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("ayd.RsClassTreeServiceImpl.queryclassTree.null");
            return ResultEnums.error.getCode();
        }
        RsClassTreeRequest classTreeRequest = new RsClassTreeRequest();
        String url = RsClassTreeRequest.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = AydStoreInfoRequest.getUrl(tenantCode, "aydSynFlag", "url");
        this.logger.error("ayd.RsClassTreeServiceImpl====url=====aydSynFlag===", (Object)("====" + url + "=====" + aydSynFlag + "==="));
        Httpfacade httpfacade = new Httpfacade(url);
        classTreeRequest.setTopHttpMethod(UrlEnums.classTreeAll.getUrlMethed());
        RsClassTreeResponse execute = httpfacade.execute(classTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        if (ListUtil.isEmpty(rsClasstreeList)) {
            this.logger.error("ayd.RsClassTreeServiceImpl.queryStoreInfo.umUserinfoDomainBeanList");
            return ResultEnums.error.getCode();
        }
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeList) {
            if ("0".equals(rsClasstreeDomain.getPntreeCode())) {
                rsClasstreeDomain.setClasstreeParentcode("-1");
            }
            rsClasstreeDomain.setTenantCode(tenantCode);
            String classtreeCode = this.checkClasstree(rsClasstreeDomain, tenantCode);
            if (!StringUtils.isNotBlank((String)classtreeCode)) continue;
            this.saveClasstree(rsClasstreeDomain, classtreeCode, httpfacade);
        }
        return ResultEnums.success.getCode();
    }

    private void saveClasstree(RsClasstreeDomain rsClasstreeDomain, String classtreeParentcode, Httpfacade httpfacade) {
        String tenantCode = rsClasstreeDomain.getTenantCode();
        RsClassTreeRequest classTreeRequest = new RsClassTreeRequest();
        classTreeRequest.setTopHttpMethod(UrlEnums.classTree.getUrlMethed());
        classTreeRequest.setParentCode(rsClasstreeDomain.getClasstreeEocode());
        RsClassTreeResponse execute = httpfacade.execute(classTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        if (rsClasstreeList.size() == 0 || ListUtil.isEmpty(rsClasstreeList)) {
            return;
        }
        for (RsClasstreeDomain rsClasstree : rsClasstreeList) {
            rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
            rsClasstreeDomain.setTenantCode(tenantCode);
            String classtreeCode = this.checkClasstree(rsClasstreeDomain, tenantCode);
            if (!StringUtils.isNotBlank((String)classtreeCode)) continue;
            this.saveClasstree(rsClasstree, classtreeCode, httpfacade);
        }
    }

    public String checkClasstree(RsClasstreeDomain rsClasstreeDomain, String tenantCode) throws ApiException {
        if (rsClasstreeDomain == null) {
            this.logger.error("ayd.RsClassTreeServiceImpl.checkClassInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("classtreeEocode", rsClasstreeDomain.getClasstreeEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryClasstreePage.getApiCode(), invokeSendmap, RsClasstreeDomain.class);
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            RsClasstreeDomain rsClasstreeDomain1 = (RsClasstreeDomain)jsonToObject.getList().get(0);
            rsClasstreeDomain1.setClasstreeName(rsClasstreeDomain.getClasstreeName());
            HashMap<String, String> classTreeMap = new HashMap<String, String>();
            classTreeMap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain1));
            this.internalInvoke(ApiCodeEnums.updateClasstree.getApiCode(), classTreeMap);
            return null;
        }
        HashMap<String, String> classTreeMap = new HashMap<String, String>();
        classTreeMap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        String code = this.internalInvoke(ApiCodeEnums.saveClasstree.getApiCode(), classTreeMap);
        return code;
    }

    public static void main(String[] args) {
        Httpfacade httpfacade = new Httpfacade("http://md.aiyingtong.com.cn");
        RsClassTreeRequest rsClassTreeRequest = new RsClassTreeRequest();
        rsClassTreeRequest.setTopHttpMethod(UrlEnums.classTreeAll.getUrlMethed());
        RsClassTreeResponse execute = httpfacade.execute(rsClassTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        System.out.println("1\u7ea7execute==" + rsClasstreeList.size() + "===" + JsonUtil.buildNonDefaultBinder().toJson(rsClasstreeList));
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeList) {
        }
        System.out.println("\u5b8c\u6210\u4e86");
    }
}

