/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.ItembrandRequest;
import com.yqbsoft.laser.service.exdate.facade.response.ItembrandResponse;
import com.yqbsoft.laser.service.exdate.model.RsBrandDomain;
import com.yqbsoft.laser.service.exdate.service.BrandService;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="brandService")
public class BrandServiceImpl
extends BaseServiceImpl
implements BrandService {
    private static final String SYS_CODE = "service.adapter.dms.BrandServiceImpl";

    @Override
    public String queryGoodsBrandInfo(String tenantCode, String brandName) throws ApiException {
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.null");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        Httpfacade httpfacade = new Httpfacade(url);
        ItembrandRequest itembrandRequest = new ItembrandRequest();
        itembrandRequest.setTopHttpMethod(UrlEnums.brand.getUrlMethed());
        Integer page = 1;
        boolean flag = true;
        while (flag) {
            itembrandRequest.setPage(String.valueOf(page));
            ItembrandResponse execute = httpfacade.execute(itembrandRequest);
            if (execute == null) {
                this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.execute");
                return ResultEnums.error.getCode();
            }
            List<RsBrandDomain> rsBrandDomainList = execute.getRsBrandDomainList();
            if (ListUtil.isEmpty(rsBrandDomainList)) {
                this.logger.error("service.adapter.dms.BrandServiceImpl.queryGoodsBrandInfo.rsBrandDomainList");
                return ResultEnums.error.getCode();
            }
            for (RsBrandDomain rsBrandDomain : rsBrandDomainList) {
                rsBrandDomain.setTenantCode(tenantCode);
                rsBrandDomain.setMemberCode(umUserinfoDomainBean.getUserinfoCode());
                rsBrandDomain.setMemberName(umUserinfoDomainBean.getUserinfoCompname());
                this.getBrand(rsBrandDomain, tenantCode);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
        }
        return ResultEnums.success.getCode();
    }

    public void getBrand(RsBrandDomain rsBrandDomain, String tenantCode) throws ApiException {
        if (rsBrandDomain == null) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.checkBrandInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("brandEocode", rsBrandDomain.getBrandEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeSendmap, RsBrandDomain.class);
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            RsBrandDomain rsBrandDomain1 = (RsBrandDomain)jsonToObject.getList().get(0);
            rsBrandDomain.setBrandId(rsBrandDomain1.getBrandId());
            HashMap<String, String> brandMap = new HashMap<String, String>();
            brandMap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
            this.internalInvoke(ApiCodeEnums.updateBrand.getApiCode(), brandMap);
        } else {
            HashMap<String, String> brandMap = new HashMap<String, String>();
            brandMap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
            this.internalInvoke(ApiCodeEnums.saveBrand.getApiCode(), brandMap);
        }
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public static void main(String[] args) {
        Httpfacade httpfacade = new Httpfacade("http://md.aiyingtong.com.cn/data/brand");
        ItembrandRequest itembrandRequest = new ItembrandRequest();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("page", 10);
        ItembrandResponse execute = httpfacade.execute(itembrandRequest);
        System.out.println(execute);
        if (execute == null) {
            // empty if block
        }
        List<RsBrandDomain> rsBrandDomainList = execute.getRsBrandDomainList();
        System.out.println("========" + rsBrandDomainList);
    }
}

