/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketParam;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketResult;
import com.yqbsoft.laser.service.exdate.service.YlUnionPayWalletService;
import com.yqbsoft.laser.service.exdate.test.TransferDemoMainTest;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YlUnionPayWalletServiceImpl
extends BaseServiceImpl
implements YlUnionPayWalletService {
    private static final String SYS_CODE = "service.adapter.dms.BrandServiceImpl";

    @Override
    public String saveWalletRegistration(Map<String, Object> map) throws ApiException {
        this.logger.error("service.adapter.dms.BrandServiceImpl.saveWalletRegistration" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setJumpType("1");
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        voucherApplyTicketParam.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.getTicket(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return ResultEnums.error.getCode();
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)ticket);
    }

    public static void main(String[] args) {
        String appId = "5ed70f9c2c07873f0aa9e455560bc553";
        String sign_alg = "SHA1withRSA";
        String mct_private_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\A0010000-0014.p12";
        String mct_private_key_pwd = "123456";
        String fchannelApiUrl = "https://testapi.gnete.com:9083/routejson";
        String gnete_gateway_public_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\2048-cfca.der";
        String issr_id = "A0010000-0014";
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setJumpType("1");
        voucherApplyTicketParam.setExtUserId("233444232222");
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.getTicket(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(ticket);
    }

    @Override
    public List<VdFaccountInfo> queryWalletPay(Map<String, Object> map) throws ApiException {
        ArrayList<VdFaccountInfo> vdFaccountInfosList = new ArrayList<VdFaccountInfo>();
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo();
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("service.adapter.dms.BrandServiceImpl.extUserId is null");
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        String tenantCode = (String)map.get("tenantCode");
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        long queryAcctBal = 0L;
        try {
            queryAcctBal = TransferDemoMainTest.queryAcctBal(ticket.getWalletId(), appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (new BigDecimal(queryAcctBal).compareTo(BigDecimal.ZERO) == 0) {
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        BigDecimal divide = new BigDecimal(queryAcctBal).divide(BigDecimal.valueOf(100L));
        vdFaccountInfo.setFaccountAmount(divide);
        vdFaccountInfosList.add(vdFaccountInfo);
        return vdFaccountInfosList;
    }

    private static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

