/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.SpecEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.CtCustrel;
import com.yqbsoft.laser.service.exdate.domain.DisChannel;
import com.yqbsoft.laser.service.exdate.domain.DisDgoods;
import com.yqbsoft.laser.service.exdate.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.exdate.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.exdate.domain.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.exdate.domain.DisDpriceConf;
import com.yqbsoft.laser.service.exdate.domain.DisDpriceConfDomain;
import com.yqbsoft.laser.service.exdate.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.exdate.domain.EditSkuDomain;
import com.yqbsoft.laser.service.exdate.domain.GoodsBean;
import com.yqbsoft.laser.service.exdate.domain.MpMpriceConfDomain;
import com.yqbsoft.laser.service.exdate.domain.MpMpriceDomain;
import com.yqbsoft.laser.service.exdate.domain.MpMpriceMemDomain;
import com.yqbsoft.laser.service.exdate.domain.MpMpricelistDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgDepart;
import com.yqbsoft.laser.service.exdate.domain.OrgDepartempDomain;
import com.yqbsoft.laser.service.exdate.domain.RsBrand;
import com.yqbsoft.laser.service.exdate.domain.RsBrandDomain;
import com.yqbsoft.laser.service.exdate.domain.RsBrandRelationDomain;
import com.yqbsoft.laser.service.exdate.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.exdate.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.exdate.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.exdate.domain.RsSkuDomain;
import com.yqbsoft.laser.service.exdate.domain.RsSpec;
import com.yqbsoft.laser.service.exdate.domain.RsSpecGroup;
import com.yqbsoft.laser.service.exdate.domain.RsSpecOption;
import com.yqbsoft.laser.service.exdate.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.exdate.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfo;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.exdate.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.exdate.domain.WhStoreSku;
import com.yqbsoft.laser.service.exdate.domain.WhUserwh;
import com.yqbsoft.laser.service.exdate.domain.WhUserwhDomain;
import com.yqbsoft.laser.service.exdate.domain.WhWarehouse;
import com.yqbsoft.laser.service.exdate.domain.WhWarehouseDomain;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.MpMpriceRequest;
import com.yqbsoft.laser.service.exdate.facade.request.RsGoodsRequest;
import com.yqbsoft.laser.service.exdate.facade.response.MpMpriceResponse;
import com.yqbsoft.laser.service.exdate.facade.response.RsGoodsResponse;
import com.yqbsoft.laser.service.exdate.service.GoodsService;
import com.yqbsoft.laser.service.exdate.utils.DmUtil;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoodsServiceImpl
extends BaseServiceImpl
implements GoodsService {
    private String SYS_CODE = "exdata.GoodsServiceImpl";
    private int OneDayMillis = 86400000;

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    @Override
    public String aydsynGoodsinfos(String userinfoCode, String tenantCode, String goodsListStr, String dmsId) throws ApiException {
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        String tenantuserinfoCode = umUserinfoDomainBean.getUserinfoCode();
        String tenantusername = umUserinfoDomainBean.getUserinfoCompname();
        String goodsClass = FlagSettingUtils.getUrl(tenantCode, "aydGoodsClass", "goodsClass");
        String pntreeCode = FlagSettingUtils.getUrl(tenantCode, "pntreeCode", "pntreeCode");
        Httpfacade httpfacade = new Httpfacade(FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url"));
        RsGoodsRequest rsGoodsRequest = new RsGoodsRequest();
        rsGoodsRequest.setTopHttpMethod(UrlEnums.itemGoods.getUrlMethed());
        boolean flag = true;
        Integer page = 1;
        Integer size = 5;
        while (flag) {
            rsGoodsRequest.setPage(String.valueOf(page));
            rsGoodsRequest.setSize(String.valueOf(size));
            RsGoodsResponse execute = httpfacade.execute(rsGoodsRequest);
            if (execute == null) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.execute");
                return ResultEnums.error.getCode();
            }
            List<RsResourceGoodsDomain> rsResourceGoodsDomainList = execute.getRsResourceGoodsDomainList();
            if (rsResourceGoodsDomainList.size() == 0 || ListUtil.isEmpty(rsResourceGoodsDomainList)) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.execute");
                return ResultEnums.success.getCode();
            }
            for (RsResourceGoodsDomain rsResourceGoodsDomain : rsResourceGoodsDomainList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                map.put("goodsNo", rsResourceGoodsDomain.getGoodsNo());
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
                QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryResourceGoodsPage.getApiCode(), sendMap, RsResourceGoodsDomain.class);
                this.logger.error(this.SYS_CODE + "========aydsynGoodsinfos.queryResult==========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult));
                rsResourceGoodsDomain.setTenantCode(umUserinfoDomainBean.getTenantCode());
                rsResourceGoodsDomain.setMemberCode(tenantuserinfoCode);
                rsResourceGoodsDomain.setMemberMcode(tenantuserinfoCode);
                rsResourceGoodsDomain.setMemberName(tenantusername);
                rsResourceGoodsDomain.setMemberCcode(tenantuserinfoCode);
                DisChannel disChannel = this.getChannel(tenantuserinfoCode, "0", umUserinfoDomainBean.getTenantCode());
                if (null != disChannel) {
                    rsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
                    rsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
                }
                rsResourceGoodsDomain.setDataOpbillstate(0);
                rsResourceGoodsDomain.setPntreeCode(pntreeCode);
                rsResourceGoodsDomain.setGoodsClass(goodsClass);
                this.makeGoodsClasstree(rsResourceGoodsDomain);
                this.makeGoodsBrand(rsResourceGoodsDomain);
                this.checkGoodsSpec(rsResourceGoodsDomain);
                if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
                    this.checkRsGoods(rsResourceGoodsDomain);
                    this.logger.error(this.SYS_CODE + "=======rsResourceGoodsDomain.save==========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
                    this.saveGoodsCheck(rsResourceGoodsDomain);
                    continue;
                }
                RsResourceGoodsDomain rsResourceGoods = (RsResourceGoodsDomain)queryResult.getList().get(0);
                HashMap<String, String> goodsMap = new HashMap<String, String>();
                goodsMap.put("goodsCode", rsResourceGoods.getGoodsCode());
                goodsMap.put("tenantCode", rsResourceGoods.getTenantCode());
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(goodsMap));
                String str = this.internalInvoke(ApiCodeEnums.getResourceGoodsByCode.getApiCode(), invokeMap);
                if (StringUtils.isBlank((String)str)) {
                    this.logger.error(this.SYS_CODE + ".updatePrice.getGoodsNo", (Object)((Object)goodsMap).toString());
                    return null;
                }
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(str, RsResourceGoodsReDomain.class);
                this.checkRsGoods(rsResourceGoodsDomain);
                this.logger.error(this.SYS_CODE + "=======rsResourceGoodsDomain.update==========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
                this.updateGoodsCheck(rsResourceGoodsDomain, rsResourceGoodsReDomain);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (page != 2) continue;
            flag = false;
        }
        return null;
    }

    protected DisChannel getChannel(String memberCode, String channelSort, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelSort)) {
            return null;
        }
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-" + channelSort + "-" + tenantCode), DisChannel.class);
        return disChannel;
    }

    private List<RsSpecValueDomain> checkGoodsSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        ArrayList<RsSpecValueDomain> list = new ArrayList<RsSpecValueDomain>();
        String specValue = rsResourceGoodsDomain.getClasstreeName().substring(0, 1);
        String enumType = SpecEnums.getEnumType(specValue);
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> groupMap = new HashMap<String, HashMap<String, String>>();
        map1.put("specGroupName", enumType);
        map1.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        groupMap.put("map", map1);
        List specGroupList = this.getQueryResutl("rs.spec.querySpecGroupPageAll", map1, RsSpecGroup.class).getList();
        if (ListUtil.isNotEmpty((Collection)specGroupList)) {
            specGroupList.stream().forEach(specGroup -> {
                List<RsSpec> specList = specGroup.getSpecList();
                specList.stream().forEach(spec -> {
                    HashMap<String, String> map;
                    RsSpecOptionDomain rsSpecOptionDomain;
                    RsSpecValueDomain rsSpecValue;
                    List specOpList;
                    HashMap<String, String> specOpMap;
                    HashMap<String, String> map2;
                    if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsSpec3())) {
                        map2 = new HashMap<String, String>();
                        specOpMap = new HashMap<String, String>();
                        map2.put("specCode", spec.getSpecCode());
                        map2.put("specOptionName", rsResourceGoodsDomain.getGoodsSpec3());
                        map2.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                        specOpMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specOpMap));
                        specOpList = this.getQueryResutl("rs.spec.querySpecOptionPage", specOpMap, RsSpecOption.class).getList();
                        if (ListUtil.isNotEmpty((Collection)specOpList)) {
                            rsSpecValue = new RsSpecValueDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)rsSpecValue, specOpList.get(0));
                                rsSpecValue.setSpecValueValue(((RsSpecOption)specOpList.get(0)).getSpecOptionName());
                                list.add(rsSpecValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            rsSpecValue = new RsSpecValueDomain();
                            rsSpecOptionDomain = new RsSpecOptionDomain();
                            rsSpecOptionDomain.setSpecGroupCode(spec.getSpecGroupCode());
                            rsSpecOptionDomain.setSpecCode(spec.getSpecCode());
                            rsSpecOptionDomain.setSpecOptionName(rsResourceGoodsDomain.getGoodsSpec3());
                            rsSpecOptionDomain.setTenantCode("2021122100000001");
                            map = new HashMap<String, String>();
                            map.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecOptionDomain));
                            this.internalInvoke("rs.spec.saveSpecOption", map);
                            try {
                                BeanUtils.copyAllPropertys((Object)rsSpecValue, specOpList.get(0));
                                rsSpecValue.setSpecValueValue(((RsSpecOption)specOpList.get(0)).getSpecOptionName());
                                list.add(rsSpecValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsSpec1())) {
                        map2 = new HashMap();
                        specOpMap = new HashMap();
                        map2.put("specCode", spec.getSpecCode());
                        map2.put("specOptionName", rsResourceGoodsDomain.getGoodsSpec1());
                        map2.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                        specOpMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specOpMap));
                        specOpList = this.getQueryResutl("rs.spec.querySpecOptionPage", specOpMap, RsSpecOption.class).getList();
                        if (ListUtil.isNotEmpty((Collection)specOpList)) {
                            rsSpecValue = new RsSpecValueDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)rsSpecValue, specOpList.get(0));
                                rsSpecValue.setSpecValueValue(((RsSpecOption)specOpList.get(0)).getSpecOptionName());
                                list.add(rsSpecValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            rsSpecValue = new RsSpecValueDomain();
                            rsSpecOptionDomain = new RsSpecOptionDomain();
                            rsSpecOptionDomain.setSpecGroupCode(spec.getSpecGroupCode());
                            rsSpecOptionDomain.setSpecCode(spec.getSpecCode());
                            rsSpecOptionDomain.setSpecOptionName(rsResourceGoodsDomain.getGoodsSpec1());
                            rsSpecOptionDomain.setTenantCode("2021122100000001");
                            map = new HashMap();
                            map.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecOptionDomain));
                            this.internalInvoke("rs.spec.saveSpecOption", map);
                            try {
                                BeanUtils.copyAllPropertys((Object)rsSpecValue, specOpList.get(0));
                                rsSpecValue.setSpecValueValue(((RsSpecOption)specOpList.get(0)).getSpecOptionName());
                                list.add(rsSpecValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            });
        }
        this.logger.error("=======\u7ec4\u5408\u89c4\u683c\u6570\u636e========", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
        return list;
    }

    private void saveGoodsCheck(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        String s = this.internalInvoke(ApiCodeEnums.saveResourceGoods.getApiCode(), goodsMap);
    }

    private void updateGoodsCheck(RsResourceGoodsDomain newRsResourceGoodsDomain, RsResourceGoodsDomain oldRsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(oldRsResourceGoodsDomain.getRsSkuDomainList())) {
            boolean falg = true;
            for (RsSkuDomain rsSkuDomain : oldRsResourceGoodsDomain.getRsSkuDomainList()) {
                if (!ListUtil.isNotEmpty(newRsResourceGoodsDomain.getRsSkuDomainList())) continue;
                RsSkuDomain rsSkuDomain1 = newRsResourceGoodsDomain.getRsSkuDomainList().get(0);
                if (!rsSkuDomain.getSkuNo().equals(rsSkuDomain1.getSkuNo())) continue;
                falg = false;
            }
            if (falg) {
                oldRsResourceGoodsDomain.getRsSkuDomainList().addAll(newRsResourceGoodsDomain.getRsSkuDomainList());
            }
        }
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)oldRsResourceGoodsDomain));
        String s = this.internalInvoke(ApiCodeEnums.sendUpdateResourceGoods.getApiCode(), goodsMap);
    }

    private void checkRsGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getGoodsSpec())) {
            rsResourceGoodsDomain.setGoodsSpec("\u9ed8\u8ba4");
        }
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal(0));
        rsResourceGoodsDomain.setGoodsPro("0");
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setSkuNo(rsResourceGoodsDomain.getGoodsEocode());
        rsSkuDomain.setSkuEocode(rsResourceGoodsDomain.getGoodsEocode());
        String goodsSpec3 = rsResourceGoodsDomain.getGoodsSpec3();
        String goodsSpec1 = rsResourceGoodsDomain.getGoodsSpec1();
        String skuName = null;
        if (StringUtils.isNotBlank((String)goodsSpec3) && StringUtils.isNotBlank((String)goodsSpec1)) {
            skuName = goodsSpec3 + "/" + goodsSpec1;
        }
        if (StringUtils.isNotBlank((String)goodsSpec3) || StringUtils.isNotBlank((String)goodsSpec1)) {
            skuName = goodsSpec3 + goodsSpec1;
            skuName = skuName.replace("null", "");
        }
        if (StringUtils.isEmpty(skuName)) {
            skuName = rsResourceGoodsDomain.getGoodsSpec();
        }
        rsSkuDomain.setSkuName(skuName);
        rsSkuDomain.setGoodsWeight(rsResourceGoodsDomain.getGoodsWeight());
        rsSkuDomain.setPartsnameNumunit(rsResourceGoodsDomain.getGoodsProperty4());
        rsSkuDomain.setPricesetNprice(rsResourceGoodsDomain.getPricesetNprice());
        rsSkuDomain.setPricesetMakeprice(rsResourceGoodsDomain.getPricesetNprice());
        rsSkuDomain.setGoodsSupplynum(new BigDecimal(0));
        rsSkuDomain.setGoodsClass(rsResourceGoodsDomain.getGoodsClass());
        rsSkuDomain.setGoodsType(rsResourceGoodsDomain.getGoodsType());
        rsSkuDomain.setPartsnameNumunit(rsResourceGoodsDomain.getPartsnameNumunit());
        rsSkuDomain.setGoodsSupplyweight(rsResourceGoodsDomain.getGoodsOneweight());
        rsSkuDomain.setGoodsOrigin("0");
        rsSkuDomain.setPricesetBaseprice(rsResourceGoodsDomain.getPricesetBaseprice());
        rsSkuDomain.setPartsnameWeightunit(rsResourceGoodsDomain.getPartsnameWeightunit());
        rsSkuDomain.setGoodsOneweight(rsResourceGoodsDomain.getGoodsOneweight());
        rsSkuDomain.setSkuBarcode(rsResourceGoodsDomain.getSkuBarcode());
        rsSkuDomain.setGoodsSp(rsResourceGoodsDomain.getGoodsSp());
        rsSkuDomain.setGoodsType(rsResourceGoodsDomain.getGoodsType());
        rsSkuDomain.setDataOpbillstate(0);
        rsSkuDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
        rsSkuDomainList.add(rsSkuDomain);
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
        rsResourceGoodsDomain.setGoodsEocode(rsResourceGoodsDomain.getGoodsNo());
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        rsSpecValueDomain.setSpecGroupCode("11224bcb47a947fb81965b264442f296");
        rsSpecValueDomain.setSpecCode("7bc948b43540414e92f5149e9e7e3e43");
        rsSpecValueDomain.setSpecName(rsResourceGoodsDomain.getGoodsSpec());
        rsSpecValueDomain.setTenantCode(tenantCode);
        rsSpecValueDomain.setSpecValueValue("\u9ed8\u8ba4");
        rsSpecValueDomain.setSpecValueType("1");
        rsSpecValueDomainList.add(rsSpecValueDomain);
        rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
    }

    private void makeGoodsClasstree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:classtreeCode");
            this.logger.error(this.SYS_CODE + ".makeGoodsClasstree.classtreeCode");
            return;
        }
        String classtreePath = rsResourceGoodsDomain.getClasstreeName();
        String[] paths = classtreePath.split("\\|");
        String classtreeName = "";
        for (String path : paths) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
            map.put("classtreeEocode", path);
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
            QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryClasstreePage.getApiCode(), sendMap, RsClasstreeDomain.class);
            if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
            RsClasstreeDomain rsClasstreeDomain = (RsClasstreeDomain)queryResult.getList().get(0);
            classtreeName = classtreeName + "/" + rsClasstreeDomain.getClasstreeName();
            if (!rsClasstreeDomain.getClasstreeEocode().equals(rsResourceGoodsDomain.getClasstreeCode())) continue;
            rsResourceGoodsDomain.setClasstreeCode(rsClasstreeDomain.getClasstreeCode());
        }
        if (StringUtils.isNotBlank((String)classtreeName)) {
            classtreeName = classtreeName.substring(1, classtreeName.length());
        }
        rsResourceGoodsDomain.setClasstreeName(classtreeName);
    }

    private void makeGoodsBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:brandEocode\u4e0d\u5b58\u5728");
            this.logger.error(this.SYS_CODE + ".makeGoodsBrabd.getBrandCode");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        map.put("brandEocode", rsResourceGoodsDomain.getBrandCode());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), sendMap, RsBrandDomain.class);
        this.logger.error(this.SYS_CODE + "========makeGoodsBrand==========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult));
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            RsBrandDomain rsBrandDomain = (RsBrandDomain)queryResult.getList().get(0);
            rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
            rsResourceGoodsDomain.setBrandName(rsBrandDomain.getBrandName());
        }
    }

    @Override
    public String synWarehouseInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public WhWarehouseDomain getWarehouseId(WhWarehouseDomain whWarehouseDomain, String tenantCode) throws ApiException {
        if (whWarehouseDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkWarehouseInfo.null");
            return null;
        }
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put("tenantCode", tenantCode);
        checkMap.put("warehouseBtype", whWarehouseDomain.getWarehouseBtype());
        checkMap.put("warehouseOcode", whWarehouseDomain.getWarehouseOcode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(checkMap));
        String invokeStr = this.internalInvoke(ApiCodeEnums.getWarehouseByCode.getApiCode(), invokeMap);
        WhWarehouseDomain oldWhWarehouseDomain = (WhWarehouseDomain)JsonUtil.buildNormalBinder().getJsonToObject(invokeStr, WhWarehouseDomain.class);
        return oldWhWarehouseDomain;
    }

    @Override
    public String synIssuingAddress(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public int getIssuingAddressId(WhWarehouseDomain whWarehouseDomain, String userinfoCode, String tenantCode) throws ApiException {
        if (whWarehouseDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkIssuingAddress.null");
            return 0;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("warehouseCode", String.valueOf(whWarehouseDomain.getWarehouseCode()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryWarehousePage.getApiCode(), map, WhWarehouseDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            return 0;
        }
        return ((WhWarehouseDomain)jsonToObject.getList().get(0)).getWarehouseId();
    }

    public DisChannel getChannelDomain(String memberCode, String goodsClass, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        map.put("goodsClass", goodsClass);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getChannelDomain.null", (Object)((Object)map).toString());
            return null;
        }
        return (DisChannel)queryResutl.getList().get(0);
    }

    public DisChannel getChannelDomainByDea(String memberCode, String goodsClass, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCcode", memberCode);
        map.put("goodsClass", goodsClass);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getChannelDomain.null", (Object)((Object)map).toString());
            return null;
        }
        return (DisChannel)queryResutl.getList().get(0);
    }

    public List<RsBrand> getRsBrandList(String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("memberCode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeMap, RsBrand.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return queryResutl.getList();
    }

    @Override
    public String synGoodsInfo(String userinfoCode, String tenantCode, String goodsListStr, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.null", (Object)(userinfoCode + "====:==" + tenantCode + "goodsListStr" + dmsId + "====" + goodsListStr.length()));
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        if (null == umUserinfoDomainBean) {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.umUserinfoDomainBean", (Object)(userinfoCode + "====:==" + tenantCode + "goodsListStr" + dmsId + "====" + goodsListStr.length()));
            return ResultEnums.error.getCode();
        }
        List<String> itemNumList = null;
        if (null != goodsListStr && goodsListStr.length() > 1) {
            String[] goods = goodsListStr.split(",");
            itemNumList = Arrays.asList(goods);
        }
        List<RsBrand> rsBrandList = null;
        if (StringUtils.isEmpty((String)goodsListStr) && ListUtil.isEmpty(rsBrandList = this.getRsBrandList(tenantCode, umUserinfoDomainBean.getUserinfoCode()))) {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.rsBrandList.null");
            return ResultEnums.error.getCode();
        }
        DisChannel disChannel = this.getDisChannelByMem(userinfoCode, umUserinfoDomainBean.getUserinfoCode(), tenantCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.disChannel", (Object)userinfoCode);
            return ResultEnums.error.getCode();
        }
        if (ListUtil.isEmpty(itemNumList)) {
            for (RsBrand rsBrand : rsBrandList) {
                if (this.saveGoods(userinfoCode, dmsId, null, umUserinfoDomainBean, disChannel, rsBrand.getBrandEocode())) continue;
                return ResultEnums.error.getCode();
            }
        } else {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.itemNumList", (Object)itemNumList.size());
            for (String itemNum : itemNumList) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.itemNum.start", (Object)itemNum);
                if (!this.saveGoods(userinfoCode, dmsId, itemNum, umUserinfoDomainBean, disChannel, null)) {
                    return ResultEnums.error.getCode();
                }
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.itemNum.end", (Object)itemNum);
            }
        }
        return ResultEnums.success.getCode();
    }

    private boolean saveGoods(String userinfoCode, String dmsId, String itemNum, UmUserinfoDomainBean umUserinfoDomainBean, DisChannel disChannel, String brandNum) {
        List rsResourceGoodsDomainList = null;
        this.logger.error(this.SYS_CODE + ".synGoodsInfo.execute", (Object)("rsResourceGoodsDomainList is" + JsonUtil.buildNonNullBinder().toJson((Object)rsResourceGoodsDomainList.size())));
        if (ListUtil.isEmpty((Collection)rsResourceGoodsDomainList)) {
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.rsResourceGoodsDomainList", (Object)"excute is null");
            return true;
        }
        HashMap<String, String> commodityMap = new HashMap<String, String>();
        HashMap<String, String> saveDscMap = new HashMap<String, String>();
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        ArrayList<DisDgoodsScopelistDomain> dgoodsScList = new ArrayList<DisDgoodsScopelistDomain>();
        ArrayList retailGoodsList = new ArrayList();
        String tenantuserinfoCode = umUserinfoDomainBean.getUserinfoCode();
        String tenantusername = umUserinfoDomainBean.getUserinfoCompname();
        HashMap<String, String> skuNoMap = new HashMap<String, String>();
        HashMap<String, UmUserinfoDomainBean> infoMap = new HashMap<String, UmUserinfoDomainBean>();
        HashMap<String, String> classtreeMap1 = new HashMap<String, String>();
        HashMap<String, RsBrand> rsBrandMap = new HashMap<String, RsBrand>();
        HashMap<String, Integer> supplierTypeMap = new HashMap<String, Integer>();
        for (RsResourceGoodsDomain rsResourceGoodsDomain : rsResourceGoodsDomainList) {
            UmUserinfoDomainBean userinfoBySup = (UmUserinfoDomainBean)infoMap.get(rsResourceGoodsDomain.getMemberCcode());
            if (null == infoMap.get(rsResourceGoodsDomain.getMemberCcode()) && null != (userinfoBySup = this.getUserinfoBySup(umUserinfoDomainBean.getTenantCode(), rsResourceGoodsDomain.getMemberCcode()))) {
                infoMap.put(rsResourceGoodsDomain.getMemberCcode(), userinfoBySup);
            }
            if (null == userinfoBySup) {
                rsResourceGoodsDomain.setMemberCcode(null);
                rsResourceGoodsDomain.setMemberCname(null);
            } else {
                rsResourceGoodsDomain.setMemberCcode(userinfoBySup.getUserinfoCode());
                rsResourceGoodsDomain.setMemberCname(userinfoBySup.getUserinfoCompname());
            }
            rsResourceGoodsDomain.setTenantCode(umUserinfoDomainBean.getTenantCode());
            if (!StringUtils.isBlank((String)((String)skuNoMap.get(rsResourceGoodsDomain.getGoodsNo())))) continue;
            skuNoMap.put(rsResourceGoodsDomain.getGoodsNo(), rsResourceGoodsDomain.getGoodsNo());
            if (this.queryGoodsByGoodsNo(rsResourceGoodsDomain.getGoodsNo(), disChannel)) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.goodsInfo", (Object)("goodsNo is " + rsResourceGoodsDomain.getGoodsNo()));
                continue;
            }
            rsResourceGoodsDomain.setMemberCode(tenantuserinfoCode);
            rsResourceGoodsDomain.setMemberName(tenantusername);
            if (!this.checkClasstree(rsResourceGoodsDomain, classtreeMap1)) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.classtreeMap", (Object)"classtreeMap is null");
                continue;
            }
            RsResourceGoodsDomain newRsResourceGoodsDomain = this.checkGoods(rsResourceGoodsDomain, rsBrandMap, supplierTypeMap, userinfoCode);
            if (newRsResourceGoodsDomain == null) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.newRsResourceGoodsDomain", (Object)"newRsResourceGoodsDomain is null");
                continue;
            }
            DisDgoodsScopelistDomain disDgoodsScopelistDomain = this.buildDisDgoodsSc(userinfoCode, umUserinfoDomainBean.getTenantCode(), newRsResourceGoodsDomain, disChannel);
            if (disDgoodsScopelistDomain == null) {
                this.logger.error(this.SYS_CODE + ".synGoodsInfo.disDgoodsScopelistDomain", (Object)"dgoodsCode is null");
                return false;
            }
            dgoodsScList.add(disDgoodsScopelistDomain);
            goodsList.add(newRsResourceGoodsDomain);
            if (goodsList.size() != 50 && rsResourceGoodsDomainList.size() - 1 != rsResourceGoodsDomainList.indexOf(rsResourceGoodsDomain)) continue;
            saveDscMap.put("disDgoodsScopelistDomainList", JsonUtil.buildNonNullBinder().toJson(dgoodsScList));
            this.internalInvoke(ApiCodeEnums.saveDgoodsScopelistBatch.getApiCode(), saveDscMap);
            commodityMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsList));
            String msg = this.internalInvoke("rs.resource.sendSavePassResourceGoodsBatch", commodityMap);
            this.logger.info(this.SYS_CODE + ".synGoodsInfo.msg", (Object)msg);
            goodsList.clear();
            dgoodsScList.clear();
            retailGoodsList.clear();
        }
        return true;
    }

    public UmUserinfoDomainBean getUserinfoBySup(String tenantCode, String userinfoOcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOcode", userinfoOcode);
        paramMap.put("userinfoQuality", "supplier");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getReCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public Integer getSupplierType(String tenantCode, String memberCcode) {
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoCode", memberCcode);
        UmUserinfo umUserinfo = (UmUserinfo)this.readObj(ApiCodeEnums.getUserinfo.getApiCode(), map, "object", new Object[]{UmUserinfo.class});
        if (null == umUserinfo) {
            return null;
        }
        return umUserinfo.getCompanyType();
    }

    public void doRetailGoods(List<RsResourceGoodsDomain> goodsList, List<RsResourceGoodsDomain> retailGoodsList, String tenantCode, String retailCode) {
        RsResourceGoodsDomain rsResourceGoodsDomain = null;
        for (RsResourceGoodsDomain platGoods : goodsList) {
            RsResourceGoodsDomain goodsInfoId = this.getGoodsInfoId(platGoods, tenantCode);
            if (goodsInfoId == null) {
                this.logger.error(this.SYS_CODE + ".doRetailGoods.null", (Object)("goodsNo is" + rsResourceGoodsDomain.getGoodsNo()));
                continue;
            }
            rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsDomain.getGoodsCode());
            rsResourceGoodsDomain.setGoodsCode(null);
            rsResourceGoodsDomain.setMemberCode(retailCode);
            retailGoodsList.add(rsResourceGoodsDomain);
        }
        ArrayList<RsResourceGoodsDomain> fianlReGoodsList = new ArrayList<RsResourceGoodsDomain>();
        HashMap<String, String> reGoodsMap = new HashMap<String, String>();
        for (RsResourceGoodsDomain retailGoods : retailGoodsList) {
            fianlReGoodsList.add(retailGoods);
            if (fianlReGoodsList.size() != 50 && retailGoodsList.size() - 1 != retailGoodsList.indexOf(retailGoods)) continue;
            this.logger.error(this.SYS_CODE + ".synGoodsInfo.rsResourceGoodsDomainList", (Object)("size is " + goodsList.size() + "===" + goodsList.size()));
            reGoodsMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsList));
            this.internalInvoke("rs.resource.sendSaveResourceGoodsBatch", reGoodsMap);
            fianlReGoodsList.clear();
        }
    }

    public DisDgoodsScopelistDomain buildDisDgoodsSc(String userinfoCode, String tenantCode, RsResourceGoodsDomain rsResourceGoodsDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsDomain || StringUtils.isBlank((String)tenantCode) || null == disChannel) {
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(disChannel.getChannelCode() + "-" + tenantCode), DisDgoods.class);
        if (null == disDgoods) {
            this.logger.error(this.SYS_CODE + ".buildDisDgoodsSc.disDgoods", (Object)(disChannel.getChannelCode() + "-" + tenantCode));
            return null;
        }
        DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
        disDgoodsScopelistDomain.setChannelCode(disDgoods.getChannelCode());
        disDgoodsScopelistDomain.setChannelName(disDgoods.getChannelName());
        disDgoodsScopelistDomain.setChannelSort(disDgoods.getChannelSort());
        disDgoodsScopelistDomain.setChannelType(disDgoods.getChannelType());
        disDgoodsScopelistDomain.setDgoodsScopelistType("skuNo");
        disDgoodsScopelistDomain.setDgoodsScopelistTerm("=");
        disDgoodsScopelistDomain.setDgoodsScopelistValue(rsResourceGoodsDomain.getGoodsNo());
        disDgoodsScopelistDomain.setMemberCode(disDgoods.getMemberCode());
        disDgoodsScopelistDomain.setMemberMcode(disDgoods.getMemberMcode());
        disDgoodsScopelistDomain.setMemberMname(disDgoods.getMemberMname());
        disDgoodsScopelistDomain.setMemberName(disDgoods.getMemberName());
        disDgoodsScopelistDomain.setTenantCode(tenantCode);
        disDgoodsScopelistDomain.setDgoodsCode(disDgoods.getDgoodsCode());
        return disDgoodsScopelistDomain;
    }

    private DisChannel getDisChannelByMem(String userinfoCode, String memberMcode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> invokeChannelMap = new HashMap<String, String>();
        HashMap<String, String> disChannelMap = new HashMap<String, String>();
        disChannelMap.put("memberCode", userinfoCode);
        disChannelMap.put("tenantCode", tenantCode);
        disChannelMap.put("memberMcode", memberMcode);
        disChannelMap.put("channelType", "0");
        disChannelMap.put("channelSort", "0");
        disChannelMap.put("channelPcode", "-1");
        invokeChannelMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(disChannelMap));
        QueryResult disChannelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeChannelMap, DisChannel.class);
        if (null == disChannelQueryResult || ListUtil.isEmpty((Collection)disChannelQueryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".getDisChannelByMem.disChannelQueryResult", (Object)((Object)disChannelMap).toString());
            return null;
        }
        return (DisChannel)disChannelQueryResult.getList().get(0);
    }

    @Override
    public String updateGoodsNum(String userinfoCode, String tenantCode, String goodsListStr, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateGoodsNum.null");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        if (null == umUserinfoDomainBean) {
            this.logger.error(this.SYS_CODE + ".updateGoodsNum.umUserinfoDomainBean", (Object)(userinfoCode + "====:==" + tenantCode + "goodsListStr" + dmsId + "====" + goodsListStr.length()));
            return ResultEnums.error.getCode();
        }
        DisChannel disChannel = this.getDisChannelByMem(userinfoCode, umUserinfoDomainBean.getUserinfoCode(), tenantCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".updateGoodsNum.disChannel", (Object)userinfoCode);
            return ResultEnums.error.getCode();
        }
        String name = disChannel.getMemberName();
        List<String> warehouseCodeList = this.getWarehouseCodeList(tenantCode, userinfoCode);
        this.logger.error(this.SYS_CODE + ".updateGoodsNum.warehouseCodeList.size", (Object)warehouseCodeList.size());
        if (ListUtil.isEmpty(warehouseCodeList)) {
            this.logger.error(this.SYS_CODE + ".updateGoodsNum.warehouseCodeList.null");
            return ResultEnums.error.getCode();
        }
        return ResultEnums.success.getCode();
    }

    private WhStoreSku queryStoke(WhOpstoreSkuDomain whOpstoreSkuDomain, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", whOpstoreSkuDomain.getSkuNo());
        mapStr.put("chennelCode", whOpstoreSkuDomain.getChannelCode());
        mapStr.put("skuBarcode", whOpstoreSkuDomain.getSkuBarcode());
        mapStr.put("memberCode", whOpstoreSkuDomain.getMemberCode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("warehouseCode", whOpstoreSkuDomain.getWarehouseCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String whStoreSkuPageJson = null;
        try {
            whStoreSkuPageJson = (String)this.getInternalRouter().inInvoke("wh.whStoreGoods.queryStoreSkuPage", map);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".queryStoke.queryStoreSkuPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01map:" + map), (Throwable)e);
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(whStoreSkuPageJson, SupQueryResult.class);
        List whStoreStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), WhStoreSku.class);
        if (ListUtil.isEmpty((Collection)whStoreStrList)) {
            this.logger.error(this.SYS_CODE + ".queryStoke.queryStoreSkuPage.e", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01map:" + map));
            return null;
        }
        WhStoreSku whStoreSku = (WhStoreSku)whStoreStrList.get(0);
        return whStoreSku;
    }

    public List<String> getWarehouseCodeList(String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tanantCode", tenantCode);
        map.put("memberCode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryUserwhPage.getApiCode(), invokeMap, WhUserwh.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        for (WhUserwh whUserwh : queryResutl.getList()) {
            WhWarehouse whWarehouse = this.getWhWarehouse(tenantCode, whUserwh.getWarehouseCode());
            if (whWarehouse == null || warehouseCodeList.contains(whWarehouse.getWarehouseOcode())) continue;
            warehouseCodeList.add(whWarehouse.getWarehouseOcode());
        }
        return warehouseCodeList;
    }

    public WhWarehouse getWhWarehouse(String tenantCode, String warehouseCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tanantCode", tenantCode);
        map.put("warehouseCode", warehouseCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryWarehousePage.getApiCode(), invokeMap, WhWarehouse.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (WhWarehouse)queryResutl.getList().get(0);
    }

    public RsResourceGoodsReDomain getGoodsInfo(String goodsNo, String tenantCode) {
        if (StringUtils.isBlank((String)goodsNo) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsNo", goodsNo);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryResourceGoodsPage.getApiCode(), invokeMap, RsResourceGoodsReDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getGoodsInfo.getGoodsInfo", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (RsResourceGoodsReDomain)queryResutl.getList().get(0);
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", memberCode);
        params.put("memberCcode", memberCcode);
        params.put("channelCode", channelCode);
        params.put("tenantCode", tenantCode);
        return (GoodsBean)this.getForObject(ApiCodeEnums.getGoodsByNo.getApiCode(), GoodsBean.class, params);
    }

    public WhWarehouse getWarehouseByOcode(String warehouseOcode, String tenantCode) {
        if (StringUtils.isBlank((String)warehouseOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("warehouseOcode", warehouseOcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("wh.warehouse.queryWarehousePage", invokeMap, WhWarehouse.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + "getWarehouseByOcode.list.null", (Object)((Object)paramMap).toString());
            return null;
        }
        return (WhWarehouse)queryResutl.getList().get(0);
    }

    public List<String> getWarehouseCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("memeberCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("warehouseRemark", "WAREHOUSE");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("wh.warehouse.queryWarehousePage", invokeMap, WhWarehouse.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + "getWarehouseCode.list", (Object)"queryResutl is null");
            return null;
        }
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        for (WhWarehouse whWarehouseDomainList : queryResutl.getList()) {
            String warehouseCode = whWarehouseDomainList.getWarehouseCode();
            warehouseCodeList.add(warehouseCode);
        }
        return warehouseCodeList;
    }

    public RsResourceGoodsDomain checkGoods(RsResourceGoodsDomain oldRsResourceGoodsDomain, Map<String, RsBrand> rsBrandMap, Map<String, Integer> supplierTypeMap, String userinfoCode) {
        String tenantCode = oldRsResourceGoodsDomain.getTenantCode();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        if (StringUtils.isBlank((String)oldRsResourceGoodsDomain.getBrandCode())) {
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:brandEocode\u4e0d\u5b58\u5728");
            this.logger.error(this.SYS_CODE + ".checkGoods.getBrandCode");
            return null;
        }
        RsBrand rsBrand = rsBrandMap.get(oldRsResourceGoodsDomain.getBrandCode());
        if (null == rsBrand) {
            brandNameparamMap.put("brandEocode", oldRsResourceGoodsDomain.getBrandCode());
            brandNameparamMap.put("tenantCode", tenantCode);
            brandNameparamMap.put("memberCode", userinfoCode);
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
            String brandStr = "";
            try {
                brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
                if (StringUtils.isBlank((String)brandStr)) {
                    this.logger.error(this.SYS_CODE + ".checkGoods.brandStr", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                    RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                    rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + oldRsResourceGoodsDomain.getBrandCode() + "," + oldRsResourceGoodsDomain.getBrandCode() + ":\u54c1\u724c\u4e0d\u5b58\u5728");
                    return null;
                }
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".checkGoods.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
            SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
            List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
            if (ListUtil.isEmpty((Collection)rsBrands)) {
                this.logger.error(this.SYS_CODE + ".checkGoods.rsBrands", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
            rsBrand = (RsBrand)rsBrands.get(0);
            rsBrandMap.put(oldRsResourceGoodsDomain.getBrandCode(), rsBrand);
        }
        oldRsResourceGoodsDomain.setBrandCode(rsBrand.getBrandCode());
        oldRsResourceGoodsDomain.setBrandName(rsBrand.getBrandName());
        oldRsResourceGoodsDomain.setGoodsSpec("\u9ed8\u8ba4");
        oldRsResourceGoodsDomain.setGoodsNum(new BigDecimal(0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            if (map.get("createDate") != null) {
                date = simpleDateFormat.parse(map.get("createDate").toString());
            }
        }
        catch (ParseException rsBrands) {
            // empty catch block
        }
        oldRsResourceGoodsDomain.setGoodsHdate(date);
        oldRsResourceGoodsDomain.setGoodsPro("0");
        oldRsResourceGoodsDomain.setGoodsType("00");
        String memberCcode = oldRsResourceGoodsDomain.getMemberCcode();
        Integer supplierType = supplierTypeMap.get(memberCcode);
        if (null == supplierType) {
            supplierType = this.getSupplierType(tenantCode, memberCcode);
            supplierTypeMap.put(memberCcode, supplierType);
        }
        if (supplierType != null) {
            oldRsResourceGoodsDomain.setGoodsSp(String.valueOf(supplierType));
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setSkuNo(oldRsResourceGoodsDomain.getGoodsNo());
        rsSkuDomain.setSkuName(oldRsResourceGoodsDomain.getGoodsSpec());
        rsSkuDomain.setGoodsWeight(oldRsResourceGoodsDomain.getGoodsWeight());
        rsSkuDomain.setPricesetNprice(oldRsResourceGoodsDomain.getPricesetNprice());
        rsSkuDomain.setGoodsSupplynum(new BigDecimal(0));
        rsSkuDomain.setGoodsSupplyweight(oldRsResourceGoodsDomain.getGoodsOneweight());
        rsSkuDomain.setGoodsOrigin("0");
        rsSkuDomain.setPricesetBaseprice(oldRsResourceGoodsDomain.getPricesetBaseprice());
        rsSkuDomain.setPricesetAsprice(oldRsResourceGoodsDomain.getPricesetBaseprice());
        rsSkuDomain.setPartsnameNumunit(oldRsResourceGoodsDomain.getPartsnameNumunit());
        rsSkuDomain.setPartsnameWeightunit(oldRsResourceGoodsDomain.getPartsnameWeightunit());
        rsSkuDomain.setGoodsOneweight(oldRsResourceGoodsDomain.getGoodsOneweight());
        rsSkuDomain.setGoodsSp(oldRsResourceGoodsDomain.getGoodsSp());
        rsSkuDomain.setSkuBarcode(oldRsResourceGoodsDomain.getGoodsNo());
        rsSkuDomainList.add(rsSkuDomain);
        oldRsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        rsSpecValueDomain.setSpecGroupCode("11224bcb47a947fb81965b264442f296");
        rsSpecValueDomain.setSpecCode("7bc948b43540414e92f5149e9e7e3e43");
        rsSpecValueDomain.setSpecName("\u9ed8\u8ba4");
        rsSpecValueDomain.setTenantCode(tenantCode);
        rsSpecValueDomain.setSpecValueValue("\u9ed8\u8ba4");
        rsSpecValueDomain.setSpecValueType("1");
        rsSpecValueDomainList.add(rsSpecValueDomain);
        oldRsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
        return oldRsResourceGoodsDomain;
    }

    public boolean checkClasstree(RsResourceGoodsDomain rsResourceGoodsDomain, Map<String, String> classtreeMap) throws ApiException {
        if (rsResourceGoodsDomain == null || null == classtreeMap) {
            this.logger.error(this.SYS_CODE + ".getClasstree.null");
            return false;
        }
        String clastreeName = rsResourceGoodsDomain.getClasstreeName();
        String classtreeCode = classtreeMap.get(clastreeName);
        if (StringUtils.isNotBlank((String)classtreeCode)) {
            rsResourceGoodsDomain.setClasstreeCode(classtreeCode);
            return true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        map.put("classtreeEocode", rsResourceGoodsDomain.getClasstreeCode());
        map.put("memberCode", rsResourceGoodsDomain.getMemberCode());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryClasstreePage.getApiCode(), sendMap, RsClasstreeDomain.class);
        String string = classtreeCode = ListUtil.isEmpty((Collection)queryResult.getList()) ? null : ((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode();
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            classtreeCode = this.saveClasstree(rsResourceGoodsDomain);
        }
        rsResourceGoodsDomain.setClasstreeCode(classtreeCode);
        rsResourceGoodsDomain.setClasstreeName(clastreeName);
        classtreeMap.put(clastreeName, classtreeCode);
        return true;
    }

    public String saveClasstree(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        if (rsResourceGoodsDomain == null) {
            this.logger.error(this.SYS_CODE + ".saveClasstree.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
        rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
        rsClasstreeDomain.setClasstreeParentcode("-1");
        rsClasstreeDomain.setClasstreeLast("0");
        rsClasstreeDomain.setClasstreeType("0");
        rsClasstreeDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
        rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        map.put("rsClasstreeDomain", JsonUtil.buildNonNullBinder().toJson((Object)rsClasstreeDomain));
        return this.internalInvoke(ApiCodeEnums.saveClasstree.getApiCode(), map);
    }

    public RsResourceGoodsDomain getGoodsInfoId(RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode) throws ApiException {
        if (rsResourceGoodsDomain == null || StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            this.logger.error(this.SYS_CODE + ".getGoodsInfoId.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("goodsNo", rsResourceGoodsDomain.getGoodsNo());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryResourceGoodsPage.getApiCode(), map, RsResourceGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".getGoodsInfoId.null", (Object)("map is " + map));
            return null;
        }
        return (RsResourceGoodsDomain)jsonToObject.getList().get(0);
    }

    @Override
    public String synGoodsBrandInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)dmsId)) {
            this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.null");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean paltUmUserinfoDomainBean = this.getPlatCode(tenantCode);
        if (null == paltUmUserinfoDomainBean) {
            this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.paltUmUserinfoDomainBean");
            return ResultEnums.error.getCode();
        }
        List rsBrandDomainList = null;
        if (ListUtil.isEmpty(rsBrandDomainList)) {
            this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.rsBrandDomainList");
            return ResultEnums.error.getCode();
        }
        ArrayList<RsBrandDomain> brandList = new ArrayList<RsBrandDomain>();
        HashMap<String, String> brandMap = new HashMap<String, String>();
        for (RsBrandDomain rsBrandDomain : rsBrandDomainList) {
            int brandInfoId = this.getBrandInfoId(rsBrandDomain, userinfoCode, tenantCode);
            this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.brandInfoId", (Object)("brandInfoId" + brandInfoId + ",==\uff1a==" + JsonUtil.buildNonNullBinder().toJson((Object)rsBrandDomain) + "==:==" + tenantCode));
            if (brandInfoId != 0) {
                rsBrandDomain.setBrandId(brandInfoId);
            }
            rsBrandDomain.setTenantCode(tenantCode);
            rsBrandDomain.setMemberCode(paltUmUserinfoDomainBean.getUserinfoCode());
            rsBrandDomain.setMemberName(paltUmUserinfoDomainBean.getUserinfoCompname());
            brandList.add(rsBrandDomain);
            this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.over", (Object)("flag1 is" + brandList.size() + "flag2 is" + (rsBrandDomainList.size() - 1 == rsBrandDomainList.indexOf(rsBrandDomain))));
            if (brandList.size() != 100 && rsBrandDomainList.size() - 1 != rsBrandDomainList.indexOf(rsBrandDomain)) continue;
            for (RsBrandDomain rsBrandDomain1 : brandList) {
                brandMap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain1));
                String brandCode = this.internalInvoke(ApiCodeEnums.saveBrand.getApiCode(), brandMap);
                if (StringUtils.isEmpty((String)brandCode)) {
                    RsBrandDomain brandDomain = this.getBrandDomain(rsBrandDomain1, userinfoCode, tenantCode);
                    if (null == brandDomain) continue;
                    brandCode = brandDomain.getBrandCode();
                }
                this.logger.error(this.SYS_CODE + ".brandCode", (Object)brandCode);
                this.doRsBbrandRelation(brandCode, dmsId, tenantCode);
            }
            brandList.clear();
        }
        this.logger.error(this.SYS_CODE + ".synGoodsBrandInfo.brandInfoId", (Object)"over");
        return ResultEnums.success.getCode();
    }

    public void doRsBbrandRelation(String brandCode, String dmsId, String tenantCode) {
        if (StringUtils.isEmpty((String)brandCode) || StringUtils.isEmpty((String)dmsId) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".doRsBbrandRelation.null");
            return;
        }
        RsBrandRelationDomain rsBrandRelationDomain = new RsBrandRelationDomain();
        rsBrandRelationDomain.setTenantCode(tenantCode);
        rsBrandRelationDomain.setAppmanageIcode(dmsId);
        rsBrandRelationDomain.setBrandCode(brandCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsBrandRelationDomain", JsonUtil.buildNonNullBinder().toJson((Object)rsBrandRelationDomain));
        this.internalInvoke(ApiCodeEnums.saveBrandRelation.getApiCode(), map);
    }

    public int getBrandInfoId(RsBrandDomain rsBrandDomain, String userinfoCode, String tenantCode) throws ApiException {
        if (rsBrandDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkBrandInfo.null");
            return 0;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("brandEocode", rsBrandDomain.getBrandEocode());
        paramMap.put("memberCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeSendmap, RsBrandDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkBrandInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return 0;
        }
        return ((RsBrandDomain)jsonToObject.getList().get(0)).getBrandId();
    }

    public RsBrandDomain getBrandDomain(RsBrandDomain rsBrandDomain, String userinfoCode, String tenantCode) throws ApiException {
        if (rsBrandDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkBrandInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("brandEocode", rsBrandDomain.getBrandEocode());
        paramMap.put("memberCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeSendmap, RsBrandDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkBrandInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (RsBrandDomain)jsonToObject.getList().get(0);
    }

    @Override
    public String synUpdateGoodsPrice(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.null");
            return ResultEnums.error.getCode();
        }
        Date date = new Date();
        Httpfacade httpfacade = new Httpfacade("");
        List<String> userinfoSortList = this.getuserinfoSortList(tenantCode, userinfoCode);
        if (ListUtil.isEmpty(userinfoSortList)) {
            this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.userinfoSortList.null", (Object)("userinfoCode is" + userinfoCode));
            return ResultEnums.error.getCode();
        }
        this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.userinfoSortList.size", (Object)userinfoSortList.size());
        HashMap<String, String> priceTypeMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String userinfoGroup : userinfoSortList) {
            priceTypeMap.put("price_type_num", userinfoGroup);
            ArrayList<HashMap<String, String>> priceTypeList = new ArrayList<HashMap<String, String>>();
            priceTypeList.add(priceTypeMap);
            if (ListUtil.isEmpty(priceTypeList)) {
                this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.priceTypeList.null");
                continue;
            }
            List<Map<String, String>> orgNumParam = this.getOrgNumParam(userinfoGroup, tenantCode, dmsId);
            List confListResult = null;
            List<DisChannel> channelList = this.getChannelCodeList(userinfoGroup, tenantCode);
            if (ListUtil.isEmpty(channelList)) {
                this.logger.error(this.SYS_CODE + "synUpdateGoodsPrice.channelCodeList.null", (Object)("tDpriceOcode is" + userinfoGroup));
                continue;
            }
            for (DisChannel disChannel : channelList) {
                String goodsNoByItemNum = null;
                ArrayList<DisDpriceConfDomain> confList = new ArrayList<DisDpriceConfDomain>();
                boolean flag = false;
                for (DisDpriceConfDomain disDpriceConfDomain : confListResult) {
                    if (confListResult.indexOf(disDpriceConfDomain) == confListResult.size() - 1) {
                        flag = true;
                    }
                    if (StringUtils.isBlank((String)(goodsNoByItemNum = this.getGoodsNoByItemNum(tenantCode, disDpriceConfDomain.getDpriceConfValue(), userinfoCode)))) {
                        this.logger.error(this.SYS_CODE + "synUpdateGoodsPrice.goodsNoByItemNum", (Object)("tDpriceOcode is" + userinfoGroup + "=" + disDpriceConfDomain.getDpriceConfValue()));
                        continue;
                    }
                    disDpriceConfDomain.setDpriceConfValue(goodsNoByItemNum);
                    confList.add(disDpriceConfDomain);
                }
                this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.confList.size", (Object)confList.size());
                if (ListUtil.isEmpty(confList)) {
                    this.logger.error(this.SYS_CODE + "synUpdateGoodsPrice.confList", (Object)("tDpriceOcode is" + userinfoGroup));
                    continue;
                }
                DisDpriceDomain olddisDpriceDomain = null;
                DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
                disDpriceDomain.setDpriceOcode(userinfoGroup);
                olddisDpriceDomain = this.checkPrice(disDpriceDomain, tenantCode, disChannel);
                if (null != olddisDpriceDomain) {
                    disDpriceDomain.setDpriceCode(olddisDpriceDomain.getDpriceCode());
                    disDpriceDomain.setDpriceId(olddisDpriceDomain.getDpriceId());
                    disDpriceDomain.setDpriceVer(olddisDpriceDomain.getDpriceVer());
                }
                disDpriceDomain.setDpriceSydate(date);
                disDpriceDomain.setChannelCode(disChannel.getChannelCode());
                disDpriceDomain.setTenantCode(tenantCode);
                disDpriceDomain.setDpricePro("2");
                disDpriceDomain.setChannelName(disChannel.getChannelName());
                disDpriceDomain.setChannelSort(disChannel.getChannelSort());
                disDpriceDomain.setChannelType(disChannel.getChannelType());
                disDpriceDomain.setMemberMcode(disChannel.getMemberMcode());
                disDpriceDomain.setMemberMname(disChannel.getMemberMname());
                disDpriceDomain.setMemberCode(disChannel.getMemberCode());
                disDpriceDomain.setMemberName(disChannel.getMemberName());
                if (StringUtils.isNotBlank((String)disDpriceDomain.getDpriceCode())) {
                    this.updatePrice(disDpriceDomain, confList, tenantCode, disChannel, disChannel.getChannelCode(), userinfoCode, flag);
                    continue;
                }
                List<DisDpriceConf> disDpriceConfs = this.changeModel(confList);
                disDpriceDomain.setDisDpriceConfList(disDpriceConfs);
                this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.disDpriceConfs.size", (Object)disDpriceConfs.size());
                paramMap.put("disDpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)disDpriceDomain));
                this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.disDpriceConfDomain", (Object)(disChannel.getChannelCode() + "====" + disDpriceDomain.getDisDpriceConfList().size()));
                this.internalInvoke(ApiCodeEnums.saveDprice.getApiCode(), paramMap);
                ArrayList<DisDgoodsScopelistDomain> disScList = new ArrayList<DisDgoodsScopelistDomain>();
                for (DisDpriceConfDomain disDpriceConfDomain : confList) {
                    DisDgoodsScopelistDomain disDgoodsScopelistDomain = this.synDis(disChannel, disDpriceConfDomain.getDpriceConfValue(), tenantCode, userinfoCode, "save");
                    disScList.add(disDgoodsScopelistDomain);
                    this.saveGoods(disDpriceConfDomain, disChannel);
                }
                HashMap<String, Object> saveDgoodsScMap = new HashMap<String, Object>();
                saveDgoodsScMap.put("disDgoodsScopelistDomainList", JsonUtil.buildNonNullBinder().toJson(disScList));
                saveDgoodsScMap.put("flag", flag);
                this.logger.error(this.SYS_CODE + ".disDgoodsScopelistDomainList", (Object)disScList.size());
                this.internalInvoke(ApiCodeEnums.saveOrUpdateDgoodsScopelistBatch.getApiCode(), saveDgoodsScMap);
            }
            this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.execute", (Object)"======================\u7ebf\u7a0b\u7ed3\u675f================");
        }
        return ResultEnums.success.getCode();
    }

    public List<DisDpriceConf> changeModel(List<DisDpriceConfDomain> disDpriceDomainList) {
        DisDpriceConf disDpriceConf = null;
        ArrayList<DisDpriceConf> disDpriceList = new ArrayList<DisDpriceConf>();
        for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomainList) {
            disDpriceConf = new DisDpriceConf();
            try {
                BeanUtils.copyAllPropertys((Object)disDpriceConf, (Object)disDpriceConfDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            disDpriceList.add(disDpriceConf);
        }
        return disDpriceList;
    }

    public List<DisChannel> getChannelCodeList(String appmanageIcode, String tenantCode) {
        ArrayList<String> listStr = new ArrayList<String>();
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        List<CtCustrel> ctCustrelEmpList = this.getCtCustrelEmpList(appmanageIcode, tenantCode);
        this.logger.error(this.SYS_CODE + ".getChannelCodeList.size", (Object)ctCustrelEmpList.size());
        for (CtCustrel ctCustrel : ctCustrelEmpList) {
            if (listStr.contains(ctCustrel.getUserinfoCode())) {
                this.logger.error(this.SYS_CODE + ".getChannelCodeList.ctCustrel", (Object)ctCustrel.getUserinfoCode());
                continue;
            }
            DisChannel channelDomain = this.getChannelDomainByDea(ctCustrel.getUserinfoCode(), "B2B-DEA", tenantCode);
            channelList.add(channelDomain);
            listStr.add(ctCustrel.getUserinfoCode());
        }
        return channelList;
    }

    public List<CtCustrel> getCtCustrelEmpList(String appmanageIcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("appmanageIcode", appmanageIcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCustrelPage.getApiCode(), invokeMap, CtCustrel.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getCtCustrelEmpList.queryResutl", (Object)((Object)invokeMap).toString());
            return null;
        }
        return queryResutl.getList();
    }

    public List<Map<String, String>> getOrgNumParam(String appmanageIcode, String tenantCode, String custrelShortname) {
        List<CtCustrel> ctCustrelEmpList = this.getCtCustrelEmpList(appmanageIcode, tenantCode);
        HashMap<String, String> orgMap = null;
        ArrayList<Map<String, String>> orgList = new ArrayList<Map<String, String>>();
        for (CtCustrel ctCustrel : ctCustrelEmpList) {
            orgMap = new HashMap<String, String>();
            String departCode = ctCustrel.getDepartCode();
            OrgDepart departDomain = this.getDepartDomain(departCode, tenantCode);
            if (null == departDomain) {
                this.logger.error(this.SYS_CODE + ".getOrgNumParam.departDomain", (Object)(departCode + "===param===" + tenantCode));
                continue;
            }
            orgMap.put("org_num", departDomain.getDepartShortcode());
            orgList.add(orgMap);
        }
        return orgList;
    }

    public OrgDepart getDepartDomain(String departCode, String tenantCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), sendMap, OrgDepart.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgDepart)queryResutl.getList().get(0);
    }

    public WhStoreSku queryWhSku(String tenantCode, String skuNo) {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("skuNo", skuNo);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryStoreSkuPage.getApiCode(), invokeMap, WhStoreSku.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (WhStoreSku)queryResutl.getList().get(0);
    }

    private void saveGoods(DisDpriceConfDomain disDpriceConfDomain, DisChannel disChannel) {
        GoodsBean goodsBean = this.getGoodsBySkuNo(disDpriceConfDomain.getDpriceConfValue(), disChannel);
        if (null == goodsBean) {
            this.logger.error(this.SYS_CODE + ".saveGoods.goodsBean", (Object)disDpriceConfDomain.getDpriceConfValue());
            return;
        }
        if (null == goodsBean.getRsSku().getPricesetNprice()) {
            goodsBean.getRsSku().setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == goodsBean.getRsSku().getPricesetAsprice()) {
            goodsBean.getRsSku().setPricesetAsprice(BigDecimal.ZERO);
        }
        if (goodsBean.getRsSku().getPricesetNprice().compareTo(disDpriceConfDomain.getDpriceConfPrice()) == 0) {
            this.logger.error(this.SYS_CODE + ".saveGoods.PricesetNprice", (Object)(disDpriceConfDomain.getDpriceConfValue() + "=" + disDpriceConfDomain.getDpriceConfPrice()));
            return;
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(goodsBean.getRsSku().getSkuId());
        editSkuDomain.setGoodsCode(goodsBean.getRsSku().getGoodsCode());
        editSkuDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
        editSkuDomain.setSkuNo(disDpriceConfDomain.getDpriceConfValue());
        editSkuDomain.setPricesetNprice(disDpriceConfDomain.getDpriceConfPrice());
        editSkuDomain.setMemberCode(disChannel.getMemberCode());
        editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        editSkuDomain.setTenantCode(disChannel.getTenantCode());
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke(ApiCodeEnums.updateNprice.getApiCode(), updateMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synUpdateGoodsPrice.e", (Throwable)e);
        }
    }

    public String getGoodsNo(String itemNum, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("goodsCode", itemNum);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        String str = this.internalInvoke(ApiCodeEnums.getResourceGoodsByCode.getApiCode(), invokeMap);
        if (StringUtils.isBlank((String)str)) {
            this.logger.error(this.SYS_CODE + ".updatePrice.getGoodsNo", (Object)((Object)paramMap).toString());
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(str, RsResourceGoodsReDomain.class);
        return rsResourceGoodsReDomain.getGoodsNo();
    }

    private boolean queryGoodsByGoodsNo(String goodsNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)goodsNo) || null == disChannel) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("goodsNo", goodsNo);
        params.put("memberCode", disChannel.getMemberCode());
        params.put("tenantCode", disChannel.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(params));
        QueryResult qre = this.sendReSupObject(ApiCodeEnums.queryGoods.getApiCode(), map, RsResourceGoodsDomain.class);
        return null != qre && !ListUtil.isEmpty((Collection)qre.getList());
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCode());
        params.put("channelCode", disChannel.getChannelCode());
        params.put("tenantCode", disChannel.getTenantCode());
        return (GoodsBean)this.getForObject(ApiCodeEnums.getGoodsByNo.getApiCode(), GoodsBean.class, params);
    }

    public List<DisChannel> getChannelCode(String userinfoGroup, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoGroup)) {
            this.logger.error(this.SYS_CODE + ".getChannelCode.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoGroup", userinfoGroup);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getChannelCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        ArrayList<DisChannel> disChannelList = new ArrayList<DisChannel>();
        HashMap<String, String> disChannelMap = new HashMap<String, String>();
        HashMap<String, String> invokeChannelMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : quresult.getList()) {
            disChannelMap.put("memberCcode", umUserinfoDomainBean.getUserinfoCode());
            disChannelMap.put("tenantCode", tenantCode);
            invokeChannelMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(disChannelMap));
            QueryResult disChannelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeChannelMap, DisChannel.class);
            if (null == disChannelQueryResult || ListUtil.isEmpty((Collection)disChannelQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".getChannelCode.disChannelQueryResult", (Object)((Object)disChannelMap).toString());
                return null;
            }
            disChannelList.addAll(disChannelQueryResult.getList());
        }
        return disChannelList;
    }

    public DisDpriceDomain checkPrice(DisDpriceDomain disDpriceDomain, String tenantCode, DisChannel disChannel) {
        if (disDpriceDomain == null || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".checkPrice.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("dpriceOcode", disDpriceDomain.getDpriceOcode());
        sendMap.put("memberMcode", disChannel.getMemberMcode());
        sendMap.put("memberCode", disChannel.getMemberCode());
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("channelCode", disChannel.getChannelCode());
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDpricePage.getApiCode(), invokeQueryMap, DisDpriceDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkPrice.jsonToObject", (Object)((Object)sendMap).toString());
            return null;
        }
        return (DisDpriceDomain)jsonToObject.getList().get(0);
    }

    public void updatePrice(DisDpriceDomain disDpriceDomain, List<DisDpriceConfDomain> confList, String tenantCode, DisChannel disChannel, String channelCode, String userinfoCode, boolean flag) {
        ArrayList<DisDgoodsScopelistDomain> dgoodsScList = new ArrayList<DisDgoodsScopelistDomain>();
        if (disDpriceDomain == null || ListUtil.isEmpty(confList)) {
            this.logger.error(this.SYS_CODE + ".updatePrice.null");
            return;
        }
        List<DisDpriceConf> disDpriceConfs = this.queryPriceConfig(disDpriceDomain.getDpriceCode(), tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (DisDpriceConfDomain disDpriceConfDomain : confList) {
            disDpriceConfDomain.setDpriceCode(disDpriceDomain.getDpriceCode());
            disDpriceConfDomain.setTenantCode(tenantCode);
            boolean b = this.checkListData(disDpriceConfs, disDpriceConfDomain.getDpriceConfValue());
            DisDgoodsScopelistDomain disDgoodsScopelistDomain = null;
            if (b) {
                disDgoodsScopelistDomain = this.updatDpriceConfig(disDpriceDomain, disDpriceConfDomain.getDpriceConfValue(), disChannel, tenantCode, userinfoCode);
            } else {
                paramMap.put("disDpriceConfDomain", JsonUtil.buildNormalBinder().toJson((Object)disDpriceConfDomain));
                this.internalInvoke(ApiCodeEnums.saveDpriceConf.getApiCode(), paramMap);
                disDgoodsScopelistDomain = this.synDis(disChannel, disDpriceConfDomain.getDpriceConfValue(), tenantCode, userinfoCode, "save");
            }
            dgoodsScList.add(disDgoodsScopelistDomain);
            this.saveGoods(disDpriceConfDomain, disChannel);
        }
        if (ListUtil.isNotEmpty(disDpriceConfs)) {
            for (DisDpriceConf disDpriceConf : disDpriceConfs) {
                DisDgoodsScopelistDomain newDisDgoodsScopelistDomain = this.makeDgoodsSc(disChannel, disDpriceConf.getDpriceConfValue(), tenantCode);
                dgoodsScList.add(newDisDgoodsScopelistDomain);
                HashMap<String, Integer> delMap = new HashMap<String, Integer>();
                delMap.put("dpriceConfId", disDpriceConf.getDpriceConfId());
                this.internalInvoke(ApiCodeEnums.deleteDpriceConf.getApiCode(), delMap);
            }
        }
        HashMap<String, Object> saveDgoodsScMap = new HashMap<String, Object>();
        saveDgoodsScMap.put("disDgoodsScopelistDomainList", JsonUtil.buildNonNullBinder().toJson(dgoodsScList));
        saveDgoodsScMap.put("flag", flag);
        this.internalInvoke(ApiCodeEnums.saveOrUpdateDgoodsScopelistBatch.getApiCode(), saveDgoodsScMap);
    }

    public DisDgoodsScopelistDomain makeDgoodsSc(DisChannel disChannel, String itemId, String tenantCode) {
        DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsSc(disChannel.getChannelCode(), "skuNo", itemId, tenantCode);
        if (null == disDgoodsScopelist) {
            this.logger.error(this.SYS_CODE + ".makeDgoodsSc.null", (Object)(itemId + "==" + disChannel.getChannelCode()));
            return null;
        }
        DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsScopelistDomain, (Object)disDgoodsScopelist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        disDgoodsScopelistDomain.setDgoodsScopelistState(-1);
        return disDgoodsScopelistDomain;
    }

    public boolean checkListData(List<DisDpriceConf> disDpriceConfs, String skuNo) {
        if (ListUtil.isEmpty(disDpriceConfs)) {
            this.logger.error(this.SYS_CODE + ".checkListData.null");
            return false;
        }
        for (int i = 0; i <= disDpriceConfs.size() - 1; ++i) {
            DisDpriceConf disDpriceConf = disDpriceConfs.get(i);
            String dpriceConfValue = disDpriceConf.getDpriceConfValue();
            if (!disDpriceConf.getDpriceConfValue().equals(skuNo)) continue;
            this.logger.error(this.SYS_CODE + ".checkListData.skuNo", (Object)skuNo);
            disDpriceConfs.remove(disDpriceConf);
            return true;
        }
        return false;
    }

    public boolean checkPriceConfig(DisDpriceConfDomain disDpriceConfDomain, String itemNum) {
        if (disDpriceConfDomain == null) {
            this.logger.error(this.SYS_CODE + ".updatePrice.null");
            return false;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("dpriceCode", disDpriceConfDomain.getDpriceCode());
        sendMap.put("tenantCode", disDpriceConfDomain.getTenantCode());
        sendMap.put("dpriceConfValue", itemNum);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDpriceConf.getApiCode(), paramMap, DisDpriceConf.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkPrice.jsonToObject", (Object)((Object)sendMap).toString());
            return false;
        }
        return true;
    }

    public List<DisDpriceConf> queryPriceConfig(String dpriceCode, String tenantCode) {
        if (StringUtils.isEmpty((String)dpriceCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updatePrice.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("dpriceCode", dpriceCode);
        sendMap.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDpriceConf.getApiCode(), paramMap, DisDpriceConf.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkPrice.jsonToObject", (Object)((Object)sendMap).toString());
            return null;
        }
        return jsonToObject.getList();
    }

    public DisDgoodsScopelistDomain updatDpriceConfig(DisDpriceDomain disDpriceDomain, String itemNum, DisChannel disChannel, String tenantCode, String userinfoCode) {
        if (disDpriceDomain == null) {
            this.logger.error(this.SYS_CODE + ".updatDpriceConfig.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("dpriceCode", disDpriceDomain.getDpriceCode());
        sendMap.put("tenantCode", disDpriceDomain.getTenantCode());
        sendMap.put("dpriceConfValue", itemNum);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDpriceConf.getApiCode(), paramMap, DisDpriceConfDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".updatDpriceConfig.jsonToObject", (Object)((Object)sendMap).toString());
            return null;
        }
        DisDpriceConfDomain disDpriceConfDomain = (DisDpriceConfDomain)jsonToObject.getList().get(0);
        disDpriceConfDomain.setDpriceConfPrice(disDpriceDomain.getDpricePrice());
        paramMap.put("disDpriceConfDomain", JsonUtil.buildNormalBinder().toJson((Object)disDpriceConfDomain));
        this.logger.error(this.SYS_CODE + ".updatePrice.disDpriceDomain", (Object)((Object)paramMap).toString());
        this.internalInvoke(ApiCodeEnums.updateDpriceConf.getApiCode(), paramMap);
        return this.synDis(disChannel, disDpriceDomain.getMemberCode(), tenantCode, userinfoCode, "update");
    }

    @Override
    public String synOrgToWarehouse(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)dmsId)) {
            this.logger.error(this.SYS_CODE + ".synOrgToWarehouse.null");
            return ResultEnums.error.getCode();
        }
        return ResultEnums.success.getCode();
    }

    public OrgDepart getDepartInfo(String departOcode, String tenantCode) {
        if (StringUtils.isBlank((String)departOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departOcode", departOcode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), sendMap, OrgDepart.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgDepart)queryResutl.getList().get(0);
    }

    private String getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoCode", userinfoCode);
        UmUserinfo umUserinfo = (UmUserinfo)this.readObj(ApiCodeEnums.getUserinfo.getApiCode(), map, "object", new Object[]{UmUserinfo.class});
        if (null == umUserinfo) {
            return null;
        }
        return umUserinfo.getUserinfoCompname();
    }

    public String getDepartOcode(String departOcode, String tenantCode) {
        OrgDepart orgDepart = this.getDepartInfo(departOcode, tenantCode);
        if (null == orgDepart) {
            return null;
        }
        return orgDepart.getUserinfoCode();
    }

    public UmUserinfoDomainBean getuserinfoByDepart(String tenantCode, String departCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        map.put("userinfoQuality", "depart");
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public List<String> getuserinfoSortList(String tenantCode, String userinfoCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoParentCode", userinfoCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryCustrelPage.getApiCode(), sendMap, CtCustrel.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getuserinfoSortList.quresult.null", (Object)((Object)sendMap).toString());
            return null;
        }
        List empList = quresult.getList();
        ArrayList<String> userinfoSortList = new ArrayList<String>();
        String appmanageIcode = "";
        for (CtCustrel ctCustrel : empList) {
            appmanageIcode = ctCustrel.getAppmanageIcode();
            if (StringUtils.isEmpty((String)appmanageIcode)) {
                this.logger.error(this.SYS_CODE + ".getuserinfoSortList.userinfoGroup.null", (Object)(ctCustrel.getUserinfoParentCode() + "==" + ctCustrel.getAppmanageIcode()));
                continue;
            }
            String[] split = appmanageIcode.split(",");
            for (int i = 0; i <= split.length - 1; ++i) {
                if (!StringUtils.isNotBlank((String)split[i]) || userinfoSortList.contains(split[i])) continue;
                userinfoSortList.add(split[i]);
            }
        }
        this.logger.error(this.SYS_CODE + ".getuserinfoSortList.list", userinfoSortList);
        return userinfoSortList;
    }

    public List<UmUserinfoDomainBean> parseUserinfo(String querySingleStr) {
        QueryResult querySingleRes = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySingleStr, QueryResult.class);
        String querySinglleListStr = JsonUtil.buildNormalBinder().toJson((Object)querySingleRes.getList());
        List umUserinfoDomainBeanSingleList = (List)JsonUtil.buildNormalBinder().getJsonToList(querySinglleListStr, UmUserinfoDomainBean.class);
        return umUserinfoDomainBeanSingleList;
    }

    public int getWhUserwhId(WhUserwhDomain whUserwhDomain, String tenantCode) {
        if (whUserwhDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkWhUserwh.null");
            return 0;
        }
        Map<String, String> resulyMap = this.getDepartCodeByMemo(whUserwhDomain.getDepartCode(), whUserwhDomain.getTenantCode());
        this.logger.error(this.SYS_CODE + ".checkWhUserwh.getWhUserwhId", (Object)resulyMap.toString());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put(" ", whUserwhDomain.getDepartCode());
        sendMap.put("memberCode", whUserwhDomain.getMemberCode());
        sendMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
        sendMap.put("tenantCode", tenantCode);
        HashMap<String, String> queryInvokeMap = new HashMap<String, String>();
        queryInvokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserwhPage.getApiCode(), queryInvokeMap, WhUserwhDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkWhUserwh.jsonToObject", (Object)((Object)sendMap).toString());
            return 0;
        }
        return ((WhUserwhDomain)jsonToObject.getList().get(0)).getUserwhId();
    }

    public Map<String, String> getDepartCodeByMemo(String userinfoCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getDepartCodeByMemo.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), map, OrgDepartempDomain.class);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            resultMap.put("departCode", "-1");
            resultMap.put("companyCode", "-1");
            this.logger.error(this.SYS_CODE + ".getDepartCodeByMemo.jsonToObject", (Object)((Object)map).toString());
            return resultMap;
        }
        for (OrgDepartempDomain orgDepart : jsonToObject.getList()) {
            if (StringUtils.isBlank((String)orgDepart.getDepartCode())) {
                resultMap.put("departCode", "-1");
            } else {
                resultMap.put("departCode", orgDepart.getDepartCode());
            }
            String companyCode = orgDepart.getCompanyCode();
            if (StringUtils.isBlank((String)companyCode)) {
                resultMap.put("companyCode", "-1");
            } else {
                resultMap.put("companyCode", companyCode);
            }
            String departName = orgDepart.getDepartName();
            if (StringUtils.isBlank((String)departName)) {
                resultMap.put("departName", "-1");
                continue;
            }
            resultMap.put("departName", departName);
        }
        return resultMap;
    }

    public void updateWhUserwh(WhUserwhDomain whUserwhDomain, String tenantCode) {
        if (whUserwhDomain == null) {
            this.logger.error(this.SYS_CODE + ".updateWhUserwh.null");
            return;
        }
        Map<String, String> resulyMap = this.getDepartCodeByMemo(whUserwhDomain.getDepartCode(), whUserwhDomain.getTenantCode());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("departCode", resulyMap.get("departCode"));
        sendMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
        sendMap.put("tenantCode", tenantCode);
        HashMap<String, String> queryInvokeMap = new HashMap<String, String>();
        queryInvokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserwhPage.getApiCode(), queryInvokeMap, WhUserwhDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".updateWhUserwh.jsonToObject", (Object)((Object)sendMap).toString());
            return;
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (WhUserwhDomain whUserwhDomain1 : jsonToObject.getList()) {
            whUserwhDomain1.setWarehouseName(whUserwhDomain.getWarehouseName());
            updateMap.put("whUserwhDomain", JsonUtil.buildNormalBinder().toJson((Object)whUserwhDomain));
            this.internalInvoke(ApiCodeEnums.updateUserwh.getApiCode(), updateMap);
        }
    }

    public DisDgoodsScopelistDomain synDis(DisChannel disChannel, String itemId, String tenantCode, String userinfoCode, String doWay) {
        if (disChannel == null) {
            this.logger.error(this.SYS_CODE + ".synDis.null");
            return null;
        }
        if (StringUtils.isBlank((String)itemId)) {
            this.logger.error(this.SYS_CODE + ".synDis.itemId");
            return null;
        }
        DisDgoodsScopelist disDgoodsScopelist = null;
        if (doWay.equals("update")) {
            disDgoodsScopelist = this.getDgoodsSc(disChannel.getChannelCode(), "skuNo", itemId, tenantCode);
        }
        if (null == disDgoodsScopelist && doWay.equals("update")) {
            this.logger.error(this.SYS_CODE + ".getDgoodsSc.", (Object)itemId);
            return null;
        }
        HashMap saveDscMap = new HashMap();
        String dgoodsCode = this.getDgoodsCode(disChannel.getChannelCode(), tenantCode);
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(this.SYS_CODE + ".dgoodsCode.nullchannelCode is" + disChannel.getChannelCode() + "tenantCode is" + tenantCode);
            return null;
        }
        DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
        disDgoodsScopelistDomain.setChannelCode(disChannel.getChannelCode());
        disDgoodsScopelistDomain.setChannelSort(disChannel.getChannelSort());
        disDgoodsScopelistDomain.setChannelType(disChannel.getChannelType());
        disDgoodsScopelistDomain.setMemberMcode(disChannel.getMemberMcode());
        disDgoodsScopelistDomain.setMemberMname(disChannel.getMemberMname());
        disDgoodsScopelistDomain.setMemberCode(disChannel.getMemberCode());
        disDgoodsScopelistDomain.setMemberName(disChannel.getMemberName());
        disDgoodsScopelistDomain.setDgoodsScopelistType("skuNo");
        disDgoodsScopelistDomain.setDgoodsScopelistTerm("=");
        disDgoodsScopelistDomain.setDgoodsScopelistValue(itemId);
        disDgoodsScopelistDomain.setTenantCode(tenantCode);
        disDgoodsScopelistDomain.setDgoodsCode(dgoodsCode);
        if (disDgoodsScopelist != null) {
            disDgoodsScopelistDomain.setDgoodsScopelistId(disDgoodsScopelist.getDgoodsScopelistId());
        }
        return disDgoodsScopelistDomain;
    }

    public String getGoodsNoByItemNum(String tenantCode, String skuNo, String userinfoCode) {
        WhStoreSku whStoreSku = this.queryWhSku(tenantCode, skuNo);
        if (null == whStoreSku) {
            this.logger.error(this.SYS_CODE + "getGoodsNoByItemNum.goodsNoByItemNum", (Object)skuNo);
            return null;
        }
        return whStoreSku.getSkuBarcode();
    }

    public String getDgoodsCode(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getDgoodsCode.null");
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> queryDgoodsMap = new HashMap<String, String>();
        queryDgoodsMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult dgoodsQuery = this.getQueryResutl(ApiCodeEnums.queryDgoodsPage.getApiCode(), queryDgoodsMap, DisDgoodsDomain.class);
        List list = dgoodsQuery.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(this.SYS_CODE + ".getDgoodsCode.itemId", (Object)("list is null==:==" + map));
            return null;
        }
        return ((DisDgoodsDomain)dgoodsQuery.getList().get(0)).getDgoodsCode();
    }

    @Override
    public String synDepartForBrand(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)dmsId)) {
            this.logger.error(this.SYS_CODE + ".synDepartForBrand.null");
            return ResultEnums.error.getCode();
        }
        return ResultEnums.success.getCode();
    }

    public void synbrand(List<DisDgoodsScopelistDomain> disDgoodsScopelistDomainList, String tenantCode, String retailCode) {
        if (ListUtil.isEmpty(disDgoodsScopelistDomainList)) {
            this.logger.error(this.SYS_CODE + ".synbrand.null");
            return;
        }
        ArrayList<DisDgoodsScopelistDomain> newDisDgoodsScopelistDomainList = new ArrayList<DisDgoodsScopelistDomain>();
        for (int i = 0; i < disDgoodsScopelistDomainList.size(); ++i) {
            DisDgoodsScopelistDomain disDgoodsScopelistDomain = disDgoodsScopelistDomainList.get(i);
            String userinfoCode = this.getUserinfoCodeByDCode(disDgoodsScopelistDomain.getDgoodsScopelistDes(), tenantCode);
            if (StringUtils.isEmpty((String)userinfoCode)) {
                this.logger.error(this.SYS_CODE + ".synbrand.userinfoCode", (Object)disDgoodsScopelistDomain.getDgoodsScopelistDes());
                return;
            }
            HashMap<String, String> disChannelMap = new HashMap<String, String>();
            disChannelMap.put("memberCode", userinfoCode);
            disChannelMap.put("channelType", "5");
            disChannelMap.put("channelSort", "5");
            disChannelMap.put("tenantCode", tenantCode);
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(disChannelMap));
            QueryResult disChannelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), sendMap, DisChannel.class);
            if (null == disChannelQueryResult || ListUtil.isEmpty((Collection)disChannelQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + "", (Object)((Object)disChannelMap).toString());
                return;
            }
            HashMap disDpriceMap = new HashMap();
            DisChannel disChannel = (DisChannel)disChannelQueryResult.getList().get(0);
            String channelCode = disChannel.getChannelCode();
            String dgoodsCode = this.getDgoodsCode(channelCode, tenantCode);
            if (StringUtils.isBlank((String)dgoodsCode)) {
                this.logger.error(this.SYS_CODE + ".synbrand.disChannelQueryResult.null", (Object)("chanelCode is" + channelCode + "tenantCode" + tenantCode));
                continue;
            }
            DisDgoodsScopelistDomain newDisDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)newDisDgoodsScopelistDomain, (Object)disDgoodsScopelistDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newDisDgoodsScopelistDomain.setDgoodsScopelistId(null);
            newDisDgoodsScopelistDomain.setChannelName(disChannel.getChannelName());
            newDisDgoodsScopelistDomain.setChannelSort(disChannel.getChannelSort());
            newDisDgoodsScopelistDomain.setChannelType(disChannel.getChannelType());
            newDisDgoodsScopelistDomain.setChannelCode(channelCode);
            newDisDgoodsScopelistDomain.setMemberCode(disChannel.getMemberCode());
            newDisDgoodsScopelistDomain.setMemberMcode(disChannel.getMemberMcode());
            newDisDgoodsScopelistDomain.setMemberMname(disChannel.getMemberMname());
            newDisDgoodsScopelistDomain.setMemberName(disChannel.getMemberName());
            newDisDgoodsScopelistDomain.setDgoodsCode(dgoodsCode);
            newDisDgoodsScopelistDomain.setTenantCode(tenantCode);
            String brandCodeByEcode = this.getBrandCodeByEcode(newDisDgoodsScopelistDomain, retailCode);
            if (StringUtils.isBlank((String)brandCodeByEcode)) {
                this.logger.error(this.SYS_CODE + ".synbrand.disChannelQueryResult.brandCodeByEcode.null");
                continue;
            }
            List<DisDgoodsScopelist> disDgoodsScopelists = this.queryDisDgoodsScopelist(tenantCode, brandCodeByEcode, newDisDgoodsScopelistDomain.getDgoodsCode());
            if (ListUtil.isNotEmpty(disDgoodsScopelists)) {
                this.logger.error(this.SYS_CODE + ".synbrand.disDgoodsScopelists", (Object)(newDisDgoodsScopelistDomain.getDgoodsScopelistValue() + "====" + newDisDgoodsScopelistDomain.getDgoodsCode()));
                continue;
            }
            newDisDgoodsScopelistDomain.setDgoodsScopelistValue(brandCodeByEcode);
            this.logger.error(this.SYS_CODE + ".synbrand.disChannelQueryResult.newDisDgoodsScopelistDomain.id", (Object)newDisDgoodsScopelistDomain.getDgoodsScopelistId());
            newDisDgoodsScopelistDomainList.add(newDisDgoodsScopelistDomain);
        }
        HashMap<String, Object> disDpriceMap = new HashMap<String, Object>();
        disDpriceMap.put("disDgoodsScopelistDomainList", JsonUtil.buildNormalBinder().toJson(newDisDgoodsScopelistDomainList));
        disDpriceMap.put("flag", true);
        this.internalInvoke(ApiCodeEnums.saveOrUpdateDgoodsScopelistBatch.getApiCode(), disDpriceMap);
    }

    public List<DisDgoodsScopelist> queryDisDgoodsScopelist(String tenantCode, String dgoodsScopelistValue, String dgoodsCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsScopelistValue", dgoodsScopelistValue);
        map.put("dgoodsCode", dgoodsCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDgoodsScopelistPage.getApiCode(), invokeMap, DisDgoodsScopelist.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".synbrand.queryDisDgoodsScopelist.null", (Object)((Object)map).toString());
            return null;
        }
        return queryResutl.getList();
    }

    public boolean checkExistForDgoodsSc(String channelCode, String dgoodsScopelistType, String dgoodsScopelistValue, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dgoodsScopelistType", dgoodsScopelistType);
        map.put("dgoodsScopelistValue", dgoodsScopelistValue);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDgoodsScopelistPage.getApiCode(), queryMap, DisDgoodsScopelist.class);
        return queryResutl != null && !ListUtil.isEmpty((Collection)queryResutl.getList());
    }

    public DisDgoodsScopelist getDgoodsSc(String channelCode, String dgoodsScopelistType, String dgoodsScopelistValue, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dgoodsScopelistType", dgoodsScopelistType);
        map.put("dgoodsScopelistValue", dgoodsScopelistValue);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDgoodsScopelistPage.getApiCode(), queryMap, DisDgoodsScopelist.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getDgoodsSc.null");
            return null;
        }
        return (DisDgoodsScopelist)queryResutl.getList().get(0);
    }

    public String getBrandCodeByEcode(DisDgoodsScopelistDomain newDisDgoodsScopelistDomain, String userinfoCode) {
        DisChannel disChannel = this.getChannelDomain(userinfoCode, "root", newDisDgoodsScopelistDomain.getTenantCode());
        if (disChannel == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", newDisDgoodsScopelistDomain.getTenantCode());
        paramMap.put("brandEocode", newDisDgoodsScopelistDomain.getDgoodsScopelistValue());
        paramMap.put("channelCode", disChannel.getChannelCode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryBrandPage.getApiCode(), invokeMap, RsBrandDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkBrandInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return ((RsBrandDomain)jsonToObject.getList().get(0)).getBrandCode();
    }

    public String getUserinfoCodeByDCode(String departOcode, String tenantCode) {
        if (StringUtils.isBlank((String)departOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgDepart orgDepart = this.getDepartInfo(departOcode, tenantCode);
        if (null == orgDepart) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", orgDepart.getDepartCode());
        map.put("userinfoQuality", "depart");
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getUserinfoCodeByDCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public List<Map<String, String>> getOrgNum(String tenantCode, String memberMcode) {
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        String cacheValue = this.getCacheValue(tenantCode, memberMcode, "orgNum", "getOrgNum");
        if (StringUtils.isBlank((String)cacheValue)) {
            return null;
        }
        if (!cacheValue.contains(",")) {
            paramList.add((Map<String, String>)((Object)cacheValue));
            return paramList;
        }
        String[] split = cacheValue.split(",");
        HashMap<String, String> orgMap = null;
        for (int i = 0; i <= split.length - 1; ++i) {
            orgMap = new HashMap<String, String>();
            orgMap.put("org_num", split[i]);
            paramList.add(orgMap);
        }
        return paramList;
    }

    private String getCacheValue(String tenantCode, String memberMcode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)memberMcode)) {
            flagSettingType = flagSettingType + "-" + memberMcode;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error(this.SYS_CODE + ".getUrl", (Object)(tenantCode + "=" + flagSettingType + "=" + flagSettingCode + "=" + value));
        return value;
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getReCode(String tenantCode, String userinfoOpcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOpcode", userinfoOpcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getReCode", (Object)((Object)invokeMap).toString());
            return "-1";
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    @Override
    public String synGoodsMprice(String userinfoCode, String tenantCode, String goodsListStr, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return DmUtil.getMap("error", "-1", "tenantCode\u6570\u636e\u4e3a\u7a7a", null, false);
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        String memberCode = umUserinfoDomainBean.getUserinfoCode();
        String memberName = umUserinfoDomainBean.getUserinfoCompname();
        Httpfacade httpfacade = new Httpfacade(url);
        MpMpriceRequest storeRequest = new MpMpriceRequest();
        storeRequest.setTopHttpMethod("");
        List<MpMpriceDomain> mpMpriceDomainList = null;
        if (StringUtils.isNotBlank((String)goodsListStr)) {
            mpMpriceDomainList = (List<MpMpriceDomain>)JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, MpMpriceDomain.class);
        } else {
            MpMpriceResponse execute = httpfacade.execute(storeRequest);
            mpMpriceDomainList = execute.getMpMpriceDomainList();
        }
        if (ListUtil.isNotEmpty(mpMpriceDomainList)) {
            for (MpMpriceDomain mpMpriceDomain : mpMpriceDomainList) {
                if (Boolean.valueOf(dmsId).booleanValue()) {
                    MpMpricelistDomain mpMpricelistDomain = new MpMpricelistDomain();
                    mpMpricelistDomain.setTenantCode(tenantCode);
                    mpMpricelistDomain.setMemberMcode(memberCode);
                    mpMpricelistDomain.setMemberMname(memberName);
                    mpMpricelistDomain.setMemberName(mpMpriceDomain.getMpriceOpcodeStr());
                    HashMap<String, String> mpMpriceListMap = new HashMap<String, String>();
                    mpMpriceListMap.put("mpMpricelistDomain", JsonUtil.buildNormalBinder().toJson((Object)mpMpricelistDomain));
                    this.internalInvoke("mpr.mpMpricelist.saveMpMpricelist", mpMpriceListMap);
                }
                mpMpriceDomain.setMemberCode(memberCode);
                mpMpriceDomain.setMemberName(memberName);
                mpMpriceDomain.setTenantCode(tenantCode);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("tenantCode", tenantCode);
                paramMap.put("mpriceOpcode", mpMpriceDomain.getMpriceOpcode());
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
                QueryResult quresult = this.getQueryResutl("mpr.mpMprice.queryMpMpricePage", invokeMap, MpMpriceDomain.class);
                if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
                    this.logger.error("======\u4fdd\u5b58Conf======", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)mpMpriceDomain));
                    HashMap<String, String> mpMpriceMap = new HashMap<String, String>();
                    mpMpriceMap.put("mpMpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)mpMpriceDomain));
                    this.internalInvoke("mpr.mpMprice.saveMpMprice", mpMpriceMap);
                    continue;
                }
                MpMpriceDomain oldMpMpriceDomain = (MpMpriceDomain)quresult.getList().get(0);
                oldMpMpriceDomain.setMpriceName(mpMpriceDomain.getMpriceName());
                oldMpMpriceDomain.setMpricePrice(mpMpriceDomain.getMpricePrice());
                oldMpMpriceDomain.setMpriceOpcode(mpMpriceDomain.getMpriceOpcode());
                oldMpMpriceDomain.setMpriceWeight(mpMpriceDomain.getMpriceWeight());
                HashMap<String, String> updateMpMpriceMap = new HashMap<String, String>();
                updateMpMpriceMap.put("mpMpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)oldMpMpriceDomain));
                this.internalInvoke("mpr.mpMprice.updateMpMprice", updateMpMpriceMap);
                HashMap<String, String> paramConfMap = new HashMap<String, String>();
                paramConfMap.put("tenantCode", tenantCode);
                paramConfMap.put("mpriceCode", oldMpMpriceDomain.getMpriceCode());
                HashMap<String, String> invokeConfMap = new HashMap<String, String>();
                invokeConfMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramConfMap));
                QueryResult quresultConf = this.getQueryResutl("mpr.mpMprice.queryMpMpriceConfPage", invokeConfMap, MpMpriceConfDomain.class);
                this.logger.error("======\u67e5\u8be2Conf======", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)quresultConf));
                if (quresultConf != null && ListUtil.isNotEmpty((Collection)quresultConf.getList())) {
                    ArrayList<Integer> mpriceConfIds = new ArrayList<Integer>();
                    for (MpMpriceConfDomain mpMpriceConfDomain : quresultConf.getList()) {
                        mpriceConfIds.add(mpMpriceConfDomain.getMpriceConfId());
                    }
                    if (ListUtil.isNotEmpty(mpriceConfIds)) {
                        this.logger.error("======\u5220\u9664Conf======", null);
                        HashMap mpMpriceMapConf = new HashMap();
                        mpMpriceMapConf.put("mpriceConfIds", JsonUtil.buildNormalBinder().toJson(mpriceConfIds));
                        this.internalInvoke("mpr.mpMprice.deleteMpMpriceConfByIds", mpMpriceMapConf);
                    }
                    if (ListUtil.isNotEmpty(mpMpriceDomain.getMpMpriceConfDomainList())) {
                        for (MpMpriceConfDomain mpMpriceConfDomain : mpMpriceDomain.getMpMpriceConfDomainList()) {
                            mpMpriceConfDomain.setMpriceCode(((MpMpriceDomain)quresult.getList().get(0)).getMpriceCode());
                            mpMpriceConfDomain.setTenantCode(((MpMpriceDomain)quresult.getList().get(0)).getTenantCode());
                        }
                        this.logger.error("======\u4fdd\u5b58Conf======", null);
                        HashMap<String, String> mpMpriceMap = new HashMap<String, String>();
                        mpMpriceMap.put("mpMpriceConfDomainList", JsonUtil.buildNormalBinder().toJson(mpMpriceDomain.getMpMpriceConfDomainList()));
                        this.internalInvoke("mpr.mpMprice.saveMpMpriceConfBatch", mpMpriceMap);
                    }
                }
                HashMap<String, String> paramMenfMap = new HashMap<String, String>();
                paramMenfMap.put("tenantCode", tenantCode);
                paramMenfMap.put("mpriceCode", oldMpMpriceDomain.getMpriceCode());
                HashMap<String, String> invokeMenMap = new HashMap<String, String>();
                invokeMenMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMenfMap));
                QueryResult quresultMen = this.getQueryResutl("mpr.mpMprice.queryMpMpriceMemPage", invokeMenMap, MpMpriceMemDomain.class);
                this.logger.error("======\u67e5\u8be2Mem======", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)quresultMen));
                if (quresultMen == null || !ListUtil.isNotEmpty((Collection)quresultMen.getList())) continue;
                ArrayList<Integer> mpriceMemIds = new ArrayList<Integer>();
                for (MpMpriceMemDomain mpMpriceMemDomain : quresultMen.getList()) {
                    mpriceMemIds.add(mpMpriceMemDomain.getMpriceMemId());
                }
                if (ListUtil.isNotEmpty(mpriceMemIds)) {
                    this.logger.error("======\u5220\u9664Mem======", null);
                    HashMap mpMpriceMapMen = new HashMap();
                    mpMpriceMapMen.put("mpriceMemIds", JsonUtil.buildNormalBinder().toJson(mpriceMemIds));
                    this.internalInvoke("mpr.mpMprice.deleteMpMpriceMemByIds", mpMpriceMapMen);
                }
                if (!ListUtil.isNotEmpty(mpMpriceDomain.getMpMpriceMemDomainList())) continue;
                for (MpMpriceMemDomain mpMpriceMemDomain : mpMpriceDomain.getMpMpriceMemDomainList()) {
                    mpMpriceMemDomain.setMpriceCode(((MpMpriceDomain)quresult.getList().get(0)).getMpriceCode());
                    mpMpriceMemDomain.setTenantCode(((MpMpriceDomain)quresult.getList().get(0)).getTenantCode());
                }
                this.logger.error("======\u4fdd\u5b58Mem======", null);
                HashMap<String, String> mpMpriceMap = new HashMap<String, String>();
                mpMpriceMap.put("mpMpriceMemDomainList", JsonUtil.buildNormalBinder().toJson(mpMpriceDomain.getMpMpriceMemDomainList()));
                this.internalInvoke("mpr.mpMprice.saveMpMpriceMemBatch", mpMpriceMap);
            }
        }
        return null;
    }
}

