/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.DisChannel;
import com.yqbsoft.laser.service.exdate.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.exdate.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.exdate.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.RsClassTreeRequest;
import com.yqbsoft.laser.service.exdate.facade.request.RsGoodsClassRequest;
import com.yqbsoft.laser.service.exdate.facade.response.RsClassTreeResponse;
import com.yqbsoft.laser.service.exdate.facade.response.RsGoodsClassResponse;
import com.yqbsoft.laser.service.exdate.service.RsClassTreeService;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class RsClassTreeServiceImpl
extends BaseServiceImpl
implements RsClassTreeService {
    private String SYS_CODE = "exdata.RsClassTreeServiceImpl";

    @Override
    public String queryclassTree(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2021122100000001";
        }
        this.logger.error("====queryclassTree===\u5206\u7c7b\u62c9\u53d6\u5f00\u59cb\u4e86=");
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        RsClassTreeRequest classTreeRequest = new RsClassTreeRequest();
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        Httpfacade httpfacade = new Httpfacade(url);
        classTreeRequest.setTopHttpMethod(UrlEnums.classTreeAll.getUrlMethed());
        RsClassTreeResponse execute = httpfacade.execute(classTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        if (ListUtil.isEmpty(rsClasstreeList)) {
            return ResultEnums.error.getCode();
        }
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeList) {
            if ("0".equals(rsClasstreeDomain.getParentCode())) {
                rsClasstreeDomain.setClasstreeParentcode("-1");
            }
            rsClasstreeDomain.setTenantCode(tenantCode);
            rsClasstreeDomain.setMemberCode(umUserinfoDomainBean.getUserinfoCode());
            rsClasstreeDomain.setMemberName(umUserinfoDomainBean.getUserinfoCompname());
            this.checkClasstree(rsClasstreeDomain, tenantCode);
            this.saveClasstree(rsClasstreeDomain, tenantCode);
            this.saveRsPntree(rsClasstreeDomain);
        }
        Httpfacade httpfacadeGoodsClass = new Httpfacade(url);
        RsGoodsClassRequest goodsClassRequest = new RsGoodsClassRequest();
        goodsClassRequest.setTopHttpMethod(UrlEnums.classTreeAll.getUrlMethed());
        RsGoodsClassResponse rsGoodsClassexecute = httpfacadeGoodsClass.execute(goodsClassRequest);
        List<RsGoodsClassDomain> rsGoodsClassList = rsGoodsClassexecute.getRsGoodsClassList();
        for (RsGoodsClassDomain rsGoodsClassDomain : rsGoodsClassList) {
            if ("0".equals(rsGoodsClassDomain.getParentCode())) {
                rsGoodsClassDomain.setGoodsClassParentcode("-1");
            }
            rsGoodsClassDomain.setTenantCode(tenantCode);
            rsGoodsClassDomain.setGoodsClassHide("0");
            rsGoodsClassDomain.setMemberCode(umUserinfoDomainBean.getUserinfoCode());
            rsGoodsClassDomain.setMemberName(umUserinfoDomainBean.getUserinfoCompname());
            rsGoodsClassDomain.setChannelCode("B2Bchannel");
            rsGoodsClassDomain.setChannelName("B2B\u6e20\u9053");
            rsGoodsClassDomain.setMemberName(umUserinfoDomainBean.getUserinfoCompname());
            this.checkGoodsClass(rsGoodsClassDomain, tenantCode);
        }
        return ResultEnums.success.getCode();
    }

    private void saveClasstree(RsClasstreeDomain rsClasstreeDomain, String tenantCode) {
        String memberCode = rsClasstreeDomain.getMemberCode();
        String memberName = rsClasstreeDomain.getMemberName();
        Httpfacade httpfacade = new Httpfacade(FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url"));
        RsClassTreeRequest classTreeRequest = new RsClassTreeRequest();
        classTreeRequest.setTopHttpMethod(UrlEnums.classTree.getUrlMethed());
        classTreeRequest.setParentCode(rsClasstreeDomain.getClasstreeEocode());
        RsClassTreeResponse execute = httpfacade.execute(classTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        this.logger.error(this.SYS_CODE + "=======\u5b50\u96c6=====rsClasstreeList===========", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsClasstreeList));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("classtreeEocode", rsClasstreeDomain.getClasstreeEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryClasstreePage.getApiCode(), invokeSendmap, RsClasstreeDomain.class);
        this.logger.error(this.SYS_CODE + "=======\u8fd4\u56de\u7ed3\u679c=====rsClasstreeList===========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToObject));
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            for (RsClasstreeDomain rsClasstree : rsClasstreeList) {
                rsClasstree.setClasstreeParentcode(((RsClasstreeDomain)jsonToObject.getList().get(0)).getClasstreeCode());
                rsClasstree.setTenantCode(tenantCode);
                rsClasstree.setMemberCode(memberCode);
                rsClasstree.setMemberName(memberName);
                this.checkClasstree(rsClasstree, tenantCode);
                this.saveClasstree(rsClasstree, tenantCode);
            }
        }
    }

    private void saveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String tenantCode) {
        String memberCode = rsGoodsClassDomain.getMemberCode();
        String memberName = rsGoodsClassDomain.getMemberName();
        Httpfacade httpfacade = new Httpfacade(FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url"));
        RsGoodsClassRequest goodsClassRequest = new RsGoodsClassRequest();
        goodsClassRequest.setTopHttpMethod(UrlEnums.classTree.getUrlMethed());
        goodsClassRequest.setParentCode(rsGoodsClassDomain.getGoodsClassEocode());
        RsGoodsClassResponse execute = httpfacade.execute(goodsClassRequest);
        List<RsGoodsClassDomain> rsGoodsClassList = execute.getRsGoodsClassList();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("goodsClassEocode", rsGoodsClassDomain.getGoodsClassEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryGoodsClassPage.getApiCode(), invokeSendmap, RsGoodsClassDomain.class);
        this.logger.error(this.SYS_CODE + "=======\u8fd4\u56de\u7ed3\u679c=====saveGoodsClass===========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToObject));
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            for (RsGoodsClassDomain goodsClass : rsGoodsClassList) {
                goodsClass.setGoodsClassParentcode(((RsGoodsClassDomain)jsonToObject.getList().get(0)).getClasstreeCode());
                goodsClass.setTenantCode(tenantCode);
                goodsClass.setMemberCode(memberCode);
                goodsClass.setMemberName(memberName);
                goodsClass.setGoodsClassHide("0");
                goodsClass.setChannelCode("B2Bchannel");
                goodsClass.setChannelName("B2B\u6e20\u9053");
                this.checkGoodsClass(goodsClass, tenantCode);
                this.saveGoodsClass(goodsClass, tenantCode);
            }
        }
    }

    public void checkClasstree(RsClasstreeDomain rsClasstreeDomain, String tenantCode) throws ApiException {
        this.logger.error("====checkClasstree=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        if (rsClasstreeDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkClassInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("classtreeEocode", rsClasstreeDomain.getClasstreeEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryClasstreePage.getApiCode(), invokeSendmap, RsClasstreeDomain.class);
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            RsClasstreeDomain rsClasstreeDomain1 = (RsClasstreeDomain)jsonToObject.getList().get(0);
            rsClasstreeDomain1.setClasstreeName(rsClasstreeDomain.getClasstreeName());
            HashMap<String, String> classTreeMap = new HashMap<String, String>();
            classTreeMap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain1));
            this.internalInvoke(ApiCodeEnums.updateClasstree.getApiCode(), classTreeMap);
        } else {
            this.logger.error(this.SYS_CODE + "=======checkClasstree=======", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsClasstreeDomain));
            HashMap<String, String> classTreeMap = new HashMap<String, String>();
            classTreeMap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
            String string = this.internalInvoke(ApiCodeEnums.saveClasstree.getApiCode(), classTreeMap);
        }
    }

    public void checkGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String tenantCode) throws ApiException {
        if (rsGoodsClassDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkClassInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        paramMap.put("goodsClassEocode", rsGoodsClassDomain.getGoodsClassEocode());
        paramMap.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryGoodsClassPage.getApiCode(), invokeSendmap, RsGoodsClassDomain.class);
        this.logger.error("====checkGoodsClass==\u524d\u53f0\u5206\u7c7b======", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToObject));
        if (ListUtil.isNotEmpty((Collection)jsonToObject.getList())) {
            RsGoodsClassDomain goodsClassDomain = (RsGoodsClassDomain)jsonToObject.getList().get(0);
            goodsClassDomain.setGoodsClassName(rsGoodsClassDomain.getGoodsClassName());
            HashMap<String, String> classTreeMap = new HashMap<String, String>();
            classTreeMap.put("rsGoodsClassDomain", JsonUtil.buildNormalBinder().toJson((Object)goodsClassDomain));
            this.internalInvoke(ApiCodeEnums.updateGoodsClass.getApiCode(), classTreeMap);
        } else {
            this.logger.error(this.SYS_CODE + "=======rsGoodsClassDomain=======", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsGoodsClassDomain));
            HashMap<String, String> classTreeMap = new HashMap<String, String>();
            classTreeMap.put("rsGoodsClassDomain", JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassDomain));
            String string = this.internalInvoke(ApiCodeEnums.saveGoodsClass.getApiCode(), classTreeMap);
        }
    }

    private void makeChannel(RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            return;
        }
        String memberCode = goodsClassDomain.getMemberCode();
        if (StringUtils.isBlank((String)memberCode)) {
            return;
        }
        String tenantCode = "2021122100000001";
        String goodsClass = "B2B";
        DisChannel disChannel = null;
        if (StringUtils.isNotBlank((String)goodsClass)) {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"GoodsClasscode-tenantCode", (String)(memberCode + "-" + goodsClass + "-6-" + tenantCode), DisChannel.class);
        }
        if (null == disChannel && null == (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode), DisChannel.class))) {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class);
        }
        if (null == disChannel) {
            return;
        }
        goodsClassDomain.setChannelCode(disChannel.getChannelCode());
        goodsClassDomain.setChannelName(disChannel.getChannelName());
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    private void saveRsPntree(RsClasstreeDomain rsClasstreeDomain) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(rsClasstreeDomain.getClasstreeName());
        rsPntreeDomain.setTenantCode("2021122100000001");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", "2021122100000001");
        paramMap.put("pntreeName", rsClasstreeDomain.getClasstreeName());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("rs.pntree.queryPntreePage", invokeMap, RsPntreeDomain.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            HashMap<String, String> PntreeMap = new HashMap<String, String>();
            PntreeMap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
            this.internalInvoke("rs.pntree.savePntree", PntreeMap);
        }
    }

    public static void main(String[] args) {
        Httpfacade httpfacadeGoodsClass = new Httpfacade("http://md.aiyingtong.com.cn");
        RsGoodsClassRequest goodsClassRequest = new RsGoodsClassRequest();
        goodsClassRequest.setTopHttpMethod(UrlEnums.classTreeAll.getUrlMethed());
        RsGoodsClassResponse rsGoodsClassexecute = httpfacadeGoodsClass.execute(goodsClassRequest);
        List<RsGoodsClassDomain> rsGoodsClassList = rsGoodsClassexecute.getRsGoodsClassList();
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson(rsGoodsClassList));
    }
}

