/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketParam;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketResult;
import com.yqbsoft.laser.service.exdate.domain.WalletDillDomain;
import com.yqbsoft.laser.service.exdate.domain.WalletResponse;
import com.yqbsoft.laser.service.exdate.service.YlUnionPayWalletService;
import com.yqbsoft.laser.service.exdate.test.TransferDemoMainTest;
import com.yqbsoft.laser.service.exdate.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class YlUnionPayWalletServiceImpl
extends BaseServiceImpl
implements YlUnionPayWalletService {
    public static final String SYS_CODE = "exdata.YlUnionPayWalletServiceImpl";

    @Override
    public String saveWalletRegistration(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRegistration" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setJumpType("1");
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        voucherApplyTicketParam.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.getTicket(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return ResultEnums.error.getCode();
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)ticket);
    }

    @Override
    public String saveWalletWithdrawal(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletWithdrawal" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return JbsUtils.getErrorMap("\u67e5\u8be2\u7528\u6237\u94b1\u5305", JsonUtil.buildNormalBinder().toJson((Object)ticket));
        }
        VoucherApplyTicketParam voucherApplyTicketParamJson = new VoucherApplyTicketParam();
        voucherApplyTicketParamJson.setJumpType("6");
        voucherApplyTicketParamJson.setWalletId(ticket.getWalletId());
        voucherApplyTicketParamJson.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticketMap = null;
        try {
            ticketMap = TransferDemoMainTest.getTicket(voucherApplyTicketParamJson, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticketMap.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticketMap) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParamJson));
            return JbsUtils.getErrorMap("\u63d0\u73b0\u63a5\u53e3\u62a5\u9519", JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
    }

    public static void main(String[] args) {
        String appId = "5ed70f9c2c07873f0aa9e455560bc553";
        String sign_alg = "SHA1withRSA";
        String mct_private_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\A0010000-0014.p12";
        String mct_private_key_pwd = "123456";
        String fchannelApiUrl = "https://testapi.gnete.com:9083/routejson";
        String gnete_gateway_public_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\2048-cfca.der";
        String issr_id = "A0010000-0014";
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId("20000210398114");
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(ticket.getWalletId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("walletId", ticket.getWalletId());
        param.put("startDate", "2022-02-01");
        param.put("endDate", "2022-04-11");
        param.put("pageType", "0");
        param.put("pageNumber", "1");
        param.put("pageSize", "10");
        WalletResponse walletResponse = null;
        try {
            walletResponse = TransferDemoMainTest.queryBillInfo(param, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String msgBody = walletResponse.getMsgBody();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(walletResponse.getMsgBody(), String.class, Object.class);
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)walletResponse));
        if (MapUtils.isNotEmpty((Map)jsonToMap)) {
            List transList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap.get("transList")), WalletDillDomain.class);
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)transList));
        }
        System.out.println(ticket);
    }

    @Override
    public List<VdFaccountInfo> queryWalletPay(Map<String, Object> map) throws ApiException {
        ArrayList<VdFaccountInfo> vdFaccountInfosList = new ArrayList<VdFaccountInfo>();
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo();
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        String tenantCode = (String)map.get("tenantCode");
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        boolean flag = false;
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ticket.getRspCode().toString().equals("30063")) {
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            flag = true;
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        long queryAcctBal = 0L;
        try {
            queryAcctBal = TransferDemoMainTest.queryAcctBal(ticket.getWalletId(), appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (new BigDecimal(queryAcctBal).compareTo(BigDecimal.ZERO) == 0) {
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            flag = true;
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        BigDecimal divide = new BigDecimal(queryAcctBal).divide(BigDecimal.valueOf(100L));
        flag = true;
        vdFaccountInfo.setRegister(flag);
        vdFaccountInfo.setFaccountAmount(divide);
        vdFaccountInfosList.add(vdFaccountInfo);
        return vdFaccountInfosList;
    }

    @Override
    public String saveWalletRecharge(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRecharge" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRecharge.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return JbsUtils.getErrorMap("\u67e5\u8be2\u7528\u6237\u94b1\u5305", JsonUtil.buildNormalBinder().toJson((Object)ticket));
        }
        VoucherApplyTicketParam voucherApplyTicketParamJson = new VoucherApplyTicketParam();
        voucherApplyTicketParamJson.setJumpType("5");
        voucherApplyTicketParamJson.setWalletId(ticket.getWalletId());
        voucherApplyTicketParamJson.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticketMap = null;
        try {
            ticketMap = TransferDemoMainTest.getTicket(voucherApplyTicketParamJson, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticketMap.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticketMap) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParamJson));
            return JbsUtils.getErrorMap("saveWalletRecharge.\u5145\u503c\u63a5\u53e3\u62a5\u9519", JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
    }

    @Override
    public QueryResult<WalletDillDomain> queryWalletBillInfo(String extUserId, String tenantCode, Map<String, String> map) throws ApiException {
        if (MapUtils.isEmpty(map) || StringUtils.isBlank((String)map.get("startDate")) || StringUtils.isBlank((String)map.get("endDate")) || StringUtils.isBlank((String)map.get("extUserId"))) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String fchannelApiUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRecharge.extUserId is null");
            return null;
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(extUserId);
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return null;
        }
        System.out.println(ticket.getWalletId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("walletId", ticket.getWalletId());
        param.put("startDate", map.get("startDate"));
        param.put("endDate", map.get("endDate"));
        if (StringUtils.isNotBlank((String)map.get("pageType"))) {
            param.put("pageType", map.get("pageType"));
        }
        if (StringUtils.isNotBlank((String)map.get("pageNumber"))) {
            param.put("pageNumber", map.get("pageNumber"));
        }
        if (StringUtils.isNotBlank((String)map.get("pageSize"))) {
            param.put("pageSize", map.get("pageSize"));
        }
        WalletResponse walletResponse = null;
        try {
            walletResponse = TransferDemoMainTest.queryBillInfo(param, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String msgBody = walletResponse.getMsgBody();
        QueryResult walletDillDomainQueryResult = new QueryResult();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(walletResponse.getMsgBody(), String.class, Object.class);
        if (MapUtils.isNotEmpty((Map)jsonToMap)) {
            List transList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap.get("transList")), WalletDillDomain.class);
            walletDillDomainQueryResult.setList(transList);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(Integer.parseInt(jsonToMap.get("totalSize").toString()));
            walletDillDomainQueryResult.setPageTools((SupPageTools)pageTools);
            return walletDillDomainQueryResult;
        }
        return null;
    }

    private static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

