/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.test;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import sun.misc.BASE64Encoder;

public class CryptoUtils {
    public static String sign(String algorithm, String content, PrivateKey priKey, String charset) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(priKey);
            signature.update(content.getBytes(charset));
            return Hex.toHexString((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySign(String algorithm, String content, String sign, PublicKey pubKey, String charset) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(charset));
            return signature.verify(Hex.decode((String)sign));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey initPublicKeyFromHexString(String hexString) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Hex.decode((String)hexString));
        try {
            return KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey initPublicKeyFromBase64String(String base64String) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode((String)base64String));
        try {
            return KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey initPublicKeyFromFile(File file) {
        try (FileInputStream bais = new FileInputStream(file);){
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            X509Certificate Cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            PublicKey pk = Cert.getPublicKey();
            BASE64Encoder bse = new BASE64Encoder();
            PublicKey publicKey = pk;
            return publicKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey initPrivateKeyFromHexString(String hexString) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Hex.decode((String)hexString));
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey initPrivateKeyFromBase64String(String base64String) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode((String)base64String));
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey initPrivateKeyFromFile(File file, String pwd) {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            FileInputStream fin = new FileInputStream(file);
            ks.load(fin, pwd.toCharArray());
            return (PrivateKey)ks.getKey(ks.aliases().nextElement(), pwd.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

