/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.BsAreaReDomain;
import com.yqbsoft.laser.service.exdate.domain.BsProvinceReDomain;
import com.yqbsoft.laser.service.exdate.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.exdate.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.exdate.domain.CtCustrelDomain;
import com.yqbsoft.laser.service.exdate.domain.CtCustrelEmpDomain;
import com.yqbsoft.laser.service.exdate.domain.DisChannel;
import com.yqbsoft.laser.service.exdate.domain.DisChannelDomain;
import com.yqbsoft.laser.service.exdate.domain.DisDgoods;
import com.yqbsoft.laser.service.exdate.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgDepart;
import com.yqbsoft.laser.service.exdate.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgDepartempDomain;
import com.yqbsoft.laser.service.exdate.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.exdate.domain.UmAddressDomain;
import com.yqbsoft.laser.service.exdate.domain.UmQualityQtypeDomain;
import com.yqbsoft.laser.service.exdate.domain.UmUser;
import com.yqbsoft.laser.service.exdate.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.exdate.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.exdate.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.exdate.domain.WhWarehouse;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.AydStoreInfoRequest;
import com.yqbsoft.laser.service.exdate.facade.response.AydStoreInfoResponse;
import com.yqbsoft.laser.service.exdate.model.CrpRecharge;
import com.yqbsoft.laser.service.exdate.model.UmQualityQtype;
import com.yqbsoft.laser.service.exdate.model.VdFaccountOuterDtDomain;
import com.yqbsoft.laser.service.exdate.service.UserinfoService;
import com.yqbsoft.laser.service.exdate.utils.DmUtil;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.exdate.utils.HttpRequestUtil;
import com.yqbsoft.laser.service.exdate.utils.K3CloundConfig;
import com.yqbsoft.laser.service.exdate.utils.WebUtils;
import com.yqbsoft.laser.service.exdate.utils.XmlUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class UserinfoServiceImpl
extends BaseServiceImpl
implements UserinfoService {
    private String SYS_CODE = "exdata.UserinfoServiceImpl";
    private static String PGSup = "80001";
    private int OneDayMillis = 86400000;

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    private String getDate(String type, String userinfoCode, String tenantCode) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "2002-01-01 12:00:00";
    }

    @Override
    public String synSupplierInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synSupplierInfo.null");
            return ResultEnums.error.getCode();
        }
        List umUserinfoDomainBeanList = null;
        if (ListUtil.isEmpty(umUserinfoDomainBeanList)) {
            this.logger.error(this.SYS_CODE + ".synSupplierInfo.umUserinfoDomainBeanList");
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : umUserinfoDomainBeanList) {
            boolean b = this.checkSupplierInfo(umUserinfoDomainBean, tenantCode);
            if (b) {
                this.updateSupplierInfo(umUserinfoDomainBean, tenantCode);
            }
            umUserinfoDomainBean.setTenantCode(tenantCode);
            paramMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            this.internalInvoke(ApiCodeEnums.saveUserinfo.getApiCode(), paramMap);
        }
        return ResultEnums.success.getCode();
    }

    public boolean checkSupplierInfo(UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error(this.SYS_CODE + ".checkSupplierInfo.null");
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", umUserinfoDomainBean.getUserCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".checkSupplierInfo.queryResult", (Object)((Object)paramMap).toString());
            return false;
        }
        return true;
    }

    public void updateSupplierInfo(UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error(this.SYS_CODE + ".updateSupplierInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", umUserinfoDomainBean.getUserCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".updateSupplierInfo.queryResult", (Object)((Object)paramMap).toString());
            return;
        }
        HashMap<String, String> sendMapParam = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean1 : queryResult.getList()) {
            umUserinfoDomainBean1.setUserinfoCompname(umUserinfoDomainBean.getUserinfoCompname());
            umUserinfoDomainBean1.setUserCode(umUserinfoDomainBean.getUserCode());
            umUserinfoDomainBean1.setUserName(umUserinfoDomainBean.getUserName());
            umUserinfoDomainBean1.setCompanyType(umUserinfoDomainBean.getCompanyType());
            sendMapParam.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean1));
            this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), sendMapParam);
        }
    }

    @Override
    public String synStoreInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synStoreInfo.null");
            return ResultEnums.error.getCode();
        }
        List umAddressDomainList = null;
        List umUserinfoDomainBeanList = null;
        if (ListUtil.isEmpty(umAddressDomainList)) {
            this.logger.error(this.SYS_CODE + ".synStoreInfo.umAddressDomainList");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean retailInfo = this.getRetailInfo(tenantCode, userinfoCode);
        if (retailInfo == null) {
            this.logger.error(this.SYS_CODE + ".synStoreInfo.retailInfo.null", (Object)("tenantCode is" + tenantCode));
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> phoneMap = new HashMap<String, String>();
        for (UmUserDomainBean umUserinfoDomainBean : umUserinfoDomainBeanList) {
            UmUserinfoDomainBean oldUmUserinfoDomainBean = this.checkStoreInfo(umUserinfoDomainBean);
            if (null != oldUmUserinfoDomainBean) {
                this.updateStoreInfo(umUserinfoDomainBean, oldUmUserinfoDomainBean);
                continue;
            }
            if (StringUtils.isBlank((String)((String)phoneMap.get(umUserinfoDomainBean.getUserTel())))) {
                UmUser umUser = this.queryUmUserByUserPhone(tenantCode, umUserinfoDomainBean.getUserTel());
                if (null == umUser) {
                    umUserinfoDomainBean.setUserPhone(umUserinfoDomainBean.getUserTel());
                }
                phoneMap.put(umUserinfoDomainBean.getUserTel(), umUserinfoDomainBean.getUserTel());
            }
            umUserinfoDomainBean.setUserinfoType(2);
            umUserinfoDomainBean.setDataState(0);
            umUserinfoDomainBean.setUserinfoDataState(4);
            umUserinfoDomainBean.setTenantCode(tenantCode);
            umUserinfoDomainBean.setUserinfoParentCode(retailInfo.getUserinfoCode());
            umUserinfoDomainBean.setUserinfoParentName(retailInfo.getUserinfoCompname());
            ArrayList<UmUserinfoQuaDomain> umUserinfoQuaDomainList = new ArrayList<UmUserinfoQuaDomain>();
            UmUserinfoQuaDomain umUserinfoQuaDomain = new UmUserinfoQuaDomain();
            umUserinfoQuaDomainList.add(umUserinfoQuaDomain);
            umUserinfoQuaDomain.setUserinfoQuaKey("levelListCode_dealer");
            umUserinfoQuaDomain.setUserinfoQuaVaule("100055_1");
            umUserinfoDomainBean.setUmUserinfoQuaDomainList(umUserinfoQuaDomainList);
            HashMap<String, String> storeMap = new HashMap<String, String>();
            storeMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            String userinfoCodeNow = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), storeMap);
            HashMap<String, String> saveAddressMap = new HashMap<String, String>();
            for (UmAddressDomain umAddressDomain : umAddressDomainList) {
                if (!umAddressDomain.getUserCode().equals(umUserinfoDomainBean.getUserinfoOcode())) continue;
                umAddressDomain.setTenantCode(tenantCode);
                umAddressDomain.setUserCode(userinfoCodeNow);
                umAddressDomain.setAddressDefault("1");
                saveAddressMap.put("umAddressDomain", JsonUtil.buildNonNullBinder().toJson((Object)umAddressDomain));
                this.internalInvoke(ApiCodeEnums.saveAddress.getApiCode(), saveAddressMap);
            }
        }
        return ResultEnums.success.getCode();
    }

    public void updateDisByStore(List<UmUserDomainBean> umUserDomainBeanList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            map.put("userinfoOcode", umUserDomainBean.getUserinfoOcode());
            map.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
            invokeMap.put("map", map);
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
            if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error(this.SYS_CODE + ".synDepartInfo.updateDisChannel", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)quresult.getList().get(0);
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            HashMap<String, String> channelMap = new HashMap<String, String>();
            channelMap.put("memberCode", userinfoCode);
            channelMap.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeChannelMap = new HashMap<String, HashMap<String, String>>();
            invokeChannelMap.put("map", channelMap);
            QueryResult channelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
            if (channelQueryResult == null || ListUtil.isEmpty((Collection)channelQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".synDepartInfo.updateDisChannel", (Object)("invokeChannelMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            DisChannel disChannel = (DisChannel)channelQueryResult.getList().get(0);
            disChannel.setMemberCcode(umUserDomainBean.getUserinfoCode());
            disChannel.setMemberCname(umUserDomainBean.getUserinfoCompname());
            disChannel.setMemberMcode(umUserDomainBean.getUserinfoParentCode());
            disChannel.setMemberCode(umUserDomainBean.getDepartCode());
            DisChannelDomain disChannelDomain = new DisChannelDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disChannelDomain, (Object)disChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("disChannelDomain", JsonUtil.buildNonNullBinder().toJson((Object)disChannelDomain));
            this.internalInvoke(ApiCodeEnums.updateChannel.getApiCode(), updateMap);
            this.updateDgoods(umUserinfoDomainBean.getTenantCode(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoParentCode());
        }
    }

    public UmUserinfoDomainBean checkStoreInfo(UmUserDomainBean umUserinfoDomainBean) throws ApiException {
        if (umUserinfoDomainBean == null) {
            this.logger.error(this.SYS_CODE + ".checkStoreInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("qualityQtype", "dealer");
        paramMap.put("userinfoOcode", umUserinfoDomainBean.getUserinfoOcode());
        paramMap.put("tenantCode", umUserinfoDomainBean.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkStoreInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)jsonToObject.getList().get(0);
    }

    public void updateStoreInfo(UmUserDomainBean umUserinfoDomainBean, UmUserinfoDomainBean umUserinfoDomainBean1) throws ApiException {
        if (umUserinfoDomainBean == null || null == umUserinfoDomainBean1) {
            this.logger.error(this.SYS_CODE + ".updateStoreInfo.null");
            return;
        }
        HashMap<String, String> storeMap = new HashMap<String, String>();
        umUserinfoDomainBean1.setUserinfoCompname(umUserinfoDomainBean.getUserinfoCompname());
        umUserinfoDomainBean1.setUserinfoType(2);
        umUserinfoDomainBean1.setProvinceName(umUserinfoDomainBean.getProvinceName());
        umUserinfoDomainBean1.setAreaName(umUserinfoDomainBean.getAreaName());
        umUserinfoDomainBean1.setCityName(umUserinfoDomainBean.getCityName());
        umUserinfoDomainBean1.setCompanyAddress(umUserinfoDomainBean.getCompanyAddress());
        umUserinfoDomainBean1.setUserinfoConPhone(umUserinfoDomainBean.getUserinfoConPhone());
        String userinfoConPhone = umUserinfoDomainBean1.getUserinfoConPhone();
        if (StringUtils.isBlank((String)userinfoConPhone) || !userinfoConPhone.equals(umUserinfoDomainBean.getUserinfoConPhone())) {
            String userinfoCode = umUserinfoDomainBean1.getUserinfoCode();
            UmUser umUser = this.queryUmUser(umUserinfoDomainBean.getTenantCode(), userinfoCode);
            if (umUser != null) {
                this.logger.error(this.SYS_CODE + ".updateStoreInfo.umUser", (Object)("id is" + umUser.getUserId()));
                umUser.setUserTel(umUserinfoDomainBean.getUserinfoConPhone());
                UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashMap<String, UmUserDomainBean> updateMap = new HashMap<String, UmUserDomainBean>();
                updateMap.put("UmUserDomainBean", umUserDomainBean);
                this.internalInvoke(ApiCodeEnums.updateUser.getApiCode(), storeMap);
            }
        }
        storeMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean1));
        this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), storeMap);
    }

    public UmUser queryUmUser(String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userPcode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryUserPage.getApiCode(), invokeMap, UmUser.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (UmUser)queryResutl.getList().get(0);
    }

    public UmUser queryUmUserByUserPhone(String tenantCode, String userPhone) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPhone)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userPhone", userPhone);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryUserPage.getApiCode(), invokeMap, UmUser.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (UmUser)queryResutl.getList().get(0);
    }

    @Override
    public String synSalesRepresentativeInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synSalesRepresentativeInfo.null");
            return ResultEnums.error.getCode();
        }
        Httpfacade httpfacade = new Httpfacade(null);
        return ResultEnums.success.getCode();
    }

    public OrgDepart getDepShortcode(String tenantCode, String departShortcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)departShortcode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("departShortcode", departShortcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepart.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("getDepCode paramMap is" + ((Object)paramMap).toString());
            return null;
        }
        return (OrgDepart)queryResutl.getList().get(0);
    }

    public void sysDeparttemp(OrgEmployeeDomain orgEmployeeDomain) {
        if (orgEmployeeDomain == null) {
            this.logger.error(this.SYS_CODE + ".sysDeparttemp.null");
            return;
        }
        OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
        orgDepartempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
        orgDepartempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
        orgDepartempDomain.setTenantCode(orgEmployeeDomain.getTenantCode());
        Map<String, String> resultMap = this.getDepartCodeByMemo(orgEmployeeDomain.getCompanyCode(), orgDepartempDomain.getTenantCode());
        orgDepartempDomain.setDepartCode(resultMap.get("departCode"));
        orgDepartempDomain.setCompanyCode(resultMap.get("companyCode"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgDepartempDomain", JsonUtil.buildNonNullBinder().toJson((Object)orgDepartempDomain));
        this.internalInvoke(ApiCodeEnums.saveDepartemp.getApiCode(), map);
    }

    public Map<String, String> getDepartCodeByMemo(String orgNum, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)orgNum) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getDepartCodeByMemo.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", orgNum);
        map.put("tenantCode", tenantCode);
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), map, OrgDepartempDomain.class);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            resultMap.put("departCode", "-1");
            resultMap.put("companyCode", "-1");
            this.logger.error(this.SYS_CODE + ".getDepartCodeByMemo.ListUtil", (Object)((Object)map).toString());
            return resultMap;
        }
        for (OrgDepartempDomain orgDepart : jsonToObject.getList()) {
            if (StringUtils.isBlank((String)orgDepart.getDepartCode())) {
                resultMap.put("departCode", "-1");
            } else {
                resultMap.put("departCode", orgDepart.getDepartCode());
            }
            String companyCode = orgDepart.getCompanyCode();
            if (StringUtils.isBlank((String)companyCode)) {
                resultMap.put("companyCode", "-1");
            } else {
                resultMap.put("companyCode", companyCode);
            }
            String departName = orgDepart.getDepartName();
            if (StringUtils.isBlank((String)departName)) {
                resultMap.put("departName", "-1");
                continue;
            }
            resultMap.put("departName", departName);
        }
        return resultMap;
    }

    public void updateSalesRepresentativeInfo(OrgEmployeeDomain orgEmployeeDomain, String tenantCode) throws ApiException {
        if (orgEmployeeDomain == null) {
            this.logger.error(this.SYS_CODE + ".updateSalesRepresentativeInfo.null");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeCode", orgEmployeeDomain.getEmployeeCode());
        paramMap.put("companyCode", orgEmployeeDomain.getCompanyCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".updateSalesRepresentativeInfo.jsonToObject", (Object)((Object)paramMap).toString());
        }
        HashMap<String, String> employeeMap = new HashMap<String, String>();
        for (OrgEmployeeDomain orgEmployeeDomain1 : jsonToObject.getList()) {
            orgEmployeeDomain1.setCompanyCode(orgEmployeeDomain.getCompanyCode());
            orgEmployeeDomain1.setEmployeeName(orgEmployeeDomain.getEmployeeName());
            orgEmployeeDomain1.setEmployeePhone(orgEmployeeDomain.getEmployeePhone());
            employeeMap.put("orgEmployeeDomain", JsonUtil.buildNonNullBinder().toJson((Object)orgEmployeeDomain1));
            this.internalInvoke(ApiCodeEnums.updateEmployee.getApiCode(), employeeMap);
        }
    }

    public OrgEmployeeDomain checkSalesRepresentativeInfo(OrgEmployeeDomain orgEmployeeDomain, String tenantCode) throws ApiException {
        if (orgEmployeeDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkSalesRepresentativeInfo.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeOcode", orgEmployeeDomain.getEmployeeOcode());
        paramMap.put("companyCode", orgEmployeeDomain.getCompanyCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".checkSalesRepresentativeInfo.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (OrgEmployeeDomain)jsonToObject.getList().get(0);
    }

    public OrgEmployeeDomain getOrgEmployeeByOcode(String tenantCode, String employeeOcode) throws ApiException {
        if (StringUtils.isBlank((String)employeeOcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getOrgEmployeeDomain.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeOcode", employeeOcode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryEmployeePage.getApiCode(), map, OrgEmployeeDomain.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".getOrgEmployeeDomain.jsonToObject", (Object)((Object)paramMap).toString());
            return null;
        }
        return (OrgEmployeeDomain)jsonToObject.getList().get(0);
    }

    @Override
    public String synStoreType(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.error.getCode();
    }

    private void updateQualityQtype(UmQualityQtypeDomain umQualityQtypeDomain, UmQualityQtypeDomain oldUmQualityQtypeDomain) {
        oldUmQualityQtypeDomain.setQtypeQtypeName(umQualityQtypeDomain.getQtypeQtypeName());
        oldUmQualityQtypeDomain.setQualityQtypeType(umQualityQtypeDomain.getQualityQtypeType());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("UmQualityQtypeDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldUmQualityQtypeDomain));
        this.logger.error(this.SYS_CODE + "updateQualityQtype", (Object)JsonUtil.buildNonNullBinder().toJson((Object)oldUmQualityQtypeDomain));
        this.internalInvoke(ApiCodeEnums.updateQualityQtype.getApiCode(), invokeMap);
    }

    @Override
    public String synDepartInfo(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public String updateOrSaveUser(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            return null;
        }
        umUserinfoDomainBean.setTenantCode(tenantCode);
        boolean b = this.checkUserinfo(umUserinfoDomainBean, tenantCode);
        this.logger.error(this.SYS_CODE + ".synDepartInfo.execute", (Object)("checkBoolean is" + b));
        if (b) {
            this.logger.error(this.SYS_CODE + ".synDepartInfo.update", (Object)("umUserinfoDomainBean is" + JsonUtil.buildNonNullBinder().toJson((Object)umUserinfoDomainBean)));
            String userinfoCode = this.updateUserinfo(umUserinfoDomainBean, tenantCode);
            return userinfoCode;
        }
        HashMap<String, String> umMap = new HashMap<String, String>();
        umMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.logger.error(this.SYS_CODE + ".synDepartInfo.execute", (Object)("umUserinfoDomainBean is" + JsonUtil.buildNonNullBinder().toJson((Object)umUserinfoDomainBean)));
        String userinfoCode = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), umMap);
        return userinfoCode;
    }

    public Map<String, List<UmUserDomainBean>> spiltUserQuality(List<UmUserDomainBean> umUserDomainBeanList) {
        ArrayList<UmUserDomainBean> retailList = new ArrayList<UmUserDomainBean>();
        ArrayList<UmUserDomainBean> companyList = new ArrayList<UmUserDomainBean>();
        ArrayList<UmUserDomainBean> departList = new ArrayList<UmUserDomainBean>();
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            if (umUserDomainBean.getUserinfoQuality().equals("retailer")) {
                retailList.add(umUserDomainBean);
            }
            if (umUserDomainBean.getUserinfoQuality().equals("company")) {
                companyList.add(umUserDomainBean);
            }
            if (!umUserDomainBean.getUserinfoQuality().equals("depart")) continue;
            departList.add(umUserDomainBean);
        }
        HashMap<String, List<UmUserDomainBean>> resultMap = new HashMap<String, List<UmUserDomainBean>>();
        resultMap.put("retailer", retailList);
        resultMap.put("company", companyList);
        resultMap.put("depart", departList);
        return resultMap;
    }

    public void updateDis(List<UmUserDomainBean> umUserDomainBeanList) {
        for (UmUserDomainBean umUserDomainBean : umUserDomainBeanList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userinfoOcode", umUserDomainBean.getUserinfoOcode());
            map.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
            invokeMap.put("map", map);
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
            if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error(this.SYS_CODE + ".synDepartInfo.updateDisChannel", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)quresult.getList().get(0);
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            HashMap<String, String> channelMap = new HashMap<String, String>();
            channelMap.put("memberCode", userinfoCode);
            channelMap.put("tenantCode", umUserDomainBean.getTenantCode());
            HashMap<String, String> invokeChannelMap = new HashMap<String, String>();
            invokeChannelMap.put("map", JsonUtil.buildNonNullBinder().toJson(channelMap));
            QueryResult channelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
            if (channelQueryResult == null || ListUtil.isEmpty((Collection)channelQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".synDepartInfo.updateDisChannel", (Object)("invokeChannelMap is" + ((Object)invokeMap).toString()));
                continue;
            }
            DisChannel disChannel = (DisChannel)channelQueryResult.getList().get(0);
            disChannel.setMemberMcode(umUserinfoDomainBean.getUserinfoParentCode());
            disChannel.setMemberMname(umUserDomainBean.getUserinfoParentName());
            if (umUserinfoDomainBean.getUserinfoQuality().equals("company")) {
                disChannel.setGoodsClass("B2B");
            }
            if (umUserinfoDomainBean.getUserinfoQuality().equals("dealer")) {
                disChannel.setGoodsClass("B2B-ORG");
            }
            DisChannelDomain disChannelDomain = new DisChannelDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disChannelDomain, (Object)disChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("disChannelDomain", JsonUtil.buildNonNullBinder().toJson((Object)disChannelDomain));
            this.internalInvoke(ApiCodeEnums.updateChannel.getApiCode(), updateMap);
            this.updateDgoods(umUserinfoDomainBean.getTenantCode(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoParentCode());
        }
    }

    public void updateDgoods(String tenantCode, String memberCode, String memberMcode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("memberCode", memberCode);
        HashMap<String, HashMap<String, String>> invokeMap = new HashMap<String, HashMap<String, String>>();
        invokeMap.put("map", queryMap);
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDgoodsPage.getApiCode(), invokeMap, DisDgoods.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".synDepartInfo.updateDgoods", (Object)("invokeMap is" + ((Object)invokeMap).toString()));
            return;
        }
        DisDgoods disDgoods = (DisDgoods)queryResutl.getList().get(0);
        disDgoods.setDgoodsUprice("1");
        disDgoods.setDgoodsUnum("1");
        disDgoods.setDgoodsEdit("1");
        disDgoods.setMemberMcode(memberMcode);
        DisDgoodsDomain disDgoodsDomain = new DisDgoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsDomain, (Object)disDgoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("DisDgoodsDomain", JsonUtil.buildNonNullBinder().toJson((Object)disDgoodsDomain));
        this.internalInvoke(ApiCodeEnums.updateDgoods.getApiCode(), updateMap);
    }

    public UmUserinfoDomainBean getRetailInfo(String tenantCode, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getReCode(String tenantCode, String userinfoOpcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOpcode", userinfoOpcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return "-1";
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String getCodeByOcode(String tenantCode, String userinfoOcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            return "-1";
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String doRetailData(String tenantCode, String dmsId, String userinfoCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userinfoOpcode", dmsId);
        queryMap.put("userinfoQuality", "retailer");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            UmUserDomainBean umUserDomainBean = this.buildRetailUser(dmsId, tenantCode, userinfoCode);
            HashMap<String, String> umMap = new HashMap<String, String>();
            umMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            String retailCode = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), umMap);
            OrgCompanyDomain orgCompanyDomain = this.buildReCompany(dmsId, tenantCode);
            orgCompanyDomain.setUserinfoCode(retailCode);
            HashMap<String, String> companyMap = new HashMap<String, String>();
            companyMap.put("orgCompanyDomain", JsonUtil.buildNormalBinder().toJson((Object)orgCompanyDomain));
            this.internalInvoke(ApiCodeEnums.saveCompany.getApiCode(), companyMap);
            return retailCode;
        }
        return this.getReCode(tenantCode, dmsId);
    }

    public UmUserDomainBean buildRetailUser(String dmsId, String tenantCode, String userinfoCode) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserinfoType(2);
        umUserDomainBean.setCompanyType(1);
        umUserDomainBean.setUserinfoQuality("retailer");
        umUserDomainBean.setDepartCode(dmsId);
        umUserDomainBean.setDepartName(dmsId);
        umUserDomainBean.setUserinfoCompname(dmsId);
        umUserDomainBean.setUserName(dmsId);
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserinfoOpcode(dmsId);
        umUserDomainBean.setUserinfoParentCode(userinfoCode);
        return umUserDomainBean;
    }

    public OrgCompanyDomain buildReCompany(String dmsId, String tenantCode) {
        OrgCompanyDomain orgCompanyDomain = new OrgCompanyDomain();
        orgCompanyDomain.setCompanyCode(dmsId);
        orgCompanyDomain.setCompanyShortcode(dmsId);
        orgCompanyDomain.setCompanyName(dmsId);
        orgCompanyDomain.setCompanyShortname(dmsId);
        orgCompanyDomain.setTenantCode(tenantCode);
        return orgCompanyDomain;
    }

    public String doCompanyData(OrgCompanyDomain orgCompanyDomain) {
        OrgCompanyDomain oldorgCompanyDomain = this.checkCompany(orgCompanyDomain.getCompanyOcode(), orgCompanyDomain.getTenantCode());
        this.logger.error(this.SYS_CODE + ".doCompanyData.oldorgCompanyDomain", (Object)(orgCompanyDomain.getCompanyOcode() + "=" + oldorgCompanyDomain));
        if (null != oldorgCompanyDomain) {
            this.updateCompany(orgCompanyDomain, oldorgCompanyDomain);
            return oldorgCompanyDomain.getCompanyCode();
        }
        HashMap<String, String> companyMap = new HashMap<String, String>();
        companyMap.put("orgCompanyDomain", JsonUtil.buildNormalBinder().toJson((Object)orgCompanyDomain));
        return this.internalInvoke(ApiCodeEnums.saveCompany.getApiCode(), companyMap);
    }

    public OrgCompanyDomain checkCompany(String companyOcode, String tenantCode) {
        if (StringUtils.isBlank((String)companyOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyOcode", companyOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public OrgCompanyDomain getCompanyByCode(String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)companyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyCode", companyCode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public OrgCompanyDomain getCompanyByOcode(String companyOcode, String tenantCode) {
        if (StringUtils.isBlank((String)companyOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("companyOcode", companyOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCompanyPage.getApiCode(), invokeMap, OrgCompanyDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgCompanyDomain)queryResutl.getList().get(0);
    }

    public void updateCompany(OrgCompanyDomain orgCompanyDomain, OrgCompanyDomain oldorgCompanyDomain) {
        if (null == oldorgCompanyDomain || null == orgCompanyDomain) {
            return;
        }
        oldorgCompanyDomain.setCompanyPcode(orgCompanyDomain.getCompanyPcode());
        oldorgCompanyDomain.setCompanyName(orgCompanyDomain.getCompanyName());
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("orgCompanyDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldorgCompanyDomain));
        this.internalInvoke(ApiCodeEnums.updateCompany.getApiCode(), updateMap);
    }

    public String doDepartData(OrgDepartDomain orgDepartDomain) {
        if (null == orgDepartDomain) {
            return null;
        }
        OrgDepartDomain oldOrgDepartDomain = this.checkDepart(orgDepartDomain.getDepartOcode(), orgDepartDomain.getTenantCode());
        if (null != oldOrgDepartDomain) {
            this.updateDepart(orgDepartDomain, oldOrgDepartDomain);
            return oldOrgDepartDomain.getDepartCode();
        }
        HashMap<String, String> departMap = new HashMap<String, String>();
        departMap.put("orgDepartDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain));
        return this.internalInvoke(ApiCodeEnums.saveDepartBatch.getApiCode(), departMap);
    }

    public OrgDepartDomain checkDepart(String departOcode, String tenantCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("departOcode", departOcode);
        queryMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepartDomain.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OrgDepartDomain)queryResutl.getList().get(0);
    }

    public void updateDepart(OrgDepartDomain orgDepartDomain, OrgDepartDomain oldOrgDepartDomain) {
        if (null == oldOrgDepartDomain || null == orgDepartDomain) {
            return;
        }
        oldOrgDepartDomain.setDepartPcode(orgDepartDomain.getDepartPcode());
        oldOrgDepartDomain.setCompanyCode(orgDepartDomain.getCompanyCode());
        oldOrgDepartDomain.setDepartName(orgDepartDomain.getDepartName());
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("orgDepartDomain", JsonUtil.buildNonNullBinder().toJson((Object)oldOrgDepartDomain));
        this.internalInvoke(ApiCodeEnums.updateDepart.getApiCode(), updateMap);
    }

    public boolean checkUserinfo(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            this.logger.error(this.SYS_CODE + ".checkUserinfo.null");
            return false;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", umUserinfoDomainBean.getDepartCode());
        HashMap<String, String> invokeUserMap = new HashMap<String, String>();
        invokeUserMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeUserMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".checkUserinfo.quresult", (Object)((Object)sendMap).toString());
            return false;
        }
        return true;
    }

    public String updateUserinfo(UmUserDomainBean umUserinfoDomainBean, String tenantCode) {
        if (umUserinfoDomainBean == null) {
            this.logger.error(this.SYS_CODE + ".updateUserinfo.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", umUserinfoDomainBean.getDepartCode());
        HashMap<String, String> invokeUserMap = new HashMap<String, String>();
        invokeUserMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeUserMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".updateUserinfo.quresult", (Object)((Object)sendMap).toString());
            return null;
        }
        HashMap<String, String> updateUserMap = new HashMap<String, String>();
        Iterator iterator = quresult.getList().iterator();
        if (iterator.hasNext()) {
            UmUserinfoDomainBean umUserDomainBean = (UmUserinfoDomainBean)iterator.next();
            umUserDomainBean.setProvinceName(umUserinfoDomainBean.getProvinceName());
            if (String.valueOf(umUserinfoDomainBean.getCompanyCode()) != null) {
                umUserDomainBean.setCompanyCode(umUserinfoDomainBean.getCompanyCode());
            }
            umUserDomainBean.setDepartCode(umUserinfoDomainBean.getDepartCode());
            umUserDomainBean.setDepartName(umUserinfoDomainBean.getDepartName());
            umUserDomainBean.setCompanyType(umUserinfoDomainBean.getCompanyType());
            umUserDomainBean.setQualityQtypeName(umUserinfoDomainBean.getQualityQtypeName());
            umUserDomainBean.setMemo(umUserinfoDomainBean.getMemo());
            updateUserMap.put("umUserinfoDomainBean", JsonUtil.buildNonNullBinder().toJson((Object)umUserDomainBean));
            this.logger.error(this.SYS_CODE + ".updateUserinfo.updateUserMap", (Object)((Object)updateUserMap).toString());
            this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), updateUserMap);
            return umUserDomainBean.getUserinfoParentCode();
        }
        return null;
    }

    public List<OrgDepart> getDepart(String tenantCode, String appmanageIcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("appmanageIcode", appmanageIcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryDepartPage.getApiCode(), invokeMap, OrgDepart.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".synStoreToDepart.getDepart", (Object)((Object)map).toString());
            return null;
        }
        return queryResutl.getList();
    }

    @Override
    public String synStoreToDepart(String userinfoCode, String tenantCode, String dmsId) throws ApiException {
        return ResultEnums.success.getCode();
    }

    public void doCtEmpInfo(List<CtCustrelEmpDomain> ctCustrelEmpDomainList, String tenantCode, CtCustrelDomain ctCustrelDomain, OrgDepartDomain orgDepartDomain) {
        if (ListUtil.isEmpty(ctCustrelEmpDomainList)) {
            this.logger.error(this.SYS_CODE + ".doCtEmpInfo.ctCustrelEmpDomainList.null");
            return;
        }
        HashMap<String, String> saveMap = new HashMap<String, String>();
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            ctCustrelEmpDomain.setTenantCode(tenantCode);
            ctCustrelEmpDomain.setCustrelCode(ctCustrelDomain.getCustrelCode());
            ctCustrelEmpDomain.setUserinfoCode(ctCustrelDomain.getUserinfoCode());
            ctCustrelEmpDomain.setUserinfoCompname(ctCustrelDomain.getUserinfoCompname());
            ctCustrelEmpDomain.setCompanyCode(ctCustrelDomain.getCompanyCode());
            ctCustrelEmpDomain.setCompanyShortname(ctCustrelDomain.getCompanyShortname());
            ctCustrelEmpDomain.setDepartCode(orgDepartDomain.getDepartCode());
            ctCustrelEmpDomain.setDepartName(orgDepartDomain.getDepartName());
            ctCustrelEmpDomain.setCompanyCode(orgDepartDomain.getCompanyCode());
            ctCustrelEmpDomain.setCompanyShortname(ctCustrelEmpDomain.getCustrelShortname());
            boolean flag = this.checkCtEmp(ctCustrelEmpDomain);
            if (flag) continue;
            saveMap.put("ctCustrelEmpDomain", JsonUtil.buildNonNullBinder().toJson((Object)ctCustrelEmpDomain));
            this.logger.error(this.SYS_CODE + ".doCtEmpInfo.saveMap", (Object)JsonUtil.buildNonNullBinder().toJson(saveMap));
            this.internalInvoke(ApiCodeEnums.saveCustrelEmp.getApiCode(), saveMap);
        }
    }

    public boolean checkCtEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        if (null == ctCustrelEmpDomain) {
            this.logger.error(this.SYS_CODE + ".checkCtEmp.ctCustrelEmpDomain.null");
            return false;
        }
        HashMap<String, String> querymap = new HashMap<String, String>();
        querymap.put("tenantCode", ctCustrelEmpDomain.getTenantCode());
        querymap.put("employeeCode", ctCustrelEmpDomain.getEmployeeCode());
        querymap.put("departCode", ctCustrelEmpDomain.getDepartCode());
        querymap.put("custrelUicode", ctCustrelEmpDomain.getCustrelUicode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(querymap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCustrelEmpPage.getApiCode(), invokeMap, CtCustrelEmpDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".checkCtEmp.queryResutl", (Object)((Object)querymap).toString());
            return false;
        }
        return true;
    }

    public List<CtCustrelEmpDomain> doCtForStop(CtCustrelDomain ctCustrelDomain, String tenantCode, OrgDepartDomain orgDepartDomain) {
        if (null == ctCustrelDomain || StringUtils.isEmpty((String)tenantCode) || null == orgDepartDomain) {
            this.logger.error(this.SYS_CODE + ".doCtForStop.null");
            return null;
        }
        List<CtCustrelEmpDomain> ctCustrelEmpDomainList = ctCustrelDomain.getCtCustrelEmpDomainList();
        ArrayList<CtCustrelEmpDomain> empList = new ArrayList<CtCustrelEmpDomain>();
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            OrgEmployeeDomain orgEmployeeByOcode = this.getOrgEmployeeByOcode(tenantCode, ctCustrelEmpDomain.getEmployeeCode());
            this.logger.error(this.SYS_CODE + "orgEmployee1", (Object)(tenantCode + "==" + ctCustrelEmpDomain.getEmployeeCode()));
            if (null == orgEmployeeByOcode) {
                this.logger.error(this.SYS_CODE + ".doCtForStop.null", (Object)(tenantCode + "===:==" + ctCustrelEmpDomain.getEmployeeCode()));
                continue;
            }
            if (ctCustrelEmpDomain.getCustrelUicode().equals("T")) {
                HashMap<String, String> querymap = new HashMap<String, String>();
                querymap.put("tenantCode", tenantCode);
                querymap.put("employeeCode", orgEmployeeByOcode.getEmployeeCode());
                querymap.put("departCode", orgDepartDomain.getDepartCode());
                querymap.put("custrelUicode", ctCustrelDomain.getCustrelUicode());
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(querymap));
                QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryCustrelEmpPage.getApiCode(), invokeMap, CtCustrelEmpDomain.class);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    this.logger.error(this.SYS_CODE + ".doCtForStop.queryResutl", (Object)((Object)invokeMap).toString());
                    continue;
                }
                for (CtCustrelEmpDomain oldCtCustrelEmpDomain : queryResutl.getList()) {
                    HashMap<String, Integer> delMap = new HashMap<String, Integer>();
                    delMap.put("custrelEmpId", oldCtCustrelEmpDomain.getCustrelEmpId());
                    this.internalInvoke(ApiCodeEnums.deleteCustrelEmp.getApiCode(), delMap);
                }
                continue;
            }
            ctCustrelEmpDomain.setCustrelUicode(ctCustrelDomain.getCustrelUicode());
            ctCustrelEmpDomain.setEmployeeCode(orgEmployeeByOcode.getEmployeeCode());
            ctCustrelEmpDomain.setDepartCode(orgDepartDomain.getDepartCode());
            empList.add(ctCustrelEmpDomain);
        }
        return empList;
    }

    public UmQualityQtypeDomain getUmQualityQtypeDomain(String tenantCode, String qtypeQtypeRemark) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("qtypeQtypeRemark", qtypeQtypeRemark);
        map.put("qualityCode", "dealer");
        HashMap<String, String> invokeMAp = new HashMap<String, String>();
        invokeMAp.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeMAp, UmQualityQtypeDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + "getUmQualityQtypeDomain.map", (Object)((Object)map).toString());
            return null;
        }
        return (UmQualityQtypeDomain)queryResutl.getList().get(0);
    }

    public void updateChannalByStore(String tenantCode, String userinfoCodeByDep, String userinfoCodeByStore) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCodeByDep) || StringUtils.isBlank((String)userinfoCodeByStore)) {
            this.logger.error(this.SYS_CODE + ".updateChannalByStore.null", (Object)("tenantCode:" + tenantCode + "userinfoCodeByDep:" + userinfoCodeByDep + "userinfoCodeByStore:" + userinfoCodeByStore));
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("memberCcode", userinfoCodeByStore);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeMap, DisChannel.class);
        if (queryResutl == null || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".updateChannalByStore.queryResutl", (Object)((Object)paramMap).toString());
            return;
        }
        DisChannel disChannel = (DisChannel)queryResutl.getList().get(0);
        HashMap<String, String> paramDepMap = new HashMap<String, String>();
        paramDepMap.put("tenantCode", tenantCode);
        paramDepMap.put("memberCode", userinfoCodeByDep);
        HashMap<String, String> invokeDepMap = new HashMap<String, String>();
        invokeDepMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramDepMap));
        QueryResult queryDepResutl = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), invokeDepMap, DisChannel.class);
        if (queryDepResutl == null || ListUtil.isEmpty((Collection)queryDepResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".updateChannalByStore.queryDepResutl", (Object)((Object)invokeDepMap).toString());
            return;
        }
        DisChannel disChannelByDep = (DisChannel)queryDepResutl.getList().get(0);
        String channelCodeByDep = disChannelByDep.getChannelCode();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("channelCode", disChannel.getChannelCode());
        updateMap.put("tenantCode", tenantCode);
        updateMap.put("channelPcode", channelCodeByDep);
        updateMap.put("memberCode", userinfoCodeByDep);
        HashMap<String, String> invokeUpdateMap = new HashMap<String, String>();
        invokeUpdateMap.put("map", JsonUtil.buildNonNullBinder().toJson(updateMap));
        this.logger.error(this.SYS_CODE + ".updateChannalByStore.updateMap", (Object)((Object)updateMap).toString());
        this.internalInvoke(ApiCodeEnums.updateChannelByCode.getApiCode(), invokeUpdateMap);
    }

    public void saveUserinfoSort(CtCustrelDomain ctCustrelDomain, UmUserinfoDomainBean umUserinfoDomainBean, String tenantCode) {
        if (ctCustrelDomain == null || null == umUserinfoDomainBean) {
            this.logger.error(this.SYS_CODE + ".saveUserinfoSort.null");
            return;
        }
        HashMap<String, String> storeMap = new HashMap<String, String>();
        String userinfoGroup = umUserinfoDomainBean.getUserinfoGroup();
        if (StringUtils.isNotBlank((String)userinfoGroup)) {
            int length = userinfoGroup.split(",").length;
            if (length <= 5 && StringUtils.isNotBlank((String)ctCustrelDomain.getUserinfoGroup())) {
                userinfoGroup = userinfoGroup + "," + ctCustrelDomain.getUserinfoGroup();
            }
        } else if (StringUtils.isNotBlank((String)ctCustrelDomain.getUserinfoGroup())) {
            userinfoGroup = ctCustrelDomain.getUserinfoGroup();
        }
        umUserinfoDomainBean.setUserinfoGroup(userinfoGroup);
        umUserinfoDomainBean.setDepartCode(ctCustrelDomain.getDepartCode());
        umUserinfoDomainBean.setDepartName(ctCustrelDomain.getDepartName());
        umUserinfoDomainBean.setCompanyCode(ctCustrelDomain.getCompanyCode());
        umUserinfoDomainBean.setQualityQtypeName(ctCustrelDomain.getQualityQtypeName());
        umUserinfoDomainBean.setQualityQtypeCode(ctCustrelDomain.getQualityQtypeCode());
        storeMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), storeMap);
    }

    private String getCacheValue(String tenantCode, String memberMcode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)memberMcode)) {
            flagSettingType = flagSettingType + "-" + memberMcode;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error(this.SYS_CODE + ".getUrl", (Object)(tenantCode + "=" + flagSettingType + "=" + flagSettingCode + "=" + value));
        return value;
    }

    public List<Map<String, String>> getOrgNum(String tenantCode, String memberMcode) {
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        String cacheValue = this.getCacheValue(tenantCode, memberMcode, "orgNum", "getOrgNum");
        if (StringUtils.isBlank((String)cacheValue)) {
            return null;
        }
        if (!cacheValue.contains(",")) {
            paramList.add((Map<String, String>)((Object)cacheValue));
            return paramList;
        }
        String[] split = cacheValue.split(",");
        HashMap<String, String> orgMap = null;
        for (int i = 0; i <= split.length - 1; ++i) {
            orgMap = new HashMap<String, String>();
            orgMap.put("org_num", split[i]);
            paramList.add(orgMap);
        }
        return paramList;
    }

    public List<CtCustrelDomain> checkCt(CtCustrelDomain ctCustrelDomain, String tenantCode) throws ApiException {
        if (ctCustrelDomain == null) {
            this.logger.error(this.SYS_CODE + ".checkCt.null");
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("custrelUicode", ctCustrelDomain.getCustrelUicode());
        sendMap.put("tenantCode", tenantCode);
        sendMap.put("departCode", ctCustrelDomain.getDepartCode());
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult ctQueryResult = this.getQueryResutl(ApiCodeEnums.queryCustrelPage.getApiCode(), invokeQueryMap, CtCustrelDomain.class);
        if (ctQueryResult == null || ListUtil.isEmpty((Collection)ctQueryResult.getList())) {
            return null;
        }
        return ctQueryResult.getList();
    }

    public void updateCt(CtCustrelDomain ctCustrelDomain, List<CtCustrelDomain> relList, String tenantCode) throws ApiException {
        if (ctCustrelDomain == null || ListUtil.isEmpty(relList)) {
            this.logger.error(this.SYS_CODE + ".ctCustrelDomain.null");
            return;
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (CtCustrelDomain ctCustrelDomain1 : relList) {
            ctCustrelDomain1.setEmployeeCode(ctCustrelDomain.getEmployeeCode());
            ctCustrelDomain1.setEmployeeName(ctCustrelDomain.getEmployeeName());
            ctCustrelDomain1.setCustrelRemark(ctCustrelDomain.getCustrelRemark());
            ctCustrelDomain1.setCustrelPhone(ctCustrelDomain.getCustrelPhone());
            ctCustrelDomain1.setUserinfoSort(ctCustrelDomain.getUserinfoSort());
            ctCustrelDomain1.setUserinfoGroup(ctCustrelDomain.getUserinfoGroup());
            ctCustrelDomain1.setUserinfoDischannelcode(ctCustrelDomain.getUserinfoDischannelcode());
            ctCustrelDomain1.setUserinfoDischannelname(ctCustrelDomain.getUserinfoDischannelname());
            updateMap.put("ctCustrelDomain", JsonUtil.buildNonNullBinder().toJson((Object)ctCustrelDomain1));
            this.internalInvoke(ApiCodeEnums.updateCustrel.getApiCode(), updateMap);
        }
    }

    public UmUserinfoDomainBean getStoreName(String customerNum, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)customerNum)) {
            this.logger.error(this.SYS_CODE + ".getStoreName.null", (Object)(customerNum + "==:==" + tenantCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoOcode", customerNum);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult qUserinfoBean = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == qUserinfoBean || ListUtil.isEmpty((Collection)qUserinfoBean.getList())) {
            this.logger.error(this.SYS_CODE + ".getStoreName.qUserinfoBean", (Object)((Object)map).toString());
            return null;
        }
        return (UmUserinfoDomainBean)qUserinfoBean.getList().get(0);
    }

    public List<DisChannel> getChannelCode(String priceNum) {
        if (StringUtils.isBlank((String)priceNum)) {
            this.logger.error(this.SYS_CODE + ".getChannelCode.null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoSort", priceNum);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            return null;
        }
        List disChannelList = null;
        HashMap<String, String> disChannelMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : quresult.getList()) {
            String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
            disChannelMap.put("memberCode", userinfoCode);
            disChannelMap.put("tenantCode", umUserinfoDomainBean.getTenantCode());
            QueryResult disChannelQueryResult = this.getQueryResutl(ApiCodeEnums.queryChannelPage.getApiCode(), disChannelMap, DisChannel.class);
            if (null == disChannelQueryResult || ListUtil.isEmpty((Collection)disChannelQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".getChannelCode.disChannelQueryResult", (Object)((Object)disChannelMap).toString());
                return null;
            }
            disChannelList = disChannelQueryResult.getList();
        }
        return disChannelList;
    }

    public Map<String, Object> getResourcesByCode(List<Map<String, Object>> list, String goodsNo) {
        Iterator<Map<String, Object>> iterator = list.iterator();
        if (iterator.hasNext()) {
            Map<String, Object> resourceGoodsDomainMap = iterator.next();
            if (resourceGoodsDomainMap.get("goodsNo").equals(goodsNo)) {
                return resourceGoodsDomainMap;
            }
            return null;
        }
        return null;
    }

    public void synUserSupAndSub(String tenantCode) {
        HashMap<String, String> sendUserMap = new HashMap<String, String>();
        sendUserMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNormalBinder().toJson(sendUserMap));
        QueryResult quinforesult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeQueryMap, UmUserinfoDomainBean.class);
        if (null == quinforesult || ListUtil.isEmpty((Collection)quinforesult.getList())) {
            this.logger.error(this.SYS_CODE + ".synUserSupAndSub.disChannelQueryResult", (Object)((Object)sendUserMap).toString());
            return;
        }
        HashMap<String, String> singleQueryMap = new HashMap<String, String>();
        HashMap<String, String> invokeSingleMap = new HashMap<String, String>();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : quinforesult.getList()) {
            if (umUserinfoDomainBean.getUserinfoQuality().equals("dealer")) continue;
            String companyCode = umUserinfoDomainBean.getCompanyCode();
            singleQueryMap.put("tenantCode", tenantCode);
            singleQueryMap.put("departCode", companyCode);
            invokeSingleMap.put("map", JsonUtil.buildNormalBinder().toJson(singleQueryMap));
            QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeSingleMap, UmUserinfoDomainBean.class);
            if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
                this.logger.error(this.SYS_CODE + ".synUserSupAndSub.quresult", (Object)((Object)singleQueryMap).toString());
                continue;
            }
            for (UmUserinfoDomainBean umUserinfoDomainBeanSingle : quresult.getList()) {
                String userinfoCode = umUserinfoDomainBeanSingle.getUserinfoCode();
                umUserinfoDomainBean.setUserinfoParentCode(userinfoCode);
                this.logger.error(this.SYS_CODE + ".synUserSupAndSub.umId", (Object)(umUserinfoDomainBean.getUserinfoId() + "====>" + umUserinfoDomainBean.getUserinfoParentCode()));
                updateMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
                this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), updateMap);
            }
        }
    }

    public UmUserinfoDomainBean getUserinfoCodeByOcode(String userinfoOcode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoOcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getUserinfoCodeByDCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getUserinfoCodeByDCode(String departCode, String tenantCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), sendMap, UmUserinfoDomainBean.class);
        if (null == quresult || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getUserinfoCodeByDCode.quresult", (Object)((Object)map).toString());
            return null;
        }
        return ((UmUserinfoDomainBean)quresult.getList().get(0)).getUserinfoCode();
    }

    public String getDgoodsCode(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> queryDgoodsMap = new HashMap<String, String>();
        queryDgoodsMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult dgoodsQuery = this.getQueryResutl(ApiCodeEnums.queryDgoodsPage.getApiCode(), queryDgoodsMap, DisDgoodsDomain.class);
        return ((DisDgoodsDomain)dgoodsQuery.getList().get(0)).getDgoodsCode();
    }

    public String getUserinfoCode(String departCode, String tenantCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("departCode", departCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult jsonToObject = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), map, UmUserinfoDomainBean.class);
        if (null == jsonToObject || ListUtil.isEmpty((Collection)jsonToObject.getList())) {
            this.logger.error(this.SYS_CODE + ".getUserinfoCodeByDCode.jsonToObject", (Object)((Object)map).toString());
            return null;
        }
        return ((UmUserinfoDomainBean)jsonToObject.getList().get(0)).getUserinfoCode();
    }

    @Override
    public String queryStoreInfoDirect(String tenantCode, String userinfoCode, String pages) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".synStoreInfo.null");
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        String quality = FlagSettingUtils.getUrl(tenantCode, "aydQuality", "quality");
        if (StringUtils.isEmpty((String)quality)) {
            quality = "store";
        }
        String pageStr = FlagSettingUtils.getUrl(tenantCode, "page", "page");
        String sizeStr = FlagSettingUtils.getUrl(tenantCode, "size", "size");
        String initialization = FlagSettingUtils.getUrl(tenantCode, "initialization", "initialization");
        Integer page = 1;
        Integer size = 100;
        if (StringUtils.isNotBlank((String)sizeStr)) {
            size = Integer.valueOf(sizeStr);
        }
        if (StringUtils.isNotBlank((String)pageStr)) {
            page = Integer.valueOf(pageStr);
        }
        String aydSynFlag = "AddFlag";
        HashMap<String, String> qualityMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        qualityMap.put("tenantCode", tenantCode);
        qualityMap.put("qualityCode", "zhiying");
        invokeSendmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(qualityMap));
        QueryResult umQualityQtype = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeSendmap, UmQualityQtype.class);
        UmQualityQtype umQualityQtype1 = (UmQualityQtype)umQualityQtype.getList().get(0);
        String qualityQtypeCode = umQualityQtype1.getQualityQtypeCode();
        String qtypeQtypeName = umQualityQtype1.getQtypeQtypeName();
        Httpfacade httpfacade = new Httpfacade(url);
        AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoDirect.getUrlMethed());
        boolean flag = true;
        while (flag) {
            storeRequest.setPage(String.valueOf(page));
            storeRequest.setSize(String.valueOf(size));
            storeRequest.setName(userinfoCode);
            AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
            String total = execute.getTotal();
            List<UmUserDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
            if (ListUtil.isEmpty(umUserinfoDomainBeanList)) {
                this.logger.error(this.SYS_CODE + ".queryStoreInfoDirect" + JsonUtil.buildNormalBinder().toJson((Object)storeRequest));
                continue;
            }
            for (UmUserDomainBean umUserDomainBean : umUserinfoDomainBeanList) {
                umUserDomainBean.setTenantCode(tenantCode);
                umUserDomainBean.setUserinfoParentCode(umUserinfoDomainBean.getUserinfoCode());
                umUserDomainBean.setUserinfoParentName(umUserinfoDomainBean.getUserinfoCompname());
                umUserDomainBean.setUserinfoType(2);
                umUserDomainBean.setCompanyType(2);
                umUserDomainBean.setUserinfoQuality(quality);
                umUserDomainBean.setQualityQtypeCode(qualityQtypeCode);
                umUserDomainBean.setQualityQtypeName(qtypeQtypeName);
                this.makeUseArea(umUserDomainBean);
                this.getUserinfoCheck(umUserDomainBean, tenantCode, aydSynFlag);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (!StringUtils.isNotBlank((String)total)) continue;
            Integer totals = Integer.valueOf(total);
            Integer n3 = totals / size;
            if (page <= n3 + 1) continue;
            flag = false;
            this.logger.error(this.SYS_CODE + ".queryStoreInfoDirect.page", (Object)page);
        }
        return ResultEnums.success.getCode();
    }

    @Override
    public String querySytoreInfoCustomer(String tenantCode, String userinfoCode, String pages) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return ResultEnums.error.getCode();
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = "AddFlag";
        String quality = FlagSettingUtils.getUrl(tenantCode, "aydQuality", "quality");
        if (StringUtils.isEmpty((String)quality)) {
            quality = "store";
        }
        this.logger.error(this.SYS_CODE + "====url=====aydSynFlag===", (Object)("====" + url + "=====" + aydSynFlag + "==="));
        HashMap<String, String> qualityMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        qualityMap.put("tenantCode", tenantCode);
        qualityMap.put("qualityCode", "jiameng");
        invokeSendmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(qualityMap));
        QueryResult umQualityQtype = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeSendmap, UmQualityQtype.class);
        this.logger.error("=========UserinfoService.umQualityQtype=========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umQualityQtype));
        UmQualityQtype umQualityQtype1 = (UmQualityQtype)umQualityQtype.getList().get(0);
        String qualityQtypeCode = umQualityQtype1.getQualityQtypeCode();
        String qtypeQtypeName = umQualityQtype1.getQtypeQtypeName();
        Httpfacade httpfacade = new Httpfacade(url);
        AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoCustomer.getUrlMethed());
        String pageStr = FlagSettingUtils.getUrl(tenantCode, "page", "page");
        String sizeStr = FlagSettingUtils.getUrl(tenantCode, "size", "size");
        String initialization = FlagSettingUtils.getUrl(tenantCode, "initialization", "initialization");
        Integer page = 1;
        Integer size = 100;
        if (StringUtils.isNotBlank((String)sizeStr)) {
            size = Integer.valueOf(sizeStr);
        }
        if (StringUtils.isNotBlank((String)pageStr)) {
            page = Integer.valueOf(pageStr);
        }
        boolean flag = true;
        while (flag) {
            storeRequest.setPage(String.valueOf(page));
            storeRequest.setSize(String.valueOf(size));
            storeRequest.setName(userinfoCode);
            AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
            if (execute == null) {
                this.logger.error(this.SYS_CODE + "querySytoreInfoCustomer");
                continue;
            }
            List<UmUserDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
            String total = execute.getTotal();
            if (ListUtil.isEmpty(umUserinfoDomainBeanList)) {
                this.logger.error(this.SYS_CODE + ".querySytoreInfoCustomer.execute" + JsonUtil.buildNormalBinder().toJson((Object)storeRequest));
                continue;
            }
            for (UmUserDomainBean umUserDomainBean : umUserinfoDomainBeanList) {
                umUserDomainBean.setQualityQtypeCode(qualityQtypeCode);
                umUserDomainBean.setQualityQtypeName(qtypeQtypeName);
                umUserDomainBean.setUserinfoQuality(quality);
                umUserDomainBean.setTenantCode(tenantCode);
                umUserDomainBean.setUserinfoParentCode(umUserinfoDomainBean.getUserinfoCode());
                umUserDomainBean.setUserinfoParentName(umUserinfoDomainBean.getUserinfoCompname());
                umUserDomainBean.setUserinfoType(2);
                umUserDomainBean.setCompanyType(1);
                this.makeUseArea(umUserDomainBean);
                this.getUserinfoCheck(umUserDomainBean, tenantCode, aydSynFlag);
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (!StringUtils.isNotBlank((String)total)) continue;
            Integer totals = Integer.valueOf(total);
            Integer n3 = totals / size;
            if (page <= n3 + 1) continue;
            flag = false;
            this.logger.error(this.SYS_CODE + ".querySytoreInfoCustomer.flag.page", (Object)page);
        }
        return ResultEnums.success.getCode();
    }

    @Override
    public String updateUserAccount(String tenantCode, String faccountType, String JsonStr) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return ResultEnums.error.getCode();
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "aydzh", "url");
        if (StringUtils.isBlank((String)url)) {
            url = "http://alltest.lbaby1998.com:3131/WebService.asmx?op=InboundMain";
        }
        if (StringUtils.isBlank((String)JsonStr)) {
            return null;
        }
        StringBuffer template = new StringBuffer();
        template.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        template.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        template.append("<soap:Body>");
        template.append("<InboundMain xmlns=\"http://tempuri.org/\">");
        template.append("<methodName>custCreditLimitQuery</methodName>");
        template.append("<JsonStr>" + JsonStr + "</JsonStr>");
        template.append("</InboundMain>");
        template.append("</soap:Body>");
        template.append("</soap:Envelope>");
        String templateJson = template.toString().replace("\\", "");
        String xmlStr = null;
        this.logger.error(this.SYS_CODE + ".updateUserAccount.templateJson" + JsonUtil.buildNonDefaultBinder().toJson((Object)templateJson));
        try {
            xmlStr = WebUtils.doPostByXml(url, templateJson, 5000, 5000, null);
            if (StringUtils.isBlank((String)xmlStr)) {
                this.logger.error(this.SYS_CODE + ".sendSgSendgoods.xmlStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)templateJson) + ".url" + url);
                return "error";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            this.logger.error(this.SYS_CODE + "doc:", (Object)("DocumentHelper\u8f6c\u6362\u5f02\u5e38" + xmlStr), (Throwable)e);
            return null;
        }
        Map<String, Object> mapStr2 = null;
        try {
            mapStr2 = XmlUtils.Dom2Map(doc);
            if (MapUtil.isEmpty(mapStr2)) {
                this.logger.error(this.SYS_CODE + ".mapStr2" + xmlStr);
                return "error";
            }
            String body = JsonUtil.buildNonDefaultBinder().toJson(mapStr2.get("Body"));
            this.logger.error(this.SYS_CODE + ".updateUserAccount.body" + JsonUtil.buildNonDefaultBinder().toJson((Object)body));
            Map bodyJsonStr1 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(body, String.class, Object.class);
            String bodyJsonStr2 = JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr1.get("InboundMainResponse"));
            Map bodyJsonStr3 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(bodyJsonStr2, String.class, Object.class);
            Object bodyJsonStr4 = bodyJsonStr3.get("InboundMainResult");
            Map bodyJsonStr5 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(bodyJsonStr4.toString(), String.class, Object.class);
            return JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr5.get("data"));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "\u8f6c\u6362\u5f02\u5e38" + JsonUtil.buildNonDefaultBinder().toJson(mapStr2));
            return "error";
        }
    }

    @Override
    public String updateCrpRechargeAccount(String tenantCode, String userinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return ResultEnums.error.getCode();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap data = new HashMap();
        map.put("CustAccountId", userinfoCode);
        ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
        mapList.add(map);
        data.put("data", mapList);
        String url = FlagSettingUtils.getUrl(tenantCode, "aydzh", "url");
        if (StringUtils.isBlank((String)url)) {
            url = "http://alltest.lbaby1998.com:3131/WebService.asmx?op=InboundMain";
        }
        StringBuffer template = new StringBuffer();
        template.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        template.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        template.append("<soap:Body>");
        template.append("<InboundMain xmlns=\"http://tempuri.org/\">");
        template.append("<methodName>CreditPaymentDetailQuery</methodName>");
        template.append("<JsonStr>" + JsonUtil.buildNonDefaultBinder().toJson(data) + "</JsonStr>");
        template.append("</InboundMain>");
        template.append("</soap:Body>");
        template.append("</soap:Envelope>");
        String templateJson = template.toString().replace("\\", "");
        this.logger.error(this.SYS_CODE + ".updateCrpRechargeAccount:\u8bf7\u6c42\u53c2\u6570", (Object)JsonUtil.buildNormalBinder().toJson((Object)templateJson));
        String xmlStr = null;
        this.logger.error(this.SYS_CODE + ".updateCrpRechargeAccount.templateJson" + JsonUtil.buildNonDefaultBinder().toJson((Object)templateJson));
        try {
            xmlStr = WebUtils.doPostByXml(url, templateJson, 1000, 1000, null);
            if (StringUtils.isBlank((String)xmlStr)) {
                this.logger.error(this.SYS_CODE + ".updateCrpRechargeAccount.xmlStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)templateJson) + ".url" + url);
                return "error";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            this.logger.error(this.SYS_CODE + "doc:", (Object)("DocumentHelper\u8f6c\u6362\u5f02\u5e38" + xmlStr), (Throwable)e);
            return null;
        }
        Map<String, Object> mapStr2 = null;
        try {
            mapStr2 = XmlUtils.Dom2Map(doc);
            this.logger.error(this.SYS_CODE + ".updateCrpRechargeAccount:\u8fd4\u56de\u793a\u4f8b", (Object)JsonUtil.buildNormalBinder().toJson(mapStr2));
            String body = JsonUtil.buildNonDefaultBinder().toJson(mapStr2.get("Body"));
            this.logger.error(this.SYS_CODE + ".updateCrpRechargeAccount.body" + JsonUtil.buildNonDefaultBinder().toJson((Object)body));
            Map bodyJsonStr1 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(body, String.class, Object.class);
            String bodyJsonStr2 = JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr1.get("InboundMainResponse"));
            Map bodyJsonStr3 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(bodyJsonStr2, String.class, Object.class);
            Object bodyJsonStr4 = bodyJsonStr3.get("InboundMainResult");
            Map bodyJsonStr5 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(bodyJsonStr4.toString(), String.class, Object.class);
            List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(bodyJsonStr5.get("data")), List.class);
            return JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToList);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "\u8f6c\u6362\u5f02\u5e38" + JsonUtil.buildNonDefaultBinder().toJson(mapStr2));
            return "error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main22(String[] args) {
        String url = "http://192.168.19.96:3131/WebService.asmx?op=InboundMain";
        String CustAccountId = "C103107";
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap data = new HashMap();
        map.put("CustAccountId", CustAccountId);
        ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
        mapList.add(map);
        data.put("data", mapList);
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson(data));
        String JsonStr = " {\"data\":[{\"CustAccountId\":\"C103518\"}]}";
        StringBuffer template = new StringBuffer();
        template.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        template.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        template.append("<soap:Body>");
        template.append("<InboundMain xmlns=\"http://tempuri.org/\">");
        template.append("<methodName>CreditPaymentDetailQuery</methodName>");
        template.append("<JsonStr>" + JsonUtil.buildNonDefaultBinder().toJson(data) + "</JsonStr>");
        template.append("</InboundMain>");
        template.append("</soap:Body>");
        template.append("</soap:Envelope>");
        String templateJson = template.toString().replace("\\", "");
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)templateJson));
        String xmlStr = null;
        try {
            xmlStr = WebUtils.doPostByXml(url, templateJson, 1000, 1000, null);
            if (!StringUtils.isBlank((String)xmlStr)) {
                // empty if block
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        Map<String, Object> mapStr2 = null;
        try {
            mapStr2 = XmlUtils.Dom2Map(doc);
            String body = JsonUtil.buildNonDefaultBinder().toJson(mapStr2.get("Body"));
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)body));
            Map bodyJsonStr1 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(body, String.class, Object.class);
            String bodyJsonStr2 = JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr1.get("InboundMainResponse"));
            Map bodyJsonStr3 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(bodyJsonStr2, String.class, Object.class);
            Object bodyJsonStr4 = bodyJsonStr3.get("InboundMainResult");
            Map bodyJsonStr5 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(bodyJsonStr4.toString(), String.class, Object.class);
            List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(bodyJsonStr5.get("data")), List.class);
            List Json = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(jsonToList.get(0)), Map.class);
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)Json));
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson(jsonToList.get(0)));
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String queryUserSupplier(String tenantCode, String faccountType) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return ResultEnums.error.getCode();
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = "aydSynFlag";
        UmUserinfoDomainBean umUserinfoDomainBean = this.getPlatCode(tenantCode);
        Integer page = 1;
        boolean flag = true;
        while (flag) {
            Httpfacade httpfacade = new Httpfacade(url);
            AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
            storeRequest.setTopHttpMethod("");
            storeRequest.setPage(String.valueOf(page));
            AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
            List<UmUserDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
            if (ListUtil.isNotEmpty(umUserinfoDomainBeanList)) {
                for (UmUserDomainBean umUserinfo : umUserinfoDomainBeanList) {
                    umUserinfo.setUserinfoQuality("supplier");
                    umUserinfo.setTenantCode(tenantCode);
                    umUserinfo.setUserinfoParentCode(umUserinfoDomainBean.getUserinfoCode());
                    umUserinfo.setUserinfoParentName(umUserinfoDomainBean.getUserinfoCompname());
                    umUserinfo.setUserinfoType(2);
                    umUserinfo.setCompanyType(1);
                    this.getUserinfoCheck(umUserinfo, tenantCode, aydSynFlag);
                }
            } else {
                flag = false;
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
        }
        return null;
    }

    private void getUserinfoCheck(UmUserDomainBean umUserinfo, String tenantCode, String addFlag) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        map.put("userinfoOcode", umUserinfo.getUserinfoOcode());
        map.put("tenantCode", tenantCode);
        invokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult umUserinfoList = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeSendmap, UmUserinfoDomainBean.class);
        this.logger.error(this.SYS_CODE + "===umUserinfoList=========", (Object)(JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfoList) + "===umUserinfo===" + JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfo)));
        if (ListUtil.isEmpty((Collection)umUserinfoList.getList())) {
            HashMap<String, String> userinfoMap = new HashMap<String, String>();
            UmUserinfoDomainBean umUserinfoDomain = this.getCompname(umUserinfo.getTenantCode(), umUserinfo.getUserinfoScope());
            if (null != umUserinfoDomain) {
                umUserinfo.setUserinfoParentCode(umUserinfoDomain.getUserinfoCode());
                umUserinfo.setUserinfoParentName(umUserinfoDomain.getUserinfoCompname());
                umUserinfo.setCompanyCode(umUserinfoDomain.getCompanyCode());
            }
            if (StringUtils.isBlank((String)umUserinfo.getUserPwsswd())) {
                umUserinfo.setUserPwsswd("88888888");
            }
            try {
                userinfoMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
                String userinfoCode = this.internalInvoke(ApiCodeEnums.sendOpenUserinfo.getApiCode(), userinfoMap);
                this.logger.error(this.SYS_CODE + ".getUserinfoCheck.umUserinfo=====" + userinfoCode + "======", (Object)JsonUtil.buildNonDefaultBinder().toJson(userinfoMap));
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + "===umUserinfoList.Exception=========", (Object)e.getMessage());
            }
        } else {
            UmUserinfoDomainBean umUserinfoDomain = this.getCompname(umUserinfo.getTenantCode(), umUserinfo.getUserinfoScope());
            if (null != umUserinfoDomain) {
                umUserinfo.setUserinfoParentCode(umUserinfoDomain.getUserinfoCode());
                umUserinfo.setUserinfoParentName(umUserinfoDomain.getUserinfoCompname());
                umUserinfo.setCompanyCode(umUserinfoDomain.getCompanyCode());
            }
            UmUserinfoDomainBean oldUmUserinfoDomainBean = (UmUserinfoDomainBean)umUserinfoList.getList().get(0);
            try {
                BeanUtils.copyAllPropertysNotNull((Object)oldUmUserinfoDomainBean, (Object)umUserinfo);
            }
            catch (Exception e) {
                this.logger.error("===Exception===", (Object)e.getMessage());
            }
            HashMap<String, String> userinfoMap = new HashMap<String, String>();
            userinfoMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)oldUmUserinfoDomainBean));
            this.internalInvoke(ApiCodeEnums.updateUserinfo.getApiCode(), userinfoMap);
            HashMap<String, String> usermap = new HashMap<String, String>();
            HashMap<String, String> userinvokeSendmap = new HashMap<String, String>();
            usermap.put("userName", umUserinfo.getUserinfoOcode());
            usermap.put("userPcode", oldUmUserinfoDomainBean.getUserinfoCode());
            usermap.put("tenantCode", tenantCode);
            userinvokeSendmap.put("map", JsonUtil.buildNormalBinder().toJson(usermap));
            QueryResult umUserList = this.getQueryResutl(ApiCodeEnums.queryUserPage.getApiCode(), userinvokeSendmap, UmUserDomainBean.class);
            this.logger.error(this.SYS_CODE + ".getUserinfoCheck.userinvokeSendmap=======", (Object)JsonUtil.buildNonDefaultBinder().toJson(userinvokeSendmap));
            if (umUserList != null && ListUtil.isNotEmpty((Collection)umUserList.getList())) {
                UmUserDomainBean umUserDomainBean = (UmUserDomainBean)umUserList.getList().get(0);
                umUserDomainBean.setDataState(umUserinfo.getDataState());
                umUserDomainBean.setUserNickname(umUserinfo.getUserinfoCompname());
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
                this.internalInvoke(ApiCodeEnums.updateUser.getApiCode(), userMap);
            }
        }
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public UmUserinfoDomainBean getCompname(String tenantCode, String userinfoCompname) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCompname", userinfoCompname);
        paramMap.put("userinfoQuality", "company");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getCompname", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    private void makeUseArea(UmUserDomainBean umUserDomainBean) {
        String provinceName = umUserDomainBean.getProvinceName();
        String cityName = umUserDomainBean.getCityName();
        if (StringUtils.isNotBlank((String)provinceName)) {
            HashMap<String, String> provinceMapStr = new HashMap<String, String>();
            HashMap<String, String> provinceMap = new HashMap<String, String>();
            provinceMapStr.put("provincName", provinceName);
            provinceMap.put("map", JsonUtil.buildNonNullBinder().toJson(provinceMapStr));
            QueryResult provinceResult = this.getQueryResutl("bs.province.queryProvincePage", provinceMap, BsProvinceReDomain.class);
            if (provinceResult != null && ListUtil.isNotEmpty((Collection)provinceResult.getList())) {
                BsProvinceReDomain provinceReDomain = (BsProvinceReDomain)provinceResult.getList().get(0);
                umUserDomainBean.setProvinceCode(provinceReDomain.getProvinceCode());
            }
        }
        if (StringUtils.isNotBlank((String)cityName)) {
            HashMap<String, String> areaMapStr = new HashMap<String, String>();
            HashMap<String, String> areaMap = new HashMap<String, String>();
            areaMapStr.put("areaName", cityName);
            areaMap.put("map", JsonUtil.buildNonNullBinder().toJson(areaMapStr));
            QueryResult areaResult = this.getQueryResutl("bs.area.queryAreaPage", areaMap, BsAreaReDomain.class);
            if (areaResult != null && ListUtil.isNotEmpty((Collection)areaResult.getList())) {
                BsAreaReDomain areaReDomain = (BsAreaReDomain)areaResult.getList().get(0);
                umUserDomainBean.setCityCode(areaReDomain.getAreaCode());
            }
        }
    }

    @Override
    public String sendSaveFaccountOuterDt(String tenantCode, String data, String userinfoOcode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoOcode) || StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt", (Object)("tenantCode" + tenantCode + "data" + data + "userinfoOcode" + userinfoOcode));
            return DmUtil.getMap("error", null, "\u53c2\u6570\u6709\u8bef", null, false);
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getUserinfoOcode(tenantCode, userinfoOcode);
        if (null == umUserinfoDomainBean) {
            this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt.1", (Object)("tenantCode" + tenantCode + "userinfoOcode" + userinfoOcode));
            return DmUtil.getMap("error", null, "\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728", userinfoOcode, false);
        }
        String merchantCode = umUserinfoDomainBean.getUserinfoCode();
        String type = merchantCode.substring(0, 1);
        String fundType = "01";
        String faccountType = type + fundType;
        VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(merchantCode, faccountType, tenantCode);
        if (null == vdFaccountInfo) {
            this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt.2", (Object)("tenantCode" + tenantCode + "merchantCode" + merchantCode + "faccountType" + faccountType));
            return DmUtil.getMap("error", null, "\u95e8\u5e97\u8d26\u6237\u4fe1\u606f\u6709\u8bef", userinfoOcode, false);
        }
        this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt", (Object)JsonUtil.buildNormalBinder().toJson((Object)data));
        VdFaccountOuterDtDomain vdFaccountOuterDtDomain = (VdFaccountOuterDtDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, VdFaccountOuterDtDomain.class);
        if (null == vdFaccountOuterDtDomain) {
            this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt.3", (Object)("data" + data));
            return DmUtil.getMap("error", null, "data\u6570\u636e\u683c\u5f0f\u6709\u8bef", data, false);
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        CpRechargeDomain rechargeDomain = new CpRechargeDomain();
        rechargeDomain.setUserinfoCode(merchantCode);
        rechargeDomain.setFaccountId(vdFaccountInfo.getFaccountOuterNo());
        rechargeDomain.setUserbankNo(vdFaccountInfo.getFaccountOuterNo());
        rechargeDomain.setRechargeOpcode(vdFaccountInfo.getFaccountOuterNo());
        rechargeDomain.setBankcodeName(vdFaccountOuterDtDomain.getPaymentOrderMemo());
        rechargeDomain.setFchannelCode(faccountType);
        rechargeDomain.setAppmanageIcode("1");
        rechargeDomain.setRechargeUrl(vdFaccountOuterDtDomain.getBusinessOrderno());
        rechargeDomain.setTenantCode(tenantCode);
        rechargeDomain.setMemo(vdFaccountOuterDtDomain.getMemo());
        rechargeDomain.setFchannelPmodeCode("web");
        if (StringUtils.isBlank((String)rechargeDomain.getRechargeType())) {
            rechargeDomain.setRechargeType("01");
        }
        if (StringUtils.isBlank((String)rechargeDomain.getRechargeMode())) {
            rechargeDomain.setRechargeMode("1");
        }
        BigDecimal rechargeMoney = vdFaccountOuterDtDomain.getOrderAmount();
        if (StringUtils.isNotBlank((String)vdFaccountOuterDtDomain.getOrderDc()) && vdFaccountOuterDtDomain.getOrderDc().equals("2")) {
            rechargeMoney = BigDecimal.ZERO.subtract(rechargeMoney);
        }
        rechargeDomain.setRechargeMoney(rechargeMoney);
        reMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)rechargeDomain));
        String result = null;
        try {
            result = (String)this.getInternalRouter().inInvoke("cp.recharge.saveRechargeOneNew", reMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendSaveFaccountOuterDt4", (Object)("tenantCode" + tenantCode + "data" + data + "userinfoOcode" + userinfoOcode));
            return DmUtil.getMap("error", null, "\u540c\u6b65\u5931\u8d25", userinfoOcode, false);
        }
        return DmUtil.getMap("success", null, "\u6210\u529f", null, true);
    }

    private WhWarehouse checkWarehouseInfo(String memberCode, String tenantCode) {
        WhWarehouse whWarehouse = null;
        if (StringUtils.isNotBlank((String)memberCode) && StringUtils.isNotBlank((String)tenantCode)) {
            HashMap<String, String> whMap = new HashMap<String, String>();
            HashMap<String, String> warehouseMap = new HashMap<String, String>();
            whMap.put("areaName", memberCode);
            whMap.put("tenantCode", tenantCode);
            whMap.put("warehouseCtype", "0");
            warehouseMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(whMap));
            QueryResult queryResult = this.getQueryResutl("wh.warehouse.queryWarehousePage", warehouseMap, WhWarehouse.class);
            if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge", (Object)JsonUtil.buildNonDefaultBinder().toJson(warehouseMap));
                return null;
            }
            whWarehouse = (WhWarehouse)queryResult.getList().get(0);
        }
        return whWarehouse;
    }

    @Override
    public String sendSaveCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        Date date;
        SimpleDateFormat y;
        SimpleDateFormat sdf;
        if (null == crpRechargeDomain) {
            this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge", (Object)"isnull");
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        paramMap.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), mapStr, UmUserinfoDomainBean.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge.queryResult", (Object)((Object)paramMap).toString());
            return "error";
        }
        UmUserinfoDomainBean umUserinfoDomainBean1 = (UmUserinfoDomainBean)queryResult.getList().get(0);
        WhWarehouse whWarehouse = this.checkWarehouseInfo(umUserinfoDomainBean1.getUserinfoScope(), crpRechargeDomain.getTenantCode());
        if (null == whWarehouse) {
            this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge.whWarehouse", (Object)(crpRechargeDomain.getUserinfoCode() + crpRechargeDomain.getTenantCode()));
            return "error";
        }
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)queryResult.getList().get(0);
        ArrayList mapList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", whWarehouse.getMemberUrl());
        map.put("applicant", umUserinfoDomainBean.getUserinfoCompname());
        map.put("applicantDept", "");
        map.put("remark", crpRechargeDomain.getRechargeRemark());
        map.put("Lines", mapList);
        HashMap<String, Object> mapJson = new HashMap<String, Object>();
        mapJson.put("lineNum", "1");
        mapJson.put("custAccount", umUserinfoDomainBean.getUserinfoOcode());
        mapJson.put("CustName", umUserinfoDomainBean.getUserinfoCompname());
        mapJson.put("CurrencyCode", "CNY");
        mapJson.put("OrderId", crpRechargeDomain.getRechargeCode());
        if (StringUtils.isNotBlank((String)crpRechargeDomain.getRechargeName3())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            y = new SimpleDateFormat("yyyy/MM/dd");
            date = null;
            try {
                date = sdf.parse(crpRechargeDomain.getRechargeName3());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            mapJson.put("FromDate", y.format(date));
        }
        if (StringUtils.isNotBlank((String)crpRechargeDomain.getRechargeName3())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            y = new SimpleDateFormat("yyyy/MM/dd");
            date = null;
            try {
                date = sdf.parse(crpRechargeDomain.getRechargeName4());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            mapJson.put("ToDate", y.format(date));
        }
        map.put("OrderId", crpRechargeDomain.getRechargeCode());
        mapJson.put("OrigLimit", crpRechargeDomain.getRechargeAmoney());
        mapJson.put("AdjustLimit", crpRechargeDomain.getRechargeMoney());
        mapList.add(mapJson);
        this.logger.error(this.SYS_CODE + "\u53c2\u6570\uff1a" + JsonUtil.buildNonDefaultBinder().toJson(map));
        String url = FlagSettingUtils.getUrl(crpRechargeDomain.getTenantCode(), "CrpRechargeUrl", "CrpRechargeUrl");
        if (EmptyUtil.isEmpty((Object)url)) {
            this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge.url", (Object)"isnull");
            url = "http://192.168.19.96:3131/WebService.asmx?op=InboundMain";
        }
        StringBuffer template = new StringBuffer();
        template.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        template.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        template.append("<soap:Body>");
        template.append("<InboundMain xmlns=\"http://tempuri.org/\">");
        template.append("<methodName>createCustLimitJournal</methodName>");
        template.append("<JsonStr>" + JsonUtil.buildNonDefaultBinder().toJson(map) + "</JsonStr>");
        template.append("</InboundMain>");
        template.append("</soap:Body>");
        template.append("</soap:Envelope>");
        String templateJson = template.toString().replace("\\", "");
        String xmlStr = null;
        try {
            xmlStr = WebUtils.doPostByXml(url, templateJson, 1000, 1000, null);
        }
        catch (IOException e) {
            this.logger.error(this.SYS_CODE + ".sendReturnSgSendgoodsStr.xmlStr" + e);
            this.checkData(crpRechargeDomain, 9);
            return "error";
        }
        if (StringUtils.isBlank((String)xmlStr)) {
            this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge.xmlStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)xmlStr));
            this.checkData(crpRechargeDomain, 9);
            return "error";
        }
        Map<String, Object> mapStr2 = null;
        try {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)xmlStr);
            }
            catch (DocumentException e) {
                this.logger.error(this.SYS_CODE + ".sendSaveCrpRecharge.DocumentException" + (Object)((Object)e), (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)xmlStr));
                this.checkData(crpRechargeDomain, 9);
                return "error";
            }
            mapStr2 = XmlUtils.Dom2Map(doc);
            String body = JsonUtil.buildNonDefaultBinder().toJson(mapStr2.get("Body"));
            this.logger.error(this.SYS_CODE + "sendSaveCrpRecharge.body" + JsonUtil.buildNonDefaultBinder().toJson((Object)body));
            Map bodyJsonStr1 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(body, String.class, Object.class);
            String bodyJsonStr2 = JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr1.get("InboundMainResponse"));
            Map bodyJsonStr3 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(bodyJsonStr2, String.class, Object.class);
            Object bodyJsonStr4 = bodyJsonStr3.get("InboundMainResult");
            Map bodyJsonStr5 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(bodyJsonStr4.toString(), String.class, Object.class);
            this.logger.error(this.SYS_CODE + "sendSaveCrpRecharge.bodyJsonStr5" + JsonUtil.buildNonDefaultBinder().toJson((Object)bodyJsonStr5));
            if (null != bodyJsonStr5.get("retCode") && bodyJsonStr5.get("retCode").toString().equals("200")) {
                this.checkData(crpRechargeDomain, 8);
                return "success";
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "\u8f6c\u6362\u5f02\u5e38" + JsonUtil.buildNonDefaultBinder().toJson(mapStr2));
            this.checkData(crpRechargeDomain, 9);
            return "error";
        }
        return "error";
    }

    public void checkData(CrpRechargeDomain crpRechargeDomain, Integer dataState) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> CpWithdrawJson = new HashMap<String, String>();
        map.put("rechargeCode", crpRechargeDomain.getRechargeCode());
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        CpWithdrawJson.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult crpRechargeQueryResult = this.getQueryResutl("crp.send.queryCrpRechargePage", CpWithdrawJson, CrpRecharge.class);
        if (ListUtil.isNotEmpty((Collection)crpRechargeQueryResult.getList())) {
            HashMap<String, String> updateCrpRecharge = new HashMap<String, String>();
            updateCrpRecharge.put("rechargeId", ((CrpRecharge)crpRechargeQueryResult.getList().get(0)).getRechargeId().toString());
            updateCrpRecharge.put("dataState", dataState.toString());
            updateCrpRecharge.put("oldDataState", ((CrpRecharge)crpRechargeQueryResult.getList().get(0)).getDataState().toString());
            updateCrpRecharge.put("map", null);
            this.logger.error(this.SYS_CODE + ".savecpRechargeDomain.updateCrpRecharge" + JsonUtil.buildNonDefaultBinder().toJson(updateCrpRecharge));
            this.internalInvoke("crp.send.updateCrpRechargeState", updateCrpRecharge);
        }
    }

    public static void main11(String[] args) {
        String url = "http://alltest.lbaby1998.com:3131/WebService.asmx?op=InboundMain";
        ArrayList mapList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", "GD01");
        map.put("applicant", "\u6597\u95e8\u533a\u767d\u85e4\u4eb2\u8d1d\u5a74\u5c9b\u6bcd\u5a74\u7528\u54c1\u52a0\u76df\u5e97");
        map.put("applicantDept", "");
        map.put("remark", "\u54c8\u54c8\u54c8");
        map.put("Lines", mapList);
        HashMap<String, Object> mapJson = new HashMap<String, Object>();
        mapJson.put("lineNum", "2022051100000096");
        mapJson.put("custAccount", "C100046");
        mapJson.put("CustName", "\u6597\u95e8\u533a\u767d\u85e4\u4eb2\u8d1d\u5a74\u5c9b\u6bcd\u5a74\u7528\u54c1\u52a0\u76df\u5e97");
        mapJson.put("CurrencyCode", "CNY");
        mapJson.put("FromDate ", "2022/2/21");
        mapJson.put("ToDate", "2022/2/21");
        mapJson.put("OrigLimit", 100.0);
        mapJson.put("AdjustLimit ", 100.0);
        mapList.add(mapJson);
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson(map));
        StringBuffer template = new StringBuffer();
        template.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        template.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        template.append("<soap:Body>");
        template.append("<InboundMain xmlns=\"http://tempuri.org/\">");
        template.append("<methodName>createCustLimitJournal</methodName>");
        template.append("<JsonStr>" + JsonUtil.buildNonDefaultBinder().toJson(map) + "</JsonStr>");
        template.append("</InboundMain>");
        template.append("</soap:Body>");
        template.append("</soap:Envelope>");
        String templateJson = template.toString().replace("\\", "");
        String xmlStr = null;
        try {
            xmlStr = WebUtils.doPostByXml(url, templateJson, 1000, 1000, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Map<String, Object> mapStr2 = null;
        try {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)xmlStr);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            mapStr2 = XmlUtils.Dom2Map(doc);
            String body = JsonUtil.buildNonDefaultBinder().toJson(mapStr2.get("Body"));
            System.out.println("body---------" + body);
            Map bodyJsonStr1 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(body, String.class, Object.class);
            String bodyJsonStr2 = JsonUtil.buildNonDefaultBinder().toJson(bodyJsonStr1.get("InboundMainResponse"));
            Map bodyJsonStr3 = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(bodyJsonStr2, String.class, Object.class);
            Object bodyJsonStr4 = bodyJsonStr3.get("InboundMainResult");
            Map bodyJsonStr5 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(bodyJsonStr4.toString(), String.class, Object.class);
            if (null != bodyJsonStr5.get("retCode") && bodyJsonStr5.get("retCode").toString().equals("200")) {
                System.out.println("\u6210\u529f");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    public UmUserinfoDomainBean getUserinfoOcode(String tenantCode, String userinfoOcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl(ApiCodeEnums.queryUserinfoPage.getApiCode(), invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error(this.SYS_CODE + ".getUserinfoOcode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public static void main1(String[] args) {
        String url = "http://md.aiyingtong.com.cn";
        Httpfacade httpfacade = new Httpfacade(url);
        AydStoreInfoRequest storeRequest = new AydStoreInfoRequest();
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoDirect.getUrlMethed());
        boolean flag = true;
        storeRequest.setTopHttpMethod(UrlEnums.storeInfoCustomer.getUrlMethed());
        Integer page = 1;
        Integer size = 2;
        storeRequest.setSize(String.valueOf(size));
        storeRequest.setName(null);
        AydStoreInfoResponse execute = httpfacade.execute(storeRequest);
        List<UmUserDomainBean> umUserinfoDomainBeanList = execute.getUmUserinfoDomainBeanList();
        if (ListUtil.isEmpty(umUserinfoDomainBeanList) || umUserinfoDomainBeanList.size() == 0) {
            // empty if block
        }
    }

    @Override
    public String queryUserByBalance(String tenantCode, String faccountType, String JsonStr) throws ApiException {
        if (null == tenantCode || StringUtils.isEmpty((String)JsonStr)) {
            this.logger.error(this.SYS_CODE + ".queryUserByBalance", (Object)"isnull");
            return null;
        }
        String cookies = DmUtil.checkLogin(tenantCode);
        if (StringUtils.isBlank((String)cookies)) {
            this.logger.error(this.SYS_CODE + ".queryUserByBalance\uff0ccookies", (Object)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u767b\u5f55\u5931\u8d25\u539f\u56e0");
            return null;
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "K3CLOUDUrl", "K3CLOUDUrl");
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".queryUserByBalance\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        paramMap.put("FormId", "CRE_Rpt_CreditInfo");
        mapStr.put("FieldKeys", "FCREDITOBJECT,FLIMITBALANCE");
        mapStr.put("SchemeId", "");
        mapStr.put("StartRow", 0);
        mapStr.put("Limit", 0);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("FSaleOrgList", "1");
        model.put("FObjectType", "BD_Customer");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FNumber", JsonStr);
        model.put("FStartCustId", map);
        model.put("FCreditStatus", "ALL");
        model.put("FIsExceeds", "-1");
        model.put("FMultiSelect", "false");
        mapStr.put("Model", model);
        paramMap.put("data", mapStr);
        String returnResults = null;
        try {
            returnResults = HttpRequestUtil.sendCookiesPost(url + K3CloundConfig.Balance, JsonUtil.buildNormalBinder().toJson(paramMap), cookies);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "queryUserByBalance.Exception" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults), (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((String)returnResults)) {
            this.logger.error(this.SYS_CODE + "queryUserByBalance.returnResults" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(returnResults, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            this.logger.error(this.SYS_CODE + "queryUserByBalance.returnResultsMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        Map ResultMap = (Map)returnResultsMap.get("Result");
        if (MapUtil.isEmpty((Map)ResultMap)) {
            this.logger.error(this.SYS_CODE + "queryUserByBalance.ResultMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        String rows = JsonUtil.buildNormalBinder().toJson(ResultMap.get("Rows"));
        ArrayList list = new ArrayList();
        List rowsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(rows, List.class);
        if (ListUtil.isNotEmpty((Collection)rowsList)) {
            for (Object ob : rowsList) {
                List list1 = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(ob), String.class);
                if (!ListUtil.isNotEmpty((Collection)list1)) continue;
                HashMap<String, Object> paramMap1 = new HashMap<String, Object>();
                paramMap1.put("FCREDITOBJECT", list1.get(0));
                if (null != list1.get(1)) {
                    String expAccountBalance = ((String)list1.get(1)).replace(",", "");
                    paramMap1.put("expAccountBalance", expAccountBalance);
                }
                list.add(paramMap1);
            }
            return JsonUtil.buildNormalBinder().toJson(list);
        }
        this.logger.error(this.SYS_CODE + "queryUserByBalance.ResultMapStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
        return null;
    }

    @Override
    public String queryUserByFranchiseStore(String tenantCode, String StartRow, String Limit, String name) throws Exception {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".queryUserByFranchiseStore.null");
            return ResultEnums.error.getCode();
        }
        String cookies = DmUtil.checkLogin(tenantCode);
        if (StringUtils.isBlank((String)cookies)) {
            this.logger.error(this.SYS_CODE + ".queryUserByFranchiseStore\uff0ccookies", (Object)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u767b\u5f55\u5931\u8d25\u539f\u56e0");
            return null;
        }
        String url = FlagSettingUtils.getUrl(tenantCode, "K3CLOUDUrl", "K3CLOUDUrl");
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".queryUserByFranchiseStore\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        UmUserinfoDomainBean umUserinfoDomainBeanStr = this.getPlatCode(tenantCode);
        if (null == umUserinfoDomainBeanStr) {
            this.logger.error(this.SYS_CODE + ".queryUserByFranchiseStore.umUserinfoDomainBeanStr", (Object)tenantCode);
            return null;
        }
        String DBID = FlagSettingUtils.getUrl(tenantCode, "DBID", "DBID");
        HashMap paramMap = new HashMap();
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        mapStr.put("DBID", DBID);
        mapStr.put("Fileter", "");
        mapStr.put("StartRow", 0);
        mapStr.put("Limit", 20);
        if (StringUtils.isNotBlank((String)StartRow)) {
            mapStr.put("StartRow", StartRow);
        }
        String returnResults = null;
        try {
            returnResults = HttpRequestUtil.sendCookiesPost(url + K3CloundConfig.FranchiseStore, JsonUtil.buildNormalBinder().toJson(paramMap), cookies);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "queryUserByFranchiseStore.Exception" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults), (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((String)returnResults)) {
            this.logger.error(this.SYS_CODE + "queryUserByFranchiseStore.returnResults" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        String quality = FlagSettingUtils.getUrl(tenantCode, "aydQuality", "quality");
        if (StringUtils.isEmpty((String)quality)) {
            quality = "store";
        }
        HashMap<String, String> qualityMap = new HashMap<String, String>();
        HashMap<String, String> invokeSendmap = new HashMap<String, String>();
        qualityMap.put("tenantCode", tenantCode);
        qualityMap.put("qualityCode", "jiameng");
        invokeSendmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(qualityMap));
        QueryResult umQualityQtype = this.getQueryResutl(ApiCodeEnums.queryQualityQtypePage.getApiCode(), invokeSendmap, UmQualityQtype.class);
        this.logger.error(this.SYS_CODE + ".queryUserByFranchiseStore=========UserinfoService.umQualityQtype=========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umQualityQtype));
        UmQualityQtype umQualityQtype1 = (UmQualityQtype)umQualityQtype.getList().get(0);
        String qualityQtypeCode = umQualityQtype1.getQualityQtypeCode();
        String qtypeQtypeName = umQualityQtype1.getQtypeQtypeName();
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(returnResults, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            this.logger.error(this.SYS_CODE + "queryUserByFranchiseStore.returnResultsMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        Map ResultMap = (Map)returnResultsMap.get("Result");
        if (MapUtil.isEmpty((Map)ResultMap)) {
            this.logger.error(this.SYS_CODE + "queryUserByFranchiseStore.ResultMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(ResultMap.get("Data")), Map.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(this.SYS_CODE + "queryUserByFranchiseStore.jsonToList" + JsonUtil.buildNonDefaultBinder().toJson((Object)returnResults));
            return null;
        }
        for (Map paramsMap : jsonToList) {
            UmUserDomainBean umUserinfoDomainBean = new UmUserDomainBean();
            umUserinfoDomainBean.setUserinfoOcode(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fNumber"))));
            umUserinfoDomainBean.setUserOcode(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fNumber"))));
            umUserinfoDomainBean.setUserName(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fNumber"))));
            umUserinfoDomainBean.setCompanyType(1);
            umUserinfoDomainBean.setUserinfoCompname(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fname"))));
            umUserinfoDomainBean.setUserNickname(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fname"))));
            umUserinfoDomainBean.setUserinfoCorp(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("fname"))));
            umUserinfoDomainBean.setProvinceName(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("province"))));
            umUserinfoDomainBean.setAreaName("\u534e\u5357");
            umUserinfoDomainBean.setUserinfoScope("\u534e\u5357");
            umUserinfoDomainBean.setAreaCode("\u534e\u5357");
            umUserinfoDomainBean.setCityName(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FCITY"))));
            umUserinfoDomainBean.setUserinfoPhone(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FMOBILEPHONE"))));
            umUserinfoDomainBean.setUserPhone(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FNumber"))));
            umUserinfoDomainBean.setCompanyAddress(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FADDRESS"))));
            umUserinfoDomainBean.setUserPwsswd("88888888");
            if (paramsMap.containsKey("FGroup")) {
                umUserinfoDomainBean.setUserinfoGroup(UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FGroup"))));
            }
            String storeStatus = UserinfoServiceImpl.checkNull(String.valueOf(paramsMap.get("FForbidContactStatus")));
            umUserinfoDomainBean.setDataState(UserinfoServiceImpl.getDataState(storeStatus));
            umUserinfoDomainBean.setUserinfoDataState(UserinfoServiceImpl.getDataState(storeStatus));
            umUserinfoDomainBean.setUserinfoPaybalance("0");
            umUserinfoDomainBean.setQualityQtypeCode(qualityQtypeCode);
            umUserinfoDomainBean.setQualityQtypeName(qtypeQtypeName);
            umUserinfoDomainBean.setUserinfoQuality(quality);
            umUserinfoDomainBean.setTenantCode(tenantCode);
            umUserinfoDomainBean.setUserinfoParentCode(umUserinfoDomainBeanStr.getUserinfoCode());
            umUserinfoDomainBean.setUserinfoParentName(umUserinfoDomainBeanStr.getUserinfoCompname());
            umUserinfoDomainBean.setUserinfoType(2);
            umUserinfoDomainBean.setCompanyType(1);
            this.makeUseArea(umUserinfoDomainBean);
            this.getUserinfoCheck(umUserinfoDomainBean, tenantCode, null);
        }
        return ResultEnums.success.getCode();
    }

    private static String checkNull(String msg) {
        if ("null".equals(msg) || null == msg) {
            return null;
        }
        return msg;
    }

    private static Integer getDataState(String storeStatus) {
        if (StringUtils.isEmpty((String)storeStatus)) {
            return 1;
        }
        switch (storeStatus) {
            case "0": {
                return 1;
            }
            case "1": {
                return 0;
            }
            case "2": {
                return -1;
            }
            case "20": {
                return 0;
            }
            case "21": {
                return 1;
            }
            case "22": {
                return -1;
            }
        }
        return 1;
    }

    public static String checkLogin(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acctID", "61d570febb4d34");
        map.put("Username", "ERP2");
        map.put("Password", "YT888***");
        map.put("Lcid", "2052");
        String Cookies = null;
        try {
            Cookies = HttpRequestUtil.sendPost("http://192.168.116.83/K3Cloud/Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc", map);
            Map Login = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(Cookies, String.class, Object.class);
            if (MapUtil.isEmpty((Map)Login)) {
                return null;
            }
            Cookies = Login.get("KDSVCSessionId").toString();
            return Cookies;
        }
        catch (Exception e) {
            return null;
        }
    }
}

