/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.domain.CmChannelClear;
import com.yqbsoft.laser.service.exdate.domain.DaSalesSumListDomain;
import com.yqbsoft.laser.service.exdate.domain.OcContract;
import com.yqbsoft.laser.service.exdate.domain.Transaction;
import com.yqbsoft.laser.service.exdate.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketParam;
import com.yqbsoft.laser.service.exdate.domain.VoucherApplyTicketResult;
import com.yqbsoft.laser.service.exdate.domain.WalletDillDomain;
import com.yqbsoft.laser.service.exdate.domain.WalletResponse;
import com.yqbsoft.laser.service.exdate.model.DaSalesSumList;
import com.yqbsoft.laser.service.exdate.model.UnionPayDomain;
import com.yqbsoft.laser.service.exdate.model.UnionPayErrorDomain;
import com.yqbsoft.laser.service.exdate.service.YlUnionPayWalletService;
import com.yqbsoft.laser.service.exdate.test.TransferDemoMainTest;
import com.yqbsoft.laser.service.exdate.utils.DmUtil;
import com.yqbsoft.laser.service.exdate.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.exdate.utils.GnetePayUtils;
import com.yqbsoft.laser.service.exdate.utils.HttpRequestUtil;
import com.yqbsoft.laser.service.exdate.utils.JbsUtils;
import com.yqbsoft.laser.service.exdate.utils.K3CloundConfig;
import com.yqbsoft.laser.service.exdate.utils.MD5Test;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class YlUnionPayWalletServiceImpl
extends BaseServiceImpl
implements YlUnionPayWalletService {
    public static final String SYS_CODE = "exdata.YlUnionPayWalletServiceImpl";

    @Override
    public String saveWalletRegistration(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRegistration" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setJumpType("1");
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        voucherApplyTicketParam.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.getTicket(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return ResultEnums.error.getCode();
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)ticket);
    }

    @Override
    public String saveWalletWithdrawal(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletWithdrawal" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return JbsUtils.getErrorMap("\u67e5\u8be2\u7528\u6237\u94b1\u5305", JsonUtil.buildNormalBinder().toJson((Object)ticket));
        }
        VoucherApplyTicketParam voucherApplyTicketParamJson = new VoucherApplyTicketParam();
        voucherApplyTicketParamJson.setJumpType("6");
        voucherApplyTicketParamJson.setWalletId(ticket.getWalletId());
        voucherApplyTicketParamJson.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticketMap = null;
        try {
            ticketMap = TransferDemoMainTest.getTicket(voucherApplyTicketParamJson, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticketMap.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticketMap) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParamJson));
            return JbsUtils.getErrorMap("\u63d0\u73b0\u63a5\u53e3\u62a5\u9519", JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
    }

    public static void main11(String[] args) {
        String appId = "5ed70f9c2c07873f0aa9e455560bc553";
        String sign_alg = "SHA1withRSA";
        String mct_private_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\A0010000-0014.p12";
        String mct_private_key_pwd = "123456";
        String fchannelApiUrl = "https://testapi.gnete.com:9083/routejson";
        String gnete_gateway_public_key_path = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\2048-cfca.der";
        String issr_id = "A0010000-0014";
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId("20000210398114");
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(ticket.getWalletId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("walletId", ticket.getWalletId());
        param.put("startDate", "2022-02-01");
        param.put("endDate", "2022-04-11");
        param.put("pageType", "0");
        param.put("pageNumber", "1");
        param.put("pageSize", "10");
        WalletResponse walletResponse = null;
        try {
            walletResponse = TransferDemoMainTest.queryBillInfo(param, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String msgBody = walletResponse.getMsgBody();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(walletResponse.getMsgBody(), String.class, Object.class);
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)walletResponse));
        if (MapUtils.isNotEmpty((Map)jsonToMap)) {
            List transList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap.get("transList")), WalletDillDomain.class);
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)transList));
        }
        System.out.println(ticket);
    }

    @Override
    public List<VdFaccountInfo> queryWalletPay(Map<String, Object> map) throws ApiException {
        ArrayList<VdFaccountInfo> vdFaccountInfosList = new ArrayList<VdFaccountInfo>();
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo();
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.extUserId is null");
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        String tenantCode = (String)map.get("tenantCode");
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        boolean flag = false;
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ticket.getRspCode().toString().equals("30063")) {
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            flag = true;
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        long queryAcctBal = 0L;
        try {
            queryAcctBal = TransferDemoMainTest.queryAcctBal(ticket.getWalletId(), appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (new BigDecimal(queryAcctBal).compareTo(BigDecimal.ZERO) == 0) {
            vdFaccountInfo.setFaccountAmount(new BigDecimal(0));
            flag = true;
            vdFaccountInfo.setRegister(flag);
            vdFaccountInfosList.add(vdFaccountInfo);
            return vdFaccountInfosList;
        }
        BigDecimal divide = new BigDecimal(queryAcctBal).divide(BigDecimal.valueOf(100L));
        flag = true;
        vdFaccountInfo.setRegister(flag);
        vdFaccountInfo.setFaccountAmount(divide);
        vdFaccountInfosList.add(vdFaccountInfo);
        return vdFaccountInfosList;
    }

    @Override
    public String saveWalletRecharge(Map<String, Object> map) throws ApiException {
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRecharge" + map);
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u79df\u6237\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String callbackUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "callbackUrl", "callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            return ResultEnums.error.getCode();
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String url = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        if (null == map.get("extUserId") || StringUtils.isBlank((String)map.get("extUserId").toString()) || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveWalletRecharge.extUserId is null");
            return ResultEnums.error.getCode();
        }
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(map.get("extUserId").toString());
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return JbsUtils.getErrorMap("\u67e5\u8be2\u7528\u6237\u94b1\u5305", JsonUtil.buildNormalBinder().toJson((Object)ticket));
        }
        VoucherApplyTicketParam voucherApplyTicketParamJson = new VoucherApplyTicketParam();
        voucherApplyTicketParamJson.setJumpType("5");
        voucherApplyTicketParamJson.setWalletId(ticket.getWalletId());
        voucherApplyTicketParamJson.setCallbackUrl(callbackUrl);
        VoucherApplyTicketResult ticketMap = null;
        try {
            ticketMap = TransferDemoMainTest.getTicket(voucherApplyTicketParamJson, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, url, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticketMap.getRspCode().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticketMap) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParamJson));
            return JbsUtils.getErrorMap("saveWalletRecharge.\u5145\u503c\u63a5\u53e3\u62a5\u9519", JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)ticketMap));
    }

    @Override
    public QueryResult<WalletDillDomain> queryWalletBillInfo(String extUserId, String tenantCode, Map<String, String> map) throws ApiException {
        if (MapUtils.isEmpty(map) || StringUtils.isBlank((String)map.get("startDate")) || StringUtils.isBlank((String)map.get("endDate")) || StringUtils.isBlank((String)extUserId)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String appId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletappId", "WalletappId");
        String sign_alg = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "WalletsignAlg", "WalletsignAlg");
        String mct_private_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekey", "Walletprivatekey");
        String mct_private_key_pwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletprivatekeypwd", "Walletprivatekeypwd");
        String gnete_gateway_public_key_path = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletpublickeypath", "Walletpublickeypath");
        String issr_id = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walletissrid", "Walletissrid");
        String fchannelApiUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "Walleturl", "Walleturl");
        VoucherApplyTicketParam voucherApplyTicketParam = new VoucherApplyTicketParam();
        voucherApplyTicketParam.setExtUserId(extUserId);
        VoucherApplyTicketResult ticket = null;
        try {
            ticket = TransferDemoMainTest.queryWalletInformation(voucherApplyTicketParam, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ticket.getRspCode().toString().equals("00000")) {
            this.logger.error(SYS_CODE + JsonUtil.buildNonDefaultBinder().toJson((Object)ticket) + JsonUtil.buildNonDefaultBinder().toJson((Object)voucherApplyTicketParam));
            return null;
        }
        System.out.println(ticket.getWalletId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("walletId", ticket.getWalletId());
        param.put("startDate", map.get("startDate"));
        param.put("endDate", map.get("endDate"));
        if (StringUtils.isNotBlank((String)map.get("pageType"))) {
            param.put("pageType", map.get("pageType"));
        }
        if (StringUtils.isNotBlank((String)map.get("pageNumber"))) {
            param.put("pageNumber", map.get("pageNumber"));
        }
        if (StringUtils.isNotBlank((String)map.get("pageSize"))) {
            param.put("pageSize", map.get("pageSize"));
        }
        WalletResponse walletResponse = null;
        try {
            walletResponse = TransferDemoMainTest.queryBillInfo(param, appId, sign_alg, mct_private_key_path, mct_private_key_pwd, fchannelApiUrl, gnete_gateway_public_key_path, issr_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String msgBody = walletResponse.getMsgBody();
        QueryResult walletDillDomainQueryResult = new QueryResult();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(walletResponse.getMsgBody(), String.class, Object.class);
        if (MapUtils.isNotEmpty((Map)jsonToMap)) {
            List transList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap.get("transList")), WalletDillDomain.class);
            walletDillDomainQueryResult.setList(transList);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(Integer.parseInt(jsonToMap.get("totalSize").toString()));
            walletDillDomainQueryResult.setPageTools((SupPageTools)pageTools);
            return walletDillDomainQueryResult;
        }
        return null;
    }

    @Override
    public String queryCashFlow(Map<String, Object> map) {
        String cookies;
        if (MapUtils.isEmpty(map) || null == map.get("sSDate") || null == map.get("sEDate")) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.queryCashFlow", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return null;
        }
        if (null == map.get("tenantCode")) {
            map.put("tenantCode", "2022071500000001");
        }
        if (StringUtils.isBlank((String)(cookies = DmUtil.checkLogin(map.get("tenantCode").toString())))) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveSendSgSendgoods\uff0ccookies", (Object)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u767b\u5f55\u5931\u8d25\u539f\u56e0");
            return "error";
        }
        String DBID = FlagSettingUtils.getUrl(map.get("tenantCode").toString(), "K3CLOUDAcctID", "K3CLOUDAcctID");
        if (StringUtils.isBlank((String)DBID)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveSendSgSendgoods\uff0cDBID", (Object)"DBID is null");
            return null;
        }
        String url = FlagSettingUtils.getUrl(map.get("tenantCode").toString(), "K3CLOUDUrl", "K3CLOUDUrl");
        if (StringUtils.isBlank((String)url)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.saveSendSgSendgoods\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        HashMap requestMap = new HashMap();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        requestMap.put("parameter", parameterMap);
        parameterMap.put("DBID", DBID);
        if (MapUtils.isNotEmpty(map) && null != map.get("sCustNo")) {
            parameterMap.put("sCustNo", map.get("sCustNo"));
        } else {
            parameterMap.put("sCustNo", "");
        }
        parameterMap.put("sSDate", map.get("sSDate"));
        parameterMap.put("sEDate", map.get("sEDate"));
        parameterMap.put("keys", "\u4fdd\u8bc1\u91d1(\u5b9e\u6536)");
        if (MapUtils.isNotEmpty(map) && null != map.get("StartRow")) {
            parameterMap.put("StartRow", map.get("StartRow"));
        }
        if (MapUtils.isNotEmpty(map) && null != map.get("Limit")) {
            parameterMap.put("Limit", map.get("Limit"));
        }
        this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u91d1\u8776\u6536\u6b3e\u5355\u8bf7\u6c42\u53c2\u6570\uff1a" + JsonUtil.buildNormalBinder().toJson(requestMap));
        String returnResults = null;
        try {
            returnResults = HttpRequestUtil.sendCookiesPost(url + K3CloundConfig.CollectionDocjournal, JsonUtil.buildNormalBinder().toJson(requestMap), cookies);
            return returnResults;
        }
        catch (Exception e) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl.\u91d1\u8776\u4fdd\u8bc1\u91d1\u6d41\u6c34\u63a5\u53e3\u62a5\u9519" + JsonUtil.buildNonDefaultBinder().toJson(requestMap), (Throwable)e);
            return null;
        }
    }

    @Override
    public String autoPullUnionBillInfo() throws ApiException {
        HashMap<String, Object> mapJson = new HashMap<String, Object>();
        mapJson.put("InfoType", "LastDay");
        return this.pullUnionBillInfo(mapJson);
    }

    @Override
    public String userPullUnionBillInfo(Map<String, Object> paramsMap) throws ApiException {
        if (paramsMap == null || paramsMap.get("BeginTime") == null || paramsMap.get("EndTime") == null) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        return this.pullUnionBillInfo(paramsMap);
    }

    public String pullUnionBillInfo(Map<String, Object> paramsMap) throws ApiException {
        String tenantCode = "2021122100000001";
        String UoionFtpUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UoionFtpUrl", "UoionFtpUrl");
        String UoionFtpPort = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UoionFtpPort", "UoionFtpPort");
        String UoionFtpUserId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UoionFtpUserId", "UoionFtpUserId");
        String UoionFtpPasswd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UoionFtpPasswd", "UoionFtpPasswd");
        this.logger.info("exdata.YlUnionPayWalletServiceImplUoionFtpUrl", (Object)(UoionFtpUrl + ":" + UoionFtpPort));
        this.logger.info("exdata.YlUnionPayWalletServiceImplUoionFtpUPwd", (Object)(UoionFtpUserId + ":" + UoionFtpPasswd));
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (paramsMap.get("InfoType") != null && paramsMap.get("InfoType").equals("LastDay")) {
            LocalDate currentDate = LocalDate.now();
            LocalDate previousDate = currentDate.minusDays(1L);
            String lastDate = previousDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            this.Implicit(transactions, UoionFtpUrl, Integer.parseInt(UoionFtpPort), UoionFtpUserId, UoionFtpPasswd, lastDate);
        } else {
            String BeginTime = paramsMap.get("BeginTime").toString();
            String EndTime = paramsMap.get("EndTime").toString();
            LocalDate startDate = LocalDate.parse(BeginTime.substring(0, 10));
            LocalDate endDate = LocalDate.parse(EndTime.substring(0, 10));
            ArrayList<String> dates = new ArrayList<String>();
            LocalDate currentDate = startDate;
            while (!currentDate.isAfter(endDate)) {
                String formattedDate = currentDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                dates.add(formattedDate);
                currentDate = currentDate.plusDays(1L);
            }
            for (int i = 0; i < dates.size(); ++i) {
                this.Implicit(transactions, UoionFtpUrl, Integer.parseInt(UoionFtpPort), UoionFtpUserId, UoionFtpPasswd, (String)dates.get(i));
            }
        }
        for (int i = 0; i < transactions.size(); ++i) {
            OcContract ocContract;
            DaSalesSumListDomain daSalesSumList;
            String assType;
            Transaction transaction = (Transaction)transactions.get(i);
            HashMap<String, Object> mapPro = new HashMap<String, Object>();
            HashMap<String, Object> mapCmCMap = new HashMap<String, Object>();
            mapCmCMap.put("channelClearSeqno", transaction.getReservedField2());
            QueryResult<CmChannelClear> cmsChannelClearQueryResult = this.queryCMClearPage(mapCmCMap);
            QueryResult<OcContract> ocContractQueryResult = new QueryResult<OcContract>();
            if (cmsChannelClearQueryResult.getList().size() == 0) {
                this.logger.info("part1:\u4fdd\u7559\u57df2\u67e5\u8be2\u4e3anull\uff01", (Object)transaction.getReservedField2());
                mapPro.put("contractEcurl", transaction.getMerchantOrderNo());
                ocContractQueryResult = this.queryContractPage(mapPro);
                if (ocContractQueryResult.getList().size() == 0) {
                    String b2bOrder = YlUnionPayWalletServiceImpl.convertToLocaOrder(transaction.getMerchantOrderNo());
                    mapPro.clear();
                    mapPro.put("contractEcurl", b2bOrder);
                    ocContractQueryResult = this.queryContractPage(mapPro);
                    if (ocContractQueryResult.getList().size() == 0) {
                        this.logger.info("part2:\u68c0\u67e5\u8ba2\u5355\u8f6c\u6362\u662f\u5426\u51fa\u73b0\u5f02\u5e38\u6216\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", (Object)b2bOrder);
                        continue;
                    }
                }
            } else {
                this.logger.info("part1:\u4fdd\u7559\u57df2\u67e5\u8be2\u6709\u503c\uff01", (Object)transaction.getReservedField2());
                String businessOrderno = ((CmChannelClear)cmsChannelClearQueryResult.getList().get(0)).getBusinessOrderno();
                mapPro.put("contractBillcode", businessOrderno);
                ocContractQueryResult = this.queryContractPage(mapPro);
            }
            String b2bOrderOrigin = ((OcContract)ocContractQueryResult.getList().get(0)).getContractBillcode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("barCode", b2bOrderOrigin);
            QueryResult<DaSalesSumList> daSalesSumListQueryResult = this.queryUnionBillInfoPage(map);
            if (daSalesSumListQueryResult.getList().size() != 0 || !(assType = this.AssSaveDaSales(transaction, daSalesSumList = new DaSalesSumListDomain(), b2bOrderOrigin, ocContract = (OcContract)ocContractQueryResult.getList().get(0))).equals("success")) continue;
            this.savaUnionBillInfo(daSalesSumList);
        }
        return null;
    }

    @Override
    public QueryResult<UnionPayDomain> queryUnionPayBillInfo(String tenantCode, Map<String, Object> mapJson) throws ApiException {
        if (MapUtils.isEmpty(mapJson) || null == mapJson.get("BeginTime") || null == mapJson.get("EndTime") || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String UserId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UnionPayUserId", "UnionPayUserId");
        String UnionPaPwd = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UnionPayPwd", "UnionPaPwd");
        String UnionPayMerId = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UnionPayMerId", "UnionPayMerId");
        String UnionPaymchPrivateKey = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UnionPaymchPrivateKey", "UnionPaymchPrivateKey");
        String UnionPayfchannelApiUrl = YlUnionPayWalletServiceImpl.getUrl(tenantCode, "UnionPayfchannelApiUrl", "UnionPayfchannelApiUrl");
        if (StringUtils.isBlank((String)UserId) || StringUtils.isBlank((String)UnionPaPwd) || StringUtils.isBlank((String)UnionPaymchPrivateKey) || StringUtils.isBlank((String)UnionPayfchannelApiUrl) || StringUtils.isBlank((String)UnionPayMerId)) {
            this.logger.error("exdata.YlUnionPayWalletServiceImpl\u57fa\u7840\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TranType", "100");
        map.put("JavaCharset", "UTF-8");
        map.put("Version", "V60");
        map.put("UserId", UserId);
        UnionPaPwd = MD5Test.md5(UnionPaPwd, "UTF-8");
        map.put("Pwd", UnionPaPwd);
        map.put("MerId", UnionPayMerId);
        map.put("PayStatus", "1");
        map.put("BeginTime", mapJson.get("BeginTime").toString());
        map.put("EndTime", mapJson.get("EndTime").toString());
        TreeMap mapStr = new TreeMap(map);
        String encodePKey = MD5Test.md5(UnionPaymchPrivateKey, "UTF-8");
        String makeSign = MD5Test.makeSign(encodePKey, map);
        if (StringUtils.isNotBlank((String)makeSign)) {
            map.put("SignMsg", makeSign);
        }
        String signString = MD5Test.buildSignStringMap(map);
        this.logger.info("signString:", (Object)signString);
        String sendPost = null;
        try {
            this.logger.info("post Details:", (Object)(UnionPayfchannelApiUrl + signString));
            sendPost = HttpRequestUtil.sendPost(UnionPayfchannelApiUrl, signString);
        }
        catch (Exception e) {
            this.logger.error("exdata.YlUnionPayWalletServiceImplsendPost is error", sendPost);
            return null;
        }
        String Split = "&";
        int FiledCount = 9;
        sendPost = sendPost.replace("\\n", "&");
        List<UnionPayDomain> SplitValueList = null;
        Pattern pattern = Pattern.compile("Code=(\\d+)&Message=(.*)");
        Matcher matcher = pattern.matcher(sendPost);
        this.logger.error("exdata.YlUnionPayWalletServiceImplrun in matches:", (Object)sendPost);
        if (matcher.matches()) {
            String code = matcher.group(1);
            String message = matcher.group(2);
            UnionPayErrorDomain unionPayErrorDomain = new UnionPayErrorDomain(code, message);
            this.logger.error("exdata.YlUnionPayWalletServiceImplsendPost is error:", (Object)unionPayErrorDomain.toString());
            return null;
        }
        SplitValueList = GnetePayUtils.SplitStringToList(sendPost, Split, FiledCount);
        if (ListUtil.isNotEmpty(SplitValueList)) {
            QueryResult unionPayDomainQueryResult = new QueryResult();
            unionPayDomainQueryResult.setList(SplitValueList);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(SplitValueList.size());
            unionPayDomainQueryResult.setPageTools((SupPageTools)pageTools);
            return unionPayDomainQueryResult;
        }
        return null;
    }

    public static void main222(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TranType", "100");
        map.put("JavaCharset", "UTF-8");
        map.put("Version", "V60");
        map.put("UserId", "198");
        String Pwd = "123!@#QAZ";
        Pwd = MD5Test.md5(Pwd, "UTF-8");
        map.put("Pwd", Pwd);
        map.put("MerId", "198");
        map.put("PayStatus", "1");
        map.put("BeginTime", "2022-05-01 00:00:00");
        map.put("EndTime", "2022-05-07 12:00:00");
        TreeMap mapStr = new TreeMap(map);
        String mchPrivateKey = "12hi60ohgmp16nbev0gr8au69bodzguz";
        String fchannelApiUrl = "http://test.gnetpg.com:8089/GneteMerchantAPI/Trans.action";
        String encodePKey = MD5Test.md5(mchPrivateKey, "UTF-8");
        String makeSign = MD5Test.makeSign(encodePKey, map);
        if (StringUtils.isNotBlank((String)makeSign)) {
            map.put("SignMsg", makeSign);
        }
        String signString = MD5Test.buildSignStringMap(map);
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)signString));
        String sendPost = null;
        try {
            sendPost = HttpRequestUtil.sendPost(fchannelApiUrl, signString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String Split = "&";
        int FiledCount = 9;
        sendPost = sendPost.replace("\\n", "&");
        List<UnionPayDomain> SplitValueList = GnetePayUtils.SplitStringToList(sendPost, Split, FiledCount);
        System.out.println(SplitValueList.size());
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson(SplitValueList));
    }

    private static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private static DaSalesSumListDomain getDaSalesSumList(UnionPayDomain unionPayDomain) {
        DaSalesSumListDomain daSalesSumListDomain = new DaSalesSumListDomain();
        daSalesSumListDomain.setSalesSumCode(null);
        daSalesSumListDomain.setMatnr(unionPayDomain.getShoppingDate());
        daSalesSumListDomain.setBarCode(null);
        daSalesSumListDomain.setOriginalCost(unionPayDomain.getOrderAmount());
        daSalesSumListDomain.setBatch(unionPayDomain.getOrderNo());
        daSalesSumListDomain.setIssWerks(unionPayDomain.getTermNo());
        daSalesSumListDomain.setIssLgort(unionPayDomain.getSystemSSN());
        daSalesSumListDomain.setCntSign("\u6210\u529f\u8ba2\u5355");
        daSalesSumListDomain.setTaxAmtType(unionPayDomain.getSyReserverd01().getTs());
        daSalesSumListDomain.setTaxAmtCode(null);
        return daSalesSumListDomain;
    }

    public List<Transaction> Implicit(List<Transaction> transactions, String host, int port1, String userId, String passwd, String date) {
        try {
            FTPFile[] files;
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = null;
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManager, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            FTPClient client = new FTPClient();
            client.setSSLSocketFactory(sslSocketFactory);
            client.setSecurity(1);
            client.connect(host, port1);
            client.login(userId, passwd);
            this.logger.info("\u5f53\u524d\u76ee\u5f55\uff1a" + client.currentDirectory());
            for (FTPFile file : files = client.list()) {
                if (!file.getName().endsWith(date + ".xls.zip")) continue;
                this.logger.info("\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6\uff1a" + file.getName());
                File localFile = new File(file.getName());
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(localFile));
                client.download(file.getName(), localFile);
                ((OutputStream)outputStream).close();
                ZipFile zipFile = new ZipFile(localFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".xls")) continue;
                    this.logger.info("\u6b63\u5728\u8bfb\u53d6\u6587\u4ef6\uff1a" + entry.getName());
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
                    Sheet sheet = workbook.getSheetAt(0);
                    inputStream.close();
                    Row firstRow = sheet.getRow(0);
                    sheet.removeRow(firstRow);
                    for (Row row : sheet) {
                        Transaction transaction = new Transaction();
                        transaction.setClearingDate(row.getCell(0).getStringCellValue());
                        transaction.setMerchantCode(row.getCell(1).getStringCellValue());
                        transaction.setMerchantName(row.getCell(2).getStringCellValue());
                        transaction.setBusinessType(row.getCell(3).getStringCellValue());
                        transaction.setTransactionDate(row.getCell(4).getStringCellValue());
                        transaction.setTransactionTime(row.getCell(5).getStringCellValue());
                        transaction.setMerchantOrderNo(row.getCell(6).getStringCellValue());
                        transaction.setTerminalCode(row.getCell(7).getStringCellValue());
                        transaction.setTransactionType(row.getCell(8).getStringCellValue());
                        transaction.setPaymentMethod(row.getCell(9).getStringCellValue());
                        transaction.setTransactionAmount(BigDecimal.valueOf(row.getCell(10).getNumericCellValue()));
                        transaction.setDailyFee(BigDecimal.valueOf(row.getCell(11).getNumericCellValue()));
                        transaction.setTotalFee(BigDecimal.valueOf(row.getCell(12).getNumericCellValue()));
                        transaction.setEntryAmount(BigDecimal.valueOf(row.getCell(13).getNumericCellValue()));
                        transaction.setTerminalSerialNo(row.getCell(14).getStringCellValue());
                        transaction.setRetrieveReferenceNo(row.getCell(15).getStringCellValue());
                        transaction.setCardNo(row.getCell(16).getStringCellValue());
                        transaction.setCardTypeName(row.getCell(17).getStringCellValue());
                        transaction.setCardName(row.getCell(18).getStringCellValue());
                        transaction.setIssuingBankName(row.getCell(19).getStringCellValue());
                        transaction.setAcquiringBankName(row.getCell(20).getStringCellValue());
                        transaction.setAdditionalField1(row.getCell(21).getStringCellValue());
                        transaction.setAdditionalField2(row.getCell(22).getStringCellValue());
                        transaction.setReservedField1(row.getCell(23).getStringCellValue());
                        transaction.setReservedField2(row.getCell(24).getStringCellValue());
                        transaction.setCustomField1(row.getCell(25).getStringCellValue());
                        transaction.setCustomField2(row.getCell(26).getStringCellValue());
                        transaction.setCustomField3(row.getCell(27).getStringCellValue());
                        transaction.setCustomField4(row.getCell(28).getStringCellValue());
                        transaction.setCustomField5(row.getCell(29).getStringCellValue());
                        transaction.setBusinessCustomField1(row.getCell(30).getStringCellValue());
                        transaction.setBusinessCustomField2(row.getCell(31).getStringCellValue());
                        transaction.setBusinessCustomField3(row.getCell(32).getStringCellValue());
                        transaction.setBusinessCustomField4(row.getCell(33).getStringCellValue());
                        transaction.setBusinessCustomField5(row.getCell(34).getStringCellValue());
                        transaction.setBusinessCustomField6(row.getCell(35).getStringCellValue());
                        transaction.setTransactionRemark(row.getCell(36).getStringCellValue());
                        transaction.setTransactionComment(row.getCell(37).getStringCellValue());
                        transactions.add(transaction);
                    }
                }
                zipFile.close();
                localFile.delete();
            }
            this.logger.info("\u6d4b\u8bd5\u6210\u529f");
            return transactions;
        }
        catch (Exception e) {
            this.logger.info("\u6d4b\u8bd5\u5931\u8d25");
            e.printStackTrace();
            return null;
        }
    }

    public static String convertToLocaOrder(String unionpayOrder) {
        String regex = "(\\d{8})\\d{6}(\\d{3})";
        String replacement = "$1000$2";
        return unionpayOrder.replaceAll(regex, replacement);
    }

    private String AssSaveDaSales(Transaction transaction, DaSalesSumListDomain daSalesSumListDomain, String b2bOrder, OcContract ocContract) {
        daSalesSumListDomain.setSalesSumCode(ocContract.getChannelName());
        String transactionDT = transaction.getTransactionDate() + " " + transaction.getTransactionTime();
        daSalesSumListDomain.setMatnr(transactionDT);
        daSalesSumListDomain.setBarCode(b2bOrder);
        daSalesSumListDomain.setOriginalCost(transaction.getTransactionAmount());
        daSalesSumListDomain.setBatch(transaction.getMerchantOrderNo());
        daSalesSumListDomain.setIssWerks(transaction.getTerminalCode());
        daSalesSumListDomain.setIssLgort(transaction.getRetrieveReferenceNo());
        daSalesSumListDomain.setCntSign("\u6210\u529f\u8ba2\u5355");
        daSalesSumListDomain.setTaxAmtType(transaction.getPaymentMethod());
        daSalesSumListDomain.setTaxAmtCode(ocContract.getMschannelCode());
        daSalesSumListDomain.setSalesUom(String.valueOf(transaction.getDailyFee()));
        daSalesSumListDomain.setTaxAmtSign(String.valueOf(transaction.getEntryAmount()));
        daSalesSumListDomain.setTenantCode("2021122100000001");
        return "success";
    }

    private String savaUnionBillInfo(DaSalesSumListDomain daSalesSumListDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("daSalesSumListDomain", JsonUtil.buildNonNullBinder().toJson((Object)daSalesSumListDomain));
        return this.internalInvoke("da.daSalesSumList.savesalesSumList", map);
    }

    private QueryResult<DaSalesSumList> queryUnionBillInfoPage(Map<String, Object> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNonNullBinder().toJson(paramsMap));
        return this.getQueryResutl("da.daSalesSumList.querysalesSumListPage", map, DaSalesSumList.class);
    }

    private QueryResult<OcContract> queryContractPage(Map<String, Object> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNonNullBinder().toJson(paramsMap));
        return this.getQueryResutl("oc.contract.queryContractPageReDomain", map, OcContract.class);
    }

    private QueryResult<CmChannelClear> queryCMClearPage(Map<String, Object> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNonNullBinder().toJson(paramsMap));
        return this.getQueryResutl("cm.channelClear.querychannelClearPage", map, CmChannelClear.class);
    }
}

